/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4chee.arc.entity.SoundexCode;

@Entity
@Table(name="person_name", indexes={@Index(columnList="alphabetic_name"), @Index(columnList="ideographic_name"), @Index(columnList="phonetic_name")})
public class PersonName {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="alphabetic_name")
    private String alphabeticName;
    @Basic(optional=false)
    @Column(name="ideographic_name")
    private String ideographicName;
    @Basic(optional=false)
    @Column(name="phonetic_name")
    private String phoneticName;
    @OneToMany(mappedBy="personName", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Collection<SoundexCode> soundexCodes;

    public PersonName() {
    }

    public PersonName(org.dcm4che3.data.PersonName pn, FuzzyStr fuzzyStr) {
        this.fromDicom(pn, fuzzyStr);
    }

    private void fromDicom(org.dcm4che3.data.PersonName pn, FuzzyStr fuzzyStr) {
        this.setAlphabeticName(pn.toString(PersonName.Group.Alphabetic, false));
        this.setIdeographicName(pn.toString(PersonName.Group.Ideographic, false));
        this.setPhoneticName(pn.toString(PersonName.Group.Phonetic, false));
        this.createOrUpdateSoundexCodes(pn.get(PersonName.Group.Alphabetic, PersonName.Component.FamilyName), pn.get(PersonName.Group.Alphabetic, PersonName.Component.GivenName), pn.get(PersonName.Group.Alphabetic, PersonName.Component.MiddleName), fuzzyStr);
    }

    private void createOrUpdateSoundexCodes(String familyName, String givenName, String middleName, FuzzyStr fuzzyStr) {
        if (this.soundexCodes == null) {
            this.soundexCodes = new ArrayList<SoundexCode>();
        } else {
            Iterator<SoundexCode> iterator = this.soundexCodes.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        this.addSoundexCodesTo(PersonName.Component.FamilyName, familyName, fuzzyStr, this.soundexCodes);
        this.addSoundexCodesTo(PersonName.Component.GivenName, givenName, fuzzyStr, this.soundexCodes);
        this.addSoundexCodesTo(PersonName.Component.MiddleName, middleName, fuzzyStr, this.soundexCodes);
    }

    private void addSoundexCodesTo(PersonName.Component component, String name, FuzzyStr fuzzyStr, Collection<SoundexCode> codes) {
        if (name == null) {
            return;
        }
        Iterator<String> parts = SoundexCode.tokenizePersonNameComponent(name);
        int i = 0;
        while (parts.hasNext()) {
            SoundexCode soundexCode = new SoundexCode(component, i, fuzzyStr.toFuzzy(parts.next()));
            soundexCode.setPersonName(this);
            codes.add(soundexCode);
            ++i;
        }
    }

    public org.dcm4che3.data.PersonName toPersonName() {
        org.dcm4che3.data.PersonName pn = new org.dcm4che3.data.PersonName();
        pn.set(PersonName.Group.Alphabetic, this.getAlphabeticName());
        pn.set(PersonName.Group.Ideographic, this.getIdeographicName());
        pn.set(PersonName.Group.Phonetic, this.getPhoneticName());
        return pn;
    }

    public static PersonName valueOf(String s, FuzzyStr fuzzyStr, PersonName prev) {
        if (s == null) {
            return null;
        }
        org.dcm4che3.data.PersonName pn = new org.dcm4che3.data.PersonName(s, true);
        if (pn.isEmpty()) {
            return null;
        }
        if (prev != null) {
            if (!pn.equals((Object)prev.toPersonName())) {
                prev.fromDicom(pn, fuzzyStr);
            }
            return prev;
        }
        return new PersonName(pn, fuzzyStr);
    }

    public String toString() {
        return this.toPersonName().toString();
    }

    public long getPk() {
        return this.pk;
    }

    public String getAlphabeticName() {
        return this.alphabeticName.substring(0, this.alphabeticName.length() - 1);
    }

    public void setAlphabeticName(String alphabeticName) {
        this.alphabeticName = alphabeticName + "^";
    }

    public String getIdeographicName() {
        return this.ideographicName.substring(0, this.ideographicName.length() - 1);
    }

    public void setIdeographicName(String ideographicName) {
        this.ideographicName = ideographicName + "^";
    }

    public String getPhoneticName() {
        return this.phoneticName.substring(0, this.phoneticName.length() - 1);
    }

    public void setPhoneticName(String phoneticName) {
        this.phoneticName = phoneticName + "^";
    }
}

