/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Version;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;

@Entity
@Table(name="patient_id", indexes={@Index(columnList="pat_id"), @Index(columnList="entity_id"), @Index(columnList="entity_uid, entity_uid_type")})
public class PatientID {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Column(name="pat_id")
    private String id;
    @Column(name="entity_id")
    private String localNamespaceEntityID;
    @Column(name="entity_uid")
    private String universalEntityID;
    @Column(name="entity_uid_type")
    private String universalEntityIDType;
    @Column(name="pat_id_type_code")
    private String identifierTypeCode;

    public long getPk() {
        return this.pk;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Issuer getIssuer() {
        return this.localNamespaceEntityID != null || this.universalEntityID != null ? new Issuer(this.localNamespaceEntityID, this.universalEntityID, this.universalEntityIDType) : null;
    }

    public void setIssuer(Issuer issuer) {
        if (issuer != null) {
            this.localNamespaceEntityID = issuer.getLocalNamespaceEntityID();
            this.universalEntityID = issuer.getUniversalEntityID();
            this.universalEntityIDType = issuer.getUniversalEntityIDType();
        } else {
            this.localNamespaceEntityID = null;
            this.universalEntityID = null;
            this.universalEntityIDType = null;
        }
    }

    public String getIdentifierTypeCode() {
        return this.identifierTypeCode;
    }

    public void setIdentifierTypeCode(String identifierTypeCode) {
        this.identifierTypeCode = identifierTypeCode;
    }

    public IDWithIssuer getIDWithIssuer() {
        return new IDWithIssuer(this.id, this.getIssuer());
    }

    public String toString() {
        return "PatientID[pk=" + this.pk + ", id=" + this.id + ", issuer=" + this.getIssuer() + "]";
    }
}

