/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.dcm4che3.util.TagUtils;

@Entity
@Table(name="metadata", indexes={@Index(columnList="storage_id,status")})
@NamedQueries(value={@NamedQuery(name="Metadata.FindByStorageIDAndStatus", query="select m from Metadata m where m.storageID=?1 and m.status=?2"), @NamedQuery(name="Metadata.FindBySeriesIUIDAndStorageID", query="select se.metadata from Series se where se.seriesInstanceUID = ?1 and se.metadata.storageID = ?2"), @NamedQuery(name="Metadata.SetStatusBySeriesPk", query="update Metadata m set m.status = ?2 where exists (select 1 from Series s where s.pk = ?1 and s.metadata = m)"), @NamedQuery(name="Metadata.UpdateStatusFrom", query="update Metadata m set m.status = ?3 where m.pk = ?1 and m.status = ?2"), @NamedQuery(name="Metadata.DeleteByPk", query="delete from Metadata m where m.pk = ?1")})
public class Metadata {
    public static final String FIND_BY_STORAGE_ID_AND_STATUS = "Metadata.FindByStorageIDAndStatus";
    public static final String FIND_BY_SERIES_IUID_AND_STORAGE_ID = "Metadata.FindBySeriesIUIDAndStorageID";
    public static final String UPDATE_STATUS_FROM = "Metadata.UpdateStatusFrom";
    public static final String SET_STATUS_BY_SERIES_PK = "Metadata.SetStatusBySeriesPk";
    public static final String DELETE_BY_PK = "Metadata.DeleteByPk";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Column(name="storage_id", updatable=false)
    private String storageID;
    @Basic(optional=false)
    @Column(name="storage_path", updatable=false)
    private String storagePath;
    @Basic(optional=false)
    @Column(name="object_size", updatable=false)
    private long size;
    @Basic(optional=true)
    @Column(name="digest", updatable=false)
    private String digest;
    @Basic(optional=false)
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status", updatable=true)
    private Status status = Status.OK;

    public long getPk() {
        return this.pk;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public byte[] getDigest() {
        return this.digest != null ? TagUtils.fromHexString((String)this.digest) : null;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest != null ? TagUtils.toHexString((byte[])digest) : null;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String toString() {
        return "Metadata[pk=" + this.pk + ", storageID=" + this.storageID + ", path=" + this.storagePath + ", size=" + this.size + ", status=" + this.status + "]";
    }

    @PrePersist
    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public static enum Status {
        OK,
        TO_DELETE,
        FAILED_TO_DELETE,
        MISSING_OBJECT,
        FAILED_TO_FETCH_METADATA,
        FAILED_TO_FETCH_OBJECT,
        DIFFERING_OBJECT_SIZE,
        DIFFERING_OBJECT_CHECKSUM,
        DIFFERING_S3_MD5SUM,
        FAILED_TO_DELETE2;

    }
}

