/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.DateUtils;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.BlobCorruptedException;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.PersonName;

@NamedQueries(value={@NamedQuery(name="MWLItem.findByStudyIUIDEager", query="select mwl from MWLItem mwl join fetch mwl.attributesBlob where mwl.studyInstanceUID = ?1"), @NamedQuery(name="MWLItem.findByPatient", query="select mwl from MWLItem mwl where mwl.patient = ?1"), @NamedQuery(name="MWLItem.findByStudyUIDAndSPSID", query="select mwl from MWLItem mwl where mwl.studyInstanceUID = ?1 and mwl.scheduledProcedureStepID = ?2"), @NamedQuery(name="MWLItem.attrsByStudyUIDAndSPSID", query="select mwl.attributesBlob.encodedAttributes, mwl.patient.attributesBlob.encodedAttributes from MWLItem mwl where mwl.studyInstanceUID = ?1 and mwl.scheduledProcedureStepID = ?2"), @NamedQuery(name="MWLItem.findByStudyUIDAndSPSIDEager", query="select mwl from MWLItem mwl join fetch mwl.attributesBlob where mwl.studyInstanceUID = ?1 and mwl.scheduledProcedureStepID = ?2"), @NamedQuery(name="MWLItem.findPkByStatusAndUpdatedBefore", query="select mwl.pk from MWLItem mwl where mwl.status = ?1 and mwl.updatedTime < ?2"), @NamedQuery(name="MWLItem.findByPk", query="select mwl from MWLItem mwl where mwl.pk = ?1"), @NamedQuery(name="MWLItem.findDistinctInstitutions", query="select distinct mwl.institutionName from MWLItem mwl"), @NamedQuery(name="MWLItem.idsByPatientAndStatus", query="select new org.dcm4chee.arc.entity.MWLItem$IDs(mwl.scheduledProcedureStepID, mwl.studyInstanceUID) from MWLItem mwl where mwl.patient = ?1 and mwl.status = ?2"), @NamedQuery(name="MWLItem.findByAccessionNoEager", query="select mwl from MWLItem mwl join fetch mwl.attributesBlob where mwl.accessionNumber = ?1")})
@Entity
@Table(name="mwl_item", uniqueConstraints={@UniqueConstraint(columnNames={"study_iuid", "sps_id"})}, indexes={@Index(columnList="updated_time"), @Index(columnList="worklist_label"), @Index(columnList="sps_id"), @Index(columnList="req_proc_id"), @Index(columnList="study_iuid"), @Index(columnList="accession_no"), @Index(columnList="admission_id"), @Index(columnList="institution"), @Index(columnList="department"), @Index(columnList="modality"), @Index(columnList="sps_start_date"), @Index(columnList="sps_start_time"), @Index(columnList="sps_status")})
public class MWLItem {
    public static final String FIND_BY_STUDY_IUID_EAGER = "MWLItem.findByStudyIUIDEager";
    public static final String FIND_BY_PATIENT = "MWLItem.findByPatient";
    public static final String FIND_BY_STUDY_UID_AND_SPS_ID = "MWLItem.findByStudyUIDAndSPSID";
    public static final String FIND_BY_STUDY_UID_AND_SPS_ID_EAGER = "MWLItem.findByStudyUIDAndSPSIDEager";
    public static final String ATTRS_BY_STUDY_UID_AND_SPS_ID = "MWLItem.attrsByStudyUIDAndSPSID";
    public static final String FIND_PK_BY_STATUS_AND_UPDATED_BEFORE = "MWLItem.findPkByStatusAndUpdatedBefore";
    public static final String FIND_BY_PK = "MWLItem.findByPk";
    public static final String IDS_BY_PATIENT_AND_STATUS = "MWLItem.idsByPatientAndStatus";
    public static final String FIND_BY_ACCESSION_NO_EAGER = "MWLItem.findByAccessionNoEager";
    public static final String FIND_DISTINCT_INSTITUTIONS = "MWLItem.findDistinctInstitutions";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic(optional=false)
    @Column(name="worklist_label")
    private String worklistLabel;
    @Basic(optional=false)
    @Column(name="sps_id", updatable=false)
    private String scheduledProcedureStepID;
    @Basic(optional=false)
    @Column(name="req_proc_id")
    private String requestedProcedureID;
    @Basic(optional=false)
    @Column(name="study_iuid", updatable=false)
    private String studyInstanceUID;
    @Basic(optional=false)
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="accno_entity_id")
    private String accessionNumberLocalNamespaceEntityID;
    @Column(name="accno_entity_uid")
    private String accessionNumberUniversalEntityID;
    @Column(name="accno_entity_uid_type")
    private String accessionNumberUniversalEntityIDType;
    @Basic(optional=false)
    @Column(name="admission_id")
    private String admissionID;
    @Column(name="admid_entity_id")
    private String admissionIDLocalNamespaceEntityID;
    @Column(name="admid_entity_uid")
    private String admissionIDUniversalEntityID;
    @Column(name="admid_entity_uid_type")
    private String admissionIDUniversalEntityIDType;
    @Basic(optional=false)
    @Column(name="department")
    private String institutionalDepartmentName;
    @Basic(optional=false)
    @Column(name="institution")
    private String institutionName;
    @Basic(optional=false)
    @Column(name="modality")
    private String modality;
    @Basic(optional=false)
    @Column(name="sps_start_date")
    private String scheduledStartDate;
    @Basic(optional=false)
    @Column(name="sps_start_time")
    private String scheduledStartTime;
    @Basic(optional=false)
    @Column(name="sps_status")
    private SPSStatus status;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, optional=false)
    @JoinColumn(name="dicomattrs_fk")
    private AttributesBlob attributesBlob;
    @Transient
    private Attributes cachedAttributes;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="perf_phys_name_fk")
    private PersonName scheduledPerformingPhysicianName;
    @ManyToOne
    @JoinColumn(name="inst_code_fk")
    private CodeEntity institutionCode;
    @ManyToOne
    @JoinColumn(name="dept_code_fk")
    private CodeEntity institutionalDepartmentTypeCode;
    @ElementCollection
    @CollectionTable(name="sps_station_aet", joinColumns={@JoinColumn(name="mwl_item_fk")}, indexes={@Index(columnList="station_aet")})
    @Column(name="station_aet")
    private Set<String> scheduledStationAETs;
    @ManyToOne(optional=false)
    @JoinColumn(name="patient_fk")
    private Patient patient;
    private static final int[] REQUEST_ATTR = new int[]{524368, 524369, 0x401001, 0x20000D, 3280992};
    private static final int[] SPS_REQUEST_ATTR = new int[]{0x400007, 0x400008, 0x400009};

    public long getPk() {
        return this.pk;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getScheduledProcedureStepID() {
        return this.scheduledProcedureStepID;
    }

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public String getAdmissionID() {
        return this.admissionID;
    }

    public String getInstitutionalDepartmentName() {
        return this.institutionalDepartmentName;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public String getModality() {
        return this.modality;
    }

    public String getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public String getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public PersonName getScheduledPerformingPhysicianName() {
        return this.scheduledPerformingPhysicianName;
    }

    public SPSStatus getStatus() {
        return this.status;
    }

    public CodeEntity getInstitutionCode() {
        return this.institutionCode;
    }

    public void setInstitutionCode(CodeEntity institutionCode) {
        this.institutionCode = institutionCode;
    }

    public CodeEntity getInstitutionalDepartmentTypeCode() {
        return this.institutionalDepartmentTypeCode;
    }

    public void setInstitutionalDepartmentTypeCode(CodeEntity institutionalDepartmentTypeCode) {
        this.institutionalDepartmentTypeCode = institutionalDepartmentTypeCode;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public String toString() {
        return "MWLItem[pk=" + this.pk + ", worklist=" + this.worklistLabel + ", spsid=" + this.scheduledProcedureStepID + ", rpid=" + this.requestedProcedureID + ", suid=" + this.studyInstanceUID + ", accno=" + this.accessionNumber + ", modality=" + this.modality + ", performer=" + this.scheduledPerformingPhysicianName + ", start=" + this.scheduledStartDate + this.scheduledStartTime + ", status=" + this.status + "]";
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public AttributesBlob getAttributesBlob() {
        return this.attributesBlob;
    }

    public Attributes getAttributes() throws BlobCorruptedException {
        return this.attributesBlob.getAttributes();
    }

    public void setAttributes(Attributes attrs, AttributeFilter filter, FuzzyStr fuzzyStr) {
        Attributes spsItem = attrs.getNestedDataset(0x400100);
        if (spsItem == null) {
            throw new IllegalArgumentException("Missing Scheduled Procedure Step Sequence (0040,0100) Item");
        }
        this.worklistLabel = attrs.getString(7606786, "*");
        this.scheduledProcedureStepID = spsItem.getString(0x400009);
        this.modality = spsItem.getString(524384, "*").toUpperCase();
        Date dt = spsItem.getDate(18014407103610883L);
        if (dt != null) {
            this.scheduledStartDate = DateUtils.formatDA(null, (Date)dt);
            this.scheduledStartTime = spsItem.containsValue(0x400003) ? DateUtils.formatTM(null, (Date)dt) : "*";
        } else {
            this.scheduledStartDate = "*";
            this.scheduledStartTime = "*";
        }
        this.scheduledPerformingPhysicianName = PersonName.valueOf(spsItem.getString(0x400006), fuzzyStr, this.scheduledPerformingPhysicianName);
        String cs = spsItem.getString(0x400020);
        this.status = cs != null ? SPSStatus.valueOf((String)cs) : SPSStatus.SCHEDULED;
        this.requestedProcedureID = attrs.getString(0x401001);
        this.studyInstanceUID = attrs.getString(0x20000D);
        this.accessionNumber = attrs.getString(524368, "*");
        Issuer accessionNumberIssuer = Issuer.valueOf((Attributes)attrs.getNestedDataset(524369));
        if (accessionNumberIssuer != null) {
            this.accessionNumberLocalNamespaceEntityID = accessionNumberIssuer.getLocalNamespaceEntityID();
            this.accessionNumberUniversalEntityID = accessionNumberIssuer.getUniversalEntityID();
            this.accessionNumberUniversalEntityIDType = accessionNumberIssuer.getUniversalEntityIDType();
        } else {
            this.accessionNumberLocalNamespaceEntityID = null;
            this.accessionNumberUniversalEntityID = null;
            this.accessionNumberUniversalEntityIDType = null;
        }
        this.admissionID = attrs.getString(3670032, "*");
        Issuer admissionIDIssuer = Issuer.valueOf((Attributes)attrs.getNestedDataset(3670036));
        if (admissionIDIssuer != null) {
            this.admissionIDLocalNamespaceEntityID = admissionIDIssuer.getLocalNamespaceEntityID();
            this.admissionIDUniversalEntityID = admissionIDIssuer.getUniversalEntityID();
            this.admissionIDUniversalEntityIDType = admissionIDIssuer.getUniversalEntityIDType();
        } else {
            this.admissionIDLocalNamespaceEntityID = null;
            this.admissionIDUniversalEntityID = null;
            this.admissionIDUniversalEntityIDType = null;
        }
        this.institutionName = attrs.getString(524416, "*");
        this.institutionalDepartmentName = attrs.getString(528448, "*");
        String[] ssAETs = spsItem.getStrings(0x400001);
        if (ssAETs != null && ssAETs.length != 0) {
            if (this.scheduledStationAETs == null) {
                this.scheduledStationAETs = new HashSet<String>();
            }
            if (!this.scheduledStationAETs.isEmpty()) {
                this.scheduledStationAETs.clear();
            }
            for (String s : ssAETs) {
                this.scheduledStationAETs.add(s);
            }
        } else if (this.scheduledStationAETs != null && !this.scheduledStationAETs.isEmpty()) {
            this.scheduledStationAETs.clear();
        }
        if (this.attributesBlob == null) {
            this.attributesBlob = new AttributesBlob(new Attributes(attrs, filter.getSelection()));
        } else {
            this.attributesBlob.setAttributes(new Attributes(attrs, filter.getSelection()));
        }
        this.updatedTime = new Date();
    }

    public Attributes addItemToRequestAttributesSequence(Sequence seq) {
        Attributes attrs = this.getAttributes();
        Attributes spsItem = attrs.getNestedDataset(0x400100);
        return MWLItem.addItemToRequestAttributesSequence(seq, attrs, spsItem);
    }

    public static Attributes addItemToRequestAttributesSequence(Sequence seq, Attributes mwlItemAttrs, Attributes spsItem) {
        Attributes item = new Attributes(REQUEST_ATTR.length + SPS_REQUEST_ATTR.length);
        seq.add(item);
        item.addSelected(mwlItemAttrs, REQUEST_ATTR);
        item.addSelected(spsItem, SPS_REQUEST_ATTR);
        return item;
    }

    public static class IDs {
        public final String scheduledProcedureStepID;
        public final String studyInstanceUID;

        public IDs(String scheduledProcedureStepID, String studyInstanceUID) {
            this.scheduledProcedureStepID = scheduledProcedureStepID;
            this.studyInstanceUID = studyInstanceUID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IDs iDs = (IDs)o;
            return this.scheduledProcedureStepID.equals(iDs.scheduledProcedureStepID) && this.studyInstanceUID.equals(iDs.studyInstanceUID);
        }

        public int hashCode() {
            return Objects.hash(this.scheduledProcedureStepID, this.studyInstanceUID);
        }
    }
}

