/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.BlobCorruptedException;

@NamedQueries(value={@NamedQuery(name="GlobalSubscription.globalAETs", query="select sub.subscriberAET from GlobalSubscription sub where sub.matchKeysBlob is null"), @NamedQuery(name="GlobalSubscription.filteredAETs", query="select sub.subscriberAET from GlobalSubscription sub where sub.matchKeysBlob is not null"), @NamedQuery(name="GlobalSubscription.findByAET", query="select sub from GlobalSubscription sub where sub.subscriberAET = ?1"), @NamedQuery(name="GlobalSubscription.findAllEager", query="select sub from GlobalSubscription sub left join fetch sub.matchKeysBlob")})
@Entity
@Table(name="global_subscription", uniqueConstraints={@UniqueConstraint(columnNames={"subscriber_aet"})})
public class GlobalSubscription {
    public static final String GLOBAL_AETS = "GlobalSubscription.globalAETs";
    public static final String FILTERED_AETS = "GlobalSubscription.filteredAETs";
    public static final String FIND_BY_AET = "GlobalSubscription.findByAET";
    public static final String FIND_ALL_EAGER = "GlobalSubscription.findAllEager";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="subscriber_aet", updatable=false)
    private String subscriberAET;
    @Basic(optional=false)
    @Column(name="deletion_lock")
    private boolean deletionLock;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="matchkeys_fk")
    private AttributesBlob matchKeysBlob;

    public long getPk() {
        return this.pk;
    }

    public String getSubscriberAET() {
        return this.subscriberAET;
    }

    public void setSubscriberAET(String subscriberAET) {
        this.subscriberAET = subscriberAET;
    }

    public boolean isDeletionLock() {
        return this.deletionLock;
    }

    public void setDeletionLock(boolean deletionLock) {
        this.deletionLock = deletionLock;
    }

    public Attributes getMatchKeys() throws BlobCorruptedException {
        return this.matchKeysBlob != null ? this.matchKeysBlob.getAttributes() : null;
    }

    public void setMatchKeys(Attributes matchKeys) {
        if (matchKeys == null) {
            this.matchKeysBlob = null;
        } else if (this.matchKeysBlob == null) {
            this.matchKeysBlob = new AttributesBlob(matchKeys);
        } else {
            this.matchKeysBlob.setAttributes(matchKeys);
        }
    }

    public String toString() {
        return "GlobalSubscription[pk=" + this.pk + ", aet=" + this.subscriberAET + ", deletionLock=" + this.deletionLock + ", matchingKeys=" + (this.matchKeysBlob != null) + "]";
    }
}

