/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.delete.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipInputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.json.JSONReader;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.delete.impl.DeletionServiceEJB;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FailedToDeleteScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(FailedToDeleteScheduler.class);
    @Inject
    private DeletionServiceEJB ejb;
    @Inject
    private StorageFactory storageFactory;
    private Set<String> inProcess = Collections.synchronizedSet(new HashSet());

    protected FailedToDeleteScheduler() {
        super(Scheduler.Mode.scheduleAtFixedRate);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getFailedToDeletePollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        for (StorageDescriptor desc : arcDev.getStorageDescriptors()) {
            if (arcDev.getFailedToDeletePollingInterval() == null) {
                return;
            }
            if (desc.isReadOnly() || !this.inProcess.add(desc.getStorageID())) continue;
            this.device.execute(() -> {
                LOG.info("Start resolving deletion failures on {}", (Object)desc);
                try {
                    this.resolveObjectDeletionFailures(arcDev, desc);
                    this.resolveSeriesMetadatDeletionFailures(arcDev, desc);
                }
                catch (Throwable e) {
                    LOG.warn("Resolving deletion failures on {} throws:\n", (Object)desc, (Object)e);
                }
                finally {
                    this.inProcess.remove(desc.getStorageID());
                    LOG.info("Finished resolving deletion failures on {}", (Object)desc);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveSeriesMetadatDeletionFailures(ArchiveDeviceExtension arcDev, StorageDescriptor desc) {
        List<Metadata> locations;
        int fetchSize = arcDev.getFailedToDeleteFetchSize();
        do {
            int n;
            if (arcDev.getFailedToDeletePollingInterval() == null) {
                return;
            }
            LOG.debug("Query for Metadata deletion failures on {}", (Object)desc);
            locations = this.ejb.findMetadataWithStatus(desc.getStorageID(), Metadata.Status.FAILED_TO_DELETE, fetchSize);
            if (locations.isEmpty()) {
                LOG.debug("No Metadata deletion failures found on {}", (Object)desc);
                break;
            }
            int[] results = new int[5];
            LOG.info("Start resolving {} Metadata deletion failures on {}", (Object)locations.size(), (Object)desc);
            try (Result[] storage = this.storageFactory.getStorage(desc);){
                for (Metadata location : locations) {
                    int n2 = this.processMetadata((Storage)storage, location).ordinal();
                    results[n2] = results[n2] + 1;
                }
            }
            catch (Exception e) {
                try {
                    LOG.warn("Failed to access {}:\n", (Object)desc, (Object)e);
                }
                catch (Throwable throwable) {
                    for (Result value : Result.values()) {
                        int n3 = results[value.ordinal()];
                        if (n3 <= 0) continue;
                        LOG.info(value.format, (Object)n3, (Object)desc);
                    }
                    throw throwable;
                }
                for (Result value : Result.values()) {
                    n = results[value.ordinal()];
                    if (n <= 0) continue;
                    LOG.info(value.format, (Object)n, (Object)desc);
                }
                continue;
            }
            for (Result value : Result.values()) {
                n = results[value.ordinal()];
                if (n <= 0) continue;
                LOG.info(value.format, (Object)n, (Object)desc);
            }
        } while (locations.size() == fetchSize);
    }

    private Result processMetadata(Storage storage, Metadata location) {
        try {
            Attributes attrs;
            if (!this.ejb.claimResolveFailedToDeleteMetadata(location)) {
                return Result.SKIPPED;
            }
            ReadContext ctx = storage.createReadContext();
            ctx.setStoragePath(location.getStoragePath());
            if (!storage.exists(ctx)) {
                LOG.debug("{} does not exists on {} - delete record from DB", (Object)location, (Object)storage);
                this.ejb.removeMetadata(location);
                return Result.NO_OBJECT;
            }
            LOG.debug("Search for other records with equal path as {} on {}", (Object)location, (Object)storage);
            try (InputStream in = storage.openInputStream(ctx);){
                ZipInputStream zip = new ZipInputStream(in);
                zip.getNextEntry();
                attrs = FailedToDeleteScheduler.parseJSON(zip);
            }
            for (Metadata other : this.ejb.findMetadataForSeriesOnStorage(attrs.getString(0x20000E), location.getStorageID())) {
                if (!location.getStoragePath().equals(other.getStoragePath()) || !FailedToDeleteScheduler.inUse(other.getStatus())) continue;
                LOG.debug("Found other {} with equal path as {} on {} - delete this record from DB", new Object[]{other, location, storage});
                this.ejb.removeMetadata(location);
                return Result.IN_USE;
            }
            LOG.debug("No other record with equal path as {} on {} found - reschedule deletion", (Object)location, (Object)storage);
            this.ejb.rescheduleDeleteMetadata(location);
            return Result.TO_DELETE;
        }
        catch (Exception e) {
            LOG.warn("Failed to resolve {} from {}:\n", new Object[]{location, storage, e});
            return Result.FAILED;
        }
    }

    private static Attributes parseJSON(InputStream in) throws IOException {
        JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader(in, "UTF-8")));
        jsonReader.setSkipBulkDataURI(true);
        return jsonReader.readDataset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveObjectDeletionFailures(ArchiveDeviceExtension arcDev, StorageDescriptor desc) {
        List<Location> locations;
        int fetchSize = arcDev.getFailedToDeleteFetchSize();
        do {
            int n;
            if (arcDev.getFailedToDeletePollingInterval() == null) {
                return;
            }
            LOG.debug("Query for deletion failures on {}", (Object)desc);
            locations = this.ejb.findLocationsWithStatus(desc.getStorageID(), Location.Status.FAILED_TO_DELETE, fetchSize);
            if (locations.isEmpty()) {
                LOG.debug("No deletion failures found on {}", (Object)desc);
                break;
            }
            int[] results = new int[5];
            LOG.info("Start resolving {} deletion failures on {}", (Object)locations.size(), (Object)desc);
            try (Result[] storage = this.storageFactory.getStorage(desc);){
                for (Location location : locations) {
                    int n2 = this.processLocation((Storage)storage, location).ordinal();
                    results[n2] = results[n2] + 1;
                }
            }
            catch (Exception e) {
                try {
                    LOG.warn("Failed to access {}:\n", (Object)desc, (Object)e);
                }
                catch (Throwable throwable) {
                    for (Result value : Result.values()) {
                        int n3 = results[value.ordinal()];
                        if (n3 <= 0) continue;
                        LOG.info(value.format, (Object)n3, (Object)desc);
                    }
                    throw throwable;
                }
                for (Result value : Result.values()) {
                    n = results[value.ordinal()];
                    if (n <= 0) continue;
                    LOG.info(value.format, (Object)n, (Object)desc);
                }
                continue;
            }
            for (Result value : Result.values()) {
                n = results[value.ordinal()];
                if (n <= 0) continue;
                LOG.info(value.format, (Object)n, (Object)desc);
            }
        } while (locations.size() == fetchSize);
    }

    private Result processLocation(Storage storage, Location location) {
        try {
            if (!this.ejb.claimResolveFailedToDelete(location)) {
                return Result.SKIPPED;
            }
            ReadContext ctx = storage.createReadContext();
            ctx.setStoragePath(location.getStoragePath());
            if (!storage.exists(ctx)) {
                LOG.debug("{} does not exists on {} - delete record from DB", (Object)location, (Object)storage);
                this.ejb.removeLocation(location);
                return Result.NO_OBJECT;
            }
            if (location.getObjectType() == Location.ObjectType.DICOM_FILE) {
                Attributes attrs;
                LOG.debug("Search for other records with equal path as {} on {}", (Object)location, (Object)storage);
                try (DicomInputStream din = new DicomInputStream(storage.openInputStream(ctx));){
                    attrs = din.readDataset(-1, 2145386512);
                }
                for (Location other : this.ejb.findLocationsForInstanceOnStorage(attrs.getString(524312), location.getStorageID())) {
                    if (!location.getStoragePath().equals(other.getStoragePath()) || !FailedToDeleteScheduler.inUse(other.getStatus())) continue;
                    LOG.debug("Found other {} with equal path as {} on {} - delete this record from DB", new Object[]{other, location, storage});
                    this.ejb.removeLocation(location);
                    return Result.IN_USE;
                }
                this.ejb.rescheduleDeleteObject(location);
                LOG.debug("No other record with equal path as {} on {} found - reschedule deletion", (Object)location, (Object)storage);
            } else {
                this.ejb.rescheduleDeleteObject(location);
                LOG.debug("Reschedule deletion of {} on {}", (Object)location, (Object)storage);
            }
            return Result.TO_DELETE;
        }
        catch (Exception e) {
            LOG.warn("Failed to resolve {} from {}:\n", new Object[]{location, storage, e});
            return Result.FAILED;
        }
    }

    private static boolean inUse(Location.Status status) {
        switch (status) {
            case TO_DELETE: 
            case FAILED_TO_DELETE: 
            case FAILED_TO_DELETE2: {
                return false;
            }
        }
        return true;
    }

    private static boolean inUse(Metadata.Status status) {
        switch (status) {
            case TO_DELETE: 
            case FAILED_TO_DELETE: 
            case FAILED_TO_DELETE2: {
                return false;
            }
        }
        return true;
    }

    private static enum Result {
        SKIPPED("Skipped {} deletion failures on {} already processed by another node."),
        NO_OBJECT("Resolved {} deletion failures on {}: object was already deleted."),
        IN_USE("Resolved {} deletion failures on {}: object in-use - do not delete."),
        TO_DELETE("Resolved {} deletion failures on {}: deletion rescheduled."),
        FAILED("Failed to resolve {} deletion failures on {}.");

        final String format;

        private Result(String format) {
            this.format = format;
        }
    }
}

