/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.delete.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.RetentionPeriod;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StorageDuration;
import org.dcm4chee.arc.delete.StudyDeleteContext;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.entity.UIDMap;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.store.impl.StoreServiceEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class DeletionServiceEJB {
    private static final Logger LOG = LoggerFactory.getLogger(DeletionServiceEJB.class);
    public static final int MAX_LOCATIONS_PER_INSTANCE = 3;
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private CodeCache codeCache;
    @Inject
    private Device device;
    @Inject
    private PatientService patientService;
    @Inject
    private StoreServiceEJB storeEjb;
    @Inject
    private QueryService queryService;
    @Inject
    private TaskManager taskManager;

    public List<Location> findLocationsWithStatus(String storageID, Location.Status status, int limit) {
        return this.em.createNamedQuery("Location.FindByStorageIDAndStatus", Location.class).setParameter(1, (Object)storageID).setParameter(2, (Object)status).setMaxResults(limit).getResultList();
    }

    public List<Metadata> findMetadataWithStatus(String storageID, Metadata.Status status, int limit) {
        return this.em.createNamedQuery("Metadata.FindByStorageIDAndStatus", Metadata.class).setParameter(1, (Object)storageID).setParameter(2, (Object)status).setMaxResults(limit).getResultList();
    }

    public List<Study.PKUID> findStudiesForDeletionOnStorage(StorageDescriptor desc, boolean retentionPeriods, int limit) {
        List<String> studyStorageIDs = this.getStudyStorageIDs(desc);
        LOG.debug("Query for Studies for deletion on {} with StorageIDs={}", (Object)desc, studyStorageIDs);
        return this.em.createQuery(this.queryStudiesForDeletionOnStorage(desc, studyStorageIDs, retentionPeriods)).setMaxResults(limit).getResultList();
    }

    private CriteriaQuery<Study.PKUID> queryStudiesForDeletionOnStorage(StorageDescriptor desc, List<String> studyStorageIDs, boolean retentionPeriods) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Study.PKUID.class);
        Root study = query.from(Study.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(study.get(Study_.storageIDs).in(studyStorageIDs));
        String[] externalRetrieveAETitles = desc.getExternalRetrieveAETitles();
        if (externalRetrieveAETitles.length > 0) {
            predicates.add(study.get(Study_.externalRetrieveAET).in(Arrays.asList(externalRetrieveAETitles)));
        }
        if (retentionPeriods) {
            this.retentionPeriods(predicates, cb, (Root<Study>)study, desc);
        }
        return query.select((Selection)cb.construct(Study.PKUID.class, new Selection[]{study.get(Study_.pk), study.get(Study_.studyInstanceUID)})).where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{cb.asc((Expression)study.get(Study_.accessTime))});
    }

    private void retentionPeriods(List<Predicate> predicates, CriteriaBuilder cb, Root<Study> study, StorageDescriptor desc) {
        Calendar now = Calendar.getInstance();
        ArrayList list = new ArrayList();
        desc.getRetentionPeriod(RetentionPeriod.DeleteStudies.ReceivedBefore, now).ifPresent(period -> list.add(this.beforeDate(cb, (Path<java.util.Date>)study.get(Study_.createdTime), (Period)period)));
        desc.getRetentionPeriod(RetentionPeriod.DeleteStudies.OlderThan, now).ifPresent(period -> list.add(this.beforeDA(cb, (Path<String>)study.get(Study_.studyDate), (Period)period)));
        desc.getRetentionPeriod(RetentionPeriod.DeleteStudies.NotUsedSince, now).ifPresent(period -> list.add(this.beforeDate(cb, (Path<java.util.Date>)study.get(Study_.accessTime), (Period)period)));
        switch (list.size()) {
            case 0: {
                break;
            }
            case 1: {
                predicates.add((Predicate)list.get(0));
                break;
            }
            default: {
                predicates.add(cb.or(list.toArray(new Predicate[0])));
            }
        }
    }

    private Predicate beforeDA(CriteriaBuilder cb, Path<String> stringPath, Period period) {
        return cb.lessThanOrEqualTo(stringPath, (Comparable)((Object)DateTimeFormatter.BASIC_ISO_DATE.format(LocalDate.now().minus(period))));
    }

    private Predicate beforeDate(CriteriaBuilder cb, Path<java.util.Date> datePath, Period period) {
        return cb.lessThanOrEqualTo(datePath, (Comparable)Date.valueOf(LocalDate.now().minus(period)));
    }

    public int instancesNotStoredOnExportStorage(Long studyPk, StorageDescriptor desc) {
        List<String> storageIDsOfCluster = this.getStorageIDsOfCluster(desc);
        LOG.debug("Query for Instances of Study[pk={}] on Storages{} not stored on Storages[{}]", new Object[]{studyPk, storageIDsOfCluster, StringUtils.concat((String[])desc.getExportStorageID(), (char)'\\')});
        HashSet onStorage = new HashSet(this.em.createNamedQuery("Location.InstancePksByStudyPkAndStorageIDs", Long.class).setParameter(1, (Object)studyPk).setParameter(2, storageIDsOfCluster).getResultList());
        onStorage.removeAll(this.em.createNamedQuery("Location.InstancePksByStudyPkAndStorageIDsAndStatus", Long.class).setParameter(1, (Object)studyPk).setParameter(2, Arrays.asList(desc.getExportStorageID())).setParameter(3, (Object)Location.Status.OK).getResultList());
        return onStorage.size();
    }

    public List<Series> findSeriesWithPurgedInstances(Long studyPk) {
        LOG.debug("Query for Series with purged Instance records of Study[pk={}]", (Object)studyPk);
        return this.em.createNamedQuery("Series.findByStudyPkAndInstancePurgeState", Series.class).setParameter(1, (Object)studyPk).setParameter(2, (Object)Series.InstancePurgeState.PURGED).getResultList();
    }

    public boolean claimDeleteObject(Location location) {
        return this.em.createNamedQuery("Location.UpdateStatusFrom").setParameter(1, (Object)location.getPk()).setParameter(2, (Object)Location.Status.TO_DELETE).setParameter(3, (Object)Location.Status.FAILED_TO_DELETE).executeUpdate() > 0;
    }

    public boolean claimResolveFailedToDelete(Location location) {
        return this.em.createNamedQuery("Location.UpdateStatusFrom").setParameter(1, (Object)location.getPk()).setParameter(2, (Object)Location.Status.FAILED_TO_DELETE).setParameter(3, (Object)Location.Status.FAILED_TO_DELETE2).executeUpdate() > 0;
    }

    public boolean rescheduleDeleteMetadata(Metadata metadata) {
        return this.em.createNamedQuery("Metadata.UpdateStatusFrom").setParameter(1, (Object)metadata.getPk()).setParameter(2, (Object)Metadata.Status.FAILED_TO_DELETE2).setParameter(3, (Object)Metadata.Status.TO_DELETE).executeUpdate() > 0;
    }

    public boolean rescheduleDeleteObject(Location location) {
        return this.em.createNamedQuery("Location.UpdateStatusFrom").setParameter(1, (Object)location.getPk()).setParameter(2, (Object)Location.Status.FAILED_TO_DELETE2).setParameter(3, (Object)Location.Status.TO_DELETE).executeUpdate() > 0;
    }

    public List<Location> findLocationsForInstanceOnStorage(String iuid, String storageID) {
        return this.em.createNamedQuery("Location.FindBySOPIUIDAndStorageID").setParameter(1, (Object)iuid).setParameter(2, (Object)storageID).getResultList();
    }

    public List<Metadata> findMetadataForSeriesOnStorage(String iuid, String storageID) {
        return this.em.createNamedQuery("Metadata.FindBySeriesIUIDAndStorageID").setParameter(1, (Object)iuid).setParameter(2, (Object)storageID).getResultList();
    }

    public boolean claimDeleteMetadata(Metadata metadata) {
        return this.em.createNamedQuery("Metadata.UpdateStatusFrom").setParameter(1, (Object)metadata.getPk()).setParameter(2, (Object)Metadata.Status.TO_DELETE).setParameter(3, (Object)Metadata.Status.FAILED_TO_DELETE).executeUpdate() > 0;
    }

    public boolean claimResolveFailedToDeleteMetadata(Metadata metadata) {
        return this.em.createNamedQuery("Metadata.UpdateStatusFrom").setParameter(1, (Object)metadata.getPk()).setParameter(2, (Object)Metadata.Status.FAILED_TO_DELETE).setParameter(3, (Object)Metadata.Status.FAILED_TO_DELETE2).executeUpdate() > 0;
    }

    public void removeLocation(Location location) {
        this.em.createNamedQuery("Location.DeleteByPk").setParameter(1, (Object)location.getPk()).executeUpdate();
    }

    public void removeMetadata(Metadata metadata) {
        this.em.createNamedQuery("Metadata.DeleteByPk").setParameter(1, (Object)metadata.getPk()).executeUpdate();
    }

    public List<Location> deleteStudy(StudyDeleteContext ctx, int limit, boolean orphaned) {
        Long studyPk = ctx.getStudyPk();
        LOG.debug("Query for objects of Study[pk={}]", (Object)studyPk);
        List locations = this.em.createNamedQuery("Location.FindByStudyPk", Location.class).setParameter(1, (Object)studyPk).setMaxResults(limit).getResultList();
        if (!locations.isEmpty()) {
            LOG.debug("Found {} objects of Study[pk={}]", (Object)locations.size(), (Object)studyPk);
            Collection<Instance> insts = this.removeOrMarkLocationAs(locations, limit, orphaned);
            LOG.debug("Marked {}/{} objects/instances of Study[pk={} for deletion}", new Object[]{locations.size(), insts.size(), studyPk});
            this.deleteInstances(insts, ctx);
            LOG.debug("Deleted {} instances of Study[pk={}]", (Object)insts.size(), (Object)studyPk);
        } else {
            LOG.debug("No objects of Study[pk={}] found", (Object)studyPk);
        }
        return locations;
    }

    public boolean hasObjectsOnStorage(Long studyPk, StorageDescriptor desc) {
        Study study = (Study)this.em.find(Study.class, (Object)studyPk);
        return Stream.of(study.getStorageIDs()).anyMatch(storageID -> storageID.equals(desc.getStorageID()));
    }

    public boolean deleteObjectsOfStudy(Long studyPk, StorageDescriptor desc) {
        return this.deleteObjectsOfStudy((Study)this.em.find(Study.class, (Object)studyPk), desc);
    }

    public boolean deleteObjectsOfStudy(String suid, StorageDescriptor desc) {
        return this.deleteObjectsOfStudy(this.findByStudyIUID(suid), desc);
    }

    private Study findByStudyIUID(String suid) {
        return (Study)this.em.createNamedQuery("Study.findByStudyIUID", Study.class).setParameter(1, (Object)suid).getSingleResult();
    }

    private Series findBySeriesIUID(String studyUID, String seriesUID) {
        return (Series)this.em.createNamedQuery("Series.findBySeriesIUID", Series.class).setParameter(1, (Object)studyUID).setParameter(2, (Object)seriesUID).getSingleResult();
    }

    private boolean deleteObjectsOfStudy(Study study, StorageDescriptor desc) {
        List<String> storageIDs = this.getStorageIDsOfCluster(desc);
        if (!Stream.of(study.getStorageIDs()).anyMatch(storageIDs::contains)) {
            LOG.info("{} does not contain objects at Storage{}", (Object)study, storageIDs);
            return false;
        }
        LOG.debug("Query for objects of {} at Storage{}", (Object)study, storageIDs);
        List locations = this.em.createNamedQuery("Location.FindByStudyPkAndStorageIDs", Location.class).setParameter(1, (Object)study.getPk()).setParameter(2, storageIDs).getResultList();
        if (locations.isEmpty()) {
            LOG.warn("{} does not contain objects at Storage{}", (Object)study, storageIDs);
            this.updateStorageIDs(study, storageIDs);
            return false;
        }
        LOG.debug("Start marking {} objects of {} for deletion at Storage{}", new Object[]{locations.size(), study, storageIDs});
        Collection<Instance> insts = this.removeOrMarkLocationAs(locations, Integer.MAX_VALUE, false);
        LOG.debug("Finish marking {}/{} objects/instances of {} for deletion at Storage{}", new Object[]{locations.size(), insts.size(), study, storageIDs});
        HashSet<Long> seriesPks = new HashSet<Long>();
        for (Instance inst : insts) {
            Series series = inst.getSeries();
            if (!seriesPks.add(series.getPk()) || series.getMetadataScheduledUpdateTime() != null || series.getMetadata() == null) continue;
            this.scheduleMetadataUpdate(series.getPk());
        }
        this.updateStorageIDs(study, storageIDs);
        this.updateInstanceAvailability(study, desc.getInstanceAvailability(), this.remainingInstanceAvailability(desc));
        return true;
    }

    private Availability remainingInstanceAvailability(StorageDescriptor desc) {
        Availability availability2;
        Availability availability1 = desc.getExportStorageID().length > 0 ? ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getStorageDescriptorNotNull(desc.getExportStorageID()[0]).getInstanceAvailability() : null;
        Availability availability = availability2 = desc.getExternalRetrieveAETitles().length > 0 ? desc.getExternalRetrieveInstanceAvailability() : null;
        return availability1 == null ? availability2 : (availability2 == null || availability2.compareTo((Enum)availability1) > 0 ? availability1 : availability2);
    }

    private void updateInstanceAvailability(Study study, Availability from, Availability to) {
        if (to == null || from.compareTo((Enum)to) >= 0) {
            return;
        }
        LOG.info("Update Instance Availability from {} to {}", (Object)from, (Object)to);
        this.em.createNamedQuery("Instance.updateAvailabilityOfStudy").setParameter(1, (Object)study).setParameter(2, (Object)to).executeUpdate();
        this.em.createNamedQuery("StudyQueryAttributes.updateAvailabilityOfStudy").setParameter(1, (Object)study).setParameter(2, (Object)to).executeUpdate();
        this.em.createNamedQuery("SeriesQueryAttributes.updateAvailabilityByStudyPk").setParameter(1, (Object)study).setParameter(2, (Object)to).executeUpdate();
    }

    private void updateStorageIDs(Study study, List<String> storageIDs) {
        String studyEncodedStorageIDs = study.getEncodedStorageIDs();
        for (String storageID : storageIDs) {
            study.removeStorageID(storageID);
        }
        LOG.info("Update Storage IDs of {} from {} to {}", new Object[]{study, studyEncodedStorageIDs, study.getEncodedStorageIDs()});
    }

    public int deleteRejectedInstances(Code rejectionCode, java.util.Date before, int limit) {
        return this.deleteRejectedInstancesOrRejectionNotes(before != null ? "Location.FindByRejectionCodeBefore" : "Location.FindByRejectionCode", rejectionCode, before, limit);
    }

    public int deleteRejectionNotes(Code rejectionCode, java.util.Date before, int limit) {
        return this.deleteRejectedInstancesOrRejectionNotes(before != null ? "Location.FindByConceptNameCodeBefore" : "Location.FindByConceptNameCode", rejectionCode, before, limit);
    }

    private int deleteRejectedInstancesOrRejectionNotes(String queryName, Code rejectionCode, java.util.Date before, int limit) {
        CodeEntity codeEntity = this.codeCache.findOrCreate(rejectionCode);
        TypedQuery query = this.em.createNamedQuery(queryName, Location.class).setParameter(1, (Object)codeEntity);
        if (before != null) {
            query.setParameter(2, (Object)before);
        }
        LOG.debug("Invoke {}", (Object)queryName);
        List locations = query.setMaxResults(limit).getResultList();
        if (!locations.isEmpty()) {
            LOG.debug("{} - Found {} objects", (Object)queryName, (Object)locations.size());
            Collection<Instance> insts = this.removeOrMarkLocationAs(locations, limit, false);
            LOG.debug("{} - Marked {}/{} objects/instances", new Object[]{queryName, locations.size(), insts.size()});
            this.deleteInstances(insts, null);
            LOG.debug("{} - Deleted {} instances", (Object)queryName, (Object)insts.size());
        } else {
            LOG.debug("{} - No objects found", (Object)queryName);
        }
        return locations.size();
    }

    public void deleteEmptyStudy(StudyDeleteContext ctx) {
        Study study = ctx.getStudy();
        study.getPatient().decrementNumberOfStudies();
        this.em.remove(this.em.contains((Object)study) ? study : this.em.merge((Object)study));
    }

    private Collection<Instance> removeOrMarkLocationAs(List<Location> locations, int limit, boolean orphaned) {
        int size = locations.size();
        int initialCapacity = size * 4 / 3;
        HashMap<Long, Instance> insts = new HashMap<Long, Instance>(initialCapacity);
        HashMap<Long, UIDMap> uidMaps = new HashMap<Long, UIDMap>();
        Instance prev = null;
        int n = limit - 2;
        for (Location location : locations) {
            Instance inst = location.getInstance();
            if (n-- <= 0 && prev != inst) break;
            prev = inst;
            insts.put(inst.getPk(), prev);
            UIDMap uidMap = location.getUidMap();
            if (uidMap != null) {
                uidMaps.put(uidMap.getPk(), uidMap);
            }
            this.storeEjb.removeOrMarkLocationAs(location, orphaned && location.getObjectType() == Location.ObjectType.DICOM_FILE ? Location.Status.ORPHANED : Location.Status.TO_DELETE);
        }
        for (UIDMap uidMap : uidMaps.values()) {
            this.storeEjb.removeOrphaned(uidMap);
        }
        return insts.values();
    }

    private void deleteInstances(Collection<Instance> insts, StudyDeleteContext ctx) {
        HashMap<Long, Series> series = new HashMap<Long, Series>();
        for (Instance inst : insts) {
            Series ser = inst.getSeries();
            if (!series.containsKey(ser.getPk())) {
                series.put(ser.getPk(), ser);
                this.deleteSeriesQueryAttributes(ser);
                ser.resetSize();
            }
            if (ctx != null) {
                ctx.addInstance(inst);
            }
            this.em.remove((Object)inst);
            this.em.createNamedQuery("RejectedInstance.deleteByUIDs").setParameter(1, (Object)ser.getStudy().getStudyInstanceUID()).setParameter(2, (Object)ser.getSeriesInstanceUID()).setParameter(3, (Object)inst.getSopInstanceUID()).executeUpdate();
        }
        HashMap<Long, Study> studies = new HashMap<Long, Study>();
        for (Series ser : series.values()) {
            Study study = ser.getStudy();
            if (!studies.containsKey(study.getPk())) {
                studies.put(study.getPk(), study);
                this.deleteStudyQueryAttributes(study);
                study.resetSize();
            }
            if (this.countInstancesOfSeries(ser) == 0L) {
                if (ser.getMetadata() != null) {
                    ser.getMetadata().setStatus(Metadata.Status.TO_DELETE);
                }
                this.em.remove((Object)ser);
                continue;
            }
            studies.put(study.getPk(), null);
            if (ser.getRejectionState() != RejectionState.PARTIAL || this.hasRejectedInstances(ser)) continue;
            ser.setRejectionState(RejectionState.NONE);
        }
        for (Study study : studies.values()) {
            if (study == null) continue;
            if (this.countSeriesOfStudy(study) == 0L) {
                if (study.getRejectionState() == RejectionState.NONE) {
                    study.getPatient().decrementNumberOfStudies();
                }
                this.em.remove((Object)study);
                if (!this.arcDev().isDeletePatientOnDeleteLastStudy() || this.countStudiesOfPatient(study.getPatient()) != 0L) continue;
                PatientMgtContext patMgtCtx = this.patientService.createPatientMgtContextScheduler();
                patMgtCtx.setPatient(study.getPatient());
                patMgtCtx.setEventActionCode("D");
                patMgtCtx.setAttributes(study.getPatient().getAttributes());
                patMgtCtx.setPatientID(IDWithIssuer.pidOf((Attributes)study.getPatient().getAttributes()));
                this.patientService.deletePatient(patMgtCtx);
                continue;
            }
            if (study.getRejectionState() == RejectionState.PARTIAL && !this.hasSeriesWithOtherRejectionState(study, RejectionState.NONE)) {
                study.setRejectionState(RejectionState.NONE);
            }
            study.setModifiedTime(new java.util.Date());
        }
    }

    private boolean hasRejectedInstances(Series series) {
        return (Long)this.em.createNamedQuery("Instance.countRejectedInstancesOfSeries", Long.class).setParameter(1, (Object)series).getSingleResult() > 0L;
    }

    private boolean hasSeriesWithOtherRejectionState(Study study, RejectionState rejectionState) {
        return (Long)this.em.createNamedQuery("Series.countSeriesOfStudyWithOtherRejectionState", Long.class).setParameter(1, (Object)study).setParameter(2, (Object)rejectionState).getSingleResult() > 0L;
    }

    private long countStudiesOfPatient(Patient patient) {
        return (Long)this.em.createNamedQuery("Study.countStudiesOfPatient", Long.class).setParameter(1, (Object)patient).getSingleResult();
    }

    private long countSeriesOfStudy(Study study) {
        return (Long)this.em.createNamedQuery("Series.countSeriesOfStudy", Long.class).setParameter(1, (Object)study).getSingleResult();
    }

    private long countInstancesOfSeries(Series series) {
        return (Long)this.em.createNamedQuery("Instance.countInstancesOfSeries", Long.class).setParameter(1, (Object)series).getSingleResult();
    }

    private int deleteStudyQueryAttributes(Study study) {
        return this.em.createNamedQuery("StudyQueryAttributes.deleteForStudy").setParameter(1, (Object)study).executeUpdate();
    }

    private int deleteSeriesQueryAttributes(Series series) {
        return this.em.createNamedQuery("SeriesQueryAttributes.deleteForSeries").setParameter(1, (Object)series).executeUpdate();
    }

    public List<Series.MetadataUpdate> findSeriesToPurgeInstances(int fetchSize) {
        return this.em.createNamedQuery("Series.scheduledPurgeInstances", Series.MetadataUpdate.class).setMaxResults(fetchSize).getResultList();
    }

    public boolean purgeInstanceRecordsOfSeries(Long seriesPk, Map<String, List<Location>> locationsFromMetadata) {
        Series series = (Series)this.em.find(Series.class, (Object)seriesPk);
        List locations = this.em.createNamedQuery("Location.FindBySeriesPk", Location.class).setParameter(1, (Object)seriesPk).getResultList();
        if (!this.verifyMetadata(locationsFromMetadata, locations)) {
            java.util.Date now = new java.util.Date();
            series.setMetadataScheduledUpdateTime(now);
            series.setInstancePurgeTime(now);
            return false;
        }
        series.setModifiedTime(this.maxInstanceUpdatedTimeOfSeries(series));
        HashMap<String, Long> sizeOfInst = new HashMap<String, Long>();
        for (Location location : locations) {
            switch (location.getObjectType()) {
                case DICOM_FILE: {
                    sizeOfInst.merge(location.getInstance().getSopInstanceUID(), location.getSize(), (v1, v2) -> Math.max(v1, v2));
                    this.em.remove((Object)location);
                    this.em.remove((Object)location.getInstance());
                    break;
                }
                case METADATA: {
                    location.setInstance(null);
                    location.setStatus(Location.Status.TO_DELETE);
                }
            }
        }
        series.setSize(sizeOfInst.values().stream().mapToLong(Long::longValue).sum());
        series.setInstancePurgeTime(null);
        series.setInstancePurgeState(Series.InstancePurgeState.PURGED);
        return true;
    }

    private java.util.Date maxInstanceUpdatedTimeOfSeries(Series series) {
        return (java.util.Date)this.em.createNamedQuery("Instance.maxUpdateTimeOfSeries", java.util.Date.class).setParameter(1, (Object)series).getSingleResult();
    }

    private boolean verifyMetadata(Map<String, List<Location>> locationsFromMetadata, List<Location> locations) {
        for (Location location : locations) {
            if (location.getObjectType() != Location.ObjectType.DICOM_FILE || this.verifyMetadata(locationsFromMetadata, location)) continue;
            return false;
        }
        return locationsFromMetadata.isEmpty();
    }

    private boolean verifyMetadata(Map<String, List<Location>> locationsFromMetadata, Location location) {
        String iuid = location.getInstance().getSopInstanceUID();
        List<Location> locations = locationsFromMetadata.get(iuid);
        if (locations == null || !locations.removeIf(l -> Objects.equals(location.getStorageID(), l.getStorageID()) && Objects.equals(location.getStoragePath(), l.getStoragePath()) && Objects.equals(location.getDigestAsHexString(), l.getDigestAsHexString()) && Objects.equals(location.getSize(), l.getSize()) && Objects.equals(location.getStatus(), l.getStatus()))) {
            return false;
        }
        if (locations.isEmpty()) {
            locationsFromMetadata.remove(iuid);
        }
        return true;
    }

    public boolean claimPurgeInstanceRecordsOfSeries(Series.MetadataUpdate metadataUpdate) {
        return this.em.createNamedQuery("Series.claimPurgeInstanceRecords").setParameter(1, (Object)metadataUpdate.seriesPk).setParameter(2, (Object)metadataUpdate.instancePurgeTime).executeUpdate() > 0;
    }

    public boolean scheduleMetadataUpdate(Long seriesPk) {
        return this.em.createNamedQuery("Series.scheduleMetadataUpdateForSeries").setParameter(1, (Object)seriesPk).executeUpdate() > 0;
    }

    public boolean updateInstancePurgeState(Long seriesPk, Series.InstancePurgeState from, Series.InstancePurgeState to) {
        return this.em.createNamedQuery("Series.updateInstancePurgeState").setParameter(1, (Object)seriesPk).setParameter(2, (Object)from).setParameter(3, (Object)to).executeUpdate() > 0;
    }

    private ArchiveDeviceExtension arcDev() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
    }

    public void updateStudyAccessTime(Long studyPk) {
        this.em.createNamedQuery("Study.UpdateAccessTime").setParameter(1, (Object)studyPk).executeUpdate();
    }

    private List<String> getStorageIDsOfCluster(StorageDescriptor desc) {
        return desc.getStorageClusterID() != null ? ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getStorageDescriptorsOfCluster(desc.getStorageClusterID()).filter(other -> other.getStorageDuration() != StorageDuration.PERMANENT).map(StorageDescriptor::getStorageID).filter(storageID -> !Arrays.asList(desc.getExportStorageID()).contains(storageID)).collect(Collectors.toList()) : Collections.singletonList(desc.getStorageID());
    }

    private List<String> getStudyStorageIDs(StorageDescriptor desc) {
        return desc.getStudyStorageIDs(((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getOtherStorageIDsOfStorageCluster(desc), Collections.emptyList(), null, Boolean.valueOf(true));
    }

    public List<Study> findExpiredStudies(int studyFetchSize) {
        return this.em.createNamedQuery("Study.getExpiredStudies", Study.class).setParameter(1, (Object)DateTimeFormatter.BASIC_ISO_DATE.format(LocalDate.now())).setParameter(2, EnumSet.of(ExpirationState.UPDATEABLE, ExpirationState.FROZEN)).setMaxResults(studyFetchSize).getResultList();
    }

    public List<Series> findExpiredSeries(int seriesFetchSize) {
        return this.em.createNamedQuery("Series.GetExpiredSeries", Series.class).setParameter(1, (Object)DateTimeFormatter.BASIC_ISO_DATE.format(LocalDate.now())).setParameter(2, EnumSet.of(ExpirationState.UPDATEABLE, ExpirationState.FROZEN)).setMaxResults(seriesFetchSize).getResultList();
    }

    public boolean claimExpiredStudyFor(Study study, ExpirationState expirationState) {
        return this.em.createNamedQuery("Study.claimExpiredStudy").setParameter(1, (Object)study.getPk()).setParameter(2, (Object)study.getExpirationState()).setParameter(3, (Object)expirationState).executeUpdate() > 0;
    }

    public boolean claimExpiredSeriesFor(Series series, ExpirationState expirationState) {
        return this.em.createNamedQuery("Series.ClaimExpiredSeries").setParameter(1, (Object)series.getPk()).setParameter(2, (Object)series.getExpirationState()).setParameter(3, (Object)expirationState).executeUpdate() > 0;
    }

    public boolean claimExpired(String studyIUID, String seriesIUID, ExpirationState expirationState) {
        return seriesIUID != null ? this.claimExpiredSeriesFor(this.findBySeriesIUID(studyIUID, seriesIUID), expirationState) : this.claimExpiredStudyFor(this.findByStudyIUID(studyIUID), expirationState);
    }

    public void createRejectionTask(String aet, String studyIUID, String seriesIUID, String sopIUID, Code code, HttpServletRequestInfo httpRequest, String batchID, java.util.Date scheduledTime) {
        Task task = new Task();
        task.setDeviceName(this.device.getDeviceName());
        task.setQueueName("Rejection");
        task.setType(Task.Type.REJECT);
        task.setScheduledTime(scheduledTime);
        task.setLocalAET(aet);
        task.setStudyInstanceUID(studyIUID);
        task.setSeriesInstanceUID(seriesIUID);
        task.setSOPInstanceUID(sopIUID);
        task.setCode(code);
        if (httpRequest != null) {
            task.setRequesterUserID(httpRequest.requesterUserID);
            task.setRequesterHost(httpRequest.requesterHost);
            task.setRequestURI(this.requestURL(httpRequest));
        }
        task.setStatus(Task.Status.SCHEDULED);
        task.setBatchID(batchID);
        this.taskManager.scheduleTask(task);
    }

    private String requestURL(HttpServletRequestInfo httpServletRequestInfo) {
        String requestURI = httpServletRequestInfo.requestURI;
        String queryString = httpServletRequestInfo.queryString;
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @FunctionalInterface
    static interface DeleteRejectedInstancesOrRejectionNotes {
        public int delete(Code var1, java.util.Date var2, int var3);
    }
}

