/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.ui.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ui.UIAetList;
import org.dcm4chee.arc.conf.ui.UICompareSide;
import org.dcm4chee.arc.conf.ui.UIConfig;
import org.dcm4chee.arc.conf.ui.UIConfigDeviceExtension;
import org.dcm4chee.arc.conf.ui.UICreateDialogTemplate;
import org.dcm4chee.arc.conf.ui.UIDashboardConfig;
import org.dcm4chee.arc.conf.ui.UIDeviceCluster;
import org.dcm4chee.arc.conf.ui.UIDeviceURL;
import org.dcm4chee.arc.conf.ui.UIDiffConfig;
import org.dcm4chee.arc.conf.ui.UIDiffCriteria;
import org.dcm4chee.arc.conf.ui.UIElasticsearchConfig;
import org.dcm4chee.arc.conf.ui.UIElasticsearchURL;
import org.dcm4chee.arc.conf.ui.UIFiltersTemplate;
import org.dcm4chee.arc.conf.ui.UIFunction;
import org.dcm4chee.arc.conf.ui.UILanguageConfig;
import org.dcm4chee.arc.conf.ui.UILanguageProfile;
import org.dcm4chee.arc.conf.ui.UIPermission;
import org.dcm4chee.arc.conf.ui.UITableColumn;
import org.dcm4chee.arc.conf.ui.UITableConfig;
import org.dcm4chee.arc.conf.ui.UIWebAppList;

@ApplicationScoped
public class LdapArchiveUIConfiguration
extends LdapDicomConfigurationExtension {
    protected void storeChilds(ConfigurationChanges diffs, String deviceDN, Device device) throws NamingException {
        UIConfigDeviceExtension ext = (UIConfigDeviceExtension)device.getDeviceExtension(UIConfigDeviceExtension.class);
        if (ext == null) {
            return;
        }
        for (UIConfig ui : ext.getUIConfigs()) {
            this.store(diffs, deviceDN, ui);
        }
    }

    protected void storeTo(ConfigurationChanges.ModifiedObject ldapObj, Device device, Attributes attrs) {
        super.storeTo(ldapObj, device, attrs);
    }

    private String uiConfigDN(UIConfig uiConfig, String deviceDN) {
        return LdapUtils.dnOf((String)"dcmuiConfigName", (String)uiConfig.getName(), (String)deviceDN);
    }

    private void store(ConfigurationChanges diffs, String deviceDN, UIConfig uiConfig) throws NamingException {
        String uiConfigDN = this.uiConfigDN(uiConfig, deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.config.createSubcontext(uiConfigDN, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiConfig, (Attributes)new BasicAttributes(true)));
        this.storePermissions(diffs, uiConfig, uiConfigDN);
        this.storeDiffConfigs(diffs, uiConfig, uiConfigDN);
        this.storeDashboardConfigs(diffs, uiConfig, uiConfigDN);
        this.storeElasticsearchConfigs(diffs, uiConfig, uiConfigDN);
        this.storeLanguageConfigs(diffs, uiConfig, uiConfigDN);
        this.storeLTableConfigs(diffs, uiConfig, uiConfigDN);
        this.storeDeviceURL(diffs, uiConfig, uiConfigDN);
        this.storeDeviceCluster(diffs, uiConfig, uiConfigDN);
        this.storeFiltersTemplate(diffs, uiConfig, uiConfigDN);
        this.storeAets(diffs, uiConfig, uiConfigDN);
        this.storeCreateDialogTemplate(diffs, uiConfig, uiConfigDN);
        this.storeWebApps(diffs, uiConfig, uiConfigDN);
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIConfig uiConfig, Attributes attrs) {
        attrs.put("objectclass", "dcmuiConfig");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiConfigName", (Object)uiConfig.getName(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiModalities", (Object[])uiConfig.getModalities(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiWidgetAets", (Object[])uiConfig.getWidgetAets(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiXDSInterfaceURL", (Object)uiConfig.getXdsUrl(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiBackgroundURL", (Object)uiConfig.getBackgroundUrl(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDateTimeFormat", (Object)uiConfig.getDateTimeFormat(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiHideClock", (boolean)uiConfig.isHideClock(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiPageTitle", (Object)uiConfig.getPageTitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiPersonNameFormat", (Object)uiConfig.getPersonNameFormat(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiLogoURL", (Object)uiConfig.getLogoUrl(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDefaultWidgetAets", (Object[])uiConfig.getDefaultWidgetAets(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiMWLWorklistLabel", (Object[])uiConfig.getMWLWorklistLabels(), (Object[])new String[0]);
        return attrs;
    }

    private void storePermissions(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIPermission uiPermission : uiConfig.getPermissions()) {
            String uiPermissionDN = LdapUtils.dnOf((String)"dcmuiPermissionName", (String)uiPermission.getName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiPermissionDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiPermissionDN, this.storeTo(ldapObj1, uiPermission, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeAets(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIAetList uiAets : uiConfig.getAetLists()) {
            String uiAetListDN = LdapUtils.dnOf((String)"dcmuiAetListName", (String)uiAets.getAetListName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiAetListDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiAetListDN, this.storeTo(ldapObj1, uiAets, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeCreateDialogTemplate(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UICreateDialogTemplate uiDialogTemplate : uiConfig.getCreateDialogTemplates()) {
            String uiTemplateDN = LdapUtils.dnOf((String)"dcmuiTemplateName", (String)uiDialogTemplate.getTemplateName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiTemplateDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiTemplateDN, this.storeTo(ldapObj1, uiDialogTemplate, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeWebApps(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIWebAppList uiWebApps : uiConfig.getWebAppLists()) {
            String uiWebAppListDN = LdapUtils.dnOf((String)"dcmuiWebAppListName", (String)uiWebApps.getWebAppListName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiWebAppListDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiWebAppListDN, this.storeTo(ldapObj1, uiWebApps, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeDeviceURL(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIDeviceURL uiDeviceURL : uiConfig.getDeviceURLs()) {
            String uiDeviceURLDN = LdapUtils.dnOf((String)"dcmuiDeviceURLName", (String)uiDeviceURL.getDeviceName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiDeviceURLDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiDeviceURLDN, this.storeTo(ldapObj1, uiDeviceURL, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeDeviceCluster(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIDeviceCluster uiDeviceCluster : uiConfig.getDeviceClusters()) {
            String uiDeviceClusterDN = LdapUtils.dnOf((String)"dcmuiDeviceClusterName", (String)uiDeviceCluster.getClusterName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiDeviceClusterDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiDeviceClusterDN, this.storeTo(ldapObj1, uiDeviceCluster, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeFiltersTemplate(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIFiltersTemplate uiFiltersTemplate : uiConfig.getFilterTemplates()) {
            String uiFilterTemplateDN = LdapUtils.dnOf((String)"dcmuiFilterTemplateGroupName", (String)uiFiltersTemplate.getFilterGroupName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiFilterTemplateDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiFilterTemplateDN, this.storeTo(ldapObj1, uiFiltersTemplate, (Attributes)new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIPermission uiPermission, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiPermission"));
        attrs.put(new BasicAttribute("dcmuiPermissionName", uiPermission.getName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiAction", (Object)uiPermission.getAction(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiActionParam", (Object[])uiPermission.getActionParams(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptedUserRole", (Object[])uiPermission.getAcceptedUserRoles(), (Object[])new String[0]);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIAetList uiAetList, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiAetConfig"));
        attrs.put(new BasicAttribute("dcmuiAetListName", uiAetList.getAetListName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiAetListDescription", (Object)uiAetList.getAetListDescription(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiMode", (Object)uiAetList.getMode(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiAets", (Object[])uiAetList.getAets(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptedUserRole", (Object[])uiAetList.getAcceptedRole(), (Object[])new String[0]);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UICreateDialogTemplate uiCreateDialogTemplate, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiCreateDialogTemplate"));
        attrs.put(new BasicAttribute("dcmuiTemplateName", uiCreateDialogTemplate.getTemplateName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)uiCreateDialogTemplate.getDescription(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDialog", (Object)((Object)uiCreateDialogTemplate.getDialog()), (Object)((Object)UIFunction.mwl));
        this.storeNotEmptyTags(ldapObj, attrs, "dcmTag", uiCreateDialogTemplate.getTags());
        return attrs;
    }

    private void storeNotEmptyTags(ConfigurationChanges.ModifiedObject ldapObj, Attributes attrs, String attrid, int[] vals) {
        if (vals != null && vals.length > 0) {
            attrs.put(this.tagsAttr(attrid, vals));
            if (ldapObj != null) {
                ConfigurationChanges.ModifiedAttribute attribute = new ConfigurationChanges.ModifiedAttribute(attrid);
                for (int val : vals) {
                    attribute.addValue((Object)val);
                }
                ldapObj.add(attribute);
            }
        }
    }

    private Attribute tagsAttr(String attrID, int[] tags) {
        BasicAttribute attr = new BasicAttribute(attrID);
        for (int tag : tags) {
            attr.add(TagUtils.toHexString((int)tag));
        }
        return attr;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIWebAppList uiWebAppList, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiWebAppConfig"));
        attrs.put(new BasicAttribute("dcmuiWebAppListName", uiWebAppList.getWebAppListName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiWebAppListDescription", (Object)uiWebAppList.getWebAppListDescription(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiMode", (Object)uiWebAppList.getMode(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiWebApps", (Object[])uiWebAppList.getWebApps(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptedUserRole", (Object[])uiWebAppList.getAcceptedRole(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptedUserName", (Object[])uiWebAppList.getAcceptedUserName(), (Object[])new String[0]);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIDeviceURL uiDeviceURL, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiDeviceURLObject"));
        attrs.put(new BasicAttribute("dcmuiDeviceURLName", uiDeviceURL.getDeviceName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDeviceURL", (Object)uiDeviceURL.getDeviceURL(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDeviceURLDescription", (Object)uiDeviceURL.getDescription(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDeviceURLInstalled", (boolean)uiDeviceURL.isInstalled(), (boolean)true);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIDeviceCluster uiDeviceCluster, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiDeviceClusterObject"));
        attrs.put(new BasicAttribute("dcmuiDeviceClusterName", uiDeviceCluster.getClusterName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDeviceClusterDescription", (Object)uiDeviceCluster.getDescription(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiClusterWebApp", (Object)uiDeviceCluster.getClusterWebApp(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDeviceClusterDevices", (Object[])uiDeviceCluster.getDevices(), (Object[])new String[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDeviceClusterInstalled", (boolean)uiDeviceCluster.isInstalled(), (boolean)true);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIFiltersTemplate uiFilterTemplate, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiFilterTemplateObject"));
        attrs.put(new BasicAttribute("dcmuiFilterTemplateGroupName", uiFilterTemplate.getFilterGroupName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiFilterTemplateID", (Object)uiFilterTemplate.getFilterGroupID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiFilterTemplateDescription", (Object)uiFilterTemplate.getFilterGroupDescription(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiFilterTemplateUsername", (Object)uiFilterTemplate.getFilterGroupUsername(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiFilterTemplateRole", (Object)uiFilterTemplate.getFilterGroupRole(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiFilterTemplateFilters", (Object[])uiFilterTemplate.getFilters(), (Object[])new String[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiFilterTemplateDefault", (boolean)uiFilterTemplate.isDefault(), (boolean)false);
        return attrs;
    }

    private void storeDiffConfigs(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIDiffConfig uiDiffConfig : uiConfig.getDiffConfigs()) {
            String uiDiffConfigDN = LdapUtils.dnOf((String)"dcmuiDiffConfigName", (String)uiDiffConfig.getName(), (String)uiConfigDN);
            this.config.createSubcontext(uiDiffConfigDN, this.storeTo(diffs, uiDiffConfigDN, uiDiffConfig, new BasicAttributes(true)));
            this.storeDiffCriterias(diffs, uiDiffConfigDN, uiDiffConfig);
        }
    }

    private Attributes storeTo(ConfigurationChanges diffs, String uiDiffConfigDN, UIDiffConfig uiDiffConfig, Attributes attrs) {
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiDiffConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        attrs.put(new BasicAttribute("objectclass", "dcmuiDiffConfig"));
        attrs.put(new BasicAttribute("dcmuiDiffConfigName", uiDiffConfig.getName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffCallingAET", (Object)uiDiffConfig.getCallingAET(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffPrimaryCFindSCP", (Object)uiDiffConfig.getPrimaryCFindSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffPrimaryCMoveSCP", (Object)uiDiffConfig.getPrimaryCMoveSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffPrimaryCStoreSCP", (Object)uiDiffConfig.getPrimaryCStoreSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffSecondaryCFindSCP", (Object)uiDiffConfig.getSecondaryCFindSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffSecondaryCMoveSCP", (Object)uiDiffConfig.getSecondaryCMoveSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffSecondaryCStoreSCP", (Object)uiDiffConfig.getSecondaryCStoreSCP(), null);
        return attrs;
    }

    private void storeDiffCriterias(ConfigurationChanges diffs, String uiDiffConfigDN, UIDiffConfig uiDiffConfig) throws NamingException {
        for (UIDiffCriteria uiDiffCriteria : uiDiffConfig.getCriterias()) {
            String uiDiffCriteriaDN = LdapUtils.dnOf((String)"dcmuiDiffCriteriaTitle", (String)uiDiffCriteria.getTitle(), (String)uiDiffConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiDiffCriteriaDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiDiffCriteriaDN, this.storeTo(ldapObj, uiDiffCriteria, (Attributes)new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIDiffCriteria uiDiffCriteria, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiDiffCriteria"));
        attrs.put(new BasicAttribute("dcmuiDiffCriteriaTitle", uiDiffCriteria.getTitle()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)uiDiffCriteria.getDescription(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffCriteriaNumber", (int)uiDiffCriteria.getNumber(), (int)0);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffIncludeMissing", (boolean)uiDiffCriteria.isIncludeMissing(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAttributeSetID", (Object)uiDiffCriteria.getAttributeSetID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffGroupButton", (Object[])uiDiffCriteria.getGroupButtons(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiDiffAction", (Object[])uiDiffCriteria.getActions(), (Object[])new String[0]);
        return attrs;
    }

    private void storeDashboardConfigs(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIDashboardConfig uiDashboardConfig : uiConfig.getDashboardConfigs()) {
            String uiDashboardConfigDN = LdapUtils.dnOf((String)"dcmuiDashboardConfigName", (String)uiDashboardConfig.getName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiDashboardConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiDashboardConfigDN, this.storeTo(ldapObj1, uiDashboardConfig, (Attributes)new BasicAttributes(true)));
            this.storeCompareSides(diffs, uiDashboardConfigDN, uiDashboardConfig);
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIDashboardConfig uiDashboardConfig, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiDashboardConfig"));
        attrs.put(new BasicAttribute("dcmuiDashboardConfigName", uiDashboardConfig.getName()));
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiQueueName", (Object[])uiDashboardConfig.getQueueNames(), (Object[])new String[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiShowStarBlock", (boolean)uiDashboardConfig.isShowStarBlock(), (boolean)true);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiExportName", (Object[])uiDashboardConfig.getExportNames(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomuiDeviceName", (Object[])uiDashboardConfig.getDeviceNames(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomuiIgnoreParams", (Object[])uiDashboardConfig.getIgnoreParams(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomuiDockerContainer", (Object[])uiDashboardConfig.getDockerContainers(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiCountWebApp", (Object)uiDashboardConfig.getCountWebApp(), null);
        return attrs;
    }

    private void storeElasticsearchConfigs(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIElasticsearchConfig uiElasticSearchConfig : uiConfig.getElasticsearchConfigs()) {
            String uiElasticsearchConfigDN = LdapUtils.dnOf((String)"dcmuiElasticsearchConfigName", (String)uiElasticSearchConfig.getName(), (String)uiConfigDN);
            this.config.createSubcontext(uiElasticsearchConfigDN, this.storeTo(uiElasticSearchConfig, new BasicAttributes(true)));
            this.storeElasticsearchURLs(diffs, uiElasticsearchConfigDN, uiElasticSearchConfig);
        }
    }

    private void storeElasticsearchURLs(ConfigurationChanges diffs, String uiElasticsearchConfigDN, UIElasticsearchConfig uiElasticsearchConfig) throws NamingException {
        for (UIElasticsearchURL uiElasticsearchURL : uiElasticsearchConfig.getURLS()) {
            String uiElasticsearchURLDN = LdapUtils.dnOf((String)"dcmuiElasticsearchURLName", (String)uiElasticsearchURL.getUrlName(), (String)uiElasticsearchConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiElasticsearchURLDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiElasticsearchURLDN, this.storeTo(ldapObj, uiElasticsearchURL, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeLanguageProfiles(ConfigurationChanges diffs, String uiLanguageConfigDN, UILanguageConfig uiLanguageConfig) throws NamingException {
        for (UILanguageProfile uiLanguageProfile : uiLanguageConfig.getLanguageProfiles()) {
            String uiLanguageProfileDN = LdapUtils.dnOf((String)"dcmuiLanguageProfileName", (String)uiLanguageProfile.getProfileName(), (String)uiLanguageConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiLanguageProfileDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiLanguageProfileDN, this.storeTo(ldapObj, uiLanguageProfile, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeTableColumns(ConfigurationChanges diffs, String uiTableConfigDN, UITableConfig uiTableConfig) throws NamingException {
        for (UITableColumn uiTableColumn : uiTableConfig.getTableColumns()) {
            String uiTableColumnDN = LdapUtils.dnOf((String)"dcmuiColumnName", (String)uiTableColumn.getColumnName(), (String)uiTableConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiTableColumnDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiTableColumnDN, this.storeTo(ldapObj, uiTableColumn, (Attributes)new BasicAttributes(true)));
        }
    }

    private void storeLanguageConfigs(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UILanguageConfig uiLanguageConfig : uiConfig.getLanguageConfigs()) {
            String uiLanguageConfigDN = LdapUtils.dnOf((String)"dcmuiLanguageConfigName", (String)uiLanguageConfig.getName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiLanguageConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiLanguageConfigDN, this.storeTo(ldapObj1, uiLanguageConfig, (Attributes)new BasicAttributes(true)));
            this.storeLanguageProfiles(diffs, uiLanguageConfigDN, uiLanguageConfig);
        }
    }

    private void storeLTableConfigs(ConfigurationChanges diffs, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UITableConfig uiTableConfig : uiConfig.getTableConfigs()) {
            String uiTableConfigDN = LdapUtils.dnOf((String)"dcmuiTableConfigName", (String)uiTableConfig.getName(), (String)uiConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiTableConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiTableConfigDN, this.storeTo(ldapObj1, uiTableConfig, (Attributes)new BasicAttributes(true)));
            this.storeTableColumns(diffs, uiTableConfigDN, uiTableConfig);
        }
    }

    private void storeCompareSides(ConfigurationChanges diffs, String uiDashboardConfigDN, UIDashboardConfig uiDashboardConfig) throws NamingException {
        for (UICompareSide uiCompareSide : uiDashboardConfig.getCompareSides()) {
            String uiCompareSideDN = LdapUtils.dnOf((String)"dcmuiCompareSideName", (String)uiCompareSide.getName(), (String)uiDashboardConfigDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiCompareSideDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(uiCompareSideDN, this.storeTo(ldapObj, uiCompareSide, (Attributes)new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(UIElasticsearchConfig uiElasticsearchConfig, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiElasticsearchConfig"));
        attrs.put(new BasicAttribute("dcmuiElasticsearchConfigName", uiElasticsearchConfig.getName()));
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UILanguageConfig uiLanguageConfig, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiLanguageConfig"));
        attrs.put(new BasicAttribute("dcmuiLanguageConfigName", uiLanguageConfig.getName()));
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmLanguages", (Object[])uiLanguageConfig.getLanguages(), (Object[])new String[0]);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UITableConfig tableConfig, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiTableConfig"));
        attrs.put(new BasicAttribute("dcmTableConfigName", tableConfig.getName()));
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiTableConfigUsername", (Object[])tableConfig.getUsername(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiTableConfigRoles", (Object[])tableConfig.getRoles(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiTableID", (Object)tableConfig.getTableId(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiTableConfigIsDefault", (boolean)tableConfig.isDefault(), (boolean)false);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UIElasticsearchURL uiElasticsearchURL, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiElasticsearchURLObjects"));
        attrs.put(new BasicAttribute("dcmuiElasticsearchURLName", uiElasticsearchURL.getUrlName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiElasticsearchWebApp", (Object)uiElasticsearchURL.getUrl(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiAuditEnterpriseSiteID", (Object)uiElasticsearchURL.getAuditEnterpriseSiteID(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiElasticsearchIsDefault", (boolean)uiElasticsearchURL.isDefault(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiElasticsearchInstalled", (boolean)uiElasticsearchURL.isInstalled(), (boolean)true);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UILanguageProfile uiLanguageProfile, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiLanguageProfileObjects"));
        attrs.put(new BasicAttribute("dcmuiLanguageProfileName", uiLanguageProfile.getProfileName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDefaultLanguage", (Object)uiLanguageProfile.getDefaultLanguage(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiLanguageProfileRole", (Object[])uiLanguageProfile.getAcceptedUserRoles(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiLanguageProfileUsername", (Object)uiLanguageProfile.getUserName(), null);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UITableColumn uiTableColumn, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiTableColumnConfigObjects"));
        attrs.put(new BasicAttribute("dcmuiColumnName", uiTableColumn.getColumnName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiColumnId", (Object)uiTableColumn.getColumnId(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiColumnTitle", (Object)uiTableColumn.getColumnTitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiValuePath", (Object)uiTableColumn.getValuePath(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiValueType", (Object)uiTableColumn.getValueType(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiColumnWidth", (Object)uiTableColumn.getColumnWidth(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiColumnOrder", (int)uiTableColumn.getColumnOrder(), (int)0);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UICompareSide uiCompareSide, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmuiCompareSideObjects"));
        attrs.put(new BasicAttribute("dcmuiCompareSideName", uiCompareSide.getName()));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiCompareSideDescription", (Object)uiCompareSide.getDescription(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiCompareSideOrder", (int)uiCompareSide.getOrder(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiCompareSideCluster", (Object)uiCompareSide.getCluster(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiCompareSideElasticsearch", (Object)uiCompareSide.getElasticsearch(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiCompareSideQueueName", (Object)uiCompareSide.getQueueName(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmuiCompareSideInstalled", (boolean)uiCompareSide.isInstalled(), (boolean)true);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChilds(Device device, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmuiConfig)");
        try {
            if (!ne.hasMore()) {
                return;
            }
            UIConfigDeviceExtension ext = new UIConfigDeviceExtension();
            device.addDeviceExtension((DeviceExtension)ext);
            do {
                ext.addUIConfig(this.loadUIConfig((SearchResult)ne.next(), deviceDN));
            } while (ne.hasMore());
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private UIConfig loadUIConfig(SearchResult sr, String deviceDN) throws NamingException {
        Attributes attrs = sr.getAttributes();
        UIConfig uiConfig = new UIConfig(LdapUtils.stringValue((Attribute)attrs.get("dcmuiConfigName"), null));
        String uiConfigDN = this.uiConfigDN(uiConfig, deviceDN);
        uiConfig.setModalities(LdapUtils.stringArray((Attribute)attrs.get("dcmuiModalities"), (String[])new String[0]));
        uiConfig.setWidgetAets(LdapUtils.stringArray((Attribute)attrs.get("dcmuiWidgetAets"), (String[])new String[0]));
        uiConfig.setXdsUrl(LdapUtils.stringValue((Attribute)attrs.get("dcmuiXDSInterfaceURL"), null));
        uiConfig.setBackgroundUrl(LdapUtils.stringValue((Attribute)attrs.get("dcmuiBackgroundURL"), null));
        uiConfig.setDateTimeFormat(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDateTimeFormat"), null));
        uiConfig.setHideClock(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiHideClock"), (boolean)false));
        uiConfig.setPageTitle(LdapUtils.stringValue((Attribute)attrs.get("dcmuiPageTitle"), null));
        uiConfig.setPersonNameFormat(LdapUtils.stringValue((Attribute)attrs.get("dcmuiPersonNameFormat"), null));
        uiConfig.setLogoUrl(LdapUtils.stringValue((Attribute)attrs.get("dcmuiLogoURL"), null));
        uiConfig.setDefaultWidgetAets(LdapUtils.stringArray((Attribute)attrs.get("dcmuiDefaultWidgetAets"), (String[])new String[0]));
        uiConfig.setMWLWorklistLabels(LdapUtils.stringArray((Attribute)attrs.get("dcmuiMWLWorklistLabel"), (String[])new String[0]));
        this.loadPermissions(uiConfig, uiConfigDN);
        this.loadDiffConfigs(uiConfig, uiConfigDN);
        this.loadDashboardConfigs(uiConfig, uiConfigDN);
        this.loadElasticsearchConfigs(uiConfig, uiConfigDN);
        this.loadLanguageConfigs(uiConfig, uiConfigDN);
        this.loadTableConfigs(uiConfig, uiConfigDN);
        this.loadDeviceURLs(uiConfig, uiConfigDN);
        this.loadDeviceClusters(uiConfig, uiConfigDN);
        this.loadFilterTemplates(uiConfig, uiConfigDN);
        this.loadAetList(uiConfig, uiConfigDN);
        this.loadCreateDialogTemplate(uiConfig, uiConfigDN);
        this.loadWebAppList(uiConfig, uiConfigDN);
        return uiConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPermissions(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiPermission)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIPermission uiPermission = new UIPermission((String)attrs.get("dcmuiPermissionName").get());
                uiPermission.setAction(LdapUtils.stringValue((Attribute)attrs.get("dcmuiAction"), null));
                uiPermission.setActionParams(LdapUtils.stringArray((Attribute)attrs.get("dcmuiActionParam"), (String[])new String[0]));
                uiPermission.setAcceptedUserRoles(LdapUtils.stringArray((Attribute)attrs.get("dcmAcceptedUserRole"), (String[])new String[0]));
                uiConfig.addPermission(uiPermission);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAetList(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiAetConfig)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIAetList uiAetList = new UIAetList((String)attrs.get("dcmuiAetListName").get());
                uiAetList.setAetListDescription(LdapUtils.stringValue((Attribute)attrs.get("dcmuiAetListDescription"), null));
                uiAetList.setMode(LdapUtils.stringValue((Attribute)attrs.get("dcmuiMode"), null));
                uiAetList.setAets(LdapUtils.stringArray((Attribute)attrs.get("dcmuiAets"), (String[])new String[0]));
                uiAetList.setAcceptedRole(LdapUtils.stringArray((Attribute)attrs.get("dcmAcceptedUserRole"), (String[])new String[0]));
                uiConfig.addAetList(uiAetList);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCreateDialogTemplate(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiCreateDialogTemplate)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UICreateDialogTemplate uiCreateDialogTemplate = new UICreateDialogTemplate((String)attrs.get("dcmuiTemplateName").get());
                uiCreateDialogTemplate.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
                uiCreateDialogTemplate.setDialog((UIFunction)LdapUtils.enumValue(UIFunction.class, (Attribute)attrs.get("dcmuiDialog"), (Enum)UIFunction.mwl));
                uiCreateDialogTemplate.setTags(this.tags(attrs.get("dcmTag")));
                uiConfig.addCreatDialogTemplate(uiCreateDialogTemplate);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private int[] tags(Attribute attr) throws NamingException {
        if (attr == null) {
            return ByteUtils.EMPTY_INTS;
        }
        int[] is = new int[attr.size()];
        for (int i = 0; i < is.length; ++i) {
            is[i] = TagUtils.intFromHexString((String)((String)attr.get(i)));
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWebAppList(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiWebAppConfig)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIWebAppList uiWebAppList = new UIWebAppList((String)attrs.get("dcmuiWebAppListName").get());
                uiWebAppList.setWebAppListDescription(LdapUtils.stringValue((Attribute)attrs.get("dcmuiWebAppListDescription"), null));
                uiWebAppList.setMode(LdapUtils.stringValue((Attribute)attrs.get("dcmuiMode"), null));
                uiWebAppList.setWebApps(LdapUtils.stringArray((Attribute)attrs.get("dcmuiWebApps"), (String[])new String[0]));
                uiWebAppList.setAcceptedRole(LdapUtils.stringArray((Attribute)attrs.get("dcmAcceptedUserRole"), (String[])new String[0]));
                uiWebAppList.setAcceptedUserName(LdapUtils.stringArray((Attribute)attrs.get("dcmAcceptedUserName"), (String[])new String[0]));
                uiConfig.addWebAppList(uiWebAppList);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeviceURLs(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiDeviceURLObject)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIDeviceURL uiDeviceURL = new UIDeviceURL((String)attrs.get("dcmuiDeviceURLName").get());
                uiDeviceURL.setDeviceURL(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDeviceURL"), null));
                uiDeviceURL.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDeviceURLDescription"), null));
                uiDeviceURL.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiDeviceURLInstalled"), (boolean)true));
                uiConfig.addDeviceURL(uiDeviceURL);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeviceClusters(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiDeviceClusterObject)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIDeviceCluster uiDeviceCluster = new UIDeviceCluster((String)attrs.get("dcmuiDeviceClusterName").get());
                uiDeviceCluster.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDeviceClusterDescription"), null));
                uiDeviceCluster.setClusterWebApp(LdapUtils.stringValue((Attribute)attrs.get("dcmuiClusterWebApp"), null));
                uiDeviceCluster.setDevices(LdapUtils.stringArray((Attribute)attrs.get("dcmuiDeviceClusterDevices"), (String[])new String[0]));
                uiDeviceCluster.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiDeviceClusterInstalled"), (boolean)true));
                uiConfig.addDeviceCluster(uiDeviceCluster);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFilterTemplates(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiFilterTemplateObject)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIFiltersTemplate uiFiltersTemplate = new UIFiltersTemplate((String)attrs.get("dcmuiFilterTemplateGroupName").get());
                uiFiltersTemplate.setFilterGroupID(LdapUtils.stringValue((Attribute)attrs.get("dcmuiFilterTemplateID"), null));
                uiFiltersTemplate.setFilterGroupDescription(LdapUtils.stringValue((Attribute)attrs.get("dcmuiFilterTemplateDescription"), null));
                uiFiltersTemplate.setFilterGroupUsername(LdapUtils.stringValue((Attribute)attrs.get("dcmuiFilterTemplateUsername"), null));
                uiFiltersTemplate.setFilterGroupRole(LdapUtils.stringValue((Attribute)attrs.get("dcmuiFilterTemplateRole"), null));
                uiFiltersTemplate.setFilters(LdapUtils.stringArray((Attribute)attrs.get("dcmuiFilterTemplateFilters"), (String[])new String[0]));
                uiFiltersTemplate.setDefault(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiFilterTemplateDefault"), (boolean)false));
                uiConfig.addFilterTemplate(uiFiltersTemplate);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDiffConfigs(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiDiffConfig)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIDiffConfig uiDiffConfig = new UIDiffConfig((String)attrs.get("dcmuiDiffConfigName").get());
                String uiDiffConfigDN = LdapUtils.dnOf((String)"dcmuiDiffConfigName", (String)uiDiffConfig.getName(), (String)uiConfigDN);
                uiDiffConfig.setCallingAET(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDiffCallingAET"), null));
                uiDiffConfig.setPrimaryCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDiffPrimaryCFindSCP"), null));
                uiDiffConfig.setPrimaryCMoveSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDiffPrimaryCMoveSCP"), null));
                uiDiffConfig.setPrimaryCStoreSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDiffPrimaryCStoreSCP"), null));
                uiDiffConfig.setSecondaryCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDiffSecondaryCFindSCP"), null));
                uiDiffConfig.setSecondaryCMoveSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDiffSecondaryCMoveSCP"), null));
                uiDiffConfig.setSecondaryCStoreSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmuiDiffSecondaryCStoreSCP"), null));
                this.loadDiffCriterias(uiDiffConfig, uiDiffConfigDN);
                uiConfig.addDiffConfig(uiDiffConfig);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDiffCriterias(UIDiffConfig uiDiffConfig, String uiDiffConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiDiffConfigDN, "(objectclass=dcmuiDiffCriteria)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIDiffCriteria uiDiffCriteria = new UIDiffCriteria((String)attrs.get("dcmuiDiffCriteriaTitle").get());
                uiDiffCriteria.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
                uiDiffCriteria.setNumber(LdapUtils.intValue((Attribute)attrs.get("dcmuiDiffCriteriaNumber"), (int)0));
                uiDiffCriteria.setIncludeMissing(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiDiffIncludeMissing"), (boolean)false));
                uiDiffCriteria.setAttributeSetID(LdapUtils.stringValue((Attribute)attrs.get("dcmAttributeSetID"), null));
                uiDiffCriteria.setActions(LdapUtils.stringArray((Attribute)attrs.get("dcmuiDiffAction"), (String[])new String[0]));
                uiDiffCriteria.setGroupButtons(LdapUtils.stringArray((Attribute)attrs.get("dcmuiDiffGroupButton"), (String[])new String[0]));
                uiDiffConfig.addCriteria(uiDiffCriteria);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDashboardConfigs(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiDashboardConfig)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIDashboardConfig uiDashboardConfig = new UIDashboardConfig((String)attrs.get("dcmuiDashboardConfigName").get());
                uiDashboardConfig.setShowStarBlock(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiShowStarBlock"), (boolean)true));
                uiDashboardConfig.setCountWebApp(LdapUtils.stringValue((Attribute)attrs.get("dcmuiCountWebApp"), null));
                uiDashboardConfig.setQueueNames(LdapUtils.stringArray((Attribute)attrs.get("dcmuiQueueName"), (String[])new String[0]));
                uiDashboardConfig.setExportNames(LdapUtils.stringArray((Attribute)attrs.get("dcmuiExportName"), (String[])new String[0]));
                uiDashboardConfig.setDeviceNames(LdapUtils.stringArray((Attribute)attrs.get("dicomuiDeviceName"), (String[])new String[0]));
                uiDashboardConfig.setIgnoreParams(LdapUtils.stringArray((Attribute)attrs.get("dicomuiIgnoreParams"), (String[])new String[0]));
                uiDashboardConfig.setDockerContainers(LdapUtils.stringArray((Attribute)attrs.get("dicomuiDockerContainer"), (String[])new String[0]));
                String uiDashboardConfigDN = LdapUtils.dnOf((String)"dcmuiDashboardConfigName", (String)uiDashboardConfig.getName(), (String)uiConfigDN);
                this.loadCompareSide(uiDashboardConfig, uiDashboardConfigDN);
                uiConfig.addDashboardConfig(uiDashboardConfig);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadElasticsearchConfigs(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiElasticsearchConfig)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIElasticsearchConfig uiElasticsearchConfig = new UIElasticsearchConfig((String)attrs.get("dcmuiElasticsearchConfigName").get());
                String uiElasticsearchConfigDN = LdapUtils.dnOf((String)"dcmuiElasticsearchConfigName", (String)uiElasticsearchConfig.getName(), (String)uiConfigDN);
                this.loadElasticsearchURL(uiElasticsearchConfig, uiElasticsearchConfigDN);
                uiConfig.addElasticsearchConfig(uiElasticsearchConfig);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadElasticsearchURL(UIElasticsearchConfig uiElasticsearchConfig, String uiElasticsearchConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiElasticsearchConfigDN, "(objectclass=dcmuiElasticsearchURLObjects)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UIElasticsearchURL uiElasticsearchURL = new UIElasticsearchURL((String)attrs.get("dcmuiElasticsearchURLName").get());
                uiElasticsearchURL.setUrl(LdapUtils.stringValue((Attribute)attrs.get("dcmuiElasticsearchWebApp"), null));
                uiElasticsearchURL.setAuditEnterpriseSiteID(LdapUtils.stringValue((Attribute)attrs.get("dcmuiAuditEnterpriseSiteID"), null));
                uiElasticsearchURL.setDefault(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiElasticsearchIsDefault"), (boolean)false));
                uiElasticsearchURL.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiElasticsearchInstalled"), (boolean)true));
                uiElasticsearchConfig.addURL(uiElasticsearchURL);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLanguageConfigs(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiLanguageConfig)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UILanguageConfig uiLanguageConfig = new UILanguageConfig((String)attrs.get("dcmuiLanguageConfigName").get());
                String uiLanguageConfigDN = LdapUtils.dnOf((String)"dcmuiLanguageConfigName", (String)uiLanguageConfig.getName(), (String)uiConfigDN);
                uiLanguageConfig.setLanguages(LdapUtils.stringArray((Attribute)attrs.get("dcmLanguages"), (String[])new String[0]));
                this.loadLanguageProfile(uiLanguageConfig, uiLanguageConfigDN);
                uiConfig.addLanguageConfig(uiLanguageConfig);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTableConfigs(UIConfig uiConfig, String uiConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiConfigDN, "(objectclass=dcmuiTableConfig)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UITableConfig uiTableConfig = new UITableConfig((String)attrs.get("dcmuiTableConfigName").get());
                String uiTableConfigDN = LdapUtils.dnOf((String)"dcmuiTableConfigName", (String)uiTableConfig.getName(), (String)uiConfigDN);
                uiTableConfig.setUsername(LdapUtils.stringArray((Attribute)attrs.get("dcmuiTableConfigUsername"), (String[])new String[0]));
                uiTableConfig.setRoles(LdapUtils.stringArray((Attribute)attrs.get("dcmuiTableConfigRoles"), (String[])new String[0]));
                uiTableConfig.setTableId(LdapUtils.stringValue((Attribute)attrs.get("dcmuiTableID"), null));
                uiTableConfig.setDefault(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiTableConfigIsDefault"), (boolean)false));
                this.loadTableColumn(uiTableConfig, uiTableConfigDN);
                uiConfig.addTableConfig(uiTableConfig);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLanguageProfile(UILanguageConfig uiLanguageConfig, String uiLanguageConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiLanguageConfigDN, "(objectclass=dcmuiLanguageProfileObjects)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UILanguageProfile uiLanguageProfile = new UILanguageProfile((String)attrs.get("dcmuiLanguageProfileName").get());
                uiLanguageProfile.setDefaultLanguage(LdapUtils.stringValue((Attribute)attrs.get("dcmDefaultLanguage"), null));
                uiLanguageProfile.setAcceptedUserRoles(LdapUtils.stringArray((Attribute)attrs.get("dcmuiLanguageProfileRole"), (String[])new String[0]));
                uiLanguageProfile.setUserName(LdapUtils.stringValue((Attribute)attrs.get("dcmuiLanguageProfileUsername"), null));
                uiLanguageConfig.addLanguageProfile(uiLanguageProfile);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTableColumn(UITableConfig uiTableConfig, String uiTableConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiTableConfigDN, "(objectclass=dcmuiTableColumnConfigObjects)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UITableColumn uiTableColumn = new UITableColumn((String)attrs.get("dcmuiColumnName").get());
                uiTableColumn.setColumnId(LdapUtils.stringValue((Attribute)attrs.get("dcmuiColumnId"), null));
                uiTableColumn.setColumnTitle(LdapUtils.stringValue((Attribute)attrs.get("dcmuiColumnTitle"), null));
                uiTableColumn.setValuePath(LdapUtils.stringValue((Attribute)attrs.get("dcmuiValuePath"), null));
                uiTableColumn.setValueType(LdapUtils.stringValue((Attribute)attrs.get("dcmuiValueType"), null));
                uiTableColumn.setColumnWidth(LdapUtils.stringValue((Attribute)attrs.get("dcmuiColumnWidth"), null));
                uiTableColumn.setColumnOrder(LdapUtils.intValue((Attribute)attrs.get("dcmuiColumnOrder"), null));
                uiTableConfig.addTableColumn(uiTableColumn);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCompareSide(UIDashboardConfig uiDashboardConfig, String uiDashboardConfigDN) throws NamingException {
        NamingEnumeration ne = this.config.search(uiDashboardConfigDN, "(objectclass=dcmuiCompareSideObjects)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UICompareSide uiCompareSide = new UICompareSide((String)attrs.get("dcmuiCompareSideName").get());
                uiCompareSide.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dcmuiCompareSideDescription"), null));
                uiCompareSide.setOrder(LdapUtils.intValue((Attribute)attrs.get("dcmuiCompareSideOrder"), (int)0));
                uiCompareSide.setCluster(LdapUtils.stringValue((Attribute)attrs.get("dcmuiCompareSideCluster"), null));
                uiCompareSide.setElasticsearch(LdapUtils.stringValue((Attribute)attrs.get("dcmuiCompareSideElasticsearch"), null));
                uiCompareSide.setQueueName(LdapUtils.stringValue((Attribute)attrs.get("dcmuiCompareSideQueueName"), null));
                uiCompareSide.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dcmuiCompareSideInstalled"), (boolean)true));
                uiDashboardConfig.addCompareSide(uiCompareSide);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    protected void mergeChilds(ConfigurationChanges diffs, Device prev, Device device, String deviceDN) throws NamingException {
        UIConfigDeviceExtension prevUIConfigExt = (UIConfigDeviceExtension)prev.getDeviceExtension(UIConfigDeviceExtension.class);
        UIConfigDeviceExtension uiConfigExt = (UIConfigDeviceExtension)device.getDeviceExtension(UIConfigDeviceExtension.class);
        if (prevUIConfigExt != null) {
            for (UIConfig prevUIConfig : prevUIConfigExt.getUIConfigs()) {
                if (uiConfigExt != null && uiConfigExt.getUIConfig(prevUIConfig.getName()) != null) continue;
                String dn = this.uiConfigDN(prevUIConfig, deviceDN);
                this.config.destroySubcontextWithChilds(dn);
                ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
            }
        }
        if (uiConfigExt == null) {
            return;
        }
        for (UIConfig uiConfig : uiConfigExt.getUIConfigs()) {
            if (prevUIConfigExt == null || prevUIConfigExt.getUIConfig(uiConfig.getName()) == null) {
                this.store(diffs, deviceDN, uiConfig);
                continue;
            }
            this.merge(diffs, prevUIConfigExt.getUIConfig(uiConfig.getName()), uiConfig, deviceDN);
        }
    }

    private void merge(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String deviceDN) throws NamingException {
        String uiConfigDN = this.uiConfigDN(uiConfig, deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.config.modifyAttributes(uiConfigDN, this.storeDiff(ldapObj, prevUIConfig, uiConfig, new ArrayList<ModificationItem>()));
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        this.mergeDiffConfigs(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeDashboardConfigs(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeElasticsearchConfigs(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeLanguageConfigs(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeDeviceURL(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeDeviceCluster(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeFilterTemplate(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergePermissions(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeAetLists(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeCreateDialogTemplate(diffs, prevUIConfig, uiConfig, uiConfigDN);
        this.mergeWebAppLists(diffs, prevUIConfig, uiConfig, uiConfigDN);
    }

    private List<ModificationItem> storeDiff(ConfigurationChanges.ModifiedObject ldapObj, UIConfig prevUIConfig, UIConfig uiConfig, ArrayList<ModificationItem> mods) throws NamingException {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiModalities", (Object[])prevUIConfig.getModalities(), (Object[])uiConfig.getModalities(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiWidgetAets", (Object[])prevUIConfig.getWidgetAets(), (Object[])uiConfig.getWidgetAets(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiMWLWorklistLabel", (Object[])prevUIConfig.getMWLWorklistLabels(), (Object[])uiConfig.getMWLWorklistLabels(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiXDSInterfaceURL", (Object)prevUIConfig.getXdsUrl(), (Object)uiConfig.getXdsUrl(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiBackgroundURL", (Object)prevUIConfig.getBackgroundUrl(), (Object)uiConfig.getBackgroundUrl(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDateTimeFormat", (Object)prevUIConfig.getDateTimeFormat(), (Object)uiConfig.getDateTimeFormat(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiHideClock", (boolean)prevUIConfig.isHideClock(), (boolean)uiConfig.isHideClock(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiPageTitle", (Object)prevUIConfig.getPageTitle(), (Object)uiConfig.getPageTitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiPersonNameFormat", (Object)prevUIConfig.getPersonNameFormat(), (Object)uiConfig.getPersonNameFormat(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiLogoURL", (Object)prevUIConfig.getLogoUrl(), (Object)uiConfig.getLogoUrl(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDefaultWidgetAets", (Object[])prevUIConfig.getDefaultWidgetAets(), (Object[])uiConfig.getDefaultWidgetAets(), (Object[])new String[0]);
        return mods;
    }

    private void mergePermissions(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UIPermission prevUIPermission : prevUIConfig.getPermissions()) {
            String prevUIPermissionName = prevUIPermission.getName();
            if (uiConfig.getPermission(prevUIPermissionName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiPermissionName", (String)prevUIPermissionName, (String)uiConfigDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIPermission uiPermission : uiConfig.getPermissions()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiPermissionName = uiPermission.getName();
            dn = LdapUtils.dnOf((String)"dcmuiPermissionName", (String)uiPermissionName, (String)uiConfigDN);
            UIPermission prevUIPermission = prevUIConfig.getPermission(uiPermissionName);
            if (prevUIPermission == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiPermission, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUIPermission, uiPermission, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeAetLists(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UIAetList prevUIAetList : prevUIConfig.getAetLists()) {
            String prevUIAetListName = prevUIAetList.getAetListName();
            if (uiConfig.getAetList(prevUIAetListName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiAetListName", (String)prevUIAetListName, (String)uiConfigDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIAetList uiAetList : uiConfig.getAetLists()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiAetListName = uiAetList.getAetListName();
            dn = LdapUtils.dnOf((String)"dcmuiAetListName", (String)uiAetListName, (String)uiConfigDN);
            UIAetList prevUIAetList = prevUIConfig.getAetList(uiAetListName);
            if (prevUIAetList == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiAetList, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUIAetList, uiAetList, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeCreateDialogTemplate(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UICreateDialogTemplate prevUICreateDialogTemplate : prevUIConfig.getCreateDialogTemplates()) {
            String prevUICreateDialogTemplateName = prevUICreateDialogTemplate.getTemplateName();
            if (uiConfig.getCreateDialogTemplate(prevUICreateDialogTemplateName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiTemplateName", (String)prevUICreateDialogTemplateName, (String)uiConfigDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UICreateDialogTemplate uiCreateDialogTemplate : uiConfig.getCreateDialogTemplates()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiCreateDialogTemplateName = uiCreateDialogTemplate.getTemplateName();
            dn = LdapUtils.dnOf((String)"dcmuiTemplateName", (String)uiCreateDialogTemplateName, (String)uiConfigDN);
            UICreateDialogTemplate prevUICreateDialogTemplate = prevUIConfig.getCreateDialogTemplate(uiCreateDialogTemplateName);
            if (prevUICreateDialogTemplate == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiCreateDialogTemplate, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUICreateDialogTemplate, uiCreateDialogTemplate, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeWebAppLists(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UIWebAppList prevUIWebAppList : prevUIConfig.getWebAppLists()) {
            String prevUIWebAppListName = prevUIWebAppList.getWebAppListName();
            if (uiConfig.getWebAppList(prevUIWebAppListName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiWebAppListName", (String)prevUIWebAppListName, (String)uiConfigDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIWebAppList uiWebAppList : uiConfig.getWebAppLists()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiWebAppListName = uiWebAppList.getWebAppListName();
            dn = LdapUtils.dnOf((String)"dcmuiWebAppListName", (String)uiWebAppListName, (String)uiConfigDN);
            UIWebAppList prevUIWebAppList = prevUIConfig.getWebAppList(uiWebAppListName);
            if (prevUIWebAppList == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiWebAppList, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUIWebAppList, uiWebAppList, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeDeviceURL(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UIDeviceURL prevUIDeviceURL : prevUIConfig.getDeviceURLs()) {
            String prevUIDeviceURLName = prevUIDeviceURL.getDeviceName();
            if (uiConfig.getDeviceURL(prevUIDeviceURLName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiDeviceURLName", (String)prevUIDeviceURLName, (String)uiConfigDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIDeviceURL uiDeviceURL : uiConfig.getDeviceURLs()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiDeviceURLName = uiDeviceURL.getDeviceName();
            dn = LdapUtils.dnOf((String)"dcmuiDeviceURLName", (String)uiDeviceURLName, (String)uiConfigDN);
            UIDeviceURL prevUIDeviceURL = prevUIConfig.getDeviceURL(uiDeviceURLName);
            if (prevUIDeviceURL == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiDeviceURL, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUIDeviceURL, uiDeviceURL, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeFilterTemplate(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UIFiltersTemplate prevUIFiltersTemplate : prevUIConfig.getFilterTemplates()) {
            String prevUIFiltersTemplateName = prevUIFiltersTemplate.getFilterGroupName();
            if (uiConfig.getFilterTemplate(prevUIFiltersTemplateName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiFilterTemplateGroupName", (String)prevUIFiltersTemplateName, (String)uiConfigDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIFiltersTemplate uiFiltersTemplate : uiConfig.getFilterTemplates()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiFiltersTemplateGroupName = uiFiltersTemplate.getFilterGroupName();
            dn = LdapUtils.dnOf((String)"dcmuiFilterTemplateGroupName", (String)uiFiltersTemplateGroupName, (String)uiConfigDN);
            UIFiltersTemplate prevUIFiltersTemplate = prevUIConfig.getFilterTemplate(uiFiltersTemplateGroupName);
            if (prevUIFiltersTemplate == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiFiltersTemplate, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUIFiltersTemplate, uiFiltersTemplate, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeDeviceCluster(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UIDeviceCluster prevUIDeviceCluster : prevUIConfig.getDeviceClusters()) {
            String prevUIDeviceClusterName = prevUIDeviceCluster.getClusterName();
            if (uiConfig.getDeviceCluster(prevUIDeviceClusterName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiDeviceClusterName", (String)prevUIDeviceClusterName, (String)uiConfigDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIDeviceCluster uiDeviceCluster : uiConfig.getDeviceClusters()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiDeviceClusterName = uiDeviceCluster.getClusterName();
            dn = LdapUtils.dnOf((String)"dcmuiDeviceClusterName", (String)uiDeviceClusterName, (String)uiConfigDN);
            UIDeviceCluster prevUIDeviceCluster = prevUIConfig.getDeviceCluster(uiDeviceClusterName);
            if (prevUIDeviceCluster == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiDeviceCluster, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUIDeviceCluster, uiDeviceCluster, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UIPermission prev, UIPermission uiPermission, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiAction", (Object)prev.getAction(), (Object)uiPermission.getAction(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiActionParam", (Object[])prev.getActionParams(), (Object[])uiPermission.getActionParams(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptedUserRole", (Object[])prev.getAcceptedUserRoles(), (Object[])uiPermission.getAcceptedUserRoles(), (Object[])new String[0]);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UIAetList prev, UIAetList uiAetList, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiAetListDescription", (Object)prev.getAetListDescription(), (Object)uiAetList.getAetListDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiMode", (Object)prev.getMode(), (Object)uiAetList.getMode(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiAets", (Object[])prev.getAets(), (Object[])uiAetList.getAets(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptedUserRole", (Object[])prev.getAcceptedRole(), (Object[])uiAetList.getAcceptedRole(), (Object[])new String[0]);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UICreateDialogTemplate prev, UICreateDialogTemplate uiCreateDialogTemplate, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)prev.getDescription(), (Object)uiCreateDialogTemplate.getDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDialog", (Object)((Object)prev.getDialog()), (Object)((Object)uiCreateDialogTemplate.getDialog()), (Object)((Object)UIFunction.mwl));
        this.storeDiffTags(mods, "dcmTag", prev.getTags(), uiCreateDialogTemplate.getTags());
        return mods;
    }

    private void storeDiffTags(List<ModificationItem> mods, String attrId, int[] prevs, int[] vals) {
        if (!Arrays.equals(prevs, vals)) {
            mods.add(vals == null || vals.length == 0 ? new ModificationItem(3, new BasicAttribute(attrId)) : new ModificationItem(2, this.tagsAttr(attrId, vals)));
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UIWebAppList prev, UIWebAppList uiWebAppList, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiWebAppListDescription", (Object)prev.getWebAppListDescription(), (Object)uiWebAppList.getWebAppListDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiMode", (Object)prev.getMode(), (Object)uiWebAppList.getMode(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiWebApps", (Object[])prev.getWebApps(), (Object[])uiWebAppList.getWebApps(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptedUserRole", (Object[])prev.getAcceptedRole(), (Object[])uiWebAppList.getAcceptedRole(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptedUserName", (Object[])prev.getAcceptedUserName(), (Object[])uiWebAppList.getAcceptedUserName(), (Object[])new String[0]);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UIDeviceURL prev, UIDeviceURL uiDeviceURL, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDeviceURL", (Object)prev.getDeviceURL(), (Object)uiDeviceURL.getDeviceURL(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDeviceURLDescription", (Object)prev.getDescription(), (Object)uiDeviceURL.getDescription(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDeviceURLInstalled", (boolean)prev.isInstalled(), (boolean)uiDeviceURL.isInstalled(), (boolean)true);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UIFiltersTemplate prev, UIFiltersTemplate uiFiltersTemplate, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiFilterTemplateID", (Object)prev.getFilterGroupID(), (Object)uiFiltersTemplate.getFilterGroupID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiFilterTemplateDescription", (Object)prev.getFilterGroupDescription(), (Object)uiFiltersTemplate.getFilterGroupDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiFilterTemplateUsername", (Object)prev.getFilterGroupUsername(), (Object)uiFiltersTemplate.getFilterGroupUsername(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiFilterTemplateRole", (Object)prev.getFilterGroupRole(), (Object)uiFiltersTemplate.getFilterGroupRole(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiFilterTemplateFilters", (Object[])prev.getFilters(), (Object[])uiFiltersTemplate.getFilters(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiFilterTemplateDefault", (boolean)prev.isDefault(), (boolean)uiFiltersTemplate.isDefault(), (boolean)false);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UIDeviceCluster prev, UIDeviceCluster uiDeviceCluster, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDeviceClusterDevices", (Object[])prev.getDevices(), (Object[])uiDeviceCluster.getDevices(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDeviceClusterDescription", (Object)prev.getDescription(), (Object)uiDeviceCluster.getDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiClusterWebApp", (Object)prev.getClusterWebApp(), (Object)uiDeviceCluster.getClusterWebApp(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDeviceClusterInstalled", (boolean)prev.isInstalled(), (boolean)uiDeviceCluster.isInstalled(), (boolean)true);
        return mods;
    }

    private void mergeDashboardConfigs(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UIDashboardConfig prevUIDashboardConfig : prevUIConfig.getDashboardConfigs()) {
            String prevUIDashboardConfigName = prevUIDashboardConfig.getName();
            if (uiConfig.getDashboardConfig(prevUIDashboardConfigName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiDashboardConfigName", (String)prevUIDashboardConfigName, (String)uiConfigDN);
            for (UICompareSide prevCompareSide : prevUIDashboardConfig.getCompareSides()) {
                this.deleteCompareSide(diffs, prevCompareSide.getName(), dn);
            }
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIDashboardConfig uiDashboardConfig : uiConfig.getDashboardConfigs()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiDashboardConfigName = uiDashboardConfig.getName();
            dn = LdapUtils.dnOf((String)"dcmuiDashboardConfigName", (String)uiDashboardConfigName, (String)uiConfigDN);
            UIDashboardConfig prevUIDashboardConfig = prevUIConfig.getDashboardConfig(uiDashboardConfigName);
            if (prevUIDashboardConfig == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiDashboardConfig, (Attributes)new BasicAttributes(true)));
                this.storeCompareSides(diffs, dn, uiDashboardConfig);
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(diffs, dn, ldapObj, prevUIDashboardConfig, uiDashboardConfig, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeUIDashboardConfig(ConfigurationChanges diffs, String uiDashboardConfigDN, UIDashboardConfig a, UIDashboardConfig b, ArrayList<ModificationItem> mods) throws NamingException {
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiDashboardConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.mergeUICompareSide(diffs, a, b, uiDashboardConfigDN);
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        return mods;
    }

    private void mergeUICompareSide(ConfigurationChanges diffs, UIDashboardConfig prevUIDashboardConfig, UIDashboardConfig uiDashboardConfig, String uiDashboardConfigDN) throws NamingException {
        for (UICompareSide prevUICompareSide : prevUIDashboardConfig.getCompareSides()) {
            String prevUICompareSideName = prevUICompareSide.getName();
            if (uiDashboardConfig.getCompareSide(prevUICompareSideName) != null) continue;
            this.deleteUICompareSide(diffs, prevUICompareSideName, uiDashboardConfigDN);
        }
        for (UICompareSide uiCompareSide : uiDashboardConfig.getCompareSides()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiCompareSideName = uiCompareSide.getName();
            UICompareSide prevUICompareSide = prevUIDashboardConfig.getCompareSide(uiCompareSideName);
            String uiUICompareSideDN = LdapUtils.dnOf((String)"dcmuiCompareSideName", (String)uiCompareSide.getName(), (String)uiDashboardConfigDN);
            if (prevUICompareSide == null) {
                ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiUICompareSideDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(uiUICompareSideDN, this.storeTo(ldapObj, uiCompareSide, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiDashboardConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(uiUICompareSideDN, this.storeDiff(ldapObj, prevUICompareSide, uiCompareSide, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void deleteUICompareSide(ConfigurationChanges diffs, String prevUIDashboardConfigName, String uiDashboardConfigDN) throws NamingException {
        String dn = LdapUtils.dnOf((String)"dcmuiCompareSideName", (String)prevUIDashboardConfigName, (String)uiDashboardConfigDN);
        this.config.destroySubcontext(dn);
        ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
    }

    private void mergeElasticsearchConfigs(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIElasticsearchConfig prevUIElasticsearchConfig : prevUIConfig.getElasticsearchConfigs()) {
            String prevUIElasticsearchConfigName = prevUIElasticsearchConfig.getName();
            if (uiConfig.getElasticsearchConfig(prevUIElasticsearchConfigName) != null) continue;
            String dn = LdapUtils.dnOf((String)"dcmuiElasticsearchConfigName", (String)prevUIElasticsearchConfigName, (String)uiConfigDN);
            for (UIElasticsearchURL prevUIElasticsearchURL : prevUIElasticsearchConfig.getURLS()) {
                this.deleteUIElasticsearchURL(diffs, prevUIElasticsearchURL.getUrlName(), dn);
            }
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIElasticsearchConfig uiElasticsearchConfig : uiConfig.getElasticsearchConfigs()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiElasticsearchConfigName = uiElasticsearchConfig.getName();
            String uiElasticsearchConfigDN = LdapUtils.dnOf((String)"dcmuiElasticsearchConfigName", (String)uiElasticsearchConfigName, (String)uiConfigDN);
            UIElasticsearchConfig prevUIElasticsearchConfig = prevUIConfig.getElasticsearchConfig(uiElasticsearchConfigName);
            if (prevUIElasticsearchConfig == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiElasticsearchConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(uiElasticsearchConfigDN, this.storeTo(uiElasticsearchConfig, new BasicAttributes(true)));
                this.storeElasticsearchURLs(diffs, uiElasticsearchConfigDN, uiElasticsearchConfig);
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiElasticsearchConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(uiElasticsearchConfigDN, this.storeUIElasticsearchConfig(diffs, uiElasticsearchConfigDN, prevUIElasticsearchConfig, uiElasticsearchConfig, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeLanguageConfigs(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        String dn;
        for (UILanguageConfig prevUILanguageConfig : prevUIConfig.getLanguageConfigs()) {
            String prevUILanguageConfigName = prevUILanguageConfig.getName();
            if (uiConfig.getLanguageConfig(prevUILanguageConfigName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmuiLanguageConfigName", (String)prevUILanguageConfigName, (String)uiConfigDN);
            for (UILanguageProfile prevLanguageProfile : prevUILanguageConfig.getLanguageProfiles()) {
                this.deleteUILanguageProfile(diffs, prevLanguageProfile.getProfileName(), dn);
            }
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UILanguageConfig uiLanguageConfig : uiConfig.getLanguageConfigs()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiLanguageConfigName = uiLanguageConfig.getName();
            dn = LdapUtils.dnOf((String)"dcmuiLanguageConfigName", (String)uiLanguageConfigName, (String)uiConfigDN);
            UILanguageConfig prevUILanguageConfig = prevUIConfig.getLanguageConfig(uiLanguageConfigName);
            if (prevUILanguageConfig == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), uiLanguageConfig, (Attributes)new BasicAttributes(true)));
                this.storeLanguageProfiles(diffs, dn, uiLanguageConfig);
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeUILanguageConfig(diffs, dn, prevUILanguageConfig, uiLanguageConfig, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void deleteUIElasticsearchURL(ConfigurationChanges diffs, String prevUIElasticsearchConfigName, String uiElasticsearcConfigDN) throws NamingException {
        String dn = LdapUtils.dnOf((String)"dcmuiElasticsearchURLName", (String)prevUIElasticsearchConfigName, (String)uiElasticsearcConfigDN);
        this.config.destroySubcontext(dn);
        ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
    }

    private void deleteUILanguageProfile(ConfigurationChanges diffs, String prevUILanguageConfigName, String uiLanguageConfigDN) throws NamingException {
        String dn = LdapUtils.dnOf((String)"dcmuiLanguageProfileName", (String)prevUILanguageConfigName, (String)uiLanguageConfigDN);
        this.config.destroySubcontext(dn);
        ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
    }

    private void deleteCompareSide(ConfigurationChanges diffs, String prevCompareSideName, String uiUIDashboardConfigDN) throws NamingException {
        String dn = LdapUtils.dnOf((String)"dcmuiCompareSideName", (String)prevCompareSideName, (String)uiUIDashboardConfigDN);
        this.config.destroySubcontext(dn);
        ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
    }

    private List<ModificationItem> storeUIElasticsearchConfig(ConfigurationChanges diffs, String uiElasticsearcConfigDN, UIElasticsearchConfig a, UIElasticsearchConfig b, ArrayList<ModificationItem> mods) throws NamingException {
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiElasticsearcConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.mergeUIElasticsearchURLs(diffs, a, b, uiElasticsearcConfigDN);
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        return mods;
    }

    private List<ModificationItem> storeUILanguageConfig(ConfigurationChanges diffs, String uiLanguageConfigDN, UILanguageConfig a, UILanguageConfig b, ArrayList<ModificationItem> mods) throws NamingException {
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiLanguageConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.mergeUILanguageProfiles(diffs, a, b, uiLanguageConfigDN);
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        return mods;
    }

    private void mergeUILanguageProfiles(ConfigurationChanges diffs, UILanguageConfig prevUILanguageConfig, UILanguageConfig uiLanguageConfig, String uiLanguageConfigDN) throws NamingException {
        for (UILanguageProfile prevUILanguageProfile : prevUILanguageConfig.getLanguageProfiles()) {
            String prevUILanguageProfileName = prevUILanguageProfile.getProfileName();
            if (uiLanguageConfig.getLanguageProfile(prevUILanguageProfileName) != null) continue;
            this.deleteUILanguageProfile(diffs, prevUILanguageProfileName, uiLanguageConfigDN);
        }
        for (UILanguageProfile uiLanguageProfile : uiLanguageConfig.getLanguageProfiles()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiLanguageProfileName = uiLanguageProfile.getProfileName();
            UILanguageProfile prevLanguageProfile = prevUILanguageConfig.getLanguageProfile(uiLanguageProfileName);
            String uiLanguageProfileDN = LdapUtils.dnOf((String)"dcmuiLanguageProfileName", (String)uiLanguageProfile.getProfileName(), (String)uiLanguageConfigDN);
            if (prevLanguageProfile == null) {
                ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiLanguageProfileDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(uiLanguageProfileDN, this.storeTo(ldapObj, uiLanguageProfile, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiLanguageConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(uiLanguageProfileDN, this.storeLanguageProfile(ldapObj, prevLanguageProfile, uiLanguageProfile, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeUIElasticsearchURLs(ConfigurationChanges diffs, UIElasticsearchConfig prevUIElasticsearchConfig, UIElasticsearchConfig uiElasticsearchConfig, String uiElasticsearchConfigDN) throws NamingException {
        for (UIElasticsearchURL prevUIElasticsearchURL : prevUIElasticsearchConfig.getURLS()) {
            String prevUIElasticsearchURLUrlName = prevUIElasticsearchURL.getUrlName();
            if (uiElasticsearchConfig.getURL(prevUIElasticsearchURLUrlName) != null) continue;
            this.deleteUIElasticsearchURL(diffs, prevUIElasticsearchURLUrlName, uiElasticsearchConfigDN);
        }
        for (UIElasticsearchURL uiElasticsearchURL : uiElasticsearchConfig.getURLS()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiElasticserachURLName = uiElasticsearchURL.getUrlName();
            UIElasticsearchURL prevElasticserachURL = prevUIElasticsearchConfig.getURL(uiElasticserachURLName);
            String uiElasticsearchURLDN = LdapUtils.dnOf((String)"dcmuiElasticsearchURLName", (String)uiElasticsearchURL.getUrlName(), (String)uiElasticsearchConfigDN);
            if (prevElasticserachURL == null) {
                ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiElasticsearchURLDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(uiElasticsearchURLDN, this.storeTo(ldapObj, uiElasticsearchURL, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiElasticsearchConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(uiElasticsearchURLDN, this.storeDiff(ldapObj, prevElasticserachURL, uiElasticsearchURL, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiff(ConfigurationChanges.ModifiedObject ldapObj, UIElasticsearchURL prev, UIElasticsearchURL uiElasticsearchURL, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiElasticsearchWebApp", (Object)prev.getUrl(), (Object)uiElasticsearchURL.getUrl(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiAuditEnterpriseSiteID", (Object)prev.getAuditEnterpriseSiteID(), (Object)uiElasticsearchURL.getAuditEnterpriseSiteID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiElasticsearchIsDefault", (boolean)prev.isDefault(), (boolean)uiElasticsearchURL.isDefault(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiElasticsearchInstalled", (boolean)prev.isInstalled(), (boolean)uiElasticsearchURL.isInstalled(), (boolean)true);
        return mods;
    }

    private List<ModificationItem> storeLanguageProfile(ConfigurationChanges.ModifiedObject ldapObj, UILanguageProfile prev, UILanguageProfile uiLanguageProfile, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDefaultLanguage", (Object)prev.getDefaultLanguage(), (Object)uiLanguageProfile.getDefaultLanguage(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiLanguageProfileRole", (Object[])prev.getAcceptedUserRoles(), (Object[])uiLanguageProfile.getAcceptedUserRoles(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiLanguageProfileUsername", (Object)prev.getUserName(), (Object)uiLanguageProfile.getUserName(), null);
        return mods;
    }

    private List<ModificationItem> storeDiff(ConfigurationChanges.ModifiedObject ldapObj, UICompareSide prev, UICompareSide uiCompareSide, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiCompareSideName", (Object)prev.getName(), (Object)uiCompareSide.getName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiCompareSideDescription", (Object)prev.getDescription(), (Object)uiCompareSide.getDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiCompareSideOrder", (Object)prev.getOrder(), (Object)uiCompareSide.getOrder(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiCompareSideCluster", (Object)prev.getCluster(), (Object)uiCompareSide.getCluster(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiCompareSideElasticsearch", (Object)prev.getElasticsearch(), (Object)uiCompareSide.getElasticsearch(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiCompareSideQueueName", (Object)prev.getQueueName(), (Object)uiCompareSide.getQueueName(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiCompareSideInstalled", (boolean)prev.isInstalled(), (boolean)uiCompareSide.isInstalled(), (boolean)true);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges diffs, String dn, ConfigurationChanges.ModifiedObject ldapObj, UIDashboardConfig prev, UIDashboardConfig uiDashboardConfig, ArrayList<ModificationItem> mods) throws NamingException {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiQueueName", (Object[])prev.getQueueNames(), (Object[])uiDashboardConfig.getQueueNames(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiExportName", (Object[])prev.getExportNames(), (Object[])uiDashboardConfig.getExportNames(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomuiDeviceName", (Object[])prev.getDeviceNames(), (Object[])uiDashboardConfig.getDeviceNames(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomuiIgnoreParams", (Object[])prev.getIgnoreParams(), (Object[])uiDashboardConfig.getIgnoreParams(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiShowStarBlock", (boolean)prev.isShowStarBlock(), (boolean)uiDashboardConfig.isShowStarBlock(), (boolean)true);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomuiDockerContainer", (Object[])prev.getDockerContainers(), (Object[])uiDashboardConfig.getDockerContainers(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiCountWebApp", (Object)prev.getCountWebApp(), (Object)uiDashboardConfig.getCountWebApp(), null);
        this.mergeUICompareSide(diffs, prev, uiDashboardConfig, dn);
        return mods;
    }

    private void mergeDiffConfigs(ConfigurationChanges diffs, UIConfig prevUIConfig, UIConfig uiConfig, String uiConfigDN) throws NamingException {
        for (UIDiffConfig prevUIDiffConfig : prevUIConfig.getDiffConfigs()) {
            String prevUIDiffConfigName = prevUIDiffConfig.getName();
            if (uiConfig.getDiffConfig(prevUIDiffConfigName) != null) continue;
            String dn = LdapUtils.dnOf((String)"dcmuiDiffConfigName", (String)prevUIDiffConfigName, (String)uiConfigDN);
            for (UIDiffCriteria prevUIDiffCriteria : prevUIDiffConfig.getCriterias()) {
                this.deleteCriteria(diffs, prevUIDiffCriteria.getTitle(), dn);
            }
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UIDiffConfig uiDiffConfig : uiConfig.getDiffConfigs()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiDiffConfigName = uiDiffConfig.getName();
            String uiDiffConfigDN = LdapUtils.dnOf((String)"dcmuiDiffConfigName", (String)uiDiffConfigName, (String)uiConfigDN);
            UIDiffConfig prevUIDiffConfig = prevUIConfig.getDiffConfig(uiDiffConfigName);
            if (prevUIDiffConfig == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiDiffConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(uiDiffConfigDN, this.storeTo(diffs, uiDiffConfigDN, uiDiffConfig, new BasicAttributes(true)));
                this.storeDiffCriterias(diffs, uiDiffConfigDN, uiDiffConfig);
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiDiffConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(uiDiffConfigDN, this.storeDiffs(diffs, uiDiffConfigDN, prevUIDiffConfig, uiDiffConfig, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges diffs, String uiDiffConfigDN, UIDiffConfig prev, UIDiffConfig uiDiffConfig, ArrayList<ModificationItem> mods) throws NamingException {
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiDiffConfigDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffCallingAET", (Object)prev.getCallingAET(), (Object)uiDiffConfig.getCallingAET(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffPrimaryCFindSCP", (Object)prev.getPrimaryCFindSCP(), (Object)uiDiffConfig.getPrimaryCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffPrimaryCMoveSCP", (Object)prev.getPrimaryCMoveSCP(), (Object)uiDiffConfig.getPrimaryCMoveSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffPrimaryCStoreSCP", (Object)prev.getPrimaryCStoreSCP(), (Object)uiDiffConfig.getPrimaryCStoreSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffSecondaryCFindSCP", (Object)prev.getSecondaryCFindSCP(), (Object)uiDiffConfig.getSecondaryCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffSecondaryCMoveSCP", (Object)prev.getSecondaryCMoveSCP(), (Object)uiDiffConfig.getSecondaryCMoveSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffSecondaryCStoreSCP", (Object)prev.getSecondaryCStoreSCP(), (Object)uiDiffConfig.getSecondaryCStoreSCP(), null);
        this.mergeUIDiffCriteria(diffs, prev, uiDiffConfig, uiDiffConfigDN);
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        return mods;
    }

    private void mergeUIDiffCriteria(ConfigurationChanges diffs, UIDiffConfig prevUIDiffConfig, UIDiffConfig uiDiffConfig, String uiDiffConfigDN) throws NamingException {
        for (UIDiffCriteria prevUIDiffCriteria : prevUIDiffConfig.getCriterias()) {
            String prevUIDiffCriteriaTitle = prevUIDiffCriteria.getTitle();
            if (uiDiffConfig.getCriteria(prevUIDiffCriteriaTitle) != null) continue;
            this.deleteCriteria(diffs, prevUIDiffCriteriaTitle, uiDiffConfigDN);
        }
        for (UIDiffCriteria uiDiffCriteria : uiDiffConfig.getCriterias()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String uiDiffCriteriaTitle = uiDiffCriteria.getTitle();
            UIDiffCriteria prevUIDiffCriteria = prevUIDiffConfig.getCriteria(uiDiffCriteriaTitle);
            String uiDiffCriteriaDN = LdapUtils.dnOf((String)"dcmuiDiffCriteriaTitle", (String)uiDiffCriteria.getTitle(), (String)uiDiffConfigDN);
            if (prevUIDiffCriteria == null) {
                ldapObj = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)uiDiffCriteriaDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(uiDiffCriteriaDN, this.storeTo(ldapObj, uiDiffCriteria, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)uiDiffCriteriaDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(uiDiffCriteriaDN, this.storeDiffs(ldapObj, prevUIDiffCriteria, uiDiffCriteria, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void deleteCriteria(ConfigurationChanges diffs, String prevUIDiffCriteriaTitle, String uiDiffConfigDN) throws NamingException {
        String dn = LdapUtils.dnOf((String)"dcmuiDiffCriteriaTitle", (String)prevUIDiffCriteriaTitle, (String)uiDiffConfigDN);
        this.config.destroySubcontext(dn);
        ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UIDiffCriteria prev, UIDiffCriteria uiDiffCriteria, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)prev.getDescription(), (Object)uiDiffCriteria.getDescription(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffCriteriaNumber", (int)prev.getNumber(), (int)uiDiffCriteria.getNumber(), (int)0);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffIncludeMissing", (boolean)prev.isIncludeMissing(), (boolean)uiDiffCriteria.isIncludeMissing(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAttributeSetID", (Object)prev.getAttributeSetID(), (Object)uiDiffCriteria.getAttributeSetID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffAction", (Object[])prev.getActions(), (Object[])uiDiffCriteria.getActions(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmuiDiffGroupButton", (Object[])prev.getGroupButtons(), (Object[])uiDiffCriteria.getGroupButtons(), (Object[])new String[0]);
        return mods;
    }
}

