/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.ldap;

import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.ldap.LdapDicomConfiguration;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.conf.ldap.hl7.LdapHL7ConfigurationExtension;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7ApplicationExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.HL7ImportReportAdjustIUID;
import org.dcm4chee.arc.conf.HL7ImportReportMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7ImportReportMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7ORUAction;
import org.dcm4chee.arc.conf.HL7OrderMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7ReferredMergedPatientPolicy;
import org.dcm4chee.arc.conf.ScheduledProtocolCodeInOrder;
import org.dcm4chee.arc.conf.ScheduledStationAETInOrder;
import org.dcm4chee.arc.conf.ldap.LdapArchiveConfiguration;

public class LdapArchiveHL7Configuration
extends LdapHL7ConfigurationExtension {
    public void storeTo(ConfigurationChanges.ModifiedObject ldapObj, HL7Application hl7App, String deviceDN, Attributes attrs) {
        ArchiveHL7ApplicationExtension ext = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (ext == null) {
            return;
        }
        attrs.get("objectclass").add("dcmArchiveHL7Application");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PatientUpdateTemplateURI", (Object)ext.getPatientUpdateTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportTemplateURI", (Object)ext.getImportReportTemplateURI(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportTemplateParam", (Map)ext.getImportReportTemplateParams());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ScheduleProcedureTemplateURI", (Object)ext.getScheduleProcedureTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7LogFilePattern", (Object)ext.getHL7LogFilePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ErrorLogFilePattern", (Object)ext.getHL7ErrorLogFilePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomAETitle", (Object)ext.getAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRecordAttributeModification", (Object)ext.getRecordAttributeModification(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ScheduledProtocolCodeInOrder", (Object)ext.getHL7ScheduledProtocolCodeInOrder(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ScheduledStationAETInOrder", (Object)ext.getHL7ScheduledStationAETInOrder(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7NoPatientCreateMessageType", (Object[])ext.getHL7NoPatientCreateMessageTypes(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7UseNullValue", (Object)ext.getHL7UseNullValue(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OrderMissingStudyIUIDPolicy", (Object)ext.getHL7OrderMissingStudyIUIDPolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OrderMissingAdmissionIDPolicy", (Object)ext.getHl7OrderMissingAdmissionIDPolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportMissingStudyIUIDPolicy", (Object)ext.getHl7ImportReportMissingStudyIUIDPolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportMissingAdmissionIDPolicy", (Object)ext.getHl7ImportReportMissingAdmissionIDPolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportMissingStudyIUIDCFindSCP", (Object)ext.getHl7ImportReportMissingStudyIUIDCFindSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportAdjustIUID", (Object)ext.getHl7ImportReportAdjustIUID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7DicomCharacterSet", (Object)ext.getHl7DicomCharacterSet(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7VeterinaryUsePatientName", (Object)ext.getHl7VeterinaryUsePatientName(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ORUAction", (Object[])ext.getHl7ORUAction(), (Object[])new HL7ORUAction[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLWorklistLabel", (Object)ext.getMWLWorklistLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLAccessionNumberGenerator", (Object)ext.getMWLAccessionNumberGenerator(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLRequestedProcedureIDGenerator", (Object)ext.getMWLRequestedProcedureIDGenerator(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLScheduledProcedureStepIDGenerator", (Object)ext.getMWLScheduledProcedureStepIDGenerator(), null);
        LdapUtils.storeNotNull((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditHL7MsgLimit", (Integer)ext.getAuditHL7MsgLimit());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ReferredMergedPatientPolicy", (Object)ext.getHl7ReferredMergedPatientPolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PatientArrivalMessageType", (Object)ext.getHL7PatientArrivalMessageType(), null);
    }

    public void storeChilds(ConfigurationChanges diffs, String appDN, HL7Application hl7App) throws NamingException {
        ArchiveHL7ApplicationExtension ext = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (ext == null) {
            return;
        }
        LdapDicomConfiguration config = this.getDicomConfiguration();
        LdapArchiveConfiguration.storeHL7ForwardRules(diffs, ext.getHL7ForwardRules(), appDN, config);
        LdapArchiveConfiguration.storeHL7ExportRules(diffs, ext.getHL7ExportRules(), appDN, config);
        LdapArchiveConfiguration.storeHL7PrefetchRules(diffs, ext.getHL7PrefetchRules(), appDN, config);
        LdapArchiveConfiguration.storeScheduledStations(diffs, ext.getHL7OrderScheduledStations(), appDN, config);
        LdapArchiveConfiguration.storeHL7OrderSPSStatus(diffs, ext.getHL7OrderSPSStatuses(), appDN, config);
        LdapArchiveConfiguration.storeHL7StudyRetentionPolicies(diffs, ext.getHL7StudyRetentionPolicies(), appDN, config);
        LdapArchiveConfiguration.storeUPSOnHL7List(diffs, ext.listUPSOnHL7(), appDN, config);
    }

    public void loadFrom(HL7Application hl7App, Attributes attrs) throws NamingException {
        if (!LdapUtils.hasObjectClass((Attributes)attrs, (String)"dcmArchiveHL7Application")) {
            return;
        }
        ArchiveHL7ApplicationExtension ext = new ArchiveHL7ApplicationExtension();
        hl7App.addHL7ApplicationExtension((HL7ApplicationExtension)ext);
        ext.setPatientUpdateTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7PatientUpdateTemplateURI"), null));
        ext.setImportReportTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7ImportReportTemplateURI"), null));
        ext.setImportReportTemplateParams(LdapUtils.stringArray((Attribute)attrs.get("hl7ImportReportTemplateParam"), (String[])new String[0]));
        ext.setScheduleProcedureTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7ScheduleProcedureTemplateURI"), null));
        ext.setHL7LogFilePattern(LdapUtils.stringValue((Attribute)attrs.get("hl7LogFilePattern"), null));
        ext.setHL7ErrorLogFilePattern(LdapUtils.stringValue((Attribute)attrs.get("hl7ErrorLogFilePattern"), null));
        ext.setAETitle(LdapUtils.stringValue((Attribute)attrs.get("dicomAETitle"), null));
        ext.setRecordAttributeModification(LdapUtils.booleanValue((Attribute)attrs.get("dcmRecordAttributeModification"), null));
        ext.setHL7ScheduledProtocolCodeInOrder((ScheduledProtocolCodeInOrder)LdapUtils.enumValue(ScheduledProtocolCodeInOrder.class, (Attribute)attrs.get("hl7ScheduledProtocolCodeInOrder"), null));
        ext.setHL7ScheduledStationAETInOrder((ScheduledStationAETInOrder)LdapUtils.enumValue(ScheduledStationAETInOrder.class, (Attribute)attrs.get("hl7ScheduledStationAETInOrder"), null));
        ext.setHL7NoPatientCreateMessageTypes(LdapUtils.stringArray((Attribute)attrs.get("hl7NoPatientCreateMessageType"), (String[])new String[0]));
        ext.setHL7UseNullValue(LdapUtils.booleanValue((Attribute)attrs.get("hl7UseNullValue"), null));
        ext.setHL7OrderMissingStudyIUIDPolicy((HL7OrderMissingStudyIUIDPolicy)LdapUtils.enumValue(HL7OrderMissingStudyIUIDPolicy.class, (Attribute)attrs.get("hl7OrderMissingStudyIUIDPolicy"), null));
        ext.setHl7OrderMissingAdmissionIDPolicy((HL7OrderMissingAdmissionIDPolicy)LdapUtils.enumValue(HL7OrderMissingAdmissionIDPolicy.class, (Attribute)attrs.get("hl7OrderMissingAdmissionIDPolicy"), null));
        ext.setHl7ImportReportMissingStudyIUIDPolicy((HL7ImportReportMissingStudyIUIDPolicy)LdapUtils.enumValue(HL7ImportReportMissingStudyIUIDPolicy.class, (Attribute)attrs.get("hl7ImportReportMissingStudyIUIDPolicy"), null));
        ext.setHl7ImportReportMissingAdmissionIDPolicy((HL7ImportReportMissingAdmissionIDPolicy)LdapUtils.enumValue(HL7ImportReportMissingAdmissionIDPolicy.class, (Attribute)attrs.get("hl7ImportReportMissingAdmissionIDPolicy"), null));
        ext.setHl7ImportReportMissingStudyIUIDCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("hl7ImportReportMissingStudyIUIDCFindSCP"), null));
        ext.setHl7ImportReportAdjustIUID((HL7ImportReportAdjustIUID)LdapUtils.enumValue(HL7ImportReportAdjustIUID.class, (Attribute)attrs.get("hl7ImportReportAdjustIUID"), null));
        ext.setHl7DicomCharacterSet(LdapUtils.stringValue((Attribute)attrs.get("hl7DicomCharacterSet"), null));
        ext.setHl7VeterinaryUsePatientName(LdapUtils.booleanValue((Attribute)attrs.get("hl7VeterinaryUsePatientName"), null));
        ext.setHl7ORUAction((HL7ORUAction[])LdapUtils.enumArray(HL7ORUAction.class, (Attribute)attrs.get("hl7ORUAction")));
        ext.setMWLWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLWorklistLabel"), null));
        ext.setMWLAccessionNumberGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLAccessionNumberGenerator"), null));
        ext.setMWLRequestedProcedureIDGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLRequestedProcedureIDGenerator"), null));
        ext.setMWLScheduledProcedureStepIDGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLScheduledProcedureStepIDGenerator"), null));
        ext.setAuditHL7MsgLimit(LdapUtils.intValue((Attribute)attrs.get("dcmAuditHL7MsgLimit"), null));
        ext.setHl7ReferredMergedPatientPolicy((HL7ReferredMergedPatientPolicy)LdapUtils.enumValue(HL7ReferredMergedPatientPolicy.class, (Attribute)attrs.get("hl7ReferredMergedPatientPolicy"), null));
        ext.setHL7PatientArrivalMessageType(LdapUtils.stringValue((Attribute)attrs.get("hl7PatientArrivalMessageType"), null));
    }

    public void loadChilds(HL7Application hl7App, String appDN) throws NamingException {
        ArchiveHL7ApplicationExtension ext = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (ext == null) {
            return;
        }
        LdapDicomConfiguration config = this.getDicomConfiguration();
        LdapArchiveConfiguration.loadHL7ForwardRules(ext.getHL7ForwardRules(), appDN, config);
        LdapArchiveConfiguration.loadHL7ExportRules(ext.getHL7ExportRules(), appDN, config);
        LdapArchiveConfiguration.loadHL7PrefetchRules(ext.getHL7PrefetchRules(), appDN, config);
        LdapArchiveConfiguration.loadScheduledStations(ext.getHL7OrderScheduledStations(), appDN, config, hl7App.getDevice());
        LdapArchiveConfiguration.loadHL7OrderSPSStatus(ext.getHL7OrderSPSStatuses(), appDN, config);
        LdapArchiveConfiguration.loadHL7StudyRetentionPolicies(ext.getHL7StudyRetentionPolicies(), appDN, config);
        LdapArchiveConfiguration.loadUPSOnHL7List(ext.listUPSOnHL7(), appDN, config);
    }

    public void storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, HL7Application a, HL7Application b, List<ModificationItem> mods) {
        boolean remove;
        ArchiveHL7ApplicationExtension aa = (ArchiveHL7ApplicationExtension)a.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        ArchiveHL7ApplicationExtension bb = (ArchiveHL7ApplicationExtension)b.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (aa == null && bb == null) {
            return;
        }
        boolean bl = remove = bb == null;
        if (remove) {
            bb = new ArchiveHL7ApplicationExtension();
        } else if (aa == null) {
            aa = new ArchiveHL7ApplicationExtension();
            mods.add(new ModificationItem(1, LdapUtils.attr((String)"objectClass", (Object[])new String[]{"dcmArchiveHL7Application"})));
        }
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PatientUpdateTemplateURI", (Object)aa.getPatientUpdateTemplateURI(), (Object)bb.getPatientUpdateTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportTemplateURI", (Object)aa.getImportReportTemplateURI(), (Object)bb.getImportReportTemplateURI(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportTemplateParam", (Map)aa.getImportReportTemplateParams(), (Map)bb.getImportReportTemplateParams());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ScheduleProcedureTemplateURI", (Object)aa.getScheduleProcedureTemplateURI(), (Object)bb.getScheduleProcedureTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7LogFilePattern", (Object)aa.getHL7LogFilePattern(), (Object)bb.getHL7LogFilePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ErrorLogFilePattern", (Object)aa.getHL7ErrorLogFilePattern(), (Object)bb.getHL7ErrorLogFilePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomAETitle", (Object)aa.getAETitle(), (Object)bb.getAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRecordAttributeModification", (Object)aa.getRecordAttributeModification(), (Object)bb.getRecordAttributeModification(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ScheduledProtocolCodeInOrder", (Object)aa.getHL7ScheduledProtocolCodeInOrder(), (Object)bb.getHL7ScheduledProtocolCodeInOrder(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ScheduledStationAETInOrder", (Object)aa.getHL7ScheduledStationAETInOrder(), (Object)bb.getHL7ScheduledStationAETInOrder(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7NoPatientCreateMessageType", (Object[])aa.getHL7NoPatientCreateMessageTypes(), (Object[])bb.getHL7NoPatientCreateMessageTypes(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7UseNullValue", (Object)aa.getHL7UseNullValue(), (Object)bb.getHL7UseNullValue(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OrderMissingStudyIUIDPolicy", (Object)aa.getHL7OrderMissingStudyIUIDPolicy(), (Object)bb.getHL7OrderMissingStudyIUIDPolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OrderMissingAdmissionIDPolicy", (Object)aa.getHl7OrderMissingAdmissionIDPolicy(), (Object)bb.getHl7OrderMissingAdmissionIDPolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportMissingStudyIUIDPolicy", (Object)aa.getHl7ImportReportMissingStudyIUIDPolicy(), (Object)bb.getHl7ImportReportMissingStudyIUIDPolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportMissingAdmissionIDPolicy", (Object)aa.getHl7ImportReportMissingAdmissionIDPolicy(), (Object)bb.getHl7ImportReportMissingAdmissionIDPolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportMissingStudyIUIDCFindSCP", (Object)aa.getHl7ImportReportMissingStudyIUIDCFindSCP(), (Object)bb.getHl7ImportReportMissingStudyIUIDCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportAdjustIUID", (Object)aa.getHl7ImportReportAdjustIUID(), (Object)bb.getHl7ImportReportAdjustIUID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7DicomCharacterSet", (Object)aa.getHl7DicomCharacterSet(), (Object)bb.getHl7DicomCharacterSet(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7VeterinaryUsePatientName", (Object)aa.getHl7VeterinaryUsePatientName(), (Object)bb.getHl7VeterinaryUsePatientName(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ORUAction", (Object[])aa.getHl7ORUAction(), (Object[])bb.getHl7ORUAction(), (Object[])new HL7ORUAction[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLWorklistLabel", (Object)aa.getMWLWorklistLabel(), (Object)bb.getMWLWorklistLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLAccessionNumberGenerator", (Object)aa.getMWLAccessionNumberGenerator(), (Object)bb.getMWLAccessionNumberGenerator(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLRequestedProcedureIDGenerator", (Object)aa.getMWLRequestedProcedureIDGenerator(), (Object)bb.getMWLRequestedProcedureIDGenerator(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLScheduledProcedureStepIDGenerator", (Object)aa.getMWLScheduledProcedureStepIDGenerator(), (Object)bb.getMWLScheduledProcedureStepIDGenerator(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditHL7MsgLimit", (Object)aa.getAuditHL7MsgLimit(), (Object)bb.getAuditHL7MsgLimit(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ReferredMergedPatientPolicy", (Object)aa.getHl7ReferredMergedPatientPolicy(), (Object)bb.getHl7ReferredMergedPatientPolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PatientArrivalMessageType", (Object)aa.getHL7PatientArrivalMessageType(), (Object)bb.getHL7PatientArrivalMessageType(), null);
        if (remove) {
            mods.add(new ModificationItem(3, LdapUtils.attr((String)"objectClass", (Object[])new String[]{"dcmArchiveHL7Application"})));
        }
    }

    public void mergeChilds(ConfigurationChanges diffs, HL7Application prev, HL7Application hl7App, String appDN) throws NamingException {
        ArchiveHL7ApplicationExtension aa = (ArchiveHL7ApplicationExtension)prev.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        ArchiveHL7ApplicationExtension bb = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (aa == null && bb == null) {
            return;
        }
        if (aa == null) {
            aa = new ArchiveHL7ApplicationExtension();
        } else if (bb == null) {
            bb = new ArchiveHL7ApplicationExtension();
        }
        LdapDicomConfiguration config = this.getDicomConfiguration();
        LdapArchiveConfiguration.mergeHL7ForwardRules(diffs, aa.getHL7ForwardRules(), bb.getHL7ForwardRules(), appDN, config);
        LdapArchiveConfiguration.mergeHL7ExportRules(diffs, aa.getHL7ExportRules(), bb.getHL7ExportRules(), appDN, config);
        LdapArchiveConfiguration.mergeHL7PrefetchRules(diffs, aa.getHL7PrefetchRules(), bb.getHL7PrefetchRules(), appDN, config);
        LdapArchiveConfiguration.mergeScheduledStations(diffs, aa.getHL7OrderScheduledStations(), bb.getHL7OrderScheduledStations(), appDN, config);
        LdapArchiveConfiguration.mergeHL7OrderSPSStatus(diffs, aa.getHL7OrderSPSStatuses(), bb.getHL7OrderSPSStatuses(), appDN, config);
        LdapArchiveConfiguration.mergeHL7StudyRetentionPolicies(diffs, aa.getHL7StudyRetentionPolicies(), bb.getHL7StudyRetentionPolicies(), appDN, config);
        LdapArchiveConfiguration.mergeUPSOnHL7List(diffs, aa.listUPSOnHL7(), bb.listUPSOnHL7(), appDN, config);
    }
}

