/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.json;

import java.net.URI;
import java.time.Period;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.json.stream.JsonParser;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.json.ConfigurationDelegate;
import org.dcm4che3.conf.json.JsonConfigurationExtension;
import org.dcm4che3.conf.json.JsonReader;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.ValueSelector;
import org.dcm4che3.deident.DeIdentifier;
import org.dcm4che3.net.AEExtension;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.AcceptConflictingPatientID;
import org.dcm4chee.arc.conf.AcceptMissingPatientID;
import org.dcm4chee.arc.conf.AllowDeletePatient;
import org.dcm4chee.arc.conf.AllowDeleteStudyPermanently;
import org.dcm4chee.arc.conf.AllowRejectionForDataRetentionPolicyExpired;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.ArchiveCompressionRule;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.AttributeSet;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.EntitySelector;
import org.dcm4chee.arc.conf.ExportPriorsRule;
import org.dcm4chee.arc.conf.ExportReoccurredInstances;
import org.dcm4chee.arc.conf.ExportRule;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.HL7Conditions;
import org.dcm4chee.arc.conf.HL7ExportRule;
import org.dcm4chee.arc.conf.HL7ForwardRule;
import org.dcm4chee.arc.conf.HL7ImportReportAdjustIUID;
import org.dcm4chee.arc.conf.HL7ImportReportMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7ImportReportMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7ORUAction;
import org.dcm4chee.arc.conf.HL7OrderMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderSPSStatus;
import org.dcm4chee.arc.conf.HL7OrderScheduledStation;
import org.dcm4chee.arc.conf.HL7PSUMWLMatchingKey;
import org.dcm4chee.arc.conf.HL7PSUMessageType;
import org.dcm4chee.arc.conf.HL7PrefetchRule;
import org.dcm4chee.arc.conf.HL7ReferredMergedPatientPolicy;
import org.dcm4chee.arc.conf.HL7StudyRetentionPolicy;
import org.dcm4chee.arc.conf.IDGenerator;
import org.dcm4chee.arc.conf.InputReadinessState;
import org.dcm4chee.arc.conf.MPPSForwardRule;
import org.dcm4chee.arc.conf.MWLIdleTimeout;
import org.dcm4chee.arc.conf.MWLImport;
import org.dcm4chee.arc.conf.MergeAttribute;
import org.dcm4chee.arc.conf.MergeMWLMatchingKey;
import org.dcm4chee.arc.conf.MetricsDescriptor;
import org.dcm4chee.arc.conf.MultipleStoreAssociations;
import org.dcm4chee.arc.conf.NullifyIssuer;
import org.dcm4chee.arc.conf.OverwritePolicy;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.dcm4chee.arc.conf.RSForwardRule;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.conf.RetentionPeriod;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.conf.ScheduledProtocolCodeInOrder;
import org.dcm4chee.arc.conf.ScheduledStationAETInOrder;
import org.dcm4chee.arc.conf.ShowPatientInfo;
import org.dcm4chee.arc.conf.SpanningCFindSCPPolicy;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StorageDuration;
import org.dcm4chee.arc.conf.StorageThreshold;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.conf.StoreAccessControlIDRule;
import org.dcm4chee.arc.conf.StudyRetentionPolicy;
import org.dcm4chee.arc.conf.UPSOnHL7;
import org.dcm4chee.arc.conf.UPSOnStore;
import org.dcm4chee.arc.conf.UPSOnUPSCompleted;
import org.dcm4chee.arc.conf.UPSPriority;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.conf.UseCallingAETitleAsCoercion;
import org.dcm4chee.arc.conf.UserIdentityNegotiation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JsonArchiveConfiguration
extends JsonConfigurationExtension {
    private static final Logger LOG = LoggerFactory.getLogger(JsonArchiveConfiguration.class);

    protected void storeTo(Device device, JsonWriter writer) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (arcDev == null) {
            return;
        }
        writer.writeStartObject("dcmArchiveDevice");
        writer.writeNotNullOrDef("dcmFuzzyAlgorithmClass", (Object)arcDev.getFuzzyAlgorithmClass(), null);
        writer.writeNotNullOrDef("dcmBulkDataDescriptorID", (Object)arcDev.getBulkDataDescriptorID(), null);
        writer.writeNotEmpty("dcmSeriesMetadataStorageID", (Object[])arcDev.getSeriesMetadataStorageIDs(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmSeriesMetadataDelay", (Object)arcDev.getSeriesMetadataDelay(), null);
        writer.writeNotNullOrDef("dcmSeriesMetadataPollingInterval", (Object)arcDev.getSeriesMetadataPollingInterval(), null);
        writer.writeNotDef("dcmSeriesMetadataFetchSize", arcDev.getSeriesMetadataFetchSize(), 100);
        writer.writeNotDef("dcmSeriesMetadataThreads", arcDev.getSeriesMetadataThreads(), 1);
        writer.writeNotDef("dcmSeriesMetadataMaxRetries", arcDev.getSeriesMetadataMaxRetries(), 0);
        writer.writeNotNullOrDef("dcmSeriesMetadataRetryInterval", (Object)arcDev.getSeriesMetadataRetryInterval(), null);
        writer.writeNotDef("dcmPurgeInstanceRecords", arcDev.isPurgeInstanceRecords(), false);
        writer.writeNotNullOrDef("dcmPurgeInstanceRecordsDelay", (Object)arcDev.getPurgeInstanceRecordsDelay(), null);
        writer.writeNotNullOrDef("dcmPurgeInstanceRecordsPollingInterval", (Object)arcDev.getPurgeInstanceRecordsPollingInterval(), null);
        writer.writeNotDef("dcmPurgeInstanceRecordsFetchSize", arcDev.getPurgeInstanceRecordsFetchSize(), 100);
        writer.writeNotNullOrDef("dcmDeleteUPSPollingInterval", (Object)arcDev.getDeleteUPSPollingInterval(), null);
        writer.writeNotDef("dcmDeleteUPSFetchSize", arcDev.getDeleteUPSFetchSize(), 100);
        writer.writeNotNullOrDef("dcmDeleteUPSCompletedDelay", (Object)arcDev.getDeleteUPSCompletedDelay(), null);
        writer.writeNotNullOrDef("dcmDeleteUPSCanceledDelay", (Object)arcDev.getDeleteUPSCanceledDelay(), null);
        writer.writeNotNullOrDef("dcmOverwritePolicy", (Object)arcDev.getOverwritePolicy(), (Object)OverwritePolicy.NEVER);
        writer.writeNotDef("dcmRecordAttributeModification", arcDev.isRecordAttributeModification(), true);
        writer.writeNotDef("dcmIdentifyPatientByAllAttributes", arcDev.isIdentifyPatientByAllAttributes(), false);
        writer.writeNotNullOrDef("dcmBulkDataSpoolDirectory", (Object)arcDev.getBulkDataSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        writer.writeNotEmpty("dcmHideSPSWithStatusFromMWL", (Object[])arcDev.getHideSPSWithStatusFrom(), (Object[])new SPSStatus[0]);
        writer.writeNotEmpty("dcmHideSPSWithStatusFromMWLRS", (Object[])arcDev.getHideSPSWithStatusFromMWLRS(), (Object[])new SPSStatus[0]);
        writer.writeNotEmpty("dcmEncodeAsJSONNumber", (Object[])arcDev.getEncodeAsJSONNumber(), (Object[])new VR[0]);
        writer.writeNotEmpty("hl7ORUAction", (Object[])arcDev.getHl7ORUAction(), (Object[])new HL7ORUAction[0]);
        writer.writeNotNullOrDef("dcmMWLAccessionNumberGenerator", (Object)arcDev.getMWLAccessionNumberGenerator(), null);
        writer.writeNotNullOrDef("dcmMWLRequestedProcedureIDGenerator", (Object)arcDev.getMWLRequestedProcedureIDGenerator(), null);
        writer.writeNotNullOrDef("dcmMWLScheduledProcedureStepIDGenerator", (Object)arcDev.getMWLScheduledProcedureStepIDGenerator(), null);
        writer.writeNotDef("dcmPersonNameComponentOrderInsensitiveMatching", arcDev.isPersonNameComponentOrderInsensitiveMatching(), false);
        writer.writeNotDef("dcmSendPendingCGet", arcDev.isSendPendingCGet(), false);
        writer.writeNotNullOrDef("dcmSendPendingCMoveInterval", (Object)arcDev.getSendPendingCMoveInterval(), null);
        writer.writeNotEmpty("dcmWadoSupportedSRClasses", (Object[])arcDev.getWadoSupportedSRClasses(), (Object[])new String[0]);
        writer.writeNotEmpty("dcmWadoSupportedPRClasses", (Object[])arcDev.getWadoSupportedPRClasses(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmWadoZIPEntryNameFormat", (Object)arcDev.getWadoZIPEntryNameFormat(), (Object)"DICOM/{0020000D,hash}/{0020000E,hash}/{00080018,hash}.dcm");
        writer.writeNotNullOrDef("dcmWadoSR2HtmlTemplateURI", (Object)arcDev.getWadoSR2HtmlTemplateURI(), null);
        writer.writeNotNullOrDef("dcmWadoSR2TextTemplateURI", (Object)arcDev.getWadoSR2TextTemplateURI(), null);
        writer.writeNotNullOrDef("dcmWadoCDA2HtmlTemplateURI", (Object)arcDev.getWadoCDA2HtmlTemplateURI(), null);
        writer.writeNotNullOrDef("dcmWadoSpoolDirectory", (Object)arcDev.getWadoSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        writer.writeNotNullOrDef("dcmWadoThumbnailViewport", (Object)arcDev.getWadoThumbnailViewPort(), (Object)"64,64");
        writer.writeNotNullOrDef("dcmFallbackWadoURIWebAppName", (Object)arcDev.getFallbackWadoURIWebApplication(), null);
        writer.writeNotDef("dcmFallbackWadoURIHttpStatusCode", arcDev.getFallbackWadoURIHttpStatusCode(), 303);
        writer.writeNotDef("dcmWadoIgnorePresentationLUTShape", arcDev.isWadoIgnorePresentationLUTShape(), false);
        writer.writeNotDef("dcmWadoMetadataExcludePrivate", arcDev.isWadoMetadataWithoutPrivate(), false);
        writer.writeNotDef("dcmQueryFetchSize", arcDev.getQueryFetchSize(), 100);
        writer.writeNotDef("dcmQueryMaxNumberOfResults", arcDev.getQueryMaxNumberOfResults(), 0);
        writer.writeNotDef("dcmQidoMaxNumberOfResults", arcDev.getQidoMaxNumberOfResults(), 0);
        writer.writeNotDef("dcmQidoETag", arcDev.isQidoETag(), false);
        writer.writeNotEmpty("dcmFwdMppsDestination", (Object[])arcDev.getMppsForwardDestinations(), (Object[])new String[0]);
        writer.writeNotEmpty("dcmIanDestination", (Object[])arcDev.getIanDestinations(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmIanDelay", (Object)arcDev.getIanDelay(), null);
        writer.writeNotNullOrDef("dcmIanTimeout", (Object)arcDev.getIanTimeout(), null);
        writer.writeNotDef("dcmIanOnTimeout", arcDev.isIanOnTimeout(), false);
        writer.writeNotNullOrDef("dcmIanTaskPollingInterval", (Object)arcDev.getIanTaskPollingInterval(), null);
        writer.writeNotDef("dcmIanTaskFetchSize", arcDev.getIanTaskFetchSize(), 100);
        writer.writeNotNullOrDef("dcmSpanningCFindSCP", (Object)arcDev.getSpanningCFindSCP(), null);
        writer.writeNotEmpty("dcmSpanningCFindSCPRetrieveAET", (Object[])arcDev.getSpanningCFindSCPRetrieveAETitles(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmSpanningCFindSCPPolicy", (Object)arcDev.getSpanningCFindSCPPolicy(), (Object)SpanningCFindSCPPolicy.REPLACE);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCP", (Object)arcDev.getFallbackCMoveSCP(), null);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCPDestination", (Object)arcDev.getFallbackCMoveSCPDestination(), null);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCPCallingAET", (Object)arcDev.getFallbackCMoveSCPCallingAET(), null);
        writer.writeNotDef("dcmFallbackCMoveSCPRetries", arcDev.getFallbackCMoveSCPRetries(), 0);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCPLeadingCFindSCP", (Object)arcDev.getFallbackCMoveSCPLeadingCFindSCP(), null);
        writer.writeNotNullOrDef("dcmAltCMoveSCP", (Object)arcDev.getAlternativeCMoveSCP(), null);
        writer.writeNotNullOrDef("dcmPurgeStoragePollingInterval", (Object)arcDev.getPurgeStoragePollingInterval(), null);
        writer.writeNotDef("dcmPurgeStorageFetchSize", arcDev.getPurgeStorageFetchSize(), 100);
        writer.writeNotNullOrDef("dcmFailedToDeletePollingInterval", (Object)arcDev.getFailedToDeletePollingInterval(), null);
        writer.writeNotDef("dcmFailedToDeleteFetchSize", arcDev.getFailedToDeleteFetchSize(), 100);
        writer.writeNotDef("dcmDeleteStudyBatchSize", arcDev.getDeleteStudyBatchSize(), 10);
        writer.writeNotDef("dcmDeletePatientOnDeleteLastStudy", arcDev.isDeletePatientOnDeleteLastStudy(), false);
        writer.writeNotNullOrDef("dcmDeleteRejectedPollingInterval", (Object)arcDev.getDeleteRejectedPollingInterval(), null);
        writer.writeNotDef("dcmDeleteRejectedFetchSize", arcDev.getDeleteRejectedFetchSize(), 100);
        writer.writeNotNullOrDef("dcmMaxAccessTimeStaleness", (Object)arcDev.getMaxAccessTimeStaleness(), null);
        writer.writeNotNullOrDef("dcmAECacheStaleTimeout", (Object)arcDev.getAECacheStaleTimeout(), null);
        writer.writeNotNullOrDef("dcmLeadingCFindSCPQueryCacheStaleTimeout", (Object)arcDev.getLeadingCFindSCPQueryCacheStaleTimeout(), null);
        writer.writeNotDef("dcmLeadingCFindSCPQueryCacheSize", arcDev.getLeadingCFindSCPQueryCacheSize(), 10);
        writer.writeNotNullOrDef("dcmAuditSpoolDirectory", (Object)arcDev.getAuditSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        writer.writeNotNullOrDef("dcmAuditPollingInterval", (Object)arcDev.getAuditPollingInterval(), null);
        writer.writeNotNullOrDef("dcmAuditAggregateDuration", (Object)arcDev.getAuditAggregateDuration(), null);
        writer.writeNotNullOrDef("dcmStowSpoolDirectory", (Object)arcDev.getStowSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        writer.writeNotNullOrDef("hl7PatientUpdateTemplateURI", (Object)arcDev.getPatientUpdateTemplateURI(), null);
        writer.writeNotNullOrDef("hl7ImportReportTemplateURI", (Object)arcDev.getImportReportTemplateURI(), null);
        writer.writeNotEmpty("hl7ImportReportTemplateParam", arcDev.getImportReportTemplateParams());
        writer.writeNotNullOrDef("hl7ScheduleProcedureTemplateURI", (Object)arcDev.getScheduleProcedureTemplateURI(), null);
        writer.writeNotNullOrDef("hl7OutgoingPatientUpdateTemplateURI", (Object)arcDev.getOutgoingPatientUpdateTemplateURI(), null);
        writer.writeNotNullOrDef("hl7LogFilePattern", (Object)arcDev.getHL7LogFilePattern(), null);
        writer.writeNotNullOrDef("hl7ErrorLogFilePattern", (Object)arcDev.getHL7ErrorLogFilePattern(), null);
        writer.writeNotNullOrDef("dcmUnzipVendorDataToURI", (Object)arcDev.getUnzipVendorDataToURI(), null);
        writer.writeNotNullOrDef("dcmPurgeQueueMessagePollingInterval", (Object)arcDev.getPurgeTaskPollingInterval(), null);
        writer.writeNotNullOrDef("dcmRejectExpiredStudiesPollingInterval", (Object)arcDev.getRejectExpiredStudiesPollingInterval(), null);
        writer.writeNotEmpty("dcmRejectExpiredStudiesSchedule", (Object[])arcDev.getRejectExpiredStudiesSchedules(), (Object[])new ScheduleExpression[0]);
        writer.writeNotDef("dcmRejectExpiredStudiesFetchSize", arcDev.getRejectExpiredStudiesFetchSize(), 0);
        writer.writeNotDef("dcmRejectExpiredSeriesFetchSize", arcDev.getRejectExpiredSeriesFetchSize(), 0);
        writer.writeNotNullOrDef("dcmRejectExpiredStudiesAETitle", (Object)arcDev.getRejectExpiredStudiesAETitle(), null);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCPStudyOlderThan", (Object)arcDev.getFallbackCMoveSCPStudyOlderThan(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceURL", (Object)arcDev.getStorePermissionServiceURL(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceResponse", (Object)arcDev.getStorePermissionServiceResponse(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceResponsePattern", (Object)arcDev.getStorePermissionServiceResponsePattern(), null);
        writer.writeNotNullOrDef("dcmStorePermissionCacheStaleTimeout", (Object)arcDev.getStorePermissionCacheStaleTimeout(), null);
        writer.writeNotDef("dcmStorePermissionCacheSize", arcDev.getStorePermissionCacheSize(), 10);
        writer.writeNotNullOrDef("dcmMergeMWLCacheStaleTimeout", (Object)arcDev.getMergeMWLCacheStaleTimeout(), null);
        writer.writeNotDef("dcmMergeMWLCacheSize", arcDev.getMergeMWLCacheSize(), 10);
        writer.writeNotDef("dcmStoreUpdateDBMaxRetries", arcDev.getStoreUpdateDBMaxRetries(), 3);
        writer.writeNotDef("dcmStoreUpdateDBMinRetryDelay", arcDev.getStoreUpdateDBMinRetryDelay(), 500);
        writer.writeNotDef("dcmStoreUpdateDBMaxRetryDelay", arcDev.getStoreUpdateDBMaxRetryDelay(), 1000);
        writer.writeNotNullOrDef("dcmAllowRejectionForDataRetentionPolicyExpired", (Object)arcDev.getAllowRejectionForDataRetentionPolicyExpired(), (Object)AllowRejectionForDataRetentionPolicyExpired.EXPIRED_UNSET);
        writer.writeNotNullOrDef("dcmAcceptMissingPatientID", (Object)arcDev.getAcceptMissingPatientID(), (Object)AcceptMissingPatientID.CREATE);
        writer.writeNotNullOrDef("dcmAllowDeleteStudyPermanently", (Object)arcDev.getAllowDeleteStudyPermanently(), (Object)AllowDeleteStudyPermanently.REJECTED);
        writer.writeNotNullOrDef("dcmAllowDeletePatient", (Object)arcDev.getAllowDeletePatient(), (Object)AllowDeletePatient.WITHOUT_STUDIES);
        writer.writeNotNullOrDef("dcmStorePermissionServiceExpirationDatePattern", (Object)arcDev.getStorePermissionServiceExpirationDatePattern(), null);
        writer.writeNotNullOrDef("dcmShowPatientInfoInSystemLog", (Object)arcDev.getShowPatientInfoInSystemLog(), (Object)ShowPatientInfo.PLAIN_TEXT);
        writer.writeNotNullOrDef("dcmShowPatientInfoInAuditLog", (Object)arcDev.getShowPatientInfoInAuditLog(), (Object)ShowPatientInfo.PLAIN_TEXT);
        writer.writeNotNullOrDef("dcmPurgeStgCmtCompletedDelay", (Object)arcDev.getPurgeStgCmtCompletedDelay(), null);
        writer.writeNotNullOrDef("dcmPurgeStgCmtPollingInterval", (Object)arcDev.getPurgeStgCmtPollingInterval(), null);
        writer.writeNotNullOrDef("dcmDefaultCharacterSet", (Object)arcDev.getDefaultCharacterSet(), null);
        writer.writeNotEmpty("dcmCharsetNameMapping", arcDev.getDicomCharsetNameMappings());
        writer.writeNotEmpty("hl7CharsetNameMapping", arcDev.getHL7CharsetNameMappings());
        writer.writeNotEmpty("dcmUPSEventWebSocketQueueSize", arcDev.getUPSEventWebSocketQueueSizes());
        writer.writeNotNullOrDef("dcmUPSWorklistLabel", (Object)arcDev.getUPSWorklistLabel(), null);
        writer.writeNotEmpty("dcmUPSEventSCU", (Object[])arcDev.getUPSEventSCUs(), (Object[])new String[0]);
        writer.writeNotDef("dcmUPSEventSCUKeepAlive", arcDev.getUPSEventSCUKeepAlive(), 0);
        writer.writeNotNullOrDef("dcmStorePermissionServiceErrorCommentPattern", (Object)arcDev.getStorePermissionServiceErrorCommentPattern(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceErrorCodePattern", (Object)arcDev.getStorePermissionServiceErrorCodePattern(), null);
        writer.writeNotEmpty("dcmRetrieveAET", (Object[])arcDev.getRetrieveAETitles(), (Object[])new String[0]);
        writer.writeNotEmpty("dcmReturnRetrieveAET", (Object[])arcDev.getReturnRetrieveAETitles(), (Object[])new String[0]);
        writer.writeNotEmpty("dcmMultipleStoreAssociations", (Object[])arcDev.getMultipleStoreAssociations(), (Object[])new MultipleStoreAssociations[0]);
        writer.writeNotNullOrDef("dcmExternalRetrieveAEDestination", (Object)arcDev.getExternalRetrieveAEDestination(), null);
        writer.writeNotNullOrDef("dcmXDSiImagingDocumentSourceAETitle", (Object)arcDev.getXDSiImagingDocumentSourceAETitle(), null);
        writer.writeNotNullOrDef("dcmRemapRetrieveURL", (Object)arcDev.getRemapRetrieveURL(), null);
        writer.writeNotDef("dcmValidateCallingAEHostname", arcDev.isValidateCallingAEHostname(), false);
        writer.writeNotNullOrDef("hl7PSUSendingApplication", (Object)arcDev.getHL7PSUSendingApplication(), null);
        writer.writeNotEmpty("hl7PSUReceivingApplication", (Object[])arcDev.getHL7PSUReceivingApplications(), (Object[])new String[0]);
        writer.writeNotNullOrDef("hl7PSUDelay", (Object)arcDev.getHL7PSUDelay(), null);
        writer.writeNotNullOrDef("hl7PSUTimeout", (Object)arcDev.getHL7PSUTimeout(), null);
        writer.writeNotDef("hl7PSUOnTimeout", arcDev.isHL7PSUOnTimeout(), false);
        writer.writeNotNullOrDef("hl7PSUTaskPollingInterval", (Object)arcDev.getHL7PSUTaskPollingInterval(), null);
        writer.writeNotDef("hl7PSUTaskFetchSize", arcDev.getHL7PSUTaskFetchSize(), 100);
        writer.writeNotDef("hl7PSUMWL", arcDev.isHL7PSUMWL(), false);
        writer.writeNotNullOrDef("hl7PSUMWLMatchingKey", (Object)arcDev.getHL7PSUMWLMatchingKey(), (Object)HL7PSUMWLMatchingKey.StudyInstanceUID);
        writer.writeNotDef("hl7PSUForRequestedProcedure", arcDev.isHl7PSUForRequestedProcedure(), false);
        writer.writeNotDef("hl7PSUPIDPV1", arcDev.isHl7PSUPIDPV1(), false);
        writer.writeNotNullOrDef("hl7PSURequestedProcedureID", (Object)arcDev.getHl7PSURequestedProcedureID(), null);
        writer.writeNotNullOrDef("hl7PSUAccessionNumber", (Object)arcDev.getHl7PSUAccessionNumber(), null);
        writer.writeNotNullOrDef("hl7PSUFillerOrderNumber", (Object)arcDev.getHl7PSUFillerOrderNumber(), null);
        writer.writeNotNullOrDef("hl7PSUPlacerOrderNumber", (Object)arcDev.getHl7PSUPlacerOrderNumber(), null);
        writer.writeNotEmpty("hl7PSUTemplateParam", arcDev.getHL7PSUTemplateParams());
        writer.writeNotNullOrDef("hl7PSUMessageType", (Object)arcDev.getHl7PSUMessageType(), (Object)HL7PSUMessageType.OMG_O19);
        writer.writeNotEmpty("hl7PSUCondition", arcDev.getHl7PSUConditions().getMap());
        writer.writeNotNullOrDef("hl7PSUMppsTemplateURI", (Object)arcDev.getHl7PSUMppsTemplateURI(), null);
        writer.writeNotNullOrDef("hl7PSUStudyTemplateURI", (Object)arcDev.getHl7PSUStudyTemplateURI(), null);
        writer.writeNotNullOrDef("dcmAcceptConflictingPatientID", (Object)arcDev.getAcceptConflictingPatientID(), (Object)AcceptConflictingPatientID.MERGED);
        writer.writeNotNullOrDef("dcmProxyUpstreamURL", (Object)arcDev.getProxyUpstreamURL(), null);
        writer.writeNotNullOrDef("dcmAudit2JsonFhirTemplateURI", (Object)arcDev.getAudit2JsonFhirTemplateURI(), null);
        writer.writeNotNullOrDef("dcmAudit2XmlFhirTemplateURI", (Object)arcDev.getAudit2XmlFhirTemplateURI(), null);
        writer.writeNotNullOrDef("dcmCopyMoveUpdatePolicy", (Object)arcDev.getCopyMoveUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        writer.writeNotNullOrDef("dcmLinkMWLEntryUpdatePolicy", (Object)arcDev.getLinkMWLEntryUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        writer.writeNotNullOrDef("dcmStorageVerificationPolicy", (Object)arcDev.getStorageVerificationPolicy(), (Object)StorageVerificationPolicy.OBJECT_CHECKSUM);
        writer.writeNotDef("dcmStorageVerificationUpdateLocationStatus", arcDev.isStorageVerificationUpdateLocationStatus(), false);
        writer.writeNotEmpty("dcmStorageVerificationStorageID", (Object[])arcDev.getStorageVerificationStorageIDs(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmStorageVerificationAETitle", (Object)arcDev.getStorageVerificationAETitle(), null);
        writer.writeNotNullOrDef("dcmStorageVerificationBatchID", (Object)arcDev.getStorageVerificationBatchID(), null);
        writer.writeNotNullOrDef("dcmStorageVerificationInitialDelay", (Object)arcDev.getStorageVerificationInitialDelay(), null);
        writer.writeNotNullOrDef("dcmStorageVerificationPeriod", (Object)arcDev.getStorageVerificationPeriod(), null);
        writer.writeNotDef("dcmStorageVerificationMaxScheduled", arcDev.getStorageVerificationMaxScheduled(), 0);
        writer.writeNotNullOrDef("dcmStorageVerificationPollingInterval", (Object)arcDev.getStorageVerificationPollingInterval(), null);
        writer.writeNotEmpty("dcmStorageVerificationSchedule", (Object[])arcDev.getStorageVerificationSchedules(), (Object[])new ScheduleExpression[0]);
        writer.writeNotDef("dcmStorageVerificationFetchSize", arcDev.getStorageVerificationFetchSize(), 100);
        writer.writeNotDef("dcmUpdateLocationStatusOnRetrieve", arcDev.isUpdateLocationStatusOnRetrieve(), false);
        writer.writeNotDef("dcmStorageVerificationOnRetrieve", arcDev.isStorageVerificationOnRetrieve(), false);
        writer.writeNotDef("hl7TrackChangedPatientID", arcDev.isHL7TrackChangedPatientID(), true);
        writer.writeNotNullOrDef("hl7ADTSendingApplication", (Object)arcDev.getHL7ADTSendingApplication(), null);
        writer.writeNotEmpty("hl7ADTReceivingApplication", (Object[])arcDev.getHL7ADTReceivingApplication(), (Object[])new String[0]);
        writer.writeNotNullOrDef("hl7ScheduledProtocolCodeInOrder", (Object)arcDev.getHL7ScheduledProtocolCodeInOrder(), (Object)ScheduledProtocolCodeInOrder.OBR_4_4);
        writer.writeNotNullOrDef("hl7ScheduledStationAETInOrder", (Object)arcDev.getHL7ScheduledStationAETInOrder(), null);
        writer.writeNotEmpty("hl7NoPatientCreateMessageType", (Object[])arcDev.getHL7NoPatientCreateMessageTypes(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmAuditUnknownStudyInstanceUID", (Object)arcDev.getAuditUnknownStudyInstanceUID(), (Object)"1.2.40.0.13.1.15.110.3.165.1");
        writer.writeNotNullOrDef("dcmAuditUnknownPatientID", (Object)arcDev.getAuditUnknownPatientID(), (Object)"<none>");
        writer.writeNotDef("dcmAuditSoftwareConfigurationVerbose", arcDev.isAuditSoftwareConfigurationVerbose(), false);
        writer.writeNotDef("hl7UseNullValue", arcDev.isHL7UseNullValue(), false);
        writer.writeNotDef("dcmQueueTasksFetchSize", arcDev.getQueueTasksFetchSize(), 100);
        writer.writeNotNullOrDef("dcmRejectionNoteStorageAET", (Object)arcDev.getRejectionNoteStorageAET(), null);
        writer.writeNotEmpty("dcmXRoadProperty", arcDev.getXRoadProperties());
        writer.writeNotEmpty("dcmImpaxReportProperty", arcDev.getImpaxReportProperties());
        writer.writeNotNullOrDef("dcmUIConfigurationDeviceName", (Object)arcDev.getUiConfigurationDeviceName(), null);
        writer.writeNotNullOrDef("dcmCompressionAETitle", (Object)arcDev.getCompressionAETitle(), null);
        writer.writeNotNullOrDef("dcmCompressionPollingInterval", (Object)arcDev.getCompressionPollingInterval(), null);
        writer.writeNotDef("dcmCompressionFetchSize", arcDev.getCompressionFetchSize(), 100);
        writer.writeNotEmpty("dcmCompressionSchedule", (Object[])arcDev.getCompressionSchedules(), (Object[])new ScheduleExpression[0]);
        writer.writeNotDef("dcmCompressionThreads", arcDev.getCompressionThreads(), 1);
        writer.writeNotNullOrDef("dcmDiffTaskProgressUpdateInterval", (Object)arcDev.getDiffTaskProgressUpdateInterval(), null);
        writer.writeNotNullOrDef("dcmPatientVerificationPDQServiceID", (Object)arcDev.getPatientVerificationPDQServiceID(), null);
        writer.writeNotNullOrDef("dcmPatientVerificationPollingInterval", (Object)arcDev.getPatientVerificationPollingInterval(), null);
        writer.writeNotDef("dcmPatientVerificationFetchSize", arcDev.getPatientVerificationFetchSize(), 100);
        writer.writeNotDef("dcmPatientVerificationAdjustIssuerOfPatientID", arcDev.isPatientVerificationAdjustIssuerOfPatientID(), false);
        writer.writeNotNullOrDef("dcmPatientVerificationPeriod", (Object)arcDev.getPatientVerificationPeriod(), null);
        writer.writeNotNullOrDef("dcmPatientVerificationPeriodOnNotFound", (Object)arcDev.getPatientVerificationPeriodOnNotFound(), null);
        writer.writeNotNullOrDef("dcmPatientVerificationRetryInterval", (Object)arcDev.getPatientVerificationRetryInterval(), null);
        writer.writeNotDef("dcmPatientVerificationMaxRetries", arcDev.getPatientVerificationMaxRetries(), 0);
        writer.writeNotNullOrDef("dcmPatientVerificationMaxStaleness", (Object)arcDev.getPatientVerificationMaxStaleness(), null);
        writer.writeNotNullOrDef("hl7OrderMissingStudyIUIDPolicy", (Object)arcDev.getHl7OrderMissingStudyIUIDPolicy(), (Object)HL7OrderMissingStudyIUIDPolicy.GENERATE);
        writer.writeNotNullOrDef("hl7OrderMissingAdmissionIDPolicy", (Object)arcDev.getHl7OrderMissingAdmissionIDPolicy(), (Object)HL7OrderMissingAdmissionIDPolicy.ACCEPT);
        writer.writeNotNullOrDef("hl7ImportReportMissingStudyIUIDPolicy", (Object)arcDev.getHl7ImportReportMissingStudyIUIDPolicy(), (Object)HL7ImportReportMissingStudyIUIDPolicy.GENERATE);
        writer.writeNotNullOrDef("hl7ImportReportMissingAdmissionIDPolicy", (Object)arcDev.getHl7ImportReportMissingAdmissionIDPolicy(), (Object)HL7ImportReportMissingAdmissionIDPolicy.ACCEPT);
        writer.writeNotNullOrDef("hl7ImportReportMissingStudyIUIDCFindSCP", (Object)arcDev.getHl7ImportReportMissingStudyIUIDCFindSCP(), null);
        writer.writeNotNullOrDef("hl7ImportReportAdjustIUID", (Object)arcDev.getHl7ImportReportAdjustIUID(), (Object)HL7ImportReportAdjustIUID.NONE);
        writer.writeNotNullOrDef("hl7DicomCharacterSet", (Object)arcDev.getHl7DicomCharacterSet(), null);
        writer.writeNotDef("hl7VeterinaryUsePatientName", arcDev.isHl7VeterinaryUsePatientName(), false);
        writer.writeNotDef("dcmCSVUploadChunkSize", arcDev.getCSVUploadChunkSize(), 100);
        writer.writeNotDef("dcmValidateUID", arcDev.isValidateUID(), true);
        writer.writeNotDef("dcmRelationalQueryNegotiationLenient", arcDev.isRelationalQueryNegotiationLenient(), false);
        writer.writeNotDef("dcmRelationalRetrieveNegotiationLenient", arcDev.isRelationalRetrieveNegotiationLenient(), false);
        writer.writeNotEmpty("dcmRejectConflictingPatientAttribute", (Object[])TagUtils.toHexStrings((int[])arcDev.getRejectConflictingPatientAttribute()), (Object[])new String[0]);
        writer.writeNotDef("dcmSchedulerMinStartDelay", arcDev.getSchedulerMinStartDelay(), 60);
        writer.writeNotDef("dcmStowRetiredTransferSyntax", arcDev.isStowRetiredTransferSyntax(), false);
        writer.writeNotDef("dcmStowExcludeAPPMarkers", arcDev.isStowExcludeAPPMarkers(), false);
        writer.writeNotDef("dcmRestrictRetrieveSilently", arcDev.isRestrictRetrieveSilently(), false);
        writer.writeNotDef("dcmStowQuicktime2MP4", arcDev.isStowQuicktime2MP4(), false);
        writer.writeNotDef("dcmStowMaxFragmentLength", arcDev.getStowMaxFragmentLength(), 0x7FFFFFFEL);
        writer.writeNotNullOrDef("dcmMWLPollingInterval", (Object)arcDev.getMWLPollingInterval(), null);
        writer.writeNotDef("dcmMWLFetchSize", arcDev.getMWLFetchSize(), 100);
        writer.writeNotNullOrDef("dcmMWLImportInterval", (Object)arcDev.getMWLImportInterval(), null);
        writer.writeNotEmpty("dcmDeleteMWLDelay", (Object[])arcDev.getDeleteMWLDelay(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmUPSProcessingPollingInterval", (Object)arcDev.getUPSProcessingPollingInterval(), null);
        writer.writeNotDef("dcmUPSProcessingFetchSize", arcDev.getUPSProcessingFetchSize(), 100);
        writer.writeNotNullOrDef("dcmTaskPollingInterval", (Object)arcDev.getTaskPollingInterval(), null);
        writer.writeNotDef("dcmTaskFetchSize", arcDev.getTaskFetchSize(), 100);
        writer.writeNotNullOrDef("hl7ReferredMergedPatientPolicy", (Object)arcDev.getHl7ReferredMergedPatientPolicy(), (Object)HL7ReferredMergedPatientPolicy.REJECT);
        writer.writeNotDef("dcmRetrieveTaskWarningOnNoMatch", arcDev.isRetrieveTaskWarningOnNoMatch(), false);
        writer.writeNotDef("dcmRetrieveTaskWarningOnWarnings", arcDev.isRetrieveTaskWarningOnWarnings(), false);
        writer.writeNotEmpty("dcmCStoreSCUOfCMoveSCP", arcDev.getCStoreSCUOfCMoveSCPs());
        writer.writeNotDef("dcmDeleteStudyChunkSize", arcDev.getDeleteStudyChunkSize(), 100);
        writer.writeNotNullOrDef("hl7PatientArrivalMessageType", (Object)arcDev.getHL7PatientArrivalMessageType(), null);
        writer.writeNotNullOrDef("dcmUserIdentityNegotiation", (Object)arcDev.getUserIdentityNegotiation(), (Object)UserIdentityNegotiation.SUPPORTS);
        writer.writeNotNullOrDef("dcmUserIdentityNegotiationRole", (Object)arcDev.getUserIdentityNegotiationRole(), null);
        writer.writeNotNullOrDef("dcmUserIdentityNegotiationKeycloakClientID", (Object)arcDev.getUserIdentityNegotiationKeycloakClientID(), null);
        writer.writeNotNullOrDef("dcmCalculateStudySizeDelay", (Object)arcDev.getStudySizeDelay(), null);
        writer.writeNotNullOrDef("dcmCalculateStudySizePollingInterval", (Object)arcDev.getCalculateStudySizePollingInterval(), null);
        writer.writeNotDef("dcmCalculateStudySizeFetchSize", arcDev.getCalculateStudySizeFetchSize(), 100);
        writer.writeNotDef("dcmCalculateQueryAttributes", arcDev.isCalculateQueryAttributes(), false);
        writer.writeNotDef("dcmStoreImplementationVersionName", arcDev.isStoreImplementationVersionName(), true);
        writer.writeNotDef("dcmSupplementIssuerFetchSize", arcDev.getSupplementIssuerFetchSize(), 100);
        writer.writeNotDef("dcmUpdateCharsetFetchSize", arcDev.getUpdateCharsetFetchSize(), 100);
        writer.writeNotNullOrDef("dcmAuditAssigningAuthorityOfPatientID", (Object)arcDev.getAuditAssigningAuthorityOfPatientID(), null);
        writer.writeNotNullOrDef("dcmChangeRequesterAET", (Object)arcDev.getChangeRequesterAET(), null);
        writer.writeNotDef("dcmFilterByIssuerOfPatientID", arcDev.isFilterByIssuerOfPatientID(), false);
        writer.writeNotDef("dcmAuditHL7MsgLimit", arcDev.getAuditHL7MsgLimit(), 1000);
        writer.writeNotDef("dcmMatchSOPClassOnInstanceLevel", arcDev.isMatchSOPClassOnInstanceLevel(), false);
        writer.writeNotDef("dcmUPSUpdateWithoutTransactionUID", arcDev.isUPSUpdateWithoutTransactionUID(), false);
        writer.writeNotNullOrDef("dcmKeyValueRetentionPollingInterval", (Object)arcDev.getKeyValueRetentionPollingInterval(), null);
        writer.writeNotDef("dcmKeyValueRetentionFetchSize", arcDev.getKeyValueRetentionFetchSize(), 100);
        writer.writeNotNullOrDef("dcmKeyValueRetentionPeriod", (Object)arcDev.getKeyValueRetentionPeriod(), null);
        this.writeAttributeFilters(writer, arcDev);
        this.writeStorageDescriptor(writer, arcDev.getStorageDescriptors());
        this.writeQueryRetrieveView(writer, arcDev.getQueryRetrieveViews());
        this.writeQueue(writer, arcDev.getQueueDescriptors());
        this.writePDQServiceDescriptor(writer, arcDev.getPDQServiceDescriptors());
        this.writeExporterDescriptor(writer, arcDev.getExporterDescriptors());
        this.writeExportRule(writer, arcDev.getExportRules());
        this.writeExportPrefetchRules(writer, arcDev.getExportPriorsRules());
        this.writeMPPSForwardRule(writer, arcDev.getMPPSForwardRules());
        this.writeArchiveCompressionRules(writer, arcDev.getCompressionRules());
        this.writeStoreAccessControlIDRules(writer, arcDev.getStoreAccessControlIDRules());
        this.writeArchiveAttributeCoercion(writer, arcDev.getAttributeCoercions());
        this.writeArchiveAttributeCoercion2(writer, arcDev.getAttributeCoercions2());
        this.writeRejectionNote(writer, arcDev.getRejectionNotes());
        this.writeStudyRetentionPolicies(writer, arcDev.getStudyRetentionPolicies());
        JsonArchiveConfiguration.writeHL7StudyRetentionPolicies(writer, arcDev.getHL7StudyRetentionPolicies());
        this.writeIDGenerators(writer, arcDev);
        JsonArchiveConfiguration.writeHL7ForwardRules(writer, arcDev.getHL7ForwardRules());
        JsonArchiveConfiguration.writeHL7ExportRules(writer, arcDev.getHL7ExportRules());
        JsonArchiveConfiguration.writeHL7PrefetchRules(writer, arcDev.getHL7PrefetchRules());
        JsonArchiveConfiguration.writeRSForwardRules(writer, arcDev.getRSForwardRules());
        this.writeAttributeSet(writer, arcDev);
        JsonArchiveConfiguration.writeScheduledStations(writer, arcDev.getHL7OrderScheduledStations());
        JsonArchiveConfiguration.writeHL7OrderSPSStatus(writer, arcDev.getHL7OrderSPSStatuses());
        JsonArchiveConfiguration.writeMetricsDescriptors(writer, arcDev.getMetricsDescriptors());
        JsonArchiveConfiguration.writeUPSOnStoreList(writer, arcDev.listUPSOnStore());
        JsonArchiveConfiguration.writeUPSOnHL7List(writer, arcDev.listUPSOnHL7());
        this.writeUPSProcessingRules(writer, arcDev.listUPSProcessingRules());
        JsonArchiveConfiguration.writeUPSOnUPSCompletedList(writer, arcDev.listUPSOnUPSCompleted());
        this.writeMWLIdleTimeout(writer, arcDev.getMWLIdleTimeouts());
        this.writeMWLImportRule(writer, arcDev.getMWLImports());
        this.config.writeBulkdataDescriptors(arcDev.getBulkDataDescriptors(), writer);
        writer.writeEnd();
    }

    private void writeAttributeFilters(JsonWriter writer, ArchiveDeviceExtension arcDev) {
        writer.writeStartArray("dcmAttributeFilter");
        for (Map.Entry entry : arcDev.getAttributeFilters().entrySet()) {
            this.writeAttributeFilter(writer, (Entity)entry.getKey(), (AttributeFilter)entry.getValue());
        }
        writer.writeEnd();
    }

    private void writeAttributeSet(JsonWriter writer, ArchiveDeviceExtension arcDev) {
        writer.writeStartArray("dcmAttributeSet");
        for (Map map : arcDev.getAttributeSet().values()) {
            for (AttributeSet attributeSet : map.values()) {
                this.writeAttributeSet(writer, attributeSet);
            }
        }
        writer.writeEnd();
    }

    public void writeAttributeFilter(JsonWriter writer, Entity entity, AttributeFilter attributeFilter) {
        writer.writeStartObject();
        writer.writeNotNullOrDef("dcmEntity", (Object)entity.name(), null);
        writer.writeNotEmpty("dcmTag", (Object[])TagUtils.toHexStrings((int[])attributeFilter.getSelection()), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmCustomAttribute1", (Object)attributeFilter.getCustomAttribute1(), null);
        writer.writeNotNullOrDef("dcmCustomAttribute2", (Object)attributeFilter.getCustomAttribute2(), null);
        writer.writeNotNullOrDef("dcmCustomAttribute3", (Object)attributeFilter.getCustomAttribute3(), null);
        writer.writeNotNullOrDef("dcmAttributeUpdatePolicy", (Object)attributeFilter.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        writer.writeEnd();
    }

    private void writeAttributeSet(JsonWriter writer, AttributeSet attributeSet) {
        writer.writeStartObject();
        writer.writeNotNullOrDef("dcmAttributeSetType", (Object)attributeSet.getType(), null);
        writer.writeNotNullOrDef("dcmAttributeSetID", (Object)attributeSet.getID(), null);
        writer.writeNotNullOrDef("dicomDescription", (Object)attributeSet.getDescription(), null);
        writer.writeNotNullOrDef("dcmAttributeSetTitle", (Object)attributeSet.getTitle(), null);
        writer.writeNotDef("dcmAttributeSetNumber", attributeSet.getNumber(), 0);
        writer.writeNotDef("dicomInstalled", attributeSet.isInstalled(), true);
        writer.writeNotEmpty("dcmProperty", attributeSet.getProperties());
        writer.writeNotEmpty("dcmTag", (Object[])TagUtils.toHexStrings((int[])attributeSet.getSelection()), (Object[])new String[0]);
        writer.writeEnd();
    }

    private void writeStorageDescriptor(JsonWriter writer, Collection<StorageDescriptor> storageDescriptorList) {
        writer.writeStartArray("dcmStorage");
        for (StorageDescriptor st : storageDescriptorList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmStorageID", (Object)st.getStorageID(), null);
            writer.writeNotNullOrDef("dcmURI", (Object)st.getStorageURIStr(), null);
            writer.writeNotNullOrDef("dcmDigestAlgorithm", (Object)st.getDigestAlgorithm(), null);
            writer.writeNotNullOrDef("dcmInstanceAvailability", (Object)st.getInstanceAvailability(), (Object)Availability.ONLINE);
            writer.writeNotNullOrDef("dcmStorageDuration", (Object)st.getStorageDuration(), (Object)StorageDuration.PERMANENT);
            writer.writeNotDef("dcmReadOnly", st.isReadOnly(), false);
            writer.writeNotDef("dcmNoDeletionConstraint", st.isNoDeletionConstraint(), false);
            writer.writeNotDef("dcmStorageThresholdExceedsPermanently", st.isStorageThresholdExceedsPermanently(), true);
            writer.writeNotNull("dcmStorageThresholdExceeded", st.getStorageThresholdExceeded());
            writer.writeNotDef("dcmDeleterThreads", st.getDeleterThreads(), 1);
            writer.writeNotNullOrDef("dcmStorageClusterID", (Object)st.getStorageClusterID(), null);
            writer.writeNotNullOrDef("dcmStorageThreshold", (Object)st.getStorageThreshold(), null);
            writer.writeNotEmpty("dcmDeleterThreshold", (Object[])st.getDeleterThresholdsAsStrings(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", st.getProperties());
            writer.writeNotEmpty("dcmExternalRetrieveAET", (Object[])st.getExternalRetrieveAETitles(), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmExternalRetrieveInstanceAvailability", (Object)st.getExternalRetrieveInstanceAvailability(), null);
            writer.writeNotEmpty("dcmExportStorageID", (Object[])st.getExportStorageID(), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmRetrieveCacheStorageID", (Object)st.getRetrieveCacheStorageID(), null);
            writer.writeNotDef("dcmRetrieveCacheMaxParallel", st.getRetrieveCacheMaxParallel(), 10);
            writer.writeNotEmpty("dcmDeleteStudiesOlderThan", (Object[])st.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.OlderThan), (Object[])new String[0]);
            writer.writeNotEmpty("dcmDeleteStudiesReceivedBefore", (Object[])st.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.ReceivedBefore), (Object[])new String[0]);
            writer.writeNotEmpty("dcmDeleteStudiesNotUsedSince", (Object[])st.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.NotUsedSince), (Object[])new String[0]);
            writer.writeNotDef("dcmMaxRetries", st.getMaxRetries(), 0);
            writer.writeNotNullOrDef("dcmRetryDelay", (Object)st.getRetryDelay(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeQueryRetrieveView(JsonWriter writer, Collection<QueryRetrieveView> queryRetrieveViewList) {
        writer.writeStartArray("dcmQueryRetrieveView");
        for (QueryRetrieveView qrv : queryRetrieveViewList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmQueryRetrieveViewID", (Object)qrv.getViewID(), null);
            writer.writeNotEmpty("dcmShowInstancesRejectedByCode", (Object[])qrv.getShowInstancesRejectedByCodes(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmHideRejectionNoteWithCode", (Object[])qrv.getHideRejectionNotesWithCodes(), (Object[])new Code[0]);
            writer.writeNotDef("dcmHideNotRejectedInstances", qrv.isHideNotRejectedInstances(), false);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeQueue(JsonWriter writer, Collection<QueueDescriptor> queueDescriptorsList) {
        writer.writeStartArray("dcmQueue");
        for (QueueDescriptor qd : queueDescriptorsList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmQueueName", (Object)qd.getQueueName(), null);
            writer.writeNotNullOrDef("dicomDescription", (Object)qd.getDescription(), null);
            writer.writeNotDef("dcmMaxTasksParallel", qd.getMaxTasksParallel(), 1);
            writer.writeNotDef("dcmMaxRetries", qd.getMaxRetries(), 0);
            writer.writeNotEmpty("dcmSchedule", (Object[])qd.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeNotNullOrDef("dcmRetryDelay", (Object)qd.getRetryDelay(), (Object)QueueDescriptor.DEFAULT_RETRY_DELAY);
            writer.writeNotNullOrDef("dcmMaxRetryDelay", (Object)qd.getMaxRetryDelay(), null);
            writer.writeNotDef("dcmRetryDelayMultiplier", qd.getRetryDelayMultiplier(), 100);
            writer.writeNotDef("dcmRetryOnWarning", qd.isRetryOnWarning(), false);
            writer.writeNotNullOrDef("dcmPurgeQueueMessageCompletedDelay", (Object)qd.getPurgeTaskCompletedDelay(), null);
            writer.writeNotNullOrDef("dcmPurgeQueueMessageFailedDelay", (Object)qd.getPurgeTaskFailedDelay(), null);
            writer.writeNotNullOrDef("dcmPurgeQueueMessageWarningDelay", (Object)qd.getPurgeTaskWarningDelay(), null);
            writer.writeNotNullOrDef("dcmPurgeQueueMessageCanceledDelay", (Object)qd.getPurgeTaskCanceledDelay(), null);
            writer.writeNotDef("dicomInstalled", qd.isInstalled(), true);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writePDQServiceDescriptor(JsonWriter writer, Collection<PDQServiceDescriptor> pdqServiceDescriptors) {
        writer.writeStartArray("dcmPDQService");
        for (PDQServiceDescriptor desc : pdqServiceDescriptors) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmPDQServiceID", (Object)desc.getPDQServiceID(), null);
            writer.writeNotNullOrDef("dcmURI", (Object)desc.getPDQServiceURI(), null);
            writer.writeNotNullOrDef("dicomDescription", (Object)desc.getDescription(), null);
            writer.writeNotEmpty("dcmTag", (Object[])TagUtils.toHexStrings((int[])desc.getSelection()), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", desc.getProperties());
            writer.writeNotNullOrDef("dcmEntity", (Object)desc.getEntity(), (Object)Entity.Patient);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeExporterDescriptor(JsonWriter writer, Collection<ExporterDescriptor> exportDescriptorList) {
        writer.writeStartArray("dcmExporter");
        for (ExporterDescriptor ed : exportDescriptorList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmExporterID", (Object)ed.getExporterID(), null);
            writer.writeNotNullOrDef("dcmURI", (Object)ed.getExportURI(), null);
            writer.writeNotNullOrDef("dcmQueueName", (Object)ed.getQueueName(), null);
            writer.writeNotNullOrDef("dicomDescription", (Object)ed.getDescription(), null);
            writer.writeNotNullOrDef("dicomAETitle", (Object)ed.getAETitle(), null);
            writer.writeNotNullOrDef("dcmStgCmtSCP", (Object)ed.getStgCmtSCPAETitle(), null);
            writer.writeNotNullOrDef("dcmDeleteStudyFromStorageID", (Object)ed.getDeleteStudyFromStorageID(), null);
            writer.writeNotEmpty("dcmIanDestination", (Object[])ed.getIanDestinations(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmRetrieveAET", (Object[])ed.getRetrieveAETitles(), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmRetrieveLocationUID", (Object)ed.getRetrieveLocationUID(), null);
            writer.writeNotNullOrDef("dcmInstanceAvailability", (Object)ed.getInstanceAvailability(), (Object)Availability.ONLINE);
            writer.writeNotEmpty("dcmSchedule", (Object[])ed.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeNotEmpty("dcmProperty", ed.getProperties());
            writer.writeNotDef("dcmRejectForDataRetentionExpiry", ed.isRejectForDataRetentionExpiry(), false);
            writer.writeNotDef("dcmExportAsSourceAE", ed.isExportAsSourceAE(), false);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeExportRule(JsonWriter writer, Collection<ExportRule> exportRuleList) {
        writer.writeStartArray("dcmExportRule");
        for (ExportRule er : exportRuleList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)er.getCommonName(), null);
            writer.writeNotNullOrDef("dcmEntity", (Object)er.getEntity(), null);
            writer.writeNotEmpty("dcmExporterID", (Object[])er.getExporterIDs(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", er.getConditions().getMap());
            writer.writeNotEmpty("dcmSchedule", (Object[])er.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeNotNullOrDef("dcmDuration", (Object)er.getExportDelay(), null);
            writer.writeNotDef("dcmExportPreviousEntity", er.isExportPreviousEntity(), false);
            writer.writeNotNullOrDef("dcmExportReoccurredInstances", (Object)er.getExportReoccurredInstances(), (Object)ExportReoccurredInstances.REPLACE);
            writer.writeNotNullOrDef("dicomDeviceName", (Object)er.getExporterDeviceName(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeExportPrefetchRules(JsonWriter writer, Collection<ExportPriorsRule> exportPriorsRuleList) {
        writer.writeStartArray("dcmExportPriorsRule");
        for (ExportPriorsRule rule : exportPriorsRuleList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)rule.getCommonName(), null);
            writer.writeNotEmpty("dcmExporterID", (Object[])rule.getExporterIDs(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", rule.getConditions().getMap());
            writer.writeNotEmpty("dcmSchedule", (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeNotEmpty("dcmEntitySelector", (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
            writer.writeNotNullOrDef("dcmDuration", (Object)rule.getSuppressDuplicateExportInterval(), null);
            writer.writeNotNullOrDef("dcmExportReoccurredInstances", (Object)rule.getExportReoccurredInstances(), (Object)ExportReoccurredInstances.REPLACE);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeMPPSForwardRule(JsonWriter writer, Collection<MPPSForwardRule> mppsForwardRuleList) {
        writer.writeStartArray("dcmMPPSForwardRule");
        for (MPPSForwardRule mppsFwdRule : mppsForwardRuleList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)mppsFwdRule.getCommonName(), null);
            writer.writeNotEmpty("dcmFwdMppsDestination", (Object[])mppsFwdRule.getDestinations(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", mppsFwdRule.getConditions().getMap());
            writer.writeNotEmpty("dcmSchedule", (Object[])mppsFwdRule.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    static void writeHL7ExportRules(JsonWriter writer, Collection<HL7ExportRule> exportRuleList) {
        writer.writeStartArray("hl7ExportRule");
        for (HL7ExportRule rule : exportRuleList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)rule.getCommonName(), null);
            writer.writeNotEmpty("dcmExporterID", (Object[])rule.getExporterIDs(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", rule.getConditions().getMap());
            writer.writeNotNullOrDef("dcmNullifyIssuerOfPatientID", (Object)rule.getIgnoreAssigningAuthorityOfPatientID(), null);
            writer.writeNotEmpty("dcmIssuerOfPatientID", (Object[])rule.getAssigningAuthorityOfPatientIDs(), (Object[])new Issuer[0]);
            writer.writeNotNullOrDef("dcmPrefetchForIssuerOfPatientID", (Object)rule.getPrefetchForAssigningAuthorityOfPatientID(), null);
            writer.writeNotEmpty("dcmEntitySelector", (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
            writer.writeNotNullOrDef("dcmDuration", (Object)rule.getSuppressDuplicateExportInterval(), null);
            writer.writeNotDef("dcmHistorySize", rule.getSuppressDuplicateHistorySize(), 100);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    static void writeHL7PrefetchRules(JsonWriter writer, Collection<HL7PrefetchRule> prefetchRuleList) {
        writer.writeStartArray("hl7PrefetchRule");
        for (HL7PrefetchRule rule : prefetchRuleList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)rule.getCommonName(), null);
            writer.writeNotNullOrDef("dicomAETitle", (Object)rule.getAETitle(), null);
            writer.writeNotNullOrDef("dcmQueueName", (Object)rule.getQueueName(), null);
            writer.writeNotNullOrDef("dcmPrefetchCFindSCP", (Object)rule.getPrefetchCFindSCP(), null);
            writer.writeNotNullOrDef("dcmPrefetchCMoveSCP", (Object)rule.getPrefetchCMoveSCP(), null);
            writer.writeNotEmpty("dcmPrefetchCStoreSCP", (Object[])rule.getPrefetchCStoreSCPs(), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmDestinationCFindSCP", (Object)rule.getDestinationCFindSCP(), null);
            writer.writeNotNullOrDef("dicomDeviceName", (Object)rule.getPrefetchDeviceName(), null);
            writer.writeNotEmpty("dcmProperty", rule.getConditions().getMap());
            writer.writeNotEmpty("dcmSchedule", (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeNotNullOrDef("dcmNullifyIssuerOfPatientID", (Object)rule.getIgnoreAssigningAuthorityOfPatientID(), null);
            writer.writeNotEmpty("dcmIssuerOfPatientID", (Object[])rule.getAssigningAuthorityOfPatientIDs(), (Object[])new Issuer[0]);
            writer.writeNotNullOrDef("dcmPrefetchForIssuerOfPatientID", (Object)rule.getPrefetchForAssigningAuthorityOfPatientID(), null);
            writer.writeNotEmpty("dcmEntitySelector", (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
            writer.writeNotNullOrDef("dcmDuration", (Object)rule.getSuppressDuplicateRetrieveInterval(), null);
            writer.writeNotDef("dcmHistorySize", rule.getSuppressDuplicateHistorySize(), 100);
            writer.writeNotNullOrDef("dcmPrefetchDateTimeField", (Object)rule.getPrefetchDateTimeField(), null);
            writer.writeNotNullOrDef("dcmPrefetchInAdvance", (Object)rule.getPrefetchInAdvance(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeArchiveCompressionRules(JsonWriter writer, Collection<ArchiveCompressionRule> archiveCompressionRuleList) {
        writer.writeStartArray("dcmArchiveCompressionRule");
        for (ArchiveCompressionRule acr : archiveCompressionRuleList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)acr.getCommonName(), null);
            writer.writeNotNullOrDef("dcmCompressionDelay", (Object)acr.getDelay(), null);
            writer.writeNotNullOrDef("dicomTransferSyntax", (Object)acr.getTransferSyntax(), null);
            writer.writeNotDef("dcmRulePriority", acr.getPriority(), 0);
            writer.writeNotEmpty("dcmProperty", acr.getConditions().getMap());
            writer.writeNotEmpty("dcmImageWriteParam", (Object[])acr.getImageWriteParams(), (Object[])new Property[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeStoreAccessControlIDRules(JsonWriter writer, Collection<StoreAccessControlIDRule> rules) {
        writer.writeStartArray("dcmStoreAccessControlIDRule");
        for (StoreAccessControlIDRule acr : rules) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)acr.getCommonName(), null);
            writer.writeNotNullOrDef("dcmStoreAccessControlID", (Object)acr.getStoreAccessControlID(), null);
            writer.writeNotDef("dcmRulePriority", acr.getPriority(), 0);
            writer.writeNotEmpty("dcmProperty", acr.getConditions().getMap());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeMWLImportRule(JsonWriter writer, Collection<MWLImport> mwlImportList) {
        writer.writeStartArray("dcmMWLImport");
        for (MWLImport mwlImport : mwlImportList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmMWLImportID", (Object)mwlImport.getMWLImportID(), null);
            writer.writeNotNullOrDef("dicomAETitle", (Object)mwlImport.getAETitle(), null);
            writer.writeNotNullOrDef("dcmMergeMWLSCP", (Object)mwlImport.getMWLSCP(), null);
            writer.writeNotNullOrDef("dcmMWLWorklistLabel", (Object)mwlImport.getMWLWorklistLabel(), null);
            writer.writeNotNullOrDef("dcmDuration", (Object)mwlImport.getPrefetchBefore(), null);
            writer.writeNotNullOrDef("dcmMWLImportNotOlder", (Object)mwlImport.getNotOlderThan(), null);
            writer.writeNotDef("dcmMWLImportFilterBySCU", mwlImport.isFilterBySCU(), false);
            writer.writeNotDef("dcmMWLImportDeleteNotFound", mwlImport.isDeleteNotFound(), false);
            writer.writeNotEmpty("dcmIncludeField", (Object[])mwlImport.getIncludeFields(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", mwlImport.getFilter());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeArchiveAttributeCoercion(JsonWriter writer, Collection<ArchiveAttributeCoercion> archiveAttributeCoercionList) {
        writer.writeStartArray("dcmArchiveAttributeCoercion");
        for (ArchiveAttributeCoercion aac : archiveAttributeCoercionList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)aac.getCommonName(), null);
            writer.writeNotNullOrDef("dcmDIMSE", (Object)aac.getDIMSE(), null);
            writer.writeNotNullOrDef("dicomTransferRole", (Object)aac.getRole(), null);
            writer.writeNotDef("dcmRulePriority", aac.getPriority(), 0);
            writer.writeNotEmpty("dcmSOPClass", (Object[])aac.getSOPClasses(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", aac.getConditions().getMap());
            writer.writeNotEmpty("dcmMergeAttribute", (Object[])aac.getMergeAttributes(), (Object[])new MergeAttribute[0]);
            writer.writeNotDef("dcmRetrieveAsReceived", aac.isRetrieveAsReceived(), false);
            writer.writeNotEmpty("dcmDeIdentification", (Object[])aac.getDeIdentification(), (Object[])new DeIdentifier.Option[0]);
            writer.writeNotDef("dcmNoKeywords", aac.isNoKeywords(), false);
            writer.writeNotNullOrDef("dcmURI", (Object)aac.getXSLTStylesheetURI(), null);
            writer.writeNotNullOrDef("dcmLeadingCFindSCP", (Object)aac.getLeadingCFindSCP(), null);
            writer.writeNotNullOrDef("dcmMergeMWLMatchingKey", (Object)aac.getMergeMWLMatchingKey(), null);
            writer.writeNotNullOrDef("dcmMergeMWLTemplateURI", (Object)aac.getMergeMWLTemplateURI(), null);
            writer.writeNotNullOrDef("dcmMergeMWLSCP", (Object)aac.getMergeMWLSCP(), null);
            writer.writeNotEmpty("dcmMergeLocalMWLWorklistLabel", (Object[])aac.getMergeLocalMWLWorklistLabels(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmMergeLocalMWLWithStatus", (Object[])aac.getMergeLocalMWLWithStatus(), (Object[])new SPSStatus[0]);
            writer.writeNotDef("dcmMWLImportFilterBySCU", aac.isFilterBySCU(), false);
            writer.writeNotNullOrDef("dcmNullifyIssuerOfPatientID", (Object)aac.getNullifyIssuerOfPatientID(), null);
            writer.writeNotEmpty("dcmIssuerOfPatientID", (Object[])aac.getIssuerOfPatientIDs(), (Object[])new Issuer[0]);
            writer.writeNotNullOrDef("dcmAttributeUpdatePolicy", (Object)aac.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.MERGE);
            writer.writeNotEmpty("dcmNullifyTag", (Object[])TagUtils.toHexStrings((int[])aac.getNullifyTags()), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmSupplementFromDeviceReference", (Object)JsonArchiveConfiguration.deviceNameOf(aac.getSupplementFromDevice()), null);
            writer.writeNotNullOrDef("dcmIssuerOfPatientIDFormat", (Object)aac.getIssuerOfPatientIDFormat(), null);
            writer.writeNotDef("dcmTrimISO2022CharacterSet", aac.isTrimISO2022CharacterSet(), false);
            writer.writeNotNullOrDef("dcmUseCallingAETitleAs", (Object)aac.getUseCallingAETitleAs(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeArchiveAttributeCoercion2(JsonWriter writer, Collection<ArchiveAttributeCoercion2> archiveAttributeCoercionList) {
        writer.writeStartArray("dcmArchiveAttributeCoercion2");
        for (ArchiveAttributeCoercion2 aac : archiveAttributeCoercionList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)aac.getCommonName(), null);
            writer.writeNotNullOrDef("dicomDescription", (Object)aac.getDescription(), null);
            writer.writeNotDef("dcmRulePriority", aac.getPriority(), 0);
            writer.writeNotNullOrDef("dcmDIMSE", (Object)aac.getDIMSE(), null);
            writer.writeNotNullOrDef("dicomTransferRole", (Object)aac.getRole(), null);
            writer.writeNotEmpty("dcmSOPClass", (Object[])aac.getSOPClasses(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", aac.getConditions().getMap());
            writer.writeNotNullOrDef("dcmURI", (Object)aac.getURI(), null);
            writer.writeNotNullOrDef("dcmAttributeUpdatePolicy", (Object)aac.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.MERGE);
            writer.writeNotNullOrDef("dcmSupplementFromDeviceReference", (Object)JsonArchiveConfiguration.deviceNameOf(aac.getOtherDevice()), null);
            writer.writeNotEmpty("dcmMergeAttribute", (Object[])aac.getMergeAttributes(), (Object[])new MergeAttribute[0]);
            writer.writeNotEmpty("dcmCoercionParam", aac.getCoercionParams());
            writer.writeNotDef("dcmCoercionSufficient", aac.isCoercionSufficient(), false);
            writer.writeNotNullOrDef("dcmCoercionSufficient", (Object)aac.getCoercionOnFailure(), (Object)ArchiveAttributeCoercion2.OnFailure.RETHROW);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private static String deviceNameOf(Device device) {
        return device != null ? device.getDeviceName() : null;
    }

    private void writeRejectionNote(JsonWriter writer, Collection<RejectionNote> rejectionNoteList) {
        writer.writeStartArray("dcmRejectionNote");
        for (RejectionNote rn : rejectionNoteList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmRejectionNoteLabel", (Object)rn.getRejectionNoteLabel(), null);
            writer.writeNotNullOrDef("dcmRejectionNoteType", (Object)rn.getRejectionNoteType(), null);
            writer.writeNotNullOrDef("dcmRejectionNoteCode", (Object)rn.getRejectionNoteCode(), null);
            writer.writeNotNullOrDef("dcmAcceptPreviousRejectedInstance", (Object)rn.getAcceptPreviousRejectedInstance(), (Object)RejectionNote.AcceptPreviousRejectedInstance.REJECT);
            writer.writeNotEmpty("dcmOverwritePreviousRejection", (Object[])rn.getOverwritePreviousRejection(), (Object[])new Code[0]);
            writer.writeNotNullOrDef("dcmAcceptRejectionBeforeStorage", (Object)rn.getAcceptRejectionBeforeStorage(), null);
            writer.writeNotNullOrDef("dcmDeleteRejectedInstanceDelay", (Object)rn.getDeleteRejectedInstanceDelay(), null);
            writer.writeNotNullOrDef("dcmDeleteRejectionNoteDelay", (Object)rn.getDeleteRejectionNoteDelay(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeStudyRetentionPolicies(JsonWriter writer, Collection<StudyRetentionPolicy> studyRetentionPolicies) {
        writer.writeStartArray("dcmStudyRetentionPolicy");
        for (StudyRetentionPolicy srp : studyRetentionPolicies) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)srp.getCommonName(), null);
            writer.writeNotNullOrDef("dcmRetentionPeriod", (Object)srp.getRetentionPeriod(), null);
            writer.writeNotDef("dcmRulePriority", srp.getPriority(), 0);
            writer.writeNotEmpty("dcmProperty", srp.getConditions().getMap());
            writer.writeNotDef("dcmExpireSeriesIndividually", srp.isExpireSeriesIndividually(), false);
            writer.writeNotDef("dcmStartRetentionPeriodOnStudyDate", srp.isStartRetentionPeriodOnStudyDate(), false);
            writer.writeNotNullOrDef("dcmExporterID", (Object)srp.getExporterID(), null);
            writer.writeNotDef("dcmFreezeExpirationDate", srp.isFreezeExpirationDate(), false);
            writer.writeNotDef("dcmRevokeExpiration", srp.isRevokeExpiration(), false);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    static void writeHL7StudyRetentionPolicies(JsonWriter writer, Collection<HL7StudyRetentionPolicy> studyRetentionPolicies) {
        writer.writeStartArray("hl7StudyRetentionPolicy");
        for (HL7StudyRetentionPolicy srp : studyRetentionPolicies) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)srp.getCommonName(), null);
            writer.writeNotNullOrDef("dicomAETitle", (Object)srp.getAETitle(), null);
            writer.writeNotNullOrDef("dcmRetentionPeriod", (Object)srp.getMinRetentionPeriod(), null);
            writer.writeNotNullOrDef("dcmMaxRetentionPeriod", (Object)srp.getMaxRetentionPeriod(), null);
            writer.writeNotDef("dcmRulePriority", srp.getPriority(), 0);
            writer.writeNotEmpty("dcmProperty", srp.getConditions().getMap());
            writer.writeNotDef("dcmStartRetentionPeriodOnStudyDate", srp.isStartRetentionPeriodOnStudyDate(), false);
            writer.writeNotNullOrDef("dcmExporterID", (Object)srp.getExporterID(), null);
            writer.writeNotDef("dcmFreezeExpirationDate", srp.isFreezeExpirationDate(), false);
            writer.writeNotDef("dcmRevokeExpiration", srp.isRevokeExpiration(), false);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    static void writeHL7ForwardRules(JsonWriter writer, Collection<HL7ForwardRule> rules) {
        writer.writeStartArray("hl7ForwardRule");
        for (HL7ForwardRule rule : rules) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)rule.getCommonName(), null);
            writer.writeNotEmpty("hl7FwdApplicationName", (Object[])rule.getDestinations(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmProperty", rule.getConditions().getMap());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    static void writeScheduledStations(JsonWriter writer, Collection<HL7OrderScheduledStation> stations) {
        writer.writeStartArray("hl7OrderScheduledStation");
        for (HL7OrderScheduledStation station : stations) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)station.getCommonName(), null);
            writer.writeNotNullOrDef("hl7OrderScheduledStationDeviceName", (Object)JsonArchiveConfiguration.deviceNameOf(station.getDevice()), null);
            writer.writeNotDef("dcmRulePriority", station.getPriority(), 0);
            writer.writeNotEmpty("dcmProperty", station.getConditions().getMap());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    static void writeHL7OrderSPSStatus(JsonWriter writer, Map<SPSStatus, HL7OrderSPSStatus> hl7OrderSPSStatusMap) {
        writer.writeStartArray("hl7OrderSPSStatus");
        for (Map.Entry<SPSStatus, HL7OrderSPSStatus> entry : hl7OrderSPSStatusMap.entrySet()) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmSPSStatus", (Object)entry.getKey(), null);
            writer.writeNotEmpty("hl7OrderControlStatus", (Object[])entry.getValue().getOrderControlStatusCodes(), (Object[])new String[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private static void writeRSForwardRules(JsonWriter writer, Collection<RSForwardRule> rules) {
        writer.writeStartArray("dcmRSForwardRule");
        for (RSForwardRule rule : rules) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)rule.getCommonName(), null);
            writer.writeNotNullOrDef("dcmWebAppName", (Object)rule.getWebAppName(), null);
            writer.writeNotEmpty("dcmRSOperation", (Object[])rule.getRSOperations(), (Object[])new RSOperation[0]);
            writer.writeNotDef("dcmTLSAllowAnyHostname", rule.isTlsAllowAnyHostname(), false);
            writer.writeNotDef("dcmTLSDisableTrustManager", rule.isTlsDisableTrustManager(), false);
            writer.writeNotNullOrDef("dcmURIPattern", (Object)rule.getRequestURLPattern(), null);
            writer.writeNotNullOrDef("dcmHostnamePattern", (Object)rule.getRemoteHostnamePattern(), null);
            writer.writeNotNullOrDef("dcmIPAddressPattern", (Object)rule.getRemoteIPAddressPattern(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private static void writeMetricsDescriptors(JsonWriter writer, Collection<MetricsDescriptor> metricsDescriptors) {
        writer.writeStartArray("dcmMetrics");
        for (MetricsDescriptor metricsDescriptor : metricsDescriptors) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmMetricsName", (Object)metricsDescriptor.getMetricsName(), null);
            writer.writeNotNullOrDef("dicomDescription", (Object)metricsDescriptor.getDescription(), null);
            writer.writeNotDef("dcmMetricsRetentionPeriod", metricsDescriptor.getRetentionPeriod(), 60);
            writer.writeNotNullOrDef("dcmUnit", (Object)metricsDescriptor.getUnit(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private static void writeUPSOnStoreList(JsonWriter writer, Collection<UPSOnStore> upsOnStoreList) {
        writer.writeStartArray("dcmUPSOnStore");
        for (UPSOnStore upsOnStore : upsOnStoreList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmUPSOnStoreID", (Object)upsOnStore.getUPSOnStoreID(), null);
            writer.writeNotNullOrDef("dcmUPSLabel", (Object)upsOnStore.getProcedureStepLabel(), null);
            writer.writeNotNullOrDef("dcmUPSPriority", (Object)upsOnStore.getUPSPriority(), (Object)UPSPriority.MEDIUM);
            writer.writeNotNullOrDef("dcmUPSInputReadinessState", (Object)upsOnStore.getInputReadinessState(), (Object)InputReadinessState.READY);
            writer.writeNotNullOrDef("dcmUPSStartDateTimeDelay", (Object)upsOnStore.getStartDateTimeDelay(), null);
            writer.writeNotNullOrDef("dcmUPSCompletionDateTimeDelay", (Object)upsOnStore.getCompletionDateTimeDelay(), null);
            writer.writeNotNullOrDef("dcmUPSWorklistLabel", (Object)upsOnStore.getWorklistLabel(), null);
            writer.writeNotNullOrDef("dcmUPSInstanceUIDBasedOnName", (Object)upsOnStore.getInstanceUIDBasedOnName(), null);
            writer.writeNotNullOrDef("dcmUPSIncludeInputInformation", (Object)upsOnStore.getIncludeInputInformation(), (Object)UPSOnStore.IncludeInputInformation.APPEND);
            writer.writeNotDef("dcmUPSIncludePatient", upsOnStore.isIncludePatient(), true);
            writer.writeNotDef("dcmUPSIncludeStudyInstanceUID", upsOnStore.isIncludeStudyInstanceUID(), false);
            writer.writeNotDef("dcmUPSIncludeReferencedRequest", upsOnStore.isIncludeReferencedRequest(), false);
            writer.writeNotNullOrDef("dcmDestinationAE", (Object)upsOnStore.getDestinationAE(), null);
            writer.writeNotNullOrDef("dcmEntity", (Object)upsOnStore.getScopeOfAccumulation(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledWorkitemCode", (Object)upsOnStore.getScheduledWorkitemCode(), null);
            writer.writeNotEmpty("dcmUPSScheduledStationNameCode", (Object[])upsOnStore.getScheduledStationNames(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledStationClassCode", (Object[])upsOnStore.getScheduledStationClasses(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledStationLocationCode", (Object[])upsOnStore.getScheduledStationLocations(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledHumanPerformerCode", (Object[])upsOnStore.getScheduledHumanPerformers(), (Object[])new Code[0]);
            writer.writeNotNullOrDef("dcmUPSScheduledHumanPerformerName", (Object)upsOnStore.getScheduledHumanPerformerName(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledHumanPerformerOrganization", (Object)upsOnStore.getScheduledHumanPerformerOrganization(), null);
            writer.writeNotNullOrDef("dcmAdmissionID", (Object)upsOnStore.getAdmissionID(), null);
            writer.writeNotNullOrDef("dicomIssuerOfAdmissionID", (Object)upsOnStore.getIssuerOfAdmissionID(), null);
            writer.writeNotNullOrDef("dcmAccessionNumber", (Object)upsOnStore.getAccessionNumber(), null);
            writer.writeNotNullOrDef("dicomIssuerOfAccessionNumber", (Object)upsOnStore.getIssuerOfAccessionNumber(), null);
            writer.writeNotNullOrDef("dcmRequestedProcedureID", (Object)upsOnStore.getRequestedProcedureID(), null);
            writer.writeNotNullOrDef("dcmRequestedProcedureDescription", (Object)upsOnStore.getRequestedProcedureDescription(), null);
            writer.writeNotNullOrDef("dcmRequestingPhysician", (Object)upsOnStore.getRequestingPhysician(), null);
            writer.writeNotNullOrDef("dcmRequestingService", (Object)upsOnStore.getRequestingService(), null);
            writer.writeNotNullOrDef("dcmURI", (Object)upsOnStore.getXSLTStylesheetURI(), null);
            writer.writeNotDef("dcmNoKeywords", upsOnStore.isNoKeywords(), false);
            writer.writeNotEmpty("dcmProperty", upsOnStore.getConditions().getMap());
            writer.writeNotEmpty("dcmSchedule", (Object[])upsOnStore.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUPSProcessingRules(JsonWriter writer, Collection<UPSProcessingRule> upsProcessingRules) {
        writer.writeStartArray("dcmUPSProcessingRule");
        upsProcessingRules.forEach(upsProcessingRule -> {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmUPSProcessingRuleID", (Object)upsProcessingRule.getUPSProcessingRuleID(), null);
            writer.writeNotNullOrDef("dicomAETitle", (Object)upsProcessingRule.getAETitle(), null);
            writer.writeNotNullOrDef("dcmURI", (Object)upsProcessingRule.getUPSProcessorURI(), null);
            writer.writeNotEmpty("dcmProperty", upsProcessingRule.getProperties());
            writer.writeNotEmpty("dcmSchedule", (Object[])upsProcessingRule.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeNotDef("dcmMaxThreads", upsProcessingRule.getMaxThreads(), 1);
            writer.writeNotNullOrDef("dcmUPSInputReadinessState", (Object)upsProcessingRule.getInputReadinessState(), (Object)InputReadinessState.READY);
            writer.writeNotNullOrDef("dcmUPSPriority", (Object)upsProcessingRule.getUPSPriority(), null);
            writer.writeNotNullOrDef("dcmUPSLabel", (Object)upsProcessingRule.getProcedureStepLabel(), null);
            writer.writeNotNullOrDef("dcmUPSWorklistLabel", (Object)upsProcessingRule.getWorklistLabel(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledWorkitemCode", (Object)upsProcessingRule.getScheduledWorkitemCode(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledStationNameCode", (Object)upsProcessingRule.getScheduledStationName(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledStationClassCode", (Object)upsProcessingRule.getScheduledStationClass(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledStationLocationCode", (Object)upsProcessingRule.getScheduledStationLocation(), null);
            writer.writeNotNullOrDef("dcmUPSPerformedWorkitemCode", (Object)upsProcessingRule.getPerformedWorkitemCode(), null);
            writer.writeNotNullOrDef("dcmUPSPerformedStationNameCode", (Object)upsProcessingRule.getPerformedStationNameCode(), null);
            writer.writeNotEmpty("dcmRescheduleDiscontinuationReasonCode", (Object[])upsProcessingRule.getRescheduleDiscontinuationReasonCodes(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmIgnoreDiscontinuationReasonCode", (Object[])upsProcessingRule.getIgnoreDiscontinuationReasonCodes(), (Object[])new Code[0]);
            writer.writeNotDef("dcmMaxRetries", upsProcessingRule.getMaxRetries(), 0);
            writer.writeNotNullOrDef("dcmRetryDelay", (Object)upsProcessingRule.getRetryDelay(), (Object)UPSProcessingRule.DEFAULT_RETRY_DELAY);
            writer.writeNotNullOrDef("dcmMaxRetryDelay", (Object)upsProcessingRule.getMaxRetryDelay(), null);
            writer.writeNotDef("dcmRetryDelayMultiplier", upsProcessingRule.getRetryDelayMultiplier(), 100);
            writer.writeNotNullOrDef("dcmUPSTemplateID", (Object)upsProcessingRule.getUpsTemplateID(), null);
            writer.writeEnd();
        });
        writer.writeEnd();
    }

    static void writeUPSOnHL7List(JsonWriter writer, Collection<UPSOnHL7> upsOnHL7List) {
        writer.writeStartArray("hl7UPSOnHL7");
        for (UPSOnHL7 upsOnHL7 : upsOnHL7List) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("hl7UPSOnHL7ID", (Object)upsOnHL7.getUPSOnHL7ID(), null);
            writer.writeNotEmpty("dcmProperty", upsOnHL7.getConditions().getMap());
            writer.writeNotEmpty("dcmSchedule", (Object[])upsOnHL7.getSchedules(), (Object[])new ScheduleExpression[0]);
            writer.writeNotNullOrDef("dcmUPSLabel", (Object)upsOnHL7.getProcedureStepLabel(), null);
            writer.writeNotNullOrDef("dcmUPSWorklistLabel", (Object)upsOnHL7.getWorklistLabel(), null);
            writer.writeNotNullOrDef("dcmUPSPriority", (Object)upsOnHL7.getUPSPriority(), (Object)UPSPriority.MEDIUM);
            writer.writeNotNullOrDef("dcmUPSInputReadinessState", (Object)upsOnHL7.getInputReadinessState(), (Object)InputReadinessState.READY);
            writer.writeNotNullOrDef("dcmUPSStartDateTimeDelay", (Object)upsOnHL7.getStartDateTimeDelay(), null);
            writer.writeNotNullOrDef("dcmUPSCompletionDateTimeDelay", (Object)upsOnHL7.getCompletionDateTimeDelay(), null);
            writer.writeNotNullOrDef("dcmUPSInstanceUIDBasedOnName", (Object)upsOnHL7.getInstanceUIDBasedOnName(), null);
            writer.writeNotNullOrDef("dcmDestinationAE", (Object)upsOnHL7.getDestinationAE(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledWorkitemCode", (Object)upsOnHL7.getScheduledWorkitemCode(), null);
            writer.writeNotEmpty("dcmUPSScheduledStationNameCode", (Object[])upsOnHL7.getScheduledStationNames(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledStationClassCode", (Object[])upsOnHL7.getScheduledStationClasses(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledStationLocationCode", (Object[])upsOnHL7.getScheduledStationLocations(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledHumanPerformerCode", (Object[])upsOnHL7.getScheduledHumanPerformers(), (Object[])new Code[0]);
            writer.writeNotNullOrDef("dcmUPSScheduledHumanPerformerName", (Object)upsOnHL7.getScheduledHumanPerformerName(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledHumanPerformerOrganization", (Object)upsOnHL7.getScheduledHumanPerformerOrganization(), null);
            writer.writeNotDef("dcmUPSIncludeStudyInstanceUID", upsOnHL7.isIncludeStudyInstanceUID(), false);
            writer.writeNotDef("dcmUPSIncludeReferencedRequest", upsOnHL7.isIncludeReferencedRequest(), false);
            writer.writeNotNullOrDef("dcmStudyInstanceUID", (Object)upsOnHL7.getStudyInstanceUID(), null);
            writer.writeNotNullOrDef("dcmAdmissionID", (Object)upsOnHL7.getAdmissionID(), null);
            writer.writeNotNullOrDef("dicomIssuerOfAdmissionID", (Object)upsOnHL7.getIssuerOfAdmissionID(), null);
            writer.writeNotNullOrDef("dcmAccessionNumber", (Object)upsOnHL7.getAccessionNumber(), null);
            writer.writeNotNullOrDef("dicomIssuerOfAccessionNumber", (Object)upsOnHL7.getIssuerOfAccessionNumber(), null);
            writer.writeNotNullOrDef("dcmRequestedProcedureID", (Object)upsOnHL7.getRequestedProcedureID(), null);
            writer.writeNotNullOrDef("dcmRequestedProcedureDescription", (Object)upsOnHL7.getRequestedProcedureDescription(), null);
            writer.writeNotNullOrDef("dcmRequestingPhysician", (Object)upsOnHL7.getRequestingPhysician(), null);
            writer.writeNotNullOrDef("dcmRequestingService", (Object)upsOnHL7.getRequestingService(), null);
            writer.writeNotNullOrDef("dcmURI", (Object)upsOnHL7.getXSLTStylesheetURI(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private static void writeUPSOnUPSCompletedList(JsonWriter writer, Collection<UPSOnUPSCompleted> upsOnUPSCompletedList) {
        writer.writeStartArray("dcmUPSOnUPSCompleted");
        upsOnUPSCompletedList.forEach(upsOnUPSCompleted -> {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmUPSOnUPSCompletedID", (Object)upsOnUPSCompleted.getUPSonUPSCompletedID(), null);
            writer.writeNotNullOrDef("dcmUPSLabel", (Object)upsOnUPSCompleted.getProcedureStepLabel(), null);
            writer.writeNotEmpty("dcmProperty", upsOnUPSCompleted.getConditions().getMap());
            writer.writeNotEmpty("dcmRequiresOtherUPSCompleted", (Object[])upsOnUPSCompleted.getRequiresOtherUPSCompleted(), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmUPSWorklistLabel", (Object)upsOnUPSCompleted.getWorklistLabel(), null);
            writer.writeNotNullOrDef("dcmUPSInstanceUIDBasedOnName", (Object)upsOnUPSCompleted.getInstanceUIDBasedOnName(), null);
            writer.writeNotNullOrDef("dcmUPSIncludeInputInformation", (Object)upsOnUPSCompleted.getIncludeInputInformation(), (Object)UPSOnUPSCompleted.IncludeInputInformation.COPY_OUTPUT);
            writer.writeNotDef("dcmUPSIncludePatient", upsOnUPSCompleted.isIncludePatient(), true);
            writer.writeNotNullOrDef("dcmUPSPriority", (Object)upsOnUPSCompleted.getUPSPriority(), (Object)UPSPriority.MEDIUM);
            writer.writeNotNullOrDef("dcmUPSInputReadinessState", (Object)upsOnUPSCompleted.getInputReadinessState(), (Object)InputReadinessState.READY);
            writer.writeNotNullOrDef("dcmUPSStartDateTimeDelay", (Object)upsOnUPSCompleted.getStartDateTimeDelay(), null);
            writer.writeNotNullOrDef("dcmUPSCompletionDateTimeDelay", (Object)upsOnUPSCompleted.getCompletionDateTimeDelay(), null);
            writer.writeNotNullOrDef("dcmDestinationAE", (Object)upsOnUPSCompleted.getDestinationAE(), null);
            writer.writeNotNullOrDef("dcmEntity", (Object)upsOnUPSCompleted.getScopeOfAccumulation(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledWorkitemCode", (Object)upsOnUPSCompleted.getScheduledWorkitemCode(), null);
            writer.writeNotEmpty("dcmUPSScheduledStationNameCode", (Object[])upsOnUPSCompleted.getScheduledStationNames(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledStationClassCode", (Object[])upsOnUPSCompleted.getScheduledStationClasses(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledStationLocationCode", (Object[])upsOnUPSCompleted.getScheduledStationLocations(), (Object[])new Code[0]);
            writer.writeNotEmpty("dcmUPSScheduledHumanPerformerCode", (Object[])upsOnUPSCompleted.getScheduledHumanPerformers(), (Object[])new Code[0]);
            writer.writeNotNullOrDef("dcmUPSScheduledHumanPerformerName", (Object)upsOnUPSCompleted.getScheduledHumanPerformerName(), null);
            writer.writeNotNullOrDef("dcmUPSScheduledHumanPerformerOrganization", (Object)upsOnUPSCompleted.getScheduledHumanPerformerOrganization(), null);
            writer.writeNotNullOrDef("dcmAdmissionID", (Object)upsOnUPSCompleted.getAdmissionID(), null);
            writer.writeNotNullOrDef("dicomIssuerOfAdmissionID", (Object)upsOnUPSCompleted.getIssuerOfAdmissionID(), null);
            writer.writeNotDef("dcmUPSIncludeStudyInstanceUID", upsOnUPSCompleted.isIncludeStudyInstanceUID(), false);
            writer.writeNotDef("dcmUPSIncludeReferencedRequest", upsOnUPSCompleted.isIncludeReferencedRequest(), false);
            writer.writeNotNullOrDef("dcmURI", (Object)upsOnUPSCompleted.getXSLTStylesheetURI(), null);
            writer.writeNotDef("dcmNoKeywords", upsOnUPSCompleted.isNoKeywords(), false);
            writer.writeEnd();
        });
        writer.writeEnd();
    }

    private void writeIDGenerators(JsonWriter writer, ArchiveDeviceExtension arcDev) {
        writer.writeStartArray("dcmIDGenerator");
        for (IDGenerator generator : arcDev.getIDGenerators().values()) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmIDGeneratorName", (Object)generator.getName(), null);
            writer.writeNotNullOrDef("dcmIDGeneratorFormat", (Object)generator.getFormat(), null);
            writer.writeNotDef("dcmIDGeneratorInitialValue", generator.getInitialValue(), 1);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeMWLIdleTimeout(JsonWriter writer, Collection<MWLIdleTimeout> mwlIdleTimeoutList) {
        writer.writeStartArray("dcmMWLIdleTimeout");
        for (MWLIdleTimeout mwlIdleTimeout : mwlIdleTimeoutList) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("cn", (Object)mwlIdleTimeout.getCommonName(), null);
            writer.writeNotNullOrDef("dicomAETitle", (Object)mwlIdleTimeout.getAETitle(), null);
            writer.writeNotNullOrDef("dcmMWLStatusOnIdle", (Object)mwlIdleTimeout.getStatusOnIdle(), null);
            writer.writeNotNullOrDef("dcmDuration", (Object)mwlIdleTimeout.getIdleTimeout(), null);
            writer.writeNotEmpty("dcmAETitle", (Object[])mwlIdleTimeout.getScheduledStationAETitles(), (Object[])new String[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    protected void storeTo(ApplicationEntity ae, JsonWriter writer) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
        if (arcAE == null) {
            return;
        }
        writer.writeStartObject("dcmArchiveNetworkAE");
        writer.writeNotEmpty("dcmObjectStorageID", (Object[])arcAE.getObjectStorageIDs(), (Object[])new String[0]);
        writer.writeNotDef("dcmObjectStorageCount", arcAE.getObjectStorageCount(), 1);
        writer.writeNotEmpty("dcmMetadataStorageID", (Object[])arcAE.getMetadataStorageIDs(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmBulkDataDescriptorID", (Object)arcAE.getBulkDataDescriptorID(), null);
        writer.writeNotNullOrDef("dcmSeriesMetadataDelay", (Object)arcAE.getSeriesMetadataDelay(), null);
        writer.writeNotNullOrDef("dcmPurgeInstanceRecordsDelay", (Object)arcAE.getPurgeInstanceRecordsDelay(), null);
        writer.writeNotNullOrDef("dcmStoreAccessControlID", (Object)arcAE.getStoreAccessControlID(), null);
        writer.writeNotEmpty("dcmAccessControlID", (Object[])arcAE.getAccessControlIDs(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmOverwritePolicy", (Object)arcAE.getOverwritePolicy(), null);
        writer.writeNotNull("dcmRecordAttributeModification", arcAE.getRecordAttributeModification());
        writer.writeNotNullOrDef("dcmQueryRetrieveViewID", (Object)arcAE.getQueryRetrieveViewID(), null);
        writer.writeNotNullOrDef("dcmBulkDataSpoolDirectory", (Object)arcAE.getBulkDataSpoolDirectory(), null);
        writer.writeNotEmpty("dcmHideSPSWithStatusFromMWL", (Object[])arcAE.getHideSPSWithStatusFromMWL(), (Object[])new SPSStatus[0]);
        writer.writeNotEmpty("dcmHideSPSWithStatusFromMWLRS", (Object[])arcAE.getHideSPSWithStatusFromMWLRS(), (Object[])new SPSStatus[0]);
        writer.writeNotNullOrDef("dcmMWLAccessionNumberGenerator", (Object)arcAE.getMWLAccessionNumberGenerator(), (Object)"AccessionNumber");
        writer.writeNotNullOrDef("dcmMWLRequestedProcedureIDGenerator", (Object)arcAE.getMWLRequestedProcedureIDGenerator(), (Object)"RequestedProcedureID");
        writer.writeNotNullOrDef("dcmMWLScheduledProcedureStepIDGenerator", (Object)arcAE.getMWLScheduledProcedureStepIDGenerator(), (Object)"ScheduledProcedureStepID");
        writer.writeNotEmpty("dcmEncodeAsJSONNumber", (Object[])arcAE.getEncodeAsJSONNumber(), (Object[])new VR[0]);
        writer.writeNotNull("dcmPersonNameComponentOrderInsensitiveMatching", arcAE.getPersonNameComponentOrderInsensitiveMatching());
        writer.writeNotNull("dcmSendPendingCGet", arcAE.getSendPendingCGet());
        writer.writeNotNullOrDef("dcmSendPendingCMoveInterval", (Object)arcAE.getSendPendingCMoveInterval(), null);
        writer.writeNotNullOrDef("dcmWadoZIPEntryNameFormat", (Object)arcAE.getWadoZIPEntryNameFormat(), null);
        writer.writeNotNullOrDef("dcmWadoSR2HtmlTemplateURI", (Object)arcAE.getWadoSR2HtmlTemplateURI(), null);
        writer.writeNotNullOrDef("dcmWadoSR2TextTemplateURI", (Object)arcAE.getWadoSR2TextTemplateURI(), null);
        writer.writeNotNullOrDef("dcmWadoCDA2HtmlTemplateURI", (Object)arcAE.getWadoCDA2HtmlTemplateURI(), null);
        writer.writeNotNullOrDef("dcmWadoThumbnailViewport", (Object)arcAE.getWadoThumbnailViewPort(), null);
        writer.writeNotNullOrDef("dcmFallbackWadoURIWebAppName", (Object)arcAE.getFallbackWadoURIWebApplication(), null);
        writer.writeNotNull("dcmFallbackWadoURIHttpStatusCode", arcAE.getFallbackWadoURIHttpStatusCode());
        writer.writeNotNull("dcmWadoIgnorePresentationLUTShape", arcAE.getWadoIgnorePresentationLUTShape());
        writer.writeNotNull("dcmWadoMetadataExcludePrivate", arcAE.getWadoMetadataWithoutPrivate());
        writer.writeNotNull("dcmQueryMaxNumberOfResults", arcAE.getQueryMaxNumberOfResults());
        writer.writeNotNull("dcmQidoMaxNumberOfResults", arcAE.getQidoMaxNumberOfResults());
        writer.writeNotNull("dcmQidoETag", arcAE.getQidoETag());
        writer.writeNotEmpty("dcmFwdMppsDestination", (Object[])arcAE.getMppsForwardDestinations(), (Object[])new String[0]);
        writer.writeNotEmpty("dcmIanDestination", (Object[])arcAE.getIanDestinations(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmIanDelay", (Object)arcAE.getIanDelay(), null);
        writer.writeNotNullOrDef("dcmIanTimeout", (Object)arcAE.getIanTimeout(), null);
        writer.writeNotNull("dcmIanOnTimeout", arcAE.getIanOnTimeout());
        writer.writeNotNullOrDef("dcmSpanningCFindSCP", (Object)arcAE.getSpanningCFindSCP(), null);
        writer.writeNotEmpty("dcmSpanningCFindSCPRetrieveAET", (Object[])arcAE.getSpanningCFindSCPRetrieveAETitles(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmSpanningCFindSCPPolicy", (Object)arcAE.getSpanningCFindSCPPolicy(), null);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCP", (Object)arcAE.getFallbackCMoveSCP(), null);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCPDestination", (Object)arcAE.getFallbackCMoveSCPDestination(), null);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCPCallingAET", (Object)arcAE.getFallbackCMoveSCPCallingAET(), null);
        writer.writeNotNull("dcmFallbackCMoveSCPRetries", arcAE.getFallbackCMoveSCPRetries());
        writer.writeNotNullOrDef("dcmFallbackCMoveSCPLeadingCFindSCP", (Object)arcAE.getFallbackCMoveSCPLeadingCFindSCP(), null);
        writer.writeNotNullOrDef("dcmAltCMoveSCP", (Object)arcAE.getAlternativeCMoveSCP(), null);
        writer.writeNotNullOrDef("dcmFallbackCMoveSCPStudyOlderThan", (Object)arcAE.getFallbackCMoveSCPStudyOlderThan(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceURL", (Object)arcAE.getStorePermissionServiceURL(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceResponse", (Object)arcAE.getStorePermissionServiceResponse(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceResponsePattern", (Object)arcAE.getStorePermissionServiceResponsePattern(), null);
        writer.writeNotNullOrDef("dcmAllowRejectionForDataRetentionPolicyExpired", (Object)arcAE.getAllowRejectionForDataRetentionPolicyExpired(), null);
        writer.writeNotEmpty("dcmAcceptedUserRole", (Object[])arcAE.getAcceptedUserRoles(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmAcceptMissingPatientID", (Object)arcAE.getAcceptMissingPatientID(), null);
        writer.writeNotNullOrDef("dcmAllowDeleteStudyPermanently", (Object)arcAE.getAllowDeleteStudyPermanently(), null);
        writer.writeNotNullOrDef("dcmAllowDeletePatient", (Object)arcAE.getAllowDeletePatient(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceExpirationDatePattern", (Object)arcAE.getStorePermissionServiceExpirationDatePattern(), null);
        writer.writeNotNullOrDef("dcmDefaultCharacterSet", (Object)arcAE.getDefaultCharacterSet(), null);
        writer.writeNotNullOrDef("dcmMWLWorklistLabel", (Object)arcAE.getMWLWorklistLabel(), null);
        writer.writeNotNullOrDef("dcmUPSWorklistLabel", (Object)arcAE.getUPSWorklistLabel(), null);
        writer.writeNotEmpty("dcmUPSEventSCU", (Object[])arcAE.getUPSEventSCUs(), (Object[])new String[0]);
        writer.writeNotDef("dcmUPSEventSCUKeepAlive", arcAE.getUPSEventSCUKeepAlive(), 0);
        writer.writeNotNullOrDef("dcmStorePermissionServiceErrorCommentPattern", (Object)arcAE.getStorePermissionServiceErrorCommentPattern(), null);
        writer.writeNotNullOrDef("dcmStorePermissionServiceErrorCodePattern", (Object)arcAE.getStorePermissionServiceErrorCodePattern(), null);
        writer.writeNotEmpty("dcmReturnRetrieveAET", (Object[])arcAE.getReturnRetrieveAETitles(), (Object[])new String[0]);
        writer.writeNotEmpty("dcmMultipleStoreAssociations", (Object[])arcAE.getMultipleStoreAssociations(), (Object[])new MultipleStoreAssociations[0]);
        writer.writeNotNullOrDef("dcmExternalRetrieveAEDestination", (Object)arcAE.getExternalRetrieveAEDestination(), null);
        writer.writeNotEmpty("dcmAcceptedMoveDestination", (Object[])arcAE.getAcceptedMoveDestinations(), (Object[])new String[0]);
        writer.writeNotNull("dcmValidateCallingAEHostname", arcAE.getValidateCallingAEHostname());
        writer.writeNotNullOrDef("hl7PSUSendingApplication", (Object)arcAE.getHL7PSUSendingApplication(), null);
        writer.writeNotEmpty("hl7PSUReceivingApplication", (Object[])arcAE.getHL7PSUReceivingApplications(), (Object[])new String[0]);
        writer.writeNotNullOrDef("hl7PSUDelay", (Object)arcAE.getHL7PSUDelay(), null);
        writer.writeNotNullOrDef("hl7PSUTimeout", (Object)arcAE.getHL7PSUTimeout(), null);
        writer.writeNotNull("hl7PSUOnTimeout", arcAE.getHL7PSUOnTimeout());
        writer.writeNotNull("hl7PSUMWL", arcAE.getHL7PSUMWL());
        writer.writeNotNullOrDef("hl7PSUMWLMatchingKey", (Object)arcAE.getHL7PSUMWLMatchingKey(), null);
        writer.writeNotNull("hl7PSUForRequestedProcedure", arcAE.getHl7PSUForRequestedProcedure());
        writer.writeNotNull("hl7PSUPIDPV1", arcAE.getHl7PSUPIDPV1());
        writer.writeNotNullOrDef("hl7PSURequestedProcedureID", (Object)arcAE.getHl7PSURequestedProcedureID(), null);
        writer.writeNotNullOrDef("hl7PSUAccessionNumber", (Object)arcAE.getHl7PSUAccessionNumber(), null);
        writer.writeNotNullOrDef("hl7PSUFillerOrderNumber", (Object)arcAE.getHl7PSUFillerOrderNumber(), null);
        writer.writeNotNullOrDef("hl7PSUPlacerOrderNumber", (Object)arcAE.getHl7PSUPlacerOrderNumber(), null);
        writer.writeNotEmpty("hl7PSUTemplateParam", arcAE.getHL7PSUTemplateParams());
        writer.writeNotNullOrDef("dcmAcceptConflictingPatientID", (Object)arcAE.getAcceptConflictingPatientID(), null);
        writer.writeNotNullOrDef("hl7PSUMessageType", (Object)arcAE.getHl7PSUMessageType(), null);
        writer.writeNotEmpty("hl7PSUCondition", arcAE.getHl7PSUConditions().getMap());
        writer.writeNotNullOrDef("hl7PSUMppsTemplateURI", (Object)arcAE.getHl7PSUMppsTemplateURI(), null);
        writer.writeNotNullOrDef("hl7PSUStudyTemplateURI", (Object)arcAE.getHl7PSUStudyTemplateURI(), null);
        writer.writeNotNullOrDef("dcmCopyMoveUpdatePolicy", (Object)arcAE.getCopyMoveUpdatePolicy(), null);
        writer.writeNotNullOrDef("dcmLinkMWLEntryUpdatePolicy", (Object)arcAE.getLinkMWLEntryUpdatePolicy(), null);
        writer.writeNotNullOrDef("dcmStorageVerificationPolicy", (Object)arcAE.getStorageVerificationPolicy(), null);
        writer.writeNotNull("dcmStorageVerificationUpdateLocationStatus", arcAE.getStorageVerificationUpdateLocationStatus());
        writer.writeNotEmpty("dcmStorageVerificationStorageID", (Object[])arcAE.getStorageVerificationStorageIDs(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmStorageVerificationInitialDelay", (Object)arcAE.getStorageVerificationInitialDelay(), null);
        writer.writeNotNull("dcmUpdateLocationStatusOnRetrieve", arcAE.getUpdateLocationStatusOnRetrieve());
        writer.writeNotNull("dcmStorageVerificationOnRetrieve", arcAE.getStorageVerificationOnRetrieve());
        writer.writeNotEmpty("dcmRejectConflictingPatientAttribute", (Object[])TagUtils.toHexStrings((int[])arcAE.getRejectConflictingPatientAttribute()), (Object[])new String[0]);
        writer.writeNotNull("dcmRelationalQueryNegotiationLenient", arcAE.getRelationalQueryNegotiationLenient());
        writer.writeNotNull("dcmRelationalRetrieveNegotiationLenient", arcAE.getRelationalRetrieveNegotiationLenient());
        writer.writeNotNull("dcmStowRetiredTransferSyntax", arcAE.getStowRetiredTransferSyntax());
        writer.writeNotNull("dcmStowExcludeAPPMarkers", arcAE.getStowExcludeAPPMarkers());
        writer.writeNotNull("dcmRestrictRetrieveSilently", arcAE.getRestrictRetrieveSilently());
        writer.writeNotNull("dcmStowQuicktime2MP4", arcAE.getStowQuicktime2MP4());
        writer.writeNotNull("dcmStowMaxFragmentLength", arcAE.getStowMaxFragmentLength());
        writer.writeNotNull("dcmRetrieveTaskWarningOnNoMatch", arcAE.getRetrieveTaskWarningOnNoMatch());
        writer.writeNotNull("dcmRetrieveTaskWarningOnWarnings", arcAE.getRetrieveTaskWarningOnWarnings());
        writer.writeNotNullOrDef("dcmUserIdentityNegotiation", (Object)arcAE.getUserIdentityNegotiation(), null);
        writer.writeNotNullOrDef("dcmUserIdentityNegotiationRole", (Object)arcAE.getUserIdentityNegotiationRole(), null);
        writer.writeNotNullOrDef("dcmUserIdentityNegotiationKeycloakClientID", (Object)arcAE.getUserIdentityNegotiationKeycloakClientID(), null);
        writer.writeNotNullOrDef("dcmChangeRequesterAET", (Object)arcAE.getChangeRequesterAET(), null);
        writer.writeNotNull("dcmFilterByIssuerOfPatientID", arcAE.getFilterByIssuerOfPatientID());
        writer.writeNotNull("dcmMatchSOPClassOnInstanceLevel", arcAE.getMatchSOPClassOnInstanceLevel());
        writer.writeNotNull("dcmUPSUpdateWithoutTransactionUID", arcAE.getUPSUpdateWithoutTransactionUID());
        this.writeExportRule(writer, arcAE.getExportRules());
        this.writeExportPrefetchRules(writer, arcAE.getExportPriorsRules());
        this.writeMPPSForwardRule(writer, arcAE.getMPPSForwardRules());
        this.writeArchiveCompressionRules(writer, arcAE.getCompressionRules());
        this.writeStoreAccessControlIDRules(writer, arcAE.getStoreAccessControlIDRules());
        this.writeArchiveAttributeCoercion(writer, arcAE.getAttributeCoercions());
        this.writeArchiveAttributeCoercion2(writer, arcAE.getAttributeCoercions2());
        this.writeStudyRetentionPolicies(writer, arcAE.getStudyRetentionPolicies());
        JsonArchiveConfiguration.writeRSForwardRules(writer, arcAE.getRSForwardRules());
        JsonArchiveConfiguration.writeUPSOnStoreList(writer, arcAE.listUPSOnStore());
        JsonArchiveConfiguration.writeUPSOnUPSCompletedList(writer, arcAE.listUPSOnUPSCompleted());
        writer.writeEnd();
    }

    public boolean loadDeviceExtension(Device device, JsonReader reader, ConfigurationDelegate config) {
        if (!reader.getString().equals("dcmArchiveDevice")) {
            return false;
        }
        reader.next();
        reader.expect(JsonParser.Event.START_OBJECT);
        ArchiveDeviceExtension arcDev = new ArchiveDeviceExtension();
        this.loadFrom(arcDev, reader, config);
        device.addDeviceExtension((DeviceExtension)arcDev);
        reader.expect(JsonParser.Event.END_OBJECT);
        return true;
    }

    private void loadFrom(ArchiveDeviceExtension arcDev, JsonReader reader, ConfigurationDelegate config) {
        block568: while (reader.next() == JsonParser.Event.KEY_NAME) {
            switch (reader.getString()) {
                case "dcmFuzzyAlgorithmClass": {
                    arcDev.setFuzzyAlgorithmClass(reader.stringValue());
                    continue block568;
                }
                case "dcmBulkDataDescriptorID": {
                    arcDev.setBulkDataDescriptorID(reader.stringValue());
                    continue block568;
                }
                case "dcmSeriesMetadataStorageID": {
                    arcDev.setSeriesMetadataStorageIDs(reader.stringArray());
                    continue block568;
                }
                case "dcmSeriesMetadataDelay": {
                    arcDev.setSeriesMetadataDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmSeriesMetadataPollingInterval": {
                    arcDev.setSeriesMetadataPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmSeriesMetadataFetchSize": {
                    arcDev.setSeriesMetadataFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmSeriesMetadataThreads": {
                    arcDev.setSeriesMetadataThreads(reader.intValue());
                    continue block568;
                }
                case "dcmSeriesMetadataMaxRetries": {
                    arcDev.setSeriesMetadataMaxRetries(reader.intValue());
                    continue block568;
                }
                case "dcmSeriesMetadataRetryInterval": {
                    arcDev.setSeriesMetadataRetryInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPurgeInstanceRecords": {
                    arcDev.setPurgeInstanceRecords(reader.booleanValue());
                    continue block568;
                }
                case "dcmPurgeInstanceRecordsDelay": {
                    arcDev.setPurgeInstanceRecordsDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPurgeInstanceRecordsPollingInterval": {
                    arcDev.setPurgeInstanceRecordsPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPurgeInstanceRecordsFetchSize": {
                    arcDev.setPurgeInstanceRecordsFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmDeleteUPSPollingInterval": {
                    arcDev.setDeleteUPSPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmDeleteUPSFetchSize": {
                    arcDev.setDeleteUPSFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmDeleteUPSCompletedDelay": {
                    arcDev.setDeleteUPSCompletedDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmDeleteUPSCanceledDelay": {
                    arcDev.setDeleteUPSCanceledDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmOverwritePolicy": {
                    arcDev.setOverwritePolicy(OverwritePolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmRecordAttributeModification": {
                    arcDev.setRecordAttributeModification(reader.booleanValue());
                    continue block568;
                }
                case "dcmIdentifyPatientByAllAttributes": {
                    arcDev.setIdentifyPatientByAllAttributes(reader.booleanValue());
                    continue block568;
                }
                case "dcmBulkDataSpoolDirectory": {
                    arcDev.setBulkDataSpoolDirectory(reader.stringValue());
                    continue block568;
                }
                case "dcmHideSPSWithStatusFromMWL": {
                    arcDev.setHideSPSWithStatusFrom((SPSStatus[])reader.enumArray(SPSStatus.class));
                    continue block568;
                }
                case "dcmHideSPSWithStatusFromMWLRS": {
                    arcDev.setHideSPSWithStatusFromMWLRS((SPSStatus[])reader.enumArray(SPSStatus.class));
                    continue block568;
                }
                case "dcmEncodeAsJSONNumber": {
                    arcDev.setEncodeAsJSONNumber((VR[])reader.enumArray(VR.class));
                    continue block568;
                }
                case "hl7ORUAction": {
                    arcDev.setHl7ORUAction((HL7ORUAction[])reader.enumArray(HL7ORUAction.class));
                    continue block568;
                }
                case "dcmMWLAccessionNumberGenerator": {
                    arcDev.setMWLAccessionNumberGenerator(reader.stringValue());
                    continue block568;
                }
                case "dcmMWLRequestedProcedureIDGenerator": {
                    arcDev.setMWLRequestedProcedureIDGenerator(reader.stringValue());
                    continue block568;
                }
                case "dcmMWLScheduledProcedureStepIDGenerator": {
                    arcDev.setMWLScheduledProcedureStepIDGenerator(reader.stringValue());
                    continue block568;
                }
                case "dcmPersonNameComponentOrderInsensitiveMatching": {
                    arcDev.setPersonNameComponentOrderInsensitiveMatching(reader.booleanValue());
                    continue block568;
                }
                case "dcmSendPendingCGet": {
                    arcDev.setSendPendingCGet(reader.booleanValue());
                    continue block568;
                }
                case "dcmSendPendingCMoveInterval": {
                    arcDev.setSendPendingCMoveInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmWadoSupportedSRClasses": {
                    arcDev.setWadoSupportedSRClasses(reader.stringArray());
                    continue block568;
                }
                case "dcmWadoSupportedPRClasses": {
                    arcDev.setWadoSupportedPRClasses(reader.stringArray());
                    continue block568;
                }
                case "dcmWadoZIPEntryNameFormat": {
                    arcDev.setWadoZIPEntryNameFormat(reader.stringValue());
                    continue block568;
                }
                case "dcmWadoSR2HtmlTemplateURI": {
                    arcDev.setWadoSR2HtmlTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "dcmWadoSR2TextTemplateURI": {
                    arcDev.setWadoSR2TextTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "dcmWadoCDA2HtmlTemplateURI": {
                    arcDev.setWadoCDA2HtmlTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "dcmWadoSpoolDirectory": {
                    arcDev.setWadoSpoolDirectory(reader.stringValue());
                    continue block568;
                }
                case "dcmWadoThumbnailViewport": {
                    arcDev.setWadoThumbnailViewPort(reader.stringValue());
                    continue block568;
                }
                case "dcmFallbackWadoURIWebAppName": {
                    arcDev.setFallbackWadoURIWebApplication(reader.stringValue());
                    continue block568;
                }
                case "dcmFallbackWadoURIHttpStatusCode": {
                    arcDev.setFallbackWadoURIHttpStatusCode(reader.intValue());
                    continue block568;
                }
                case "dcmWadoIgnorePresentationLUTShape": {
                    arcDev.setWadoIgnorePresentationLUTShape(reader.booleanValue());
                    continue block568;
                }
                case "dcmWadoMetadataExcludePrivate": {
                    arcDev.setWadoMetadataWithoutPrivate(reader.booleanValue());
                    continue block568;
                }
                case "dcmQueryFetchSize": {
                    arcDev.setQueryFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmQueryMaxNumberOfResults": {
                    arcDev.setQueryMaxNumberOfResults(reader.intValue());
                    continue block568;
                }
                case "dcmQidoMaxNumberOfResults": {
                    arcDev.setQidoMaxNumberOfResults(reader.intValue());
                    continue block568;
                }
                case "dcmQidoETag": {
                    arcDev.setQidoETag(reader.booleanValue());
                    continue block568;
                }
                case "dcmFwdMppsDestination": {
                    arcDev.setMppsForwardDestinations(reader.stringArray());
                    continue block568;
                }
                case "dcmIanDestination": {
                    arcDev.setIanDestinations(reader.stringArray());
                    continue block568;
                }
                case "dcmIanDelay": {
                    arcDev.setIanDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmIanTimeout": {
                    arcDev.setIanTimeout(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmIanOnTimeout": {
                    arcDev.setIanOnTimeout(reader.booleanValue());
                    continue block568;
                }
                case "dcmIanTaskPollingInterval": {
                    arcDev.setIanTaskPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmIanTaskFetchSize": {
                    arcDev.setIanTaskFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmSpanningCFindSCP": {
                    arcDev.setSpanningCFindSCP(reader.stringValue());
                    continue block568;
                }
                case "dcmSpanningCFindSCPRetrieveAET": {
                    arcDev.setSpanningCFindSCPRetrieveAETitles(reader.stringArray());
                    continue block568;
                }
                case "dcmSpanningCFindSCPPolicy": {
                    arcDev.setSpanningCFindSCPPolicy(SpanningCFindSCPPolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmFallbackCMoveSCP": {
                    arcDev.setFallbackCMoveSCP(reader.stringValue());
                    continue block568;
                }
                case "dcmFallbackCMoveSCPDestination": {
                    arcDev.setFallbackCMoveSCPDestination(reader.stringValue());
                    continue block568;
                }
                case "dcmFallbackCMoveSCPCallingAET": {
                    arcDev.setFallbackCMoveSCPCallingAET(reader.stringValue());
                    continue block568;
                }
                case "dcmFallbackCMoveSCPRetries": {
                    arcDev.setFallbackCMoveSCPRetries(reader.intValue());
                    continue block568;
                }
                case "dcmFallbackCMoveSCPLeadingCFindSCP": {
                    arcDev.setFallbackCMoveSCPLeadingCFindSCP(reader.stringValue());
                    continue block568;
                }
                case "dcmAltCMoveSCP": {
                    arcDev.setAlternativeCMoveSCP(reader.stringValue());
                    continue block568;
                }
                case "dcmPurgeStoragePollingInterval": {
                    arcDev.setPurgeStoragePollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPurgeStorageFetchSize": {
                    arcDev.setPurgeStorageFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmFailedToDeletePollingInterval": {
                    arcDev.setFailedToDeletePollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmFailedToDeleteFetchSize": {
                    arcDev.setFailedToDeleteFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmDeleteStudyBatchSize": {
                    arcDev.setDeleteStudyBatchSize(reader.intValue());
                    continue block568;
                }
                case "dcmDeletePatientOnDeleteLastStudy": {
                    arcDev.setDeletePatientOnDeleteLastStudy(reader.booleanValue());
                    continue block568;
                }
                case "dcmDeleteRejectedPollingInterval": {
                    arcDev.setDeleteRejectedPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmDeleteRejectedFetchSize": {
                    arcDev.setDeleteRejectedFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmMaxAccessTimeStaleness": {
                    arcDev.setMaxAccessTimeStaleness(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmAECacheStaleTimeout": {
                    arcDev.setAECacheStaleTimeout(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmLeadingCFindSCPQueryCacheStaleTimeout": {
                    arcDev.setLeadingCFindSCPQueryCacheStaleTimeout(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmLeadingCFindSCPQueryCacheSize": {
                    arcDev.setLeadingCFindSCPQueryCacheSize(reader.intValue());
                    continue block568;
                }
                case "dcmAuditSpoolDirectory": {
                    arcDev.setAuditSpoolDirectory(reader.stringValue());
                    continue block568;
                }
                case "dcmAuditPollingInterval": {
                    arcDev.setAuditPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmAuditAggregateDuration": {
                    arcDev.setAuditAggregateDuration(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmStowSpoolDirectory": {
                    arcDev.setStowSpoolDirectory(reader.stringValue());
                    continue block568;
                }
                case "hl7PatientUpdateTemplateURI": {
                    arcDev.setPatientUpdateTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "hl7ImportReportTemplateURI": {
                    arcDev.setImportReportTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "hl7ImportReportTemplateParam": {
                    arcDev.setImportReportTemplateParams(reader.stringArray());
                    continue block568;
                }
                case "hl7ScheduleProcedureTemplateURI": {
                    arcDev.setScheduleProcedureTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "hl7OutgoingPatientUpdateTemplateURI": {
                    arcDev.setOutgoingPatientUpdateTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "hl7LogFilePattern": {
                    arcDev.setHL7LogFilePattern(reader.stringValue());
                    continue block568;
                }
                case "hl7ErrorLogFilePattern": {
                    arcDev.setHL7ErrorLogFilePattern(reader.stringValue());
                    continue block568;
                }
                case "dcmUnzipVendorDataToURI": {
                    arcDev.setUnzipVendorDataToURI(reader.stringValue());
                    continue block568;
                }
                case "dcmPurgeQueueMessagePollingInterval": {
                    arcDev.setPurgeTaskPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmRejectExpiredStudiesPollingInterval": {
                    arcDev.setRejectExpiredStudiesPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmRejectExpiredStudiesSchedule": {
                    arcDev.setRejectExpiredStudiesSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                    continue block568;
                }
                case "dcmRejectExpiredStudiesFetchSize": {
                    arcDev.setRejectExpiredStudiesFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmRejectExpiredSeriesFetchSize": {
                    arcDev.setRejectExpiredSeriesFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmRejectExpiredStudiesAETitle": {
                    arcDev.setRejectExpiredStudiesAETitle(reader.stringValue());
                    continue block568;
                }
                case "dcmFallbackCMoveSCPStudyOlderThan": {
                    arcDev.setFallbackCMoveSCPStudyOlderThan(reader.stringValue());
                    continue block568;
                }
                case "dcmStorePermissionServiceURL": {
                    arcDev.setStorePermissionServiceURL(reader.stringValue());
                    continue block568;
                }
                case "dcmStorePermissionServiceResponse": {
                    arcDev.setStorePermissionServiceResponse(reader.stringValue());
                    continue block568;
                }
                case "dcmStorePermissionServiceResponsePattern": {
                    arcDev.setStorePermissionServiceResponsePattern(Pattern.compile(reader.stringValue()));
                    continue block568;
                }
                case "dcmStorePermissionCacheStaleTimeout": {
                    arcDev.setStorePermissionCacheStaleTimeout(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmStorePermissionCacheSize": {
                    arcDev.setStorePermissionCacheSize(reader.intValue());
                    continue block568;
                }
                case "dcmMergeMWLCacheStaleTimeout": {
                    arcDev.setMergeMWLCacheStaleTimeout(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmMergeMWLCacheSize": {
                    arcDev.setMergeMWLCacheSize(reader.intValue());
                    continue block568;
                }
                case "dcmStoreUpdateDBMaxRetries": {
                    arcDev.setStoreUpdateDBMaxRetries(reader.intValue());
                    continue block568;
                }
                case "dcmStoreUpdateDBMinRetryDelay": {
                    arcDev.setStoreUpdateDBMinRetryDelay(reader.intValue());
                    continue block568;
                }
                case "dcmStoreUpdateDBMaxRetryDelay": {
                    arcDev.setStoreUpdateDBMaxRetryDelay(reader.intValue());
                    continue block568;
                }
                case "dcmAllowRejectionForDataRetentionPolicyExpired": {
                    arcDev.setAllowRejectionForDataRetentionPolicyExpired(AllowRejectionForDataRetentionPolicyExpired.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmAcceptMissingPatientID": {
                    arcDev.setAcceptMissingPatientID(AcceptMissingPatientID.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmAllowDeleteStudyPermanently": {
                    arcDev.setAllowDeleteStudyPermanently(AllowDeleteStudyPermanently.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmAllowDeletePatient": {
                    arcDev.setAllowDeletePatient(AllowDeletePatient.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmStorePermissionServiceExpirationDatePattern": {
                    arcDev.setStorePermissionServiceExpirationDatePattern(Pattern.compile(reader.stringValue()));
                    continue block568;
                }
                case "dcmShowPatientInfoInSystemLog": {
                    arcDev.setShowPatientInfoInSystemLog(ShowPatientInfo.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmShowPatientInfoInAuditLog": {
                    arcDev.setShowPatientInfoInAuditLog(ShowPatientInfo.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPurgeStgCmtCompletedDelay": {
                    arcDev.setPurgeStgCmtCompletedDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPurgeStgCmtPollingInterval": {
                    arcDev.setPurgeStgCmtPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmDefaultCharacterSet": {
                    arcDev.setDefaultCharacterSet(reader.stringValue());
                    continue block568;
                }
                case "dcmCharsetNameMapping": {
                    arcDev.setDicomCharsetNameMappings(reader.stringArray());
                    continue block568;
                }
                case "hl7CharsetNameMapping": {
                    arcDev.setHL7CharsetNameMappings(reader.stringArray());
                    continue block568;
                }
                case "dcmUPSEventWebSocketQueueSize": {
                    arcDev.setUPSEventWebSocketQueueSizes(reader.stringArray());
                    continue block568;
                }
                case "dcmUPSWorklistLabel": {
                    arcDev.setUPSWorklistLabel(reader.stringValue());
                    continue block568;
                }
                case "dcmUPSEventSCU": {
                    arcDev.setUPSEventSCUs(reader.stringArray());
                    continue block568;
                }
                case "dcmUPSEventSCUKeepAlive": {
                    arcDev.setUPSEventSCUKeepAlive(reader.intValue());
                    continue block568;
                }
                case "dcmStorePermissionServiceErrorCommentPattern": {
                    arcDev.setStorePermissionServiceErrorCommentPattern(Pattern.compile(reader.stringValue()));
                    continue block568;
                }
                case "dcmStorePermissionServiceErrorCodePattern": {
                    arcDev.setStorePermissionServiceErrorCodePattern(Pattern.compile(reader.stringValue()));
                    continue block568;
                }
                case "dcmRetrieveAET": {
                    arcDev.setRetrieveAETitles(reader.stringArray());
                    continue block568;
                }
                case "dcmReturnRetrieveAET": {
                    arcDev.setReturnRetrieveAETitles(reader.stringArray());
                    continue block568;
                }
                case "dcmMultipleStoreAssociations": {
                    arcDev.setMultipleStoreAssociations(reader.stringArray());
                    continue block568;
                }
                case "dcmExternalRetrieveAEDestination": {
                    arcDev.setExternalRetrieveAEDestination(reader.stringValue());
                    continue block568;
                }
                case "dcmXDSiImagingDocumentSourceAETitle": {
                    arcDev.setXDSiImagingDocumentSourceAETitle(reader.stringValue());
                    continue block568;
                }
                case "dcmRemapRetrieveURL": {
                    arcDev.setRemapRetrieveURL(reader.stringValue());
                    continue block568;
                }
                case "dcmValidateCallingAEHostname": {
                    arcDev.setValidateCallingAEHostname(reader.booleanValue());
                    continue block568;
                }
                case "hl7PSUSendingApplication": {
                    arcDev.setHL7PSUSendingApplication(reader.stringValue());
                    continue block568;
                }
                case "hl7PSUReceivingApplication": {
                    arcDev.setHL7PSUReceivingApplications(reader.stringArray());
                    continue block568;
                }
                case "hl7PSUDelay": {
                    arcDev.setHL7PSUDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7PSUTimeout": {
                    arcDev.setHL7PSUTimeout(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7PSUOnTimeout": {
                    arcDev.setHL7PSUOnTimeout(reader.booleanValue());
                    continue block568;
                }
                case "hl7PSUTaskPollingInterval": {
                    arcDev.setHL7PSUTaskPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7PSUTaskFetchSize": {
                    arcDev.setHL7PSUTaskFetchSize(reader.intValue());
                    continue block568;
                }
                case "hl7PSUMWL": {
                    arcDev.setHL7PSUMWL(reader.booleanValue());
                    continue block568;
                }
                case "hl7PSUMWLMatchingKey": {
                    arcDev.setHL7PSUMWLMatchingKey(HL7PSUMWLMatchingKey.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7PSUForRequestedProcedure": {
                    arcDev.setHl7PSUForRequestedProcedure(reader.booleanValue());
                    continue block568;
                }
                case "hl7PSUPIDPV1": {
                    arcDev.setHl7PSUPIDPV1(reader.booleanValue());
                    continue block568;
                }
                case "hl7PSURequestedProcedureID": {
                    arcDev.setHl7PSURequestedProcedureID(reader.stringValue());
                    continue block568;
                }
                case "hl7PSUAccessionNumber": {
                    arcDev.setHl7PSUAccessionNumber(reader.stringValue());
                    continue block568;
                }
                case "hl7PSUFillerOrderNumber": {
                    arcDev.setHl7PSUFillerOrderNumber(reader.stringValue());
                    continue block568;
                }
                case "hl7PSUPlacerOrderNumber": {
                    arcDev.setHl7PSUPlacerOrderNumber(reader.stringValue());
                    continue block568;
                }
                case "hl7PSUTemplateParam": {
                    arcDev.setHL7PSUTemplateParams(reader.stringArray());
                    continue block568;
                }
                case "hl7PSUMessageType": {
                    arcDev.setHl7PSUMessageType(HL7PSUMessageType.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7PSUCondition": {
                    arcDev.setHl7PSUConditions(new Conditions(reader.stringArray()));
                    continue block568;
                }
                case "hl7PSUMppsTemplateURI": {
                    arcDev.setHl7PSUMppsTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "hl7PSUStudyTemplateURI": {
                    arcDev.setHl7PSUStudyTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "dcmAcceptConflictingPatientID": {
                    arcDev.setAcceptConflictingPatientID(AcceptConflictingPatientID.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmProxyUpstreamURL": {
                    arcDev.setProxyUpstreamURL(reader.stringValue());
                    continue block568;
                }
                case "dcmAudit2JsonFhirTemplateURI": {
                    arcDev.setAudit2JsonFhirTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "dcmAudit2XmlFhirTemplateURI": {
                    arcDev.setAudit2XmlFhirTemplateURI(reader.stringValue());
                    continue block568;
                }
                case "dcmCopyMoveUpdatePolicy": {
                    arcDev.setCopyMoveUpdatePolicy(Attributes.UpdatePolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmLinkMWLEntryUpdatePolicy": {
                    arcDev.setLinkMWLEntryUpdatePolicy(Attributes.UpdatePolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmStorageVerificationPolicy": {
                    arcDev.setStorageVerificationPolicy(StorageVerificationPolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmStorageVerificationUpdateLocationStatus": {
                    arcDev.setStorageVerificationUpdateLocationStatus(reader.booleanValue());
                    continue block568;
                }
                case "dcmStorageVerificationStorageID": {
                    arcDev.setStorageVerificationStorageIDs(reader.stringArray());
                    continue block568;
                }
                case "dcmStorageVerificationAETitle": {
                    arcDev.setStorageVerificationAETitle(reader.stringValue());
                    continue block568;
                }
                case "dcmStorageVerificationBatchID": {
                    arcDev.setStorageVerificationBatchID(reader.stringValue());
                    continue block568;
                }
                case "dcmStorageVerificationInitialDelay": {
                    arcDev.setStorageVerificationInitialDelay(Period.parse(reader.stringValue()));
                    continue block568;
                }
                case "dcmStorageVerificationPeriod": {
                    arcDev.setStorageVerificationPeriod(Period.parse(reader.stringValue()));
                    continue block568;
                }
                case "dcmStorageVerificationMaxScheduled": {
                    arcDev.setStorageVerificationMaxScheduled(reader.intValue());
                    continue block568;
                }
                case "dcmStorageVerificationPollingInterval": {
                    arcDev.setStorageVerificationPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmStorageVerificationSchedule": {
                    arcDev.setStorageVerificationSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                    continue block568;
                }
                case "dcmStorageVerificationFetchSize": {
                    arcDev.setStorageVerificationFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmUpdateLocationStatusOnRetrieve": {
                    arcDev.setUpdateLocationStatusOnRetrieve(reader.booleanValue());
                    continue block568;
                }
                case "dcmStorageVerificationOnRetrieve": {
                    arcDev.setStorageVerificationOnRetrieve(reader.booleanValue());
                    continue block568;
                }
                case "hl7TrackChangedPatientID": {
                    arcDev.setHL7TrackChangedPatientID(reader.booleanValue());
                    continue block568;
                }
                case "hl7ADTSendingApplication": {
                    arcDev.setHL7ADTSendingApplication(reader.stringValue());
                    continue block568;
                }
                case "hl7ADTReceivingApplication": {
                    arcDev.setHL7ADTReceivingApplication(reader.stringArray());
                    continue block568;
                }
                case "hl7ScheduledProtocolCodeInOrder": {
                    arcDev.setHL7ScheduledProtocolCodeInOrder(ScheduledProtocolCodeInOrder.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7ScheduledStationAETInOrder": {
                    arcDev.setHL7ScheduledStationAETInOrder(ScheduledStationAETInOrder.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7NoPatientCreateMessageType": {
                    arcDev.setHL7NoPatientCreateMessageTypes(reader.stringArray());
                    continue block568;
                }
                case "dcmAuditUnknownStudyInstanceUID": {
                    arcDev.setAuditUnknownStudyInstanceUID(reader.stringValue());
                    continue block568;
                }
                case "dcmAuditUnknownPatientID": {
                    arcDev.setAuditUnknownPatientID(reader.stringValue());
                    continue block568;
                }
                case "dcmAuditSoftwareConfigurationVerbose": {
                    arcDev.setAuditSoftwareConfigurationVerbose(reader.booleanValue());
                    continue block568;
                }
                case "hl7UseNullValue": {
                    arcDev.setHL7UseNullValue(reader.booleanValue());
                    continue block568;
                }
                case "dcmQueueTasksFetchSize": {
                    arcDev.setQueueTasksFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmRejectionNoteStorageAET": {
                    arcDev.setRejectionNoteStorageAET(reader.stringValue());
                    continue block568;
                }
                case "dcmXRoadProperty": {
                    arcDev.setXRoadProperties(reader.stringArray());
                    continue block568;
                }
                case "dcmImpaxReportProperty": {
                    arcDev.setImpaxReportProperties(reader.stringArray());
                    continue block568;
                }
                case "dcmUIConfigurationDeviceName": {
                    arcDev.setUiConfigurationDeviceName(reader.stringValue());
                    continue block568;
                }
                case "dcmCompressionAETitle": {
                    arcDev.setCompressionAETitle(reader.stringValue());
                    continue block568;
                }
                case "dcmCompressionPollingInterval": {
                    arcDev.setCompressionPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmCompressionFetchSize": {
                    arcDev.setCompressionFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmCompressionSchedule": {
                    arcDev.setCompressionSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                    continue block568;
                }
                case "dcmCompressionThreads": {
                    arcDev.setCompressionThreads(reader.intValue());
                    continue block568;
                }
                case "dcmDiffTaskProgressUpdateInterval": {
                    arcDev.setDiffTaskProgressUpdateInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPatientVerificationPDQServiceID": {
                    arcDev.setPatientVerificationPDQServiceID(reader.stringValue());
                    continue block568;
                }
                case "dcmPatientVerificationPollingInterval": {
                    arcDev.setPatientVerificationPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPatientVerificationFetchSize": {
                    arcDev.setPatientVerificationFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmPatientVerificationAdjustIssuerOfPatientID": {
                    arcDev.setPatientVerificationAdjustIssuerOfPatientID(reader.booleanValue());
                    continue block568;
                }
                case "dcmPatientVerificationPeriod": {
                    arcDev.setPatientVerificationPeriod(Period.parse(reader.stringValue()));
                    continue block568;
                }
                case "dcmPatientVerificationPeriodOnNotFound": {
                    arcDev.setPatientVerificationPeriodOnNotFound(Period.parse(reader.stringValue()));
                    continue block568;
                }
                case "dcmPatientVerificationRetryInterval": {
                    arcDev.setPatientVerificationRetryInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmPatientVerificationMaxRetries": {
                    arcDev.setPatientVerificationMaxRetries(reader.intValue());
                    continue block568;
                }
                case "dcmPatientVerificationMaxStaleness": {
                    arcDev.setPatientVerificationMaxStaleness(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmCSVUploadChunkSize": {
                    arcDev.setCSVUploadChunkSize(reader.intValue());
                    continue block568;
                }
                case "dcmValidateUID": {
                    arcDev.setValidateUID(reader.booleanValue());
                    continue block568;
                }
                case "dcmRelationalQueryNegotiationLenient": {
                    arcDev.setRelationalQueryNegotiationLenient(reader.booleanValue());
                    continue block568;
                }
                case "dcmRelationalRetrieveNegotiationLenient": {
                    arcDev.setRelationalRetrieveNegotiationLenient(reader.booleanValue());
                    continue block568;
                }
                case "dcmSchedulerMinStartDelay": {
                    arcDev.setSchedulerMinStartDelay(reader.intValue());
                    continue block568;
                }
                case "hl7OrderMissingStudyIUIDPolicy": {
                    arcDev.setHl7OrderMissingStudyIUIDPolicy(HL7OrderMissingStudyIUIDPolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7OrderMissingAdmissionIDPolicy": {
                    arcDev.setHl7OrderMissingAdmissionIDPolicy(HL7OrderMissingAdmissionIDPolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7ImportReportMissingStudyIUIDPolicy": {
                    arcDev.setHl7ImportReportMissingStudyIUIDPolicy(HL7ImportReportMissingStudyIUIDPolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7ImportReportMissingAdmissionIDPolicy": {
                    arcDev.setHl7ImportReportMissingAdmissionIDPolicy(HL7ImportReportMissingAdmissionIDPolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7ImportReportMissingStudyIUIDCFindSCP": {
                    arcDev.setHl7ImportReportMissingStudyIUIDCFindSCP(reader.stringValue());
                    continue block568;
                }
                case "hl7ImportReportAdjustIUID": {
                    arcDev.setHl7ImportReportAdjustIUID(HL7ImportReportAdjustIUID.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "hl7DicomCharacterSet": {
                    arcDev.setHl7DicomCharacterSet(reader.stringValue());
                    continue block568;
                }
                case "hl7VeterinaryUsePatientName": {
                    arcDev.setHl7VeterinaryUsePatientName(reader.booleanValue());
                    continue block568;
                }
                case "dcmRejectConflictingPatientAttribute": {
                    arcDev.setRejectConflictingPatientAttribute(TagUtils.fromHexStrings((String[])reader.stringArray()));
                    continue block568;
                }
                case "dcmStowRetiredTransferSyntax": {
                    arcDev.setStowRetiredTransferSyntax(reader.booleanValue());
                    continue block568;
                }
                case "dcmStowExcludeAPPMarkers": {
                    arcDev.setStowExcludeAPPMarkers(reader.booleanValue());
                    continue block568;
                }
                case "dcmRestrictRetrieveSilently": {
                    arcDev.setRestrictRetrieveSilently(reader.booleanValue());
                    continue block568;
                }
                case "dcmStowQuicktime2MP4": {
                    arcDev.setStowQuicktime2MP4(reader.booleanValue());
                    continue block568;
                }
                case "dcmStowMaxFragmentLength": {
                    arcDev.setStowMaxFragmentLength(reader.longValue());
                    continue block568;
                }
                case "dcmMWLPollingInterval": {
                    arcDev.setMWLPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmMWLFetchSize": {
                    arcDev.setMWLFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmMWLImportInterval": {
                    arcDev.setMWLImportInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmDeleteMWLDelay": {
                    arcDev.setDeleteMWLDelay(reader.stringArray());
                    continue block568;
                }
                case "dcmUPSProcessingPollingInterval": {
                    arcDev.setUPSProcessingPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmUPSProcessingFetchSize": {
                    arcDev.setUPSProcessingFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmTaskPollingInterval": {
                    arcDev.setTaskPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmTaskFetchSize": {
                    arcDev.setTaskFetchSize(reader.intValue());
                    continue block568;
                }
                case "hl7ReferredMergedPatientPolicy": {
                    arcDev.setHl7ReferredMergedPatientPolicy(HL7ReferredMergedPatientPolicy.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmRetrieveTaskWarningOnNoMatch": {
                    arcDev.setRetrieveTaskWarningOnNoMatch(reader.booleanValue());
                    continue block568;
                }
                case "dcmRetrieveTaskWarningOnWarnings": {
                    arcDev.setRetrieveTaskWarningOnWarnings(reader.booleanValue());
                    continue block568;
                }
                case "dcmCStoreSCUOfCMoveSCP": {
                    arcDev.setCStoreSCUOfCMoveSCPs(reader.stringArray());
                    continue block568;
                }
                case "dcmDeleteStudyChunkSize": {
                    arcDev.setDeleteStudyChunkSize(reader.intValue());
                    continue block568;
                }
                case "hl7PatientArrivalMessageType": {
                    arcDev.setHL7PatientArrivalMessageType(reader.stringValue());
                    continue block568;
                }
                case "dcmUserIdentityNegotiation": {
                    arcDev.setUserIdentityNegotiation(UserIdentityNegotiation.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmUserIdentityNegotiationRole": {
                    arcDev.setUserIdentityNegotiationRole(reader.stringValue());
                    continue block568;
                }
                case "dcmUserIdentityNegotiationKeycloakClientID": {
                    arcDev.setUserIdentityNegotiationKeycloakClientID(reader.stringValue());
                    continue block568;
                }
                case "dcmCalculateStudySizeDelay": {
                    arcDev.setStudySizeDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmCalculateStudySizePollingInterval": {
                    arcDev.setCalculateStudySizePollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmCalculateStudySizeFetchSize": {
                    arcDev.setCalculateStudySizeFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmCalculateQueryAttributes": {
                    arcDev.setCalculateQueryAttributes(reader.booleanValue());
                    continue block568;
                }
                case "dcmStoreImplementationVersionName": {
                    arcDev.setStoreImplementationVersionName(reader.booleanValue());
                    continue block568;
                }
                case "dcmSupplementIssuerFetchSize": {
                    arcDev.setSupplementIssuerFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmUpdateCharsetFetchSize": {
                    arcDev.setUpdateCharsetFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmAuditAssigningAuthorityOfPatientID": {
                    arcDev.setAuditAssigningAuthorityOfPatientID(JsonArchiveConfiguration.toIssuer(reader.stringValue()));
                    continue block568;
                }
                case "dcmChangeRequesterAET": {
                    arcDev.setChangeRequesterAET(reader.stringValue());
                    continue block568;
                }
                case "dcmFilterByIssuerOfPatientID": {
                    arcDev.setFilterByIssuerOfPatientID(reader.booleanValue());
                    continue block568;
                }
                case "dcmAuditHL7MsgLimit": {
                    arcDev.setAuditHL7MsgLimit(reader.intValue());
                    continue block568;
                }
                case "dcmMatchSOPClassOnInstanceLevel": {
                    arcDev.setMatchSOPClassOnInstanceLevel(reader.booleanValue());
                    continue block568;
                }
                case "dcmUPSUpdateWithoutTransactionUID": {
                    arcDev.setUPSUpdateWithoutTransactionUID(reader.booleanValue());
                    continue block568;
                }
                case "dcmKeyValueRetentionPollingInterval": {
                    arcDev.setKeyValueRetentionPollingInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmKeyValueRetentionFetchSize": {
                    arcDev.setKeyValueRetentionFetchSize(reader.intValue());
                    continue block568;
                }
                case "dcmKeyValueRetentionPeriod": {
                    arcDev.setKeyValueRetentionPeriod(Duration.valueOf((String)reader.stringValue()));
                    continue block568;
                }
                case "dcmAttributeFilter": {
                    this.loadAttributeFilterListFrom(arcDev, reader);
                    continue block568;
                }
                case "dcmStorage": {
                    this.loadStorageDescriptorFrom(arcDev, reader);
                    continue block568;
                }
                case "dcmQueryRetrieveView": {
                    this.loadQueryRetrieveViewFrom(arcDev, reader);
                    continue block568;
                }
                case "dcmQueue": {
                    this.loadQueueDescriptorFrom(arcDev, reader);
                    continue block568;
                }
                case "dcmPDQService": {
                    this.loadPDQServiceDescriptorFrom(arcDev, reader);
                    continue block568;
                }
                case "dcmExporter": {
                    this.loadExporterDescriptorFrom(arcDev, reader);
                    continue block568;
                }
                case "dcmExportRule": {
                    this.loadExportRule(arcDev.getExportRules(), reader);
                    continue block568;
                }
                case "dcmExportPriorsRule": {
                    this.loadExportPriorsRules(arcDev.getExportPriorsRules(), reader);
                    continue block568;
                }
                case "dcmMPPSForwardRule": {
                    this.loadMPPSForwardRule(arcDev.getMPPSForwardRules(), reader);
                    continue block568;
                }
                case "dcmArchiveCompressionRule": {
                    this.loadArchiveCompressionRule(arcDev.getCompressionRules(), reader);
                    continue block568;
                }
                case "dcmStoreAccessControlIDRule": {
                    this.loadStoreAccessControlIDRule(arcDev.getStoreAccessControlIDRules(), reader);
                    continue block568;
                }
                case "dcmArchiveAttributeCoercion": {
                    this.loadArchiveAttributeCoercion(arcDev.getAttributeCoercions(), reader, config);
                    continue block568;
                }
                case "dcmArchiveAttributeCoercion2": {
                    this.loadArchiveAttributeCoercion2(arcDev.getAttributeCoercions2(), reader, config);
                    continue block568;
                }
                case "dcmRejectionNote": {
                    this.loadRejectionNoteFrom(arcDev, reader);
                    continue block568;
                }
                case "dcmStudyRetentionPolicy": {
                    this.loadStudyRetentionPolicy(arcDev.getStudyRetentionPolicies(), reader);
                    continue block568;
                }
                case "dcmIDGenerator": {
                    this.loadIDGenerators(arcDev, reader);
                    continue block568;
                }
                case "hl7ForwardRule": {
                    JsonArchiveConfiguration.loadHL7ForwardRules(arcDev.getHL7ForwardRules(), reader);
                    continue block568;
                }
                case "hl7ExportRule": {
                    JsonArchiveConfiguration.loadHL7ExportRules(arcDev.getHL7ExportRules(), reader);
                    continue block568;
                }
                case "hl7PrefetchRule": {
                    JsonArchiveConfiguration.loadHL7PrefetchRules(arcDev.getHL7PrefetchRules(), reader);
                    continue block568;
                }
                case "hl7StudyRetentionPolicy": {
                    JsonArchiveConfiguration.loadHL7StudyRetentionPolicy(arcDev.getHL7StudyRetentionPolicies(), reader);
                    continue block568;
                }
                case "dcmRSForwardRule": {
                    JsonArchiveConfiguration.loadRSForwardRules(arcDev.getRSForwardRules(), reader);
                    continue block568;
                }
                case "dcmAttributeSet": {
                    this.loadAttributeSetFrom(arcDev, reader);
                    continue block568;
                }
                case "dcmBulkDataDescriptor": {
                    this.config.loadBulkdataDescriptors(arcDev.getBulkDataDescriptors(), reader);
                    continue block568;
                }
                case "hl7OrderScheduledStation": {
                    JsonArchiveConfiguration.loadScheduledStations(arcDev.getHL7OrderScheduledStations(), reader, config);
                    continue block568;
                }
                case "hl7OrderSPSStatus": {
                    JsonArchiveConfiguration.loadHL7OrderSPSStatus(arcDev.getHL7OrderSPSStatuses(), reader);
                    continue block568;
                }
                case "dcmMetrics": {
                    JsonArchiveConfiguration.loadMetricsDescriptors(arcDev, reader);
                    continue block568;
                }
                case "dcmUPSOnStore": {
                    this.loadUPSOnStoreList(arcDev.listUPSOnStore(), reader);
                    continue block568;
                }
                case "dcmUPSProcessingRule": {
                    this.loadUPSProcessingRules(arcDev, reader);
                    continue block568;
                }
                case "hl7UPSOnHL7": {
                    JsonArchiveConfiguration.loadUPSOnHL7List(arcDev.listUPSOnHL7(), reader);
                    continue block568;
                }
                case "dcmUPSOnUPSCompleted": {
                    this.loadUPSOnUPSCompletedList(arcDev.listUPSOnUPSCompleted(), reader);
                    continue block568;
                }
                case "dcmMWLIdleTimeout": {
                    this.loadMWLIdleTimeout(arcDev.getMWLIdleTimeouts(), reader);
                    continue block568;
                }
                case "dcmMWLImport": {
                    this.loadMWLImport(arcDev.getMWLImports(), reader);
                    continue block568;
                }
            }
            reader.skipUnknownProperty();
        }
    }

    private void loadAttributeFilterListFrom(ArchiveDeviceExtension arcDev, JsonReader reader) {
        Entity entity = null;
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            AttributeFilter af = new AttributeFilter();
            block17: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmEntity": {
                        entity = Entity.valueOf((String)reader.stringValue());
                        continue block17;
                    }
                    case "dcmTag": {
                        af.setSelection(TagUtils.fromHexStrings((String[])reader.stringArray()));
                        continue block17;
                    }
                    case "dcmCustomAttribute1": {
                        af.setCustomAttribute1(ValueSelector.valueOf((String)reader.stringValue()));
                        continue block17;
                    }
                    case "dcmCustomAttribute2": {
                        af.setCustomAttribute2(ValueSelector.valueOf((String)reader.stringValue()));
                        continue block17;
                    }
                    case "dcmCustomAttribute3": {
                        af.setCustomAttribute3(ValueSelector.valueOf((String)reader.stringValue()));
                        continue block17;
                    }
                    case "dcmAttributeUpdatePolicy": {
                        af.setAttributeUpdatePolicy(Attributes.UpdatePolicy.valueOf((String)reader.stringValue()));
                        continue block17;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.setAttributeFilter(entity, af);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadAttributeSetFrom(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            AttributeSet attributeSet = new AttributeSet();
            block21: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmAttributeSetType": {
                        attributeSet.setType(AttributeSet.Type.valueOf((String)reader.stringValue()));
                        continue block21;
                    }
                    case "dcmAttributeSetID": {
                        attributeSet.setID(reader.stringValue());
                        continue block21;
                    }
                    case "dicomDescription": {
                        attributeSet.setDescription(reader.stringValue());
                        continue block21;
                    }
                    case "dcmAttributeSetNumber": {
                        attributeSet.setNumber(reader.intValue());
                        continue block21;
                    }
                    case "dicomInstalled": {
                        attributeSet.setInstalled(reader.booleanValue());
                        continue block21;
                    }
                    case "dcmAttributeSetTitle": {
                        attributeSet.setTitle(reader.stringValue());
                        continue block21;
                    }
                    case "dcmTag": {
                        attributeSet.setSelection(TagUtils.fromHexStrings((String[])reader.stringArray()));
                        continue block21;
                    }
                    case "dcmProperty": {
                        attributeSet.setProperties(reader.stringArray());
                        continue block21;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addAttributeSet(attributeSet);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadStorageDescriptorFrom(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            StorageDescriptor st = new StorageDescriptor();
            block53: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmStorageID": {
                        st.setStorageID(reader.stringValue());
                        continue block53;
                    }
                    case "dcmURI": {
                        st.setStorageURIStr(reader.stringValue());
                        continue block53;
                    }
                    case "dcmDigestAlgorithm": {
                        st.setDigestAlgorithm(reader.stringValue());
                        continue block53;
                    }
                    case "dcmInstanceAvailability": {
                        st.setInstanceAvailability(Availability.valueOf((String)reader.stringValue()));
                        continue block53;
                    }
                    case "dcmStorageDuration": {
                        st.setStorageDuration(StorageDuration.valueOf((String)reader.stringValue()));
                        continue block53;
                    }
                    case "dcmReadOnly": {
                        st.setReadOnly(reader.booleanValue());
                        continue block53;
                    }
                    case "dcmNoDeletionConstraint": {
                        st.setNoDeletionConstraint(reader.booleanValue());
                        continue block53;
                    }
                    case "dcmStorageThresholdExceedsPermanently": {
                        st.setStorageThresholdExceedsPermanently(reader.booleanValue());
                        continue block53;
                    }
                    case "dcmStorageThresholdExceeded": {
                        st.setStorageThresholdExceeded(reader.dateTimeValue());
                        continue block53;
                    }
                    case "dcmDeleterThreads": {
                        st.setDeleterThreads(reader.intValue());
                        continue block53;
                    }
                    case "dcmStorageClusterID": {
                        st.setStorageClusterID(reader.stringValue());
                        continue block53;
                    }
                    case "dcmStorageThreshold": {
                        st.setStorageThreshold(StorageThreshold.valueOf((String)reader.stringValue()));
                        continue block53;
                    }
                    case "dcmDeleterThreshold": {
                        st.setDeleterThresholdsFromStrings(reader.stringArray());
                        continue block53;
                    }
                    case "dcmProperty": {
                        st.setProperties(reader.stringArray());
                        continue block53;
                    }
                    case "dcmExternalRetrieveAET": {
                        st.setExternalRetrieveAETitles(reader.stringArray());
                        continue block53;
                    }
                    case "dcmExternalRetrieveInstanceAvailability": {
                        st.setExternalRetrieveInstanceAvailability(Availability.valueOf((String)reader.stringValue()));
                        continue block53;
                    }
                    case "dcmExportStorageID": {
                        st.setExportStorageID(reader.stringArray());
                        continue block53;
                    }
                    case "dcmRetrieveCacheStorageID": {
                        st.setRetrieveCacheStorageID(reader.stringValue());
                        continue block53;
                    }
                    case "dcmRetrieveCacheMaxParallel": {
                        st.setRetrieveCacheMaxParallel(reader.intValue());
                        continue block53;
                    }
                    case "dcmDeleteStudiesOlderThan": {
                        st.setRetentionPeriods(RetentionPeriod.DeleteStudies.OlderThan, reader.stringArray());
                        continue block53;
                    }
                    case "dcmDeleteStudiesReceivedBefore": {
                        st.setRetentionPeriods(RetentionPeriod.DeleteStudies.ReceivedBefore, reader.stringArray());
                        continue block53;
                    }
                    case "dcmDeleteStudiesNotUsedSince": {
                        st.setRetentionPeriods(RetentionPeriod.DeleteStudies.NotUsedSince, reader.stringArray());
                        continue block53;
                    }
                    case "dcmMaxRetries": {
                        st.setMaxRetries(reader.intValue());
                        continue block53;
                    }
                    case "dcmRetryDelay": {
                        st.setRetryDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block53;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addStorageDescriptor(st);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadQueryRetrieveViewFrom(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            QueryRetrieveView qrv = new QueryRetrieveView();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmQueryRetrieveViewID": {
                        qrv.setViewID(reader.stringValue());
                        continue block13;
                    }
                    case "dcmShowInstancesRejectedByCode": {
                        qrv.setShowInstancesRejectedByCodes(reader.codeArray());
                        continue block13;
                    }
                    case "dcmHideRejectionNoteWithCode": {
                        qrv.setHideRejectionNotesWithCodes(reader.codeArray());
                        continue block13;
                    }
                    case "dcmHideNotRejectedInstances": {
                        qrv.setHideNotRejectedInstances(reader.booleanValue());
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addQueryRetrieveView(qrv);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadQueueDescriptorFrom(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            QueueDescriptor qd = new QueueDescriptor();
            block33: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmQueueName": {
                        qd.setQueueName(reader.stringValue());
                        continue block33;
                    }
                    case "dicomDescription": {
                        qd.setDescription(reader.stringValue());
                        continue block33;
                    }
                    case "dcmMaxTasksParallel": {
                        qd.setMaxTasksParallel(reader.intValue());
                        continue block33;
                    }
                    case "dcmMaxRetries": {
                        qd.setMaxRetries(reader.intValue());
                        continue block33;
                    }
                    case "dcmRetryDelay": {
                        qd.setRetryDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dcmMaxRetryDelay": {
                        qd.setMaxRetryDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dcmRetryDelayMultiplier": {
                        qd.setRetryDelayMultiplier(reader.intValue());
                        continue block33;
                    }
                    case "dcmRetryOnWarning": {
                        qd.setRetryOnWarning(reader.booleanValue());
                        continue block33;
                    }
                    case "dcmPurgeQueueMessageCompletedDelay": {
                        qd.setPurgeTaskCompletedDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dcmPurgeQueueMessageFailedDelay": {
                        qd.setPurgeTaskFailedDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dcmPurgeQueueMessageWarningDelay": {
                        qd.setPurgeTaskWarningDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dcmPurgeQueueMessageCanceledDelay": {
                        qd.setPurgeTaskCanceledDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dcmSchedule": {
                        qd.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block33;
                    }
                    case "dicomInstalled": {
                        qd.setInstalled(reader.booleanValue());
                        continue block33;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addQueueDescriptor(qd);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadPDQServiceDescriptorFrom(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            PDQServiceDescriptor desc = new PDQServiceDescriptor();
            block17: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmPDQServiceID": {
                        desc.setPDQServiceID(reader.stringValue());
                        continue block17;
                    }
                    case "dcmURI": {
                        desc.setPDQServiceURI(URI.create(reader.stringValue()));
                        continue block17;
                    }
                    case "dicomDescription": {
                        desc.setDescription(reader.stringValue());
                        continue block17;
                    }
                    case "dcmTag": {
                        desc.setSelection(TagUtils.fromHexStrings((String[])reader.stringArray()));
                        continue block17;
                    }
                    case "dcmProperty": {
                        desc.setProperties(reader.stringArray());
                        continue block17;
                    }
                    case "dcmEntity": {
                        desc.setEntity(Entity.valueOf((String)reader.stringValue()));
                        continue block17;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addPDQServiceDescriptor(desc);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadExporterDescriptorFrom(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            ExporterDescriptor ed = new ExporterDescriptor();
            block35: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmExporterID": {
                        ed.setExporterID(reader.stringValue());
                        continue block35;
                    }
                    case "dcmURI": {
                        ed.setExportURI(URI.create(reader.stringValue()));
                        continue block35;
                    }
                    case "dcmQueueName": {
                        ed.setQueueName(reader.stringValue());
                        continue block35;
                    }
                    case "dicomDescription": {
                        ed.setDescription(reader.stringValue());
                        continue block35;
                    }
                    case "dicomAETitle": {
                        ed.setAETitle(reader.stringValue());
                        continue block35;
                    }
                    case "dcmStgCmtSCP": {
                        ed.setStgCmtSCPAETitle(reader.stringValue());
                        continue block35;
                    }
                    case "dcmDeleteStudyFromStorageID": {
                        ed.setDeleteStudyFromStorageID(reader.stringValue());
                        continue block35;
                    }
                    case "dcmIanDestination": {
                        ed.setIanDestinations(reader.stringArray());
                        continue block35;
                    }
                    case "dcmRetrieveAET": {
                        ed.setRetrieveAETitles(reader.stringArray());
                        continue block35;
                    }
                    case "dcmRetrieveLocationUID": {
                        ed.setRetrieveLocationUID(reader.stringValue());
                        continue block35;
                    }
                    case "dcmInstanceAvailability": {
                        ed.setInstanceAvailability(Availability.valueOf((String)reader.stringValue()));
                        continue block35;
                    }
                    case "dcmSchedule": {
                        ed.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block35;
                    }
                    case "dcmProperty": {
                        ed.setProperties(reader.stringArray());
                        continue block35;
                    }
                    case "dcmRejectForDataRetentionExpiry": {
                        ed.setRejectForDataRetentionExpiry(reader.booleanValue());
                        continue block35;
                    }
                    case "dcmExportAsSourceAE": {
                        ed.setExportAsSourceAE(reader.booleanValue());
                        continue block35;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addExporterDescriptor(ed);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadExportRule(Collection<ExportRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            ExportRule er = new ExportRule();
            block23: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        er.setCommonName(reader.stringValue());
                        continue block23;
                    }
                    case "dcmEntity": {
                        er.setEntity(Entity.valueOf((String)reader.stringValue()));
                        continue block23;
                    }
                    case "dcmExporterID": {
                        er.setExporterIDs(reader.stringArray());
                        continue block23;
                    }
                    case "dcmProperty": {
                        er.setConditions(new Conditions(reader.stringArray()));
                        continue block23;
                    }
                    case "dcmSchedule": {
                        er.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block23;
                    }
                    case "dcmDuration": {
                        er.setExportDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block23;
                    }
                    case "dcmExportPreviousEntity": {
                        er.setExportPreviousEntity(reader.booleanValue());
                        continue block23;
                    }
                    case "dcmExportReoccurredInstances": {
                        er.setExportReoccurredInstances(ExportReoccurredInstances.valueOf((String)reader.stringValue()));
                        continue block23;
                    }
                    case "dicomDeviceName": {
                        er.setExporterDeviceName(reader.stringValue());
                        continue block23;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(er);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadExportPriorsRules(Collection<ExportPriorsRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            ExportPriorsRule rule = new ExportPriorsRule();
            block19: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        rule.setCommonName(reader.stringValue());
                        continue block19;
                    }
                    case "dcmEntitySelector": {
                        rule.setEntitySelectors(EntitySelector.valuesOf((String[])reader.stringArray()));
                        continue block19;
                    }
                    case "dcmExporterID": {
                        rule.setExporterIDs(reader.stringArray());
                        continue block19;
                    }
                    case "dcmProperty": {
                        rule.setConditions(new Conditions(reader.stringArray()));
                        continue block19;
                    }
                    case "dcmSchedule": {
                        rule.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block19;
                    }
                    case "dcmDuration": {
                        rule.setSuppressDuplicateExportInterval(Duration.valueOf((String)reader.stringValue()));
                        continue block19;
                    }
                    case "dcmExportReoccurredInstances": {
                        rule.setExportReoccurredInstances(ExportReoccurredInstances.valueOf((String)reader.stringValue()));
                        continue block19;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(rule);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadMPPSForwardRule(Collection<MPPSForwardRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            MPPSForwardRule mppsFwdRule = new MPPSForwardRule();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        mppsFwdRule.setCommonName(reader.stringValue());
                        continue block13;
                    }
                    case "dcmFwdMppsDestination": {
                        mppsFwdRule.setDestinations(reader.stringArray());
                        continue block13;
                    }
                    case "dcmProperty": {
                        mppsFwdRule.setConditions(new Conditions(reader.stringArray()));
                        continue block13;
                    }
                    case "dcmSchedule": {
                        mppsFwdRule.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(mppsFwdRule);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    static void loadHL7ExportRules(Collection<HL7ExportRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            HL7ExportRule rule = new HL7ExportRule();
            block23: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        rule.setCommonName(reader.stringValue());
                        continue block23;
                    }
                    case "dcmEntitySelector": {
                        rule.setEntitySelectors(EntitySelector.valuesOf((String[])reader.stringArray()));
                        continue block23;
                    }
                    case "dcmExporterID": {
                        rule.setExporterIDs(reader.stringArray());
                        continue block23;
                    }
                    case "dcmProperty": {
                        rule.setConditions(new HL7Conditions(reader.stringArray()));
                        continue block23;
                    }
                    case "dcmNullifyIssuerOfPatientID": {
                        rule.setIgnoreAssigningAuthorityOfPatientID(NullifyIssuer.valueOf((String)reader.stringValue()));
                        continue block23;
                    }
                    case "dcmIssuerOfPatientID": {
                        rule.setAssigningAuthorityOfPatientIDs(JsonArchiveConfiguration.toIssuers(reader.stringArray()));
                        continue block23;
                    }
                    case "dcmPrefetchForIssuerOfPatientID": {
                        rule.setPrefetchForAssigningAuthorityOfPatientID(JsonArchiveConfiguration.toIssuer(reader.stringValue()));
                        continue block23;
                    }
                    case "dcmDuration": {
                        rule.setSuppressDuplicateExportInterval(Duration.valueOf((String)reader.stringValue()));
                        continue block23;
                    }
                    case "dcmHistorySize": {
                        rule.setSuppressDuplicateHistorySize(reader.intValue());
                        continue block23;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(rule);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    static void loadHL7PrefetchRules(Collection<HL7PrefetchRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            HL7PrefetchRule rule = new HL7PrefetchRule();
            block41: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        rule.setCommonName(reader.stringValue());
                        continue block41;
                    }
                    case "dcmQueueName": {
                        rule.setQueueName(reader.stringValue());
                        continue block41;
                    }
                    case "dicomAETitle": {
                        rule.setAETitle(reader.stringValue());
                        continue block41;
                    }
                    case "dcmPrefetchCFindSCP": {
                        rule.setPrefetchCFindSCP(reader.stringValue());
                        continue block41;
                    }
                    case "dcmPrefetchCMoveSCP": {
                        rule.setPrefetchCMoveSCP(reader.stringValue());
                        continue block41;
                    }
                    case "dcmPrefetchCStoreSCP": {
                        rule.setPrefetchCStoreSCPs(reader.stringArray());
                        continue block41;
                    }
                    case "dcmDestinationCFindSCP": {
                        rule.setDestinationCFindSCP(reader.stringValue());
                        continue block41;
                    }
                    case "dicomDeviceName": {
                        rule.setPrefetchDeviceName(reader.stringValue());
                        continue block41;
                    }
                    case "dcmEntitySelector": {
                        rule.setEntitySelectors(EntitySelector.valuesOf((String[])reader.stringArray()));
                        continue block41;
                    }
                    case "dcmProperty": {
                        rule.setConditions(new HL7Conditions(reader.stringArray()));
                        continue block41;
                    }
                    case "dcmSchedule": {
                        rule.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block41;
                    }
                    case "dcmNullifyIssuerOfPatientID": {
                        rule.setIgnoreAssigningAuthorityOfPatientID(NullifyIssuer.valueOf((String)reader.stringValue()));
                        continue block41;
                    }
                    case "dcmIssuerOfPatientID": {
                        rule.setAssigningAuthorityOfPatientIDs(JsonArchiveConfiguration.toIssuers(reader.stringArray()));
                        continue block41;
                    }
                    case "dcmPrefetchForIssuerOfPatientID": {
                        rule.setPrefetchForAssigningAuthorityOfPatientID(JsonArchiveConfiguration.toIssuer(reader.stringValue()));
                        continue block41;
                    }
                    case "dcmDuration": {
                        rule.setSuppressDuplicateRetrieveInterval(Duration.valueOf((String)reader.stringValue()));
                        continue block41;
                    }
                    case "dcmHistorySize": {
                        rule.setSuppressDuplicateHistorySize(reader.intValue());
                        continue block41;
                    }
                    case "dcmPrefetchDateTimeField": {
                        rule.setPrefetchDateTimeField(reader.stringValue());
                        continue block41;
                    }
                    case "dcmPrefetchInAdvance": {
                        rule.setPrefetchInAdvance(Duration.valueOf((String)reader.stringValue()));
                        continue block41;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(rule);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadArchiveCompressionRule(Collection<ArchiveCompressionRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            ArchiveCompressionRule acr = new ArchiveCompressionRule();
            block17: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        acr.setCommonName(reader.stringValue());
                        continue block17;
                    }
                    case "dicomTransferSyntax": {
                        acr.setTransferSyntax(reader.stringValue());
                        continue block17;
                    }
                    case "dcmRulePriority": {
                        acr.setPriority(reader.intValue());
                        continue block17;
                    }
                    case "dcmCompressionDelay": {
                        acr.setDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block17;
                    }
                    case "dcmProperty": {
                        acr.setConditions(new Conditions(reader.stringArray()));
                        continue block17;
                    }
                    case "dcmImageWriteParam": {
                        acr.setImageWriteParams(Property.valueOf((String[])reader.stringArray()));
                        continue block17;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(acr);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadStoreAccessControlIDRule(Collection<StoreAccessControlIDRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            StoreAccessControlIDRule acr = new StoreAccessControlIDRule();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        acr.setCommonName(reader.stringValue());
                        continue block13;
                    }
                    case "dcmStoreAccessControlID": {
                        acr.setStoreAccessControlID(reader.stringValue());
                        continue block13;
                    }
                    case "dcmRulePriority": {
                        acr.setPriority(reader.intValue());
                        continue block13;
                    }
                    case "dcmProperty": {
                        acr.setConditions(new Conditions(reader.stringArray()));
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(acr);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadArchiveAttributeCoercion(Collection<ArchiveAttributeCoercion> coercions, JsonReader reader, ConfigurationDelegate config) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            ArchiveAttributeCoercion aac = new ArchiveAttributeCoercion();
            block57: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        aac.setCommonName(reader.stringValue());
                        continue block57;
                    }
                    case "dcmDIMSE": {
                        aac.setDIMSE(Dimse.valueOf((String)reader.stringValue()));
                        continue block57;
                    }
                    case "dicomTransferRole": {
                        aac.setRole(TransferCapability.Role.valueOf((String)reader.stringValue()));
                        continue block57;
                    }
                    case "dcmRulePriority": {
                        aac.setPriority(reader.intValue());
                        continue block57;
                    }
                    case "dcmSOPClass": {
                        aac.setSOPClasses(reader.stringArray());
                        continue block57;
                    }
                    case "dcmProperty": {
                        aac.setConditions(new Conditions(reader.stringArray()));
                        continue block57;
                    }
                    case "dcmMergeAttribute": {
                        aac.setMergeAttributes(reader.stringArray());
                        continue block57;
                    }
                    case "dcmRetrieveAsReceived": {
                        aac.setRetrieveAsReceived(reader.booleanValue());
                        continue block57;
                    }
                    case "dcmDeIdentification": {
                        aac.setDeIdentification((DeIdentifier.Option[])reader.enumArray(DeIdentifier.Option.class));
                        continue block57;
                    }
                    case "dcmURI": {
                        aac.setXSLTStylesheetURI(reader.stringValue());
                        continue block57;
                    }
                    case "dcmNoKeywords": {
                        aac.setNoKeywords(reader.booleanValue());
                        continue block57;
                    }
                    case "dcmLeadingCFindSCP": {
                        aac.setLeadingCFindSCP(reader.stringValue());
                        continue block57;
                    }
                    case "dcmMergeMWLMatchingKey": {
                        aac.setMergeMWLMatchingKey(MergeMWLMatchingKey.valueOf((String)reader.stringValue()));
                        continue block57;
                    }
                    case "dcmMergeMWLTemplateURI": {
                        aac.setMergeMWLTemplateURI(reader.stringValue());
                        continue block57;
                    }
                    case "dcmMergeMWLSCP": {
                        aac.setMergeMWLSCP(reader.stringValue());
                        continue block57;
                    }
                    case "dcmMergeLocalMWLWorklistLabel": {
                        aac.setMergeLocalMWLWorklistLabels(reader.stringArray());
                        continue block57;
                    }
                    case "dcmMergeLocalMWLWithStatus": {
                        aac.setMergeLocalMWLWithStatus((SPSStatus[])reader.enumArray(SPSStatus.class));
                        continue block57;
                    }
                    case "dcmMWLImportFilterBySCU": {
                        aac.setFilterBySCU(reader.booleanValue());
                        continue block57;
                    }
                    case "dcmAttributeUpdatePolicy": {
                        aac.setAttributeUpdatePolicy(Attributes.UpdatePolicy.valueOf((String)reader.stringValue()));
                        continue block57;
                    }
                    case "dcmNullifyTag": {
                        aac.setNullifyTags(TagUtils.fromHexStrings((String[])reader.stringArray()));
                        continue block57;
                    }
                    case "dcmSupplementFromDeviceReference": {
                        aac.setSupplementFromDevice(this.loadDevice(config, reader.stringValue()));
                        continue block57;
                    }
                    case "dcmNullifyIssuerOfPatientID": {
                        aac.setNullifyIssuerOfPatientID(NullifyIssuer.valueOf((String)reader.stringValue()));
                        continue block57;
                    }
                    case "dcmIssuerOfPatientID": {
                        aac.setIssuerOfPatientIDs(JsonArchiveConfiguration.toIssuers(reader.stringArray()));
                        continue block57;
                    }
                    case "dcmIssuerOfPatientIDFormat": {
                        aac.setIssuerOfPatientIDFormat(reader.stringValue());
                        continue block57;
                    }
                    case "dcmTrimISO2022CharacterSet": {
                        aac.setTrimISO2022CharacterSet(reader.booleanValue());
                        continue block57;
                    }
                    case "dcmUseCallingAETitleAs": {
                        aac.setUseCallingAETitleAs(UseCallingAETitleAsCoercion.Type.valueOf((String)reader.stringValue()));
                        continue block57;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            coercions.add(aac);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadArchiveAttributeCoercion2(Collection<ArchiveAttributeCoercion2> coercions, JsonReader reader, ConfigurationDelegate config) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            ArchiveAttributeCoercion2 aac = new ArchiveAttributeCoercion2();
            block33: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        aac.setCommonName(reader.stringValue());
                        continue block33;
                    }
                    case "dicomDescription": {
                        aac.setDescription(reader.stringValue());
                        continue block33;
                    }
                    case "dcmRulePriority": {
                        aac.setPriority(reader.intValue());
                        continue block33;
                    }
                    case "dcmDIMSE": {
                        aac.setDIMSE(Dimse.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dicomTransferRole": {
                        aac.setRole(TransferCapability.Role.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dcmSOPClass": {
                        aac.setSOPClasses(reader.stringArray());
                        continue block33;
                    }
                    case "dcmProperty": {
                        aac.setConditions(new Conditions(reader.stringArray()));
                        continue block33;
                    }
                    case "dcmURI": {
                        aac.setURI(reader.stringValue());
                        continue block33;
                    }
                    case "dcmAttributeUpdatePolicy": {
                        aac.setAttributeUpdatePolicy(Attributes.UpdatePolicy.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                    case "dcmSupplementFromDeviceReference": {
                        aac.setOtherDevice(this.loadDevice(config, reader.stringValue()));
                        continue block33;
                    }
                    case "dcmMergeAttribute": {
                        aac.setMergeAttributes(reader.stringArray());
                        continue block33;
                    }
                    case "dcmCoercionParam": {
                        aac.setCoercionParams(reader.stringArray());
                        continue block33;
                    }
                    case "dcmCoercionSufficient": {
                        aac.setCoercionSufficient(reader.booleanValue());
                        continue block33;
                    }
                    case "dcmCoercionOnFailure": {
                        aac.setCoercionOnFailure(ArchiveAttributeCoercion2.OnFailure.valueOf((String)reader.stringValue()));
                        continue block33;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            coercions.add(aac);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private static Issuer[] toIssuers(String[] issuerOfPatientIds) {
        Issuer[] issuers = new Issuer[issuerOfPatientIds.length];
        for (int i = 0; i < issuerOfPatientIds.length; ++i) {
            issuers[i] = new Issuer(issuerOfPatientIds[i]);
        }
        return issuers;
    }

    private static Issuer toIssuer(String issuerOfPatientID) {
        return issuerOfPatientID != null ? new Issuer(issuerOfPatientID) : null;
    }

    private Device loadDevice(ConfigurationDelegate config, String supplementDeviceRef) {
        try {
            return supplementDeviceRef != null ? config.findDevice(supplementDeviceRef) : null;
        }
        catch (ConfigurationException e) {
            LOG.info("Failed to load Supplement Device Reference " + supplementDeviceRef + " referenced by Attribute Coercion", (Throwable)e);
            return null;
        }
    }

    private static Device loadScheduledStation(ConfigurationDelegate config, String scheduledStationDeviceRef) {
        try {
            return config.findDevice(scheduledStationDeviceRef);
        }
        catch (ConfigurationException e) {
            LOG.info("Failed to load Scheduled Station Device Reference " + scheduledStationDeviceRef + " referenced by HL7 Order Scheduled Station", (Throwable)e);
            return null;
        }
    }

    private void loadRejectionNoteFrom(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            RejectionNote rn = new RejectionNote();
            block21: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmRejectionNoteLabel": {
                        rn.setRejectionNoteLabel(reader.stringValue());
                        continue block21;
                    }
                    case "dcmRejectionNoteType": {
                        rn.setRejectionNoteType(RejectionNote.Type.valueOf((String)reader.stringValue()));
                        continue block21;
                    }
                    case "dcmRejectionNoteCode": {
                        rn.setRejectionNoteCode(new Code(reader.stringValue()));
                        continue block21;
                    }
                    case "dcmAcceptPreviousRejectedInstance": {
                        rn.setAcceptPreviousRejectedInstance(RejectionNote.AcceptPreviousRejectedInstance.valueOf((String)reader.stringValue()));
                        continue block21;
                    }
                    case "dcmOverwritePreviousRejection": {
                        rn.setOverwritePreviousRejection(this.overwritePreviousRejection(reader.stringArray()));
                        continue block21;
                    }
                    case "dcmAcceptRejectionBeforeStorage": {
                        rn.setAcceptRejectionBeforeStorage(Duration.valueOf((String)reader.stringValue()));
                        continue block21;
                    }
                    case "dcmDeleteRejectedInstanceDelay": {
                        rn.setDeleteRejectedInstanceDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block21;
                    }
                    case "dcmDeleteRejectionNoteDelay": {
                        rn.setDeleteRejectionNoteDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block21;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addRejectionNote(rn);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private Code[] overwritePreviousRejection(String[] overwritePreviousRejectionAsStringArray) {
        Code[] overwritePreviousRejectionCodes = new Code[overwritePreviousRejectionAsStringArray.length];
        for (int i = 0; i < overwritePreviousRejectionAsStringArray.length; ++i) {
            overwritePreviousRejectionCodes[i] = new Code(overwritePreviousRejectionAsStringArray[i]);
        }
        return overwritePreviousRejectionCodes;
    }

    private void loadStudyRetentionPolicy(Collection<StudyRetentionPolicy> policies, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            StudyRetentionPolicy srp = new StudyRetentionPolicy();
            block23: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        srp.setCommonName(reader.stringValue());
                        continue block23;
                    }
                    case "dcmRetentionPeriod": {
                        srp.setRetentionPeriod(Period.parse(reader.stringValue()));
                        continue block23;
                    }
                    case "dcmRulePriority": {
                        srp.setPriority(reader.intValue());
                        continue block23;
                    }
                    case "dcmProperty": {
                        srp.setConditions(new Conditions(reader.stringArray()));
                        continue block23;
                    }
                    case "dcmExpireSeriesIndividually": {
                        srp.setExpireSeriesIndividually(reader.booleanValue());
                        continue block23;
                    }
                    case "dcmStartRetentionPeriodOnStudyDate": {
                        srp.setStartRetentionPeriodOnStudyDate(reader.booleanValue());
                        continue block23;
                    }
                    case "dcmExporterID": {
                        srp.setExporterID(reader.stringValue());
                        continue block23;
                    }
                    case "dcmFreezeExpirationDate": {
                        srp.setFreezeExpirationDate(reader.booleanValue());
                        continue block23;
                    }
                    case "dcmRevokeExpiration": {
                        srp.setRevokeExpiration(reader.booleanValue());
                        continue block23;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            policies.add(srp);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    static void loadHL7StudyRetentionPolicy(Collection<HL7StudyRetentionPolicy> policies, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            HL7StudyRetentionPolicy srp = new HL7StudyRetentionPolicy();
            block25: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        srp.setCommonName(reader.stringValue());
                        continue block25;
                    }
                    case "dicomAETitle": {
                        srp.setAETitle(reader.stringValue());
                        continue block25;
                    }
                    case "dcmRetentionPeriod": {
                        srp.setMinRetentionPeriod(Period.parse(reader.stringValue()));
                        continue block25;
                    }
                    case "dcmMaxRetentionPeriod": {
                        srp.setMaxRetentionPeriod(Period.parse(reader.stringValue()));
                        continue block25;
                    }
                    case "dcmRulePriority": {
                        srp.setPriority(reader.intValue());
                        continue block25;
                    }
                    case "dcmProperty": {
                        srp.setConditions(new HL7Conditions(reader.stringArray()));
                        continue block25;
                    }
                    case "dcmStartRetentionPeriodOnStudyDate": {
                        srp.setStartRetentionPeriodOnStudyDate(reader.booleanValue());
                        continue block25;
                    }
                    case "dcmExporterID": {
                        srp.setExporterID(reader.stringValue());
                        continue block25;
                    }
                    case "dcmFreezeExpirationDate": {
                        srp.setFreezeExpirationDate(reader.booleanValue());
                        continue block25;
                    }
                    case "dcmRevokeExpiration": {
                        srp.setRevokeExpiration(reader.booleanValue());
                        continue block25;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            policies.add(srp);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    static void loadHL7ForwardRules(Collection<HL7ForwardRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            HL7ForwardRule rule = new HL7ForwardRule();
            block11: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        rule.setCommonName(reader.stringValue());
                        continue block11;
                    }
                    case "hl7FwdApplicationName": {
                        rule.setDestinations(reader.stringArray());
                        continue block11;
                    }
                    case "dcmProperty": {
                        rule.setConditions(new HL7Conditions(reader.stringArray()));
                        continue block11;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(rule);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    static void loadScheduledStations(Collection<HL7OrderScheduledStation> stations, JsonReader reader, ConfigurationDelegate config) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            HL7OrderScheduledStation station = new HL7OrderScheduledStation();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        station.setCommonName(reader.stringValue());
                        continue block13;
                    }
                    case "hl7OrderScheduledStationDeviceName": {
                        station.setDevice(JsonArchiveConfiguration.loadScheduledStation(config, reader.stringValue()));
                        continue block13;
                    }
                    case "dcmRulePriority": {
                        station.setPriority(reader.intValue());
                        continue block13;
                    }
                    case "dcmProperty": {
                        station.setConditions(new HL7Conditions(reader.stringArray()));
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            stations.add(station);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    static void loadHL7OrderSPSStatus(Map<SPSStatus, HL7OrderSPSStatus> hl7OrderSPSStatusMap, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            HL7OrderSPSStatus hl7OrderSPSStatus = new HL7OrderSPSStatus();
            block9: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmSPSStatus": {
                        hl7OrderSPSStatus.setSPSStatus(SPSStatus.valueOf((String)reader.stringValue()));
                        continue block9;
                    }
                    case "hl7OrderControlStatus": {
                        hl7OrderSPSStatus.setOrderControlStatusCodes(reader.stringArray());
                        continue block9;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            hl7OrderSPSStatusMap.put(hl7OrderSPSStatus.getSPSStatus(), hl7OrderSPSStatus);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private static void loadRSForwardRules(Collection<RSForwardRule> rules, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            RSForwardRule rule = new RSForwardRule();
            block21: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        rule.setCommonName(reader.stringValue());
                        continue block21;
                    }
                    case "dcmWebAppName": {
                        rule.setWebAppName(reader.stringValue());
                        continue block21;
                    }
                    case "dcmRSOperation": {
                        rule.setRSOperations((RSOperation[])reader.enumArray(RSOperation.class));
                        continue block21;
                    }
                    case "dcmTLSAllowAnyHostname": {
                        rule.setTlsAllowAnyHostname(reader.booleanValue());
                        continue block21;
                    }
                    case "dcmTLSDisableTrustManager": {
                        rule.setTlsDisableTrustManager(reader.booleanValue());
                        continue block21;
                    }
                    case "dcmURIPattern": {
                        rule.setRequestURLPattern(reader.stringValue());
                        continue block21;
                    }
                    case "dcmHostnamePattern": {
                        rule.setRemoteHostnamePattern(reader.stringValue());
                        continue block21;
                    }
                    case "dcmIPAddressPattern": {
                        rule.setRemoteIPAddressPattern(reader.stringValue());
                        continue block21;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            rules.add(rule);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private static void loadMetricsDescriptors(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            MetricsDescriptor metricsDescriptor = new MetricsDescriptor();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmMetricsName": {
                        metricsDescriptor.setMetricsName(reader.stringValue());
                        continue block13;
                    }
                    case "dicomDescription": {
                        metricsDescriptor.setDescription(reader.stringValue());
                        continue block13;
                    }
                    case "dcmMetricsRetentionPeriod": {
                        metricsDescriptor.setRetentionPeriod(reader.intValue());
                        continue block13;
                    }
                    case "dcmUnit": {
                        metricsDescriptor.setUnit(reader.stringValue());
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addMetricsDescriptor(metricsDescriptor);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadIDGenerators(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            IDGenerator generator = new IDGenerator();
            block11: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmIDGeneratorName": {
                        generator.setName(reader.stringValue());
                        continue block11;
                    }
                    case "dcmIDGeneratorFormat": {
                        generator.setFormat(reader.stringValue());
                        continue block11;
                    }
                    case "dcmIDGeneratorInitialValue": {
                        generator.setInitialValue(reader.intValue());
                        continue block11;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addIDGenerator(generator);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUPSOnStoreList(Collection<UPSOnStore> upsOnStoreList, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UPSOnStore upsOnStore = new UPSOnStore();
            block71: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmUPSOnStoreID": {
                        upsOnStore.setUPSOnStoreID(reader.stringValue());
                        continue block71;
                    }
                    case "dcmUPSLabel": {
                        upsOnStore.setProcedureStepLabel(reader.stringValue());
                        continue block71;
                    }
                    case "dcmUPSPriority": {
                        upsOnStore.setUPSPriority(UPSPriority.valueOf((String)reader.stringValue()));
                        continue block71;
                    }
                    case "dcmUPSInputReadinessState": {
                        upsOnStore.setInputReadinessState(InputReadinessState.valueOf((String)reader.stringValue()));
                        continue block71;
                    }
                    case "dcmUPSStartDateTimeDelay": {
                        upsOnStore.setStartDateTimeDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block71;
                    }
                    case "dcmUPSCompletionDateTimeDelay": {
                        upsOnStore.setCompletionDateTimeDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block71;
                    }
                    case "dcmUPSWorklistLabel": {
                        upsOnStore.setWorklistLabel(reader.stringValue());
                        continue block71;
                    }
                    case "dcmUPSInstanceUIDBasedOnName": {
                        upsOnStore.setInstanceUIDBasedOnName(reader.stringValue());
                        continue block71;
                    }
                    case "dcmUPSIncludeInputInformation": {
                        upsOnStore.setIncludeInputInformation(UPSOnStore.IncludeInputInformation.valueOf((String)reader.stringValue()));
                        continue block71;
                    }
                    case "dcmUPSIncludePatient": {
                        upsOnStore.setIncludePatient(reader.booleanValue());
                        continue block71;
                    }
                    case "dcmUPSIncludeStudyInstanceUID": {
                        upsOnStore.setIncludeStudyInstanceUID(reader.booleanValue());
                        continue block71;
                    }
                    case "dcmUPSIncludeReferencedRequest": {
                        upsOnStore.setIncludeReferencedRequest(reader.booleanValue());
                        continue block71;
                    }
                    case "dcmDestinationAE": {
                        upsOnStore.setDestinationAE(reader.stringValue());
                        continue block71;
                    }
                    case "dcmEntity": {
                        upsOnStore.setScopeOfAccumulation(Entity.valueOf((String)reader.stringValue()));
                        continue block71;
                    }
                    case "dcmUPSScheduledWorkitemCode": {
                        upsOnStore.setScheduledWorkitemCode(new Code(reader.stringValue()));
                        continue block71;
                    }
                    case "dcmUPSScheduledStationNameCode": {
                        upsOnStore.setScheduledStationNames(reader.codeArray());
                        continue block71;
                    }
                    case "dcmUPSScheduledStationClassCode": {
                        upsOnStore.setScheduledStationClasses(reader.codeArray());
                        continue block71;
                    }
                    case "dcmUPSScheduledStationLocationCode": {
                        upsOnStore.setScheduledStationLocations(reader.codeArray());
                        continue block71;
                    }
                    case "dcmUPSScheduledHumanPerformerCode": {
                        upsOnStore.setScheduledHumanPerformers(reader.codeArray());
                        continue block71;
                    }
                    case "dcmUPSScheduledHumanPerformerName": {
                        upsOnStore.setScheduledHumanPerformerName(reader.stringValue());
                        continue block71;
                    }
                    case "dcmUPSScheduledHumanPerformerOrganization": {
                        upsOnStore.setScheduledHumanPerformerOrganization(reader.stringValue());
                        continue block71;
                    }
                    case "dcmAdmissionID": {
                        upsOnStore.setAdmissionID(reader.stringValue());
                        continue block71;
                    }
                    case "dicomIssuerOfAdmissionID": {
                        upsOnStore.setIssuerOfAdmissionID(reader.issuerValue());
                        continue block71;
                    }
                    case "dcmAccessionNumber": {
                        upsOnStore.setAccessionNumber(reader.stringValue());
                        continue block71;
                    }
                    case "dicomIssuerOfAccessionNumber": {
                        upsOnStore.setIssuerOfAccessionNumber(reader.issuerValue());
                        continue block71;
                    }
                    case "dcmRequestedProcedureID": {
                        upsOnStore.setRequestedProcedureID(reader.stringValue());
                        continue block71;
                    }
                    case "dcmRequestedProcedureDescription": {
                        upsOnStore.setRequestedProcedureDescription(reader.stringValue());
                        continue block71;
                    }
                    case "dcmRequestingPhysician": {
                        upsOnStore.setRequestingPhysician(reader.stringValue());
                        continue block71;
                    }
                    case "dcmRequestingService": {
                        upsOnStore.setRequestingService(reader.stringValue());
                        continue block71;
                    }
                    case "dcmURI": {
                        upsOnStore.setXSLTStylesheetURI(reader.stringValue());
                        continue block71;
                    }
                    case "dcmNoKeywords": {
                        upsOnStore.setNoKeywords(reader.booleanValue());
                        continue block71;
                    }
                    case "dcmProperty": {
                        upsOnStore.setConditions(new Conditions(reader.stringArray()));
                        continue block71;
                    }
                    case "dcmSchedule": {
                        upsOnStore.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block71;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            upsOnStoreList.add(upsOnStore);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUPSProcessingRules(ArchiveDeviceExtension arcDev, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UPSProcessingRule upsProcessingRule = new UPSProcessingRule();
            block51: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmUPSProcessingRuleID": {
                        upsProcessingRule.setUPSProcessingRuleID(reader.stringValue());
                        continue block51;
                    }
                    case "dicomAETitle": {
                        upsProcessingRule.setAETitle(reader.stringValue());
                        continue block51;
                    }
                    case "dcmURI": {
                        upsProcessingRule.setUPSProcessorURI(URI.create(StringUtils.replaceSystemProperties((String)reader.stringValue())));
                        continue block51;
                    }
                    case "dcmProperty": {
                        upsProcessingRule.setProperties(reader.stringArray());
                        continue block51;
                    }
                    case "dcmSchedule": {
                        upsProcessingRule.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block51;
                    }
                    case "dcmMaxThreads": {
                        upsProcessingRule.setMaxThreads(reader.intValue());
                        continue block51;
                    }
                    case "dcmUPSInputReadinessState": {
                        upsProcessingRule.setInputReadinessState(InputReadinessState.valueOf((String)reader.stringValue()));
                        continue block51;
                    }
                    case "dcmUPSPriority": {
                        upsProcessingRule.setUPSPriority(UPSPriority.valueOf((String)reader.stringValue()));
                        continue block51;
                    }
                    case "dcmUPSLabel": {
                        upsProcessingRule.setProcedureStepLabel(reader.stringValue());
                        continue block51;
                    }
                    case "dcmUPSWorklistLabel": {
                        upsProcessingRule.setWorklistLabel(reader.stringValue());
                        continue block51;
                    }
                    case "dcmUPSScheduledWorkitemCode": {
                        upsProcessingRule.setScheduledWorkitemCode(new Code(reader.stringValue()));
                        continue block51;
                    }
                    case "dcmUPSScheduledStationNameCode": {
                        upsProcessingRule.setScheduledStationName(new Code(reader.stringValue()));
                        continue block51;
                    }
                    case "dcmUPSScheduledStationClassCode": {
                        upsProcessingRule.setScheduledStationClass(new Code(reader.stringValue()));
                        continue block51;
                    }
                    case "dcmUPSScheduledStationLocationCode": {
                        upsProcessingRule.setScheduledStationLocation(new Code(reader.stringValue()));
                        continue block51;
                    }
                    case "dcmUPSPerformedWorkitemCode": {
                        upsProcessingRule.setPerformedWorkitemCode(new Code(reader.stringValue()));
                        continue block51;
                    }
                    case "dcmUPSPerformedStationNameCode": {
                        upsProcessingRule.setPerformedStationNameCode(new Code(reader.stringValue()));
                        continue block51;
                    }
                    case "dcmRescheduleDiscontinuationReasonCode": {
                        upsProcessingRule.setRescheduleDiscontinuationReasonCodes(reader.codeArray());
                        continue block51;
                    }
                    case "dcmIgnoreDiscontinuationReasonCode": {
                        upsProcessingRule.setIgnoreDiscontinuationReasonCodes(reader.codeArray());
                        continue block51;
                    }
                    case "dcmMaxRetries": {
                        upsProcessingRule.setMaxRetries(reader.intValue());
                        continue block51;
                    }
                    case "dcmRetryDelay": {
                        upsProcessingRule.setRetryDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block51;
                    }
                    case "dcmMaxRetryDelay": {
                        upsProcessingRule.setMaxRetryDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block51;
                    }
                    case "dcmRetryDelayMultiplier": {
                        upsProcessingRule.setRetryDelayMultiplier(reader.intValue());
                        continue block51;
                    }
                    case "dcmUPSTemplateID": {
                        upsProcessingRule.setUpsTemplateID(reader.stringValue());
                        continue block51;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            arcDev.addUPSProcessingRule(upsProcessingRule);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    static void loadUPSOnHL7List(Collection<UPSOnHL7> upsOnHL7List, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UPSOnHL7 upsOnHL7 = new UPSOnHL7();
            block65: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "hl7UPSOnHL7ID": {
                        upsOnHL7.setUPSOnHL7ID(reader.stringValue());
                        continue block65;
                    }
                    case "dcmUPSLabel": {
                        upsOnHL7.setProcedureStepLabel(reader.stringValue());
                        continue block65;
                    }
                    case "dcmUPSPriority": {
                        upsOnHL7.setUPSPriority(UPSPriority.valueOf((String)reader.stringValue()));
                        continue block65;
                    }
                    case "dcmUPSInputReadinessState": {
                        upsOnHL7.setInputReadinessState(InputReadinessState.valueOf((String)reader.stringValue()));
                        continue block65;
                    }
                    case "dcmUPSStartDateTimeDelay": {
                        upsOnHL7.setStartDateTimeDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block65;
                    }
                    case "dcmUPSCompletionDateTimeDelay": {
                        upsOnHL7.setCompletionDateTimeDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block65;
                    }
                    case "dcmUPSWorklistLabel": {
                        upsOnHL7.setWorklistLabel(reader.stringValue());
                        continue block65;
                    }
                    case "dcmUPSInstanceUIDBasedOnName": {
                        upsOnHL7.setInstanceUIDBasedOnName(reader.stringValue());
                        continue block65;
                    }
                    case "dcmDestinationAE": {
                        upsOnHL7.setDestinationAE(reader.stringValue());
                        continue block65;
                    }
                    case "dcmUPSScheduledWorkitemCode": {
                        upsOnHL7.setScheduledWorkitemCode(new Code(reader.stringValue()));
                        continue block65;
                    }
                    case "dcmUPSScheduledStationNameCode": {
                        upsOnHL7.setScheduledStationNames(reader.codeArray());
                        continue block65;
                    }
                    case "dcmUPSScheduledStationClassCode": {
                        upsOnHL7.setScheduledStationClasses(reader.codeArray());
                        continue block65;
                    }
                    case "dcmUPSScheduledStationLocationCode": {
                        upsOnHL7.setScheduledStationLocations(reader.codeArray());
                        continue block65;
                    }
                    case "dcmUPSScheduledHumanPerformerCode": {
                        upsOnHL7.setScheduledHumanPerformers(reader.codeArray());
                        continue block65;
                    }
                    case "dcmUPSScheduledHumanPerformerName": {
                        upsOnHL7.setScheduledHumanPerformerName(reader.stringValue());
                        continue block65;
                    }
                    case "dcmUPSScheduledHumanPerformerOrganization": {
                        upsOnHL7.setScheduledHumanPerformerOrganization(reader.stringValue());
                        continue block65;
                    }
                    case "dcmUPSIncludeStudyInstanceUID": {
                        upsOnHL7.setIncludeStudyInstanceUID(reader.booleanValue());
                        continue block65;
                    }
                    case "dcmUPSIncludeReferencedRequest": {
                        upsOnHL7.setIncludeReferencedRequest(reader.booleanValue());
                        continue block65;
                    }
                    case "dcmStudyInstanceUID": {
                        upsOnHL7.setStudyInstanceUID(reader.stringValue());
                        continue block65;
                    }
                    case "dcmAdmissionID": {
                        upsOnHL7.setAdmissionID(reader.stringValue());
                        continue block65;
                    }
                    case "dicomIssuerOfAdmissionID": {
                        upsOnHL7.setIssuerOfAdmissionID(reader.issuerValue());
                        continue block65;
                    }
                    case "dcmAccessionNumber": {
                        upsOnHL7.setAccessionNumber(reader.stringValue());
                        continue block65;
                    }
                    case "dicomIssuerOfAccessionNumber": {
                        upsOnHL7.setIssuerOfAccessionNumber(reader.issuerValue());
                        continue block65;
                    }
                    case "dcmRequestedProcedureID": {
                        upsOnHL7.setRequestedProcedureID(reader.stringValue());
                        continue block65;
                    }
                    case "dcmRequestedProcedureDescription": {
                        upsOnHL7.setRequestedProcedureDescription(reader.stringValue());
                        continue block65;
                    }
                    case "dcmRequestingPhysician": {
                        upsOnHL7.setRequestingPhysician(reader.stringValue());
                        continue block65;
                    }
                    case "dcmRequestingService": {
                        upsOnHL7.setRequestingService(reader.stringValue());
                        continue block65;
                    }
                    case "dcmURI": {
                        upsOnHL7.setXSLTStylesheetURI(reader.stringValue());
                        continue block65;
                    }
                    case "dcmProperty": {
                        upsOnHL7.setConditions(new HL7Conditions(reader.stringArray()));
                        continue block65;
                    }
                    case "dcmSchedule": {
                        upsOnHL7.setSchedules(ScheduleExpression.valuesOf((String[])reader.stringArray()));
                        continue block65;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            upsOnHL7List.add(upsOnHL7);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUPSOnUPSCompletedList(Collection<UPSOnUPSCompleted> upsOnUPSCompletedList, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UPSOnUPSCompleted upsOnUPSCompleted = new UPSOnUPSCompleted();
            block59: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmUPSOnUPSCompletedID": {
                        upsOnUPSCompleted.setUPSonUPSCompletedID(reader.stringValue());
                        continue block59;
                    }
                    case "dcmProperty": {
                        upsOnUPSCompleted.setConditions(new Conditions(reader.stringArray()));
                        continue block59;
                    }
                    case "dcmRequiresOtherUPSCompleted": {
                        upsOnUPSCompleted.setRequiresOtherUPSCompleted(reader.stringArray());
                        continue block59;
                    }
                    case "dcmUPSLabel": {
                        upsOnUPSCompleted.setProcedureStepLabel(reader.stringValue());
                        continue block59;
                    }
                    case "dcmUPSWorklistLabel": {
                        upsOnUPSCompleted.setWorklistLabel(reader.stringValue());
                        continue block59;
                    }
                    case "dcmUPSInstanceUIDBasedOnName": {
                        upsOnUPSCompleted.setInstanceUIDBasedOnName(reader.stringValue());
                        continue block59;
                    }
                    case "dcmUPSIncludeInputInformation": {
                        upsOnUPSCompleted.setIncludeInputInformation(UPSOnUPSCompleted.IncludeInputInformation.valueOf((String)reader.stringValue()));
                        continue block59;
                    }
                    case "dcmUPSIncludePatient": {
                        upsOnUPSCompleted.setIncludePatient(reader.booleanValue());
                        continue block59;
                    }
                    case "dcmUPSPriority": {
                        upsOnUPSCompleted.setUPSPriority(UPSPriority.valueOf((String)reader.stringValue()));
                        continue block59;
                    }
                    case "dcmUPSInputReadinessState": {
                        upsOnUPSCompleted.setInputReadinessState(InputReadinessState.valueOf((String)reader.stringValue()));
                        continue block59;
                    }
                    case "dcmUPSStartDateTimeDelay": {
                        upsOnUPSCompleted.setStartDateTimeDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block59;
                    }
                    case "dcmUPSCompletionDateTimeDelay": {
                        upsOnUPSCompleted.setCompletionDateTimeDelay(Duration.valueOf((String)reader.stringValue()));
                        continue block59;
                    }
                    case "dcmDestinationAE": {
                        upsOnUPSCompleted.setDestinationAE(reader.stringValue());
                        continue block59;
                    }
                    case "dcmEntity": {
                        upsOnUPSCompleted.setScopeOfAccumulation(Entity.valueOf((String)reader.stringValue()));
                        continue block59;
                    }
                    case "dcmUPSScheduledWorkitemCode": {
                        upsOnUPSCompleted.setScheduledWorkitemCode(new Code(reader.stringValue()));
                        continue block59;
                    }
                    case "dcmUPSScheduledStationNameCode": {
                        upsOnUPSCompleted.setScheduledStationNames(reader.codeArray());
                        continue block59;
                    }
                    case "dcmUPSScheduledStationClassCode": {
                        upsOnUPSCompleted.setScheduledStationClasses(reader.codeArray());
                        continue block59;
                    }
                    case "dcmUPSScheduledStationLocationCode": {
                        upsOnUPSCompleted.setScheduledStationLocations(reader.codeArray());
                        continue block59;
                    }
                    case "dcmUPSScheduledHumanPerformerCode": {
                        upsOnUPSCompleted.setScheduledHumanPerformers(reader.codeArray());
                        continue block59;
                    }
                    case "dcmUPSScheduledHumanPerformerName": {
                        upsOnUPSCompleted.setScheduledHumanPerformerName(reader.stringValue());
                        continue block59;
                    }
                    case "dcmUPSScheduledHumanPerformerOrganization": {
                        upsOnUPSCompleted.setScheduledHumanPerformerOrganization(reader.stringValue());
                        continue block59;
                    }
                    case "dcmAdmissionID": {
                        upsOnUPSCompleted.setAdmissionID(reader.stringValue());
                        continue block59;
                    }
                    case "dicomIssuerOfAdmissionID": {
                        upsOnUPSCompleted.setIssuerOfAdmissionID(reader.issuerValue());
                        continue block59;
                    }
                    case "dcmUPSIncludeStudyInstanceUID": {
                        upsOnUPSCompleted.setIncludeStudyInstanceUID(reader.booleanValue());
                        continue block59;
                    }
                    case "dcmUPSIncludeReferencedRequest": {
                        upsOnUPSCompleted.setIncludeReferencedRequest(reader.booleanValue());
                        continue block59;
                    }
                    case "dcmURI": {
                        upsOnUPSCompleted.setXSLTStylesheetURI(reader.stringValue());
                        continue block59;
                    }
                    case "dcmNoKeywords": {
                        upsOnUPSCompleted.setNoKeywords(reader.booleanValue());
                        continue block59;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            upsOnUPSCompletedList.add(upsOnUPSCompleted);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadMWLIdleTimeout(Collection<MWLIdleTimeout> mwlIdleTimeouts, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            MWLIdleTimeout mwlIdleTimeout = new MWLIdleTimeout();
            block15: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "cn": {
                        mwlIdleTimeout.setCommonName(reader.stringValue());
                        continue block15;
                    }
                    case "dicomAETitle": {
                        mwlIdleTimeout.setAETitle(reader.stringValue());
                        continue block15;
                    }
                    case "dcmMWLStatusOnIdle": {
                        mwlIdleTimeout.setStatusOnIdle(SPSStatus.valueOf((String)reader.stringValue()));
                        continue block15;
                    }
                    case "dcmDuration": {
                        mwlIdleTimeout.setIdleTimeout(Duration.valueOf((String)reader.stringValue()));
                        continue block15;
                    }
                    case "dcmAETitle": {
                        mwlIdleTimeout.setScheduledStationAETitles(reader.stringArray());
                        continue block15;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            mwlIdleTimeouts.add(mwlIdleTimeout);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadMWLImport(Collection<MWLImport> mwlImports, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            MWLImport mwlImport = new MWLImport();
            block25: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmMWLImportID": {
                        mwlImport.setMWLImportID(reader.stringValue());
                        continue block25;
                    }
                    case "dicomAETitle": {
                        mwlImport.setAETitle(reader.stringValue());
                        continue block25;
                    }
                    case "dcmMergeMWLSCP": {
                        mwlImport.setMWLSCP(reader.stringValue());
                        continue block25;
                    }
                    case "dcmMWLWorklistLabel": {
                        mwlImport.setMWLWorklistLabel(reader.stringValue());
                        continue block25;
                    }
                    case "dcmDuration": {
                        mwlImport.setPrefetchBefore(Duration.valueOf((String)reader.stringValue()));
                        continue block25;
                    }
                    case "dcmMWLImportNotOlder": {
                        mwlImport.setNotOlderThan(Duration.valueOf((String)reader.stringValue()));
                        continue block25;
                    }
                    case "dcmMWLImportFilterBySCU": {
                        mwlImport.setFilterBySCU(reader.booleanValue());
                        continue block25;
                    }
                    case "dcmMWLImportDeleteNotFound": {
                        mwlImport.setDeleteNotFound(reader.booleanValue());
                        continue block25;
                    }
                    case "dcmIncludeField": {
                        mwlImport.setIncludeFields(reader.stringArray());
                        continue block25;
                    }
                    case "dcmProperty": {
                        mwlImport.setFilter(reader.stringArray());
                        continue block25;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            mwlImports.add(mwlImport);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    public boolean loadApplicationEntityExtension(Device device, ApplicationEntity ae, JsonReader reader, ConfigurationDelegate config) {
        if (!reader.getString().equals("dcmArchiveNetworkAE")) {
            return false;
        }
        reader.next();
        reader.expect(JsonParser.Event.START_OBJECT);
        ArchiveAEExtension arcAE = new ArchiveAEExtension();
        this.loadFrom(arcAE, reader, config);
        ae.addAEExtension((AEExtension)arcAE);
        reader.expect(JsonParser.Event.END_OBJECT);
        return true;
    }

    private void loadFrom(ArchiveAEExtension arcAE, JsonReader reader, ConfigurationDelegate config) {
        block254: while (reader.next() == JsonParser.Event.KEY_NAME) {
            switch (reader.getString()) {
                case "dcmObjectStorageID": {
                    arcAE.setObjectStorageIDs(reader.stringArray());
                    continue block254;
                }
                case "dcmObjectStorageCount": {
                    arcAE.setObjectStorageCount(reader.intValue());
                    continue block254;
                }
                case "dcmMetadataStorageID": {
                    arcAE.setMetadataStorageIDs(reader.stringArray());
                    continue block254;
                }
                case "dcmBulkDataDescriptorID": {
                    arcAE.setBulkDataDescriptorID(reader.stringValue());
                    continue block254;
                }
                case "dcmSeriesMetadataDelay": {
                    arcAE.setSeriesMetadataDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmPurgeInstanceRecordsDelay": {
                    arcAE.setPurgeInstanceRecordsDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmStoreAccessControlID": {
                    arcAE.setStoreAccessControlID(reader.stringValue());
                    continue block254;
                }
                case "dcmAccessControlID": {
                    arcAE.setAccessControlIDs(reader.stringArray());
                    continue block254;
                }
                case "dcmOverwritePolicy": {
                    arcAE.setOverwritePolicy(OverwritePolicy.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmRecordAttributeModification": {
                    arcAE.setRecordAttributeModification(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmQueryRetrieveViewID": {
                    arcAE.setQueryRetrieveViewID(reader.stringValue());
                    continue block254;
                }
                case "dcmBulkDataSpoolDirectory": {
                    arcAE.setBulkDataSpoolDirectory(reader.stringValue());
                    continue block254;
                }
                case "dcmHideSPSWithStatusFromMWL": {
                    arcAE.setHideSPSWithStatusFromMWL((SPSStatus[])reader.enumArray(SPSStatus.class));
                    continue block254;
                }
                case "dcmHideSPSWithStatusFromMWLRS": {
                    arcAE.setHideSPSWithStatusFromMWLRS((SPSStatus[])reader.enumArray(SPSStatus.class));
                    continue block254;
                }
                case "dcmMWLAccessionNumberGenerator": {
                    arcAE.setMWLAccessionNumberGenerator(reader.stringValue());
                    continue block254;
                }
                case "dcmMWLRequestedProcedureIDGenerator": {
                    arcAE.setMWLRequestedProcedureIDGenerator(reader.stringValue());
                    continue block254;
                }
                case "dcmMWLScheduledProcedureStepIDGenerator": {
                    arcAE.setMWLScheduledProcedureStepIDGenerator(reader.stringValue());
                    continue block254;
                }
                case "dcmEncodeAsJSONNumber": {
                    arcAE.setEncodeAsJSONNumber((VR[])reader.enumArray(VR.class));
                    continue block254;
                }
                case "dcmPersonNameComponentOrderInsensitiveMatching": {
                    arcAE.setPersonNameComponentOrderInsensitiveMatching(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmSendPendingCGet": {
                    arcAE.setSendPendingCGet(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmSendPendingCMoveInterval": {
                    arcAE.setSendPendingCMoveInterval(Duration.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmWadoZIPEntryNameFormat": {
                    arcAE.setWadoZIPEntryNameFormat(reader.stringValue());
                    continue block254;
                }
                case "dcmWadoSR2HtmlTemplateURI": {
                    arcAE.setWadoSR2HtmlTemplateURI(reader.stringValue());
                    continue block254;
                }
                case "dcmWadoSR2TextTemplateURI": {
                    arcAE.setWadoSR2TextTemplateURI(reader.stringValue());
                    continue block254;
                }
                case "dcmWadoCDA2HtmlTemplateURI": {
                    arcAE.setWadoCDA2HtmlTemplateURI(reader.stringValue());
                    continue block254;
                }
                case "dcmWadoThumbnailViewport": {
                    arcAE.setWadoThumbnailViewPort(reader.stringValue());
                    continue block254;
                }
                case "dcmFallbackWadoURIWebAppName": {
                    arcAE.setFallbackWadoURIWebApplication(reader.stringValue());
                    continue block254;
                }
                case "dcmFallbackWadoURIHttpStatusCode": {
                    arcAE.setFallbackWadoURIHttpStatusCode(Integer.valueOf(reader.intValue()));
                    continue block254;
                }
                case "dcmWadoIgnorePresentationLUTShape": {
                    arcAE.setWadoIgnorePresentationLUTShape(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmWadoMetadataExcludePrivate": {
                    arcAE.setWadoMetadataWithoutPrivate(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmQueryMaxNumberOfResults": {
                    arcAE.setQueryMaxNumberOfResults(Integer.valueOf(reader.intValue()));
                    continue block254;
                }
                case "dcmQidoMaxNumberOfResults": {
                    arcAE.setQidoMaxNumberOfResults(Integer.valueOf(reader.intValue()));
                    continue block254;
                }
                case "dcmQidoETag": {
                    arcAE.setQidoETag(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmFwdMppsDestination": {
                    arcAE.setMppsForwardDestinations(reader.stringArray());
                    continue block254;
                }
                case "dcmIanDestination": {
                    arcAE.setIanDestinations(reader.stringArray());
                    continue block254;
                }
                case "dcmIanDelay": {
                    arcAE.setIanDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmIanTimeout": {
                    arcAE.setIanTimeout(Duration.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmIanOnTimeout": {
                    arcAE.setIanOnTimeout(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmSpanningCFindSCP": {
                    arcAE.setSpanningCFindSCP(reader.stringValue());
                    continue block254;
                }
                case "dcmSpanningCFindSCPRetrieveAET": {
                    arcAE.setSpanningCFindSCPRetrieveAETitles(reader.stringArray());
                    continue block254;
                }
                case "dcmSpanningCFindSCPPolicy": {
                    arcAE.setSpanningCFindSCPPolicy(SpanningCFindSCPPolicy.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmFallbackCMoveSCP": {
                    arcAE.setFallbackCMoveSCP(reader.stringValue());
                    continue block254;
                }
                case "dcmFallbackCMoveSCPDestination": {
                    arcAE.setFallbackCMoveSCPDestination(reader.stringValue());
                    continue block254;
                }
                case "dcmFallbackCMoveSCPCallingAET": {
                    arcAE.setFallbackCMoveSCPCallingAET(reader.stringValue());
                    continue block254;
                }
                case "dcmFallbackCMoveSCPRetries": {
                    arcAE.setFallbackCMoveSCPRetries(Integer.valueOf(reader.intValue()));
                    continue block254;
                }
                case "dcmFallbackCMoveSCPLeadingCFindSCP": {
                    arcAE.setFallbackCMoveSCPLeadingCFindSCP(reader.stringValue());
                    continue block254;
                }
                case "dcmAltCMoveSCP": {
                    arcAE.setAlternativeCMoveSCP(reader.stringValue());
                    continue block254;
                }
                case "dcmFallbackCMoveSCPStudyOlderThan": {
                    arcAE.setFallbackCMoveSCPStudyOlderThan(reader.stringValue());
                    continue block254;
                }
                case "dcmStorePermissionServiceURL": {
                    arcAE.setStorePermissionServiceURL(reader.stringValue());
                    continue block254;
                }
                case "dcmStorePermissionServiceResponse": {
                    arcAE.setStorePermissionServiceResponse(reader.stringValue());
                    continue block254;
                }
                case "dcmStorePermissionServiceResponsePattern": {
                    arcAE.setStorePermissionServiceResponsePattern(Pattern.compile(reader.stringValue()));
                    continue block254;
                }
                case "dcmAllowRejectionForDataRetentionPolicyExpired": {
                    arcAE.setAllowRejectionForDataRetentionPolicyExpired(AllowRejectionForDataRetentionPolicyExpired.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmAcceptedUserRole": {
                    arcAE.setAcceptedUserRoles(reader.stringArray());
                    continue block254;
                }
                case "dcmAcceptMissingPatientID": {
                    arcAE.setAcceptMissingPatientID(AcceptMissingPatientID.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmAllowDeleteStudyPermanently": {
                    arcAE.setAllowDeleteStudyPermanently(AllowDeleteStudyPermanently.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmAllowDeletePatient": {
                    arcAE.setAllowDeletePatient(AllowDeletePatient.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmStorePermissionServiceExpirationDatePattern": {
                    arcAE.setStorePermissionServiceExpirationDatePattern(Pattern.compile(reader.stringValue()));
                    continue block254;
                }
                case "dcmDefaultCharacterSet": {
                    arcAE.setDefaultCharacterSet(reader.stringValue());
                    continue block254;
                }
                case "dcmMWLWorklistLabel": {
                    arcAE.setMWLWorklistLabel(reader.stringValue());
                    continue block254;
                }
                case "dcmUPSWorklistLabel": {
                    arcAE.setUPSWorklistLabel(reader.stringValue());
                    continue block254;
                }
                case "dcmUPSEventSCU": {
                    arcAE.setUPSEventSCUs(reader.stringArray());
                    continue block254;
                }
                case "dcmUPSEventSCUKeepAlive": {
                    arcAE.setUPSEventSCUKeepAlive(reader.intValue());
                    continue block254;
                }
                case "dcmStorePermissionServiceErrorCommentPattern": {
                    arcAE.setStorePermissionServiceErrorCommentPattern(Pattern.compile(reader.stringValue()));
                    continue block254;
                }
                case "dcmStorePermissionServiceErrorCodePattern": {
                    arcAE.setStorePermissionServiceErrorCodePattern(Pattern.compile(reader.stringValue()));
                    continue block254;
                }
                case "dcmRetrieveAET": {
                    arcAE.setRetrieveAETitles(reader.stringArray());
                    continue block254;
                }
                case "dcmReturnRetrieveAET": {
                    arcAE.setReturnRetrieveAETitles(reader.stringArray());
                    continue block254;
                }
                case "dcmMultipleStoreAssociations": {
                    arcAE.setMultipleStoreAssociations(reader.stringArray());
                    continue block254;
                }
                case "dcmExternalRetrieveAEDestination": {
                    arcAE.setExternalRetrieveAEDestination(reader.stringValue());
                    continue block254;
                }
                case "dcmAcceptedMoveDestination": {
                    arcAE.setAcceptedMoveDestinations(reader.stringArray());
                    continue block254;
                }
                case "dcmValidateCallingAEHostname": {
                    arcAE.setValidateCallingAEHostname(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "hl7PSUSendingApplication": {
                    arcAE.setHL7PSUSendingApplication(reader.stringValue());
                    continue block254;
                }
                case "hl7PSUReceivingApplication": {
                    arcAE.setHL7PSUReceivingApplications(reader.stringArray());
                    continue block254;
                }
                case "hl7PSUDelay": {
                    arcAE.setHL7PSUDelay(Duration.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "hl7PSUTimeout": {
                    arcAE.setHL7PSUTimeout(Duration.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "hl7PSUOnTimeout": {
                    arcAE.setHL7PSUOnTimeout(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "hl7PSUMWL": {
                    arcAE.setHL7PSUMWL(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "hl7PSUMWLMatchingKey": {
                    arcAE.setHL7PSUMWLMatchingKey(HL7PSUMWLMatchingKey.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "hl7PSUForRequestedProcedure": {
                    arcAE.setHl7PSUForRequestedProcedure(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "hl7PSUPIDPV1": {
                    arcAE.setHl7PSUPIDPV1(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "hl7PSURequestedProcedureID": {
                    arcAE.setHl7PSURequestedProcedureID(reader.stringValue());
                    continue block254;
                }
                case "hl7PSUAccessionNumber": {
                    arcAE.setHl7PSUAccessionNumber(reader.stringValue());
                    continue block254;
                }
                case "hl7PSUFillerOrderNumber": {
                    arcAE.setHl7PSUFillerOrderNumber(reader.stringValue());
                    continue block254;
                }
                case "hl7PSUPlacerOrderNumber": {
                    arcAE.setHl7PSUPlacerOrderNumber(reader.stringValue());
                    continue block254;
                }
                case "hl7PSUTemplateParam": {
                    arcAE.setHL7PSUTemplateParams(reader.stringArray());
                    continue block254;
                }
                case "hl7PSUMessageType": {
                    arcAE.setHl7PSUMessageType(HL7PSUMessageType.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "hl7PSUCondition": {
                    arcAE.setHl7PSUConditions(new Conditions(reader.stringArray()));
                    continue block254;
                }
                case "hl7PSUMppsTemplateURI": {
                    arcAE.setHl7PSUMppsTemplateURI(reader.stringValue());
                    continue block254;
                }
                case "hl7PSUStudyTemplateURI": {
                    arcAE.setHl7PSUStudyTemplateURI(reader.stringValue());
                    continue block254;
                }
                case "dcmAcceptConflictingPatientID": {
                    arcAE.setAcceptConflictingPatientID(AcceptConflictingPatientID.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmCopyMoveUpdatePolicy": {
                    arcAE.setCopyMoveUpdatePolicy(Attributes.UpdatePolicy.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmLinkMWLEntryUpdatePolicy": {
                    arcAE.setLinkMWLEntryUpdatePolicy(Attributes.UpdatePolicy.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmStorageVerificationPolicy": {
                    arcAE.setStorageVerificationPolicy(StorageVerificationPolicy.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmStorageVerificationUpdateLocationStatus": {
                    arcAE.setStorageVerificationUpdateLocationStatus(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmStorageVerificationStorageID": {
                    arcAE.setStorageVerificationStorageIDs(reader.stringArray());
                    continue block254;
                }
                case "dcmStorageVerificationInitialDelay": {
                    arcAE.setStorageVerificationInitialDelay(Period.parse(reader.stringValue()));
                    continue block254;
                }
                case "dcmUpdateLocationStatusOnRetrieve": {
                    arcAE.setUpdateLocationStatusOnRetrieve(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmStorageVerificationOnRetrieve": {
                    arcAE.setStorageVerificationOnRetrieve(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmRejectConflictingPatientAttribute": {
                    arcAE.setRejectConflictingPatientAttribute(TagUtils.fromHexStrings((String[])reader.stringArray()));
                    continue block254;
                }
                case "dcmRelationalQueryNegotiationLenient": {
                    arcAE.setRelationalQueryNegotiationLenient(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmRelationalRetrieveNegotiationLenient": {
                    arcAE.setRelationalRetrieveNegotiationLenient(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmStowRetiredTransferSyntax": {
                    arcAE.setStowRetiredTransferSyntax(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmStowExcludeAPPMarkers": {
                    arcAE.setStowExcludeAPPMarkers(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmRestrictRetrieveSilently": {
                    arcAE.setRestrictRetrieveSilently(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmStowQuicktime2MP4": {
                    arcAE.setStowQuicktime2MP4(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmStowMaxFragmentLength": {
                    arcAE.setStowMaxFragmentLength(Long.valueOf(reader.longValue()));
                    continue block254;
                }
                case "dcmRetrieveTaskWarningOnNoMatch": {
                    arcAE.setRetrieveTaskWarningOnNoMatch(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmRetrieveTaskWarningOnWarnings": {
                    arcAE.setRetrieveTaskWarningOnWarnings(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmUserIdentityNegotiation": {
                    arcAE.setUserIdentityNegotiation(UserIdentityNegotiation.valueOf((String)reader.stringValue()));
                    continue block254;
                }
                case "dcmUserIdentityNegotiationRole": {
                    arcAE.setUserIdentityNegotiationRole(reader.stringValue());
                    continue block254;
                }
                case "dcmUserIdentityNegotiationKeycloakClientID": {
                    arcAE.setUserIdentityNegotiationKeycloakClientID(reader.stringValue());
                    continue block254;
                }
                case "dcmChangeRequesterAET": {
                    arcAE.setChangeRequesterAET(reader.stringValue());
                    continue block254;
                }
                case "dcmFilterByIssuerOfPatientID": {
                    arcAE.setFilterByIssuerOfPatientID(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmMatchSOPClassOnInstanceLevel": {
                    arcAE.setMatchSOPClassOnInstanceLevel(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmUPSUpdateWithoutTransactionUID": {
                    arcAE.setUPSUpdateWithoutTransactionUID(Boolean.valueOf(reader.booleanValue()));
                    continue block254;
                }
                case "dcmExportRule": {
                    this.loadExportRule(arcAE.getExportRules(), reader);
                    continue block254;
                }
                case "dcmExportPriorsRule": {
                    this.loadExportPriorsRules(arcAE.getExportPriorsRules(), reader);
                    continue block254;
                }
                case "dcmMPPSForwardRule": {
                    this.loadMPPSForwardRule(arcAE.getMPPSForwardRules(), reader);
                    continue block254;
                }
                case "dcmArchiveCompressionRule": {
                    this.loadArchiveCompressionRule(arcAE.getCompressionRules(), reader);
                    continue block254;
                }
                case "dcmStoreAccessControlIDRule": {
                    this.loadStoreAccessControlIDRule(arcAE.getStoreAccessControlIDRules(), reader);
                    continue block254;
                }
                case "dcmArchiveAttributeCoercion": {
                    this.loadArchiveAttributeCoercion(arcAE.getAttributeCoercions(), reader, config);
                    continue block254;
                }
                case "dcmArchiveAttributeCoercion2": {
                    this.loadArchiveAttributeCoercion2(arcAE.getAttributeCoercions2(), reader, config);
                    continue block254;
                }
                case "dcmStudyRetentionPolicy": {
                    this.loadStudyRetentionPolicy(arcAE.getStudyRetentionPolicies(), reader);
                    continue block254;
                }
                case "dcmRSForwardRule": {
                    JsonArchiveConfiguration.loadRSForwardRules(arcAE.getRSForwardRules(), reader);
                    continue block254;
                }
                case "dcmUPSOnStore": {
                    this.loadUPSOnStoreList(arcAE.listUPSOnStore(), reader);
                    continue block254;
                }
                case "dcmUPSOnUPSCompleted": {
                    this.loadUPSOnUPSCompletedList(arcAE.listUPSOnUPSCompleted(), reader);
                    continue block254;
                }
            }
            reader.skipUnknownProperty();
        }
    }
}

