/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.dcm4che3.data.Code;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.InputReadinessState;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.conf.UPSPriority;

public class UPSProcessingRule {
    public static final Duration DEFAULT_RETRY_DELAY = Duration.valueOf("PT1M");
    public static final Code DEFAULT_PERFORMED_WORKITEM_CODE = new Code("NO_WORKITEM_CODE", "99DCM4CHEE", null, "No Workitem Code specified");
    public static final Code DEFAULT_PERFORMED_STATION_NAME_CODE = new Code("NO_STATION_NAME", "99DCM4CHEE", null, "No Station Name specified");
    private String upsProcessingRuleID;
    private URI upsProcessorURI;
    private UPSPriority upsPriority;
    private InputReadinessState inputReadinessState = InputReadinessState.READY;
    private String procedureStepLabel;
    private String worklistLabel;
    private Code scheduledWorkitemCode;
    private Code scheduledStationName;
    private Code scheduledStationClass;
    private Code scheduledStationLocation;
    private Code performedWorkitemCode = DEFAULT_PERFORMED_WORKITEM_CODE;
    private Code performedStationNameCode = DEFAULT_PERFORMED_STATION_NAME_CODE;
    private Code[] rescheduleDiscontinuationReasonCodes = new Code[0];
    private Code[] ignoreDiscontinuationReasonCodes = new Code[0];
    private String aeTitle;
    private int maxThreads = 1;
    private int maxRetries = 0;
    private Duration retryDelay = DEFAULT_RETRY_DELAY;
    private Duration maxRetryDelay;
    private int retryDelayMultiplier = 100;
    private ScheduleExpression[] schedules = new ScheduleExpression[0];
    private final Map<String, String> properties = new HashMap<String, String>();
    private String upsTemplateID;

    public UPSProcessingRule() {
    }

    public UPSProcessingRule(String upsProcessingRuleID) {
        this.setUPSProcessingRuleID(upsProcessingRuleID);
    }

    public String getUPSProcessingRuleID() {
        return this.upsProcessingRuleID;
    }

    public void setUPSProcessingRuleID(String UPSProcessingRuleID) {
        this.upsProcessingRuleID = UPSProcessingRuleID;
    }

    public URI getUPSProcessorURI() {
        return this.upsProcessorURI;
    }

    public void setUPSProcessorURI(URI upsProcessorURI) {
        this.upsProcessorURI = upsProcessorURI;
    }

    public UPSPriority getUPSPriority() {
        return this.upsPriority;
    }

    public void setUPSPriority(UPSPriority upsPriority) {
        this.upsPriority = upsPriority;
    }

    public InputReadinessState getInputReadinessState() {
        return this.inputReadinessState;
    }

    public void setInputReadinessState(InputReadinessState inputReadinessState) {
        this.inputReadinessState = inputReadinessState;
    }

    public String getProcedureStepLabel() {
        return this.procedureStepLabel;
    }

    public void setProcedureStepLabel(String procedureStepLabel) {
        this.procedureStepLabel = procedureStepLabel;
    }

    public String getWorklistLabel() {
        return this.worklistLabel;
    }

    public void setWorklistLabel(String worklistLabel) {
        this.worklistLabel = worklistLabel;
    }

    public Code getScheduledWorkitemCode() {
        return this.scheduledWorkitemCode;
    }

    public void setScheduledWorkitemCode(Code scheduledWorkitemCode) {
        this.scheduledWorkitemCode = scheduledWorkitemCode;
    }

    public Code getScheduledStationName() {
        return this.scheduledStationName;
    }

    public void setScheduledStationName(Code scheduledStationName) {
        this.scheduledStationName = scheduledStationName;
    }

    public Code getScheduledStationClass() {
        return this.scheduledStationClass;
    }

    public void setScheduledStationClass(Code scheduledStationClass) {
        this.scheduledStationClass = scheduledStationClass;
    }

    public Code getScheduledStationLocation() {
        return this.scheduledStationLocation;
    }

    public void setScheduledStationLocation(Code scheduledStationLocation) {
        this.scheduledStationLocation = scheduledStationLocation;
    }

    public Code getPerformedWorkitemCode() {
        return this.performedWorkitemCode;
    }

    public void setPerformedWorkitemCode(Code performedWorkitemCode) {
        this.performedWorkitemCode = Objects.requireNonNull(performedWorkitemCode);
    }

    public Code getPerformedStationNameCode() {
        return this.performedStationNameCode;
    }

    public void setPerformedStationNameCode(Code performedStationNameCode) {
        this.performedStationNameCode = performedStationNameCode;
    }

    public Code[] getRescheduleDiscontinuationReasonCodes() {
        return this.rescheduleDiscontinuationReasonCodes;
    }

    public void setRescheduleDiscontinuationReasonCodes(Code[] rescheduleDiscontinuationReasonCodes) {
        this.rescheduleDiscontinuationReasonCodes = rescheduleDiscontinuationReasonCodes;
    }

    public boolean isRescheduleDiscontinuationReasonCodes(Code code) {
        return this.rescheduleDiscontinuationReasonCodes.length == 0 || Stream.of(this.rescheduleDiscontinuationReasonCodes).anyMatch(ignore -> ignore.equalsIgnoreMeaning(code));
    }

    public Code[] getIgnoreDiscontinuationReasonCodes() {
        return this.ignoreDiscontinuationReasonCodes;
    }

    public void setIgnoreDiscontinuationReasonCodes(Code[] ignoreDiscontinuationReasonCodes) {
        this.ignoreDiscontinuationReasonCodes = ignoreDiscontinuationReasonCodes;
    }

    public boolean isIgnoreDiscontinuationReasonCodes(Code code) {
        return this.rescheduleDiscontinuationReasonCodes.length > 0 && Stream.of(this.ignoreDiscontinuationReasonCodes).anyMatch(ignore -> ignore.equalsIgnoreMeaning(code));
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public long getRetryDelayInSeconds(int retry) {
        if (retry > this.maxRetries) {
            return -1L;
        }
        long delay = this.retryDelay.getSeconds();
        while (--retry > 0) {
            delay = delay * (long)this.retryDelayMultiplier / 100L;
        }
        return this.maxRetryDelay != null ? Math.min(delay, this.maxRetryDelay.getSeconds()) : delay;
    }

    public void setRetryDelay(Duration retryDelay) {
        this.retryDelay = Objects.requireNonNull(retryDelay, "RetryDelay");
    }

    public Duration getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public void setMaxRetryDelay(Duration maxRetryDelay) {
        this.maxRetryDelay = maxRetryDelay;
    }

    public int getRetryDelayMultiplier() {
        return this.retryDelayMultiplier;
    }

    public void setRetryDelayMultiplier(int retryDelayMultiplier) {
        this.retryDelayMultiplier = retryDelayMultiplier;
    }

    public ScheduleExpression[] getSchedules() {
        return this.schedules;
    }

    public void setSchedules(ScheduleExpression ... schedules) {
        this.schedules = schedules;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name, String defValue) {
        String value = this.properties.get(name);
        return value != null ? value : defValue;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(String[] ss) {
        this.properties.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Property in incorrect format : " + s);
            }
            this.setProperty(s.substring(0, index), s.substring(index + 1));
        }
    }

    public String getUpsTemplateID() {
        return this.upsTemplateID;
    }

    public void setUpsTemplateID(String upsTemplateID) {
        this.upsTemplateID = upsTemplateID;
    }

    public String toString() {
        return "UPSProcessingRule{cn='" + this.upsProcessingRuleID + "'}";
    }
}

