/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.DeleterThreshold;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.RetentionPeriod;
import org.dcm4chee.arc.conf.StorageDuration;
import org.dcm4chee.arc.conf.StorageThreshold;

public final class StorageDescriptor {
    private String storageID;
    private String storageURIStr;
    private URI storageURI;
    private String digestAlgorithm;
    private int maxRetries;
    private Duration retryDelay;
    private Availability instanceAvailability = Availability.ONLINE;
    private String storageClusterID;
    private String[] exportStorageID = new String[0];
    private String retrieveCacheStorageID;
    private int retrieveCacheStorageMaxParallel = 10;
    private int deleterThreads = 1;
    private String[] externalRetrieveAETitles = new String[0];
    private Availability externalRetrieveInstanceAvailability;
    private boolean readOnly;
    private boolean noDeletionConstraint;
    private boolean storageThresholdExceedsPermanently = true;
    private Date storageThresholdExceeded;
    private StorageDuration storageDuration = StorageDuration.PERMANENT;
    private StorageThreshold storageThreshold;
    private final ArrayList<DeleterThreshold> deleterThresholds = new ArrayList();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final EnumMap<RetentionPeriod.DeleteStudies, List<RetentionPeriod>> retentionPeriods = new EnumMap(RetentionPeriod.DeleteStudies.class);

    public StorageDescriptor() {
    }

    public StorageDescriptor(String storageID) {
        this.setStorageID(storageID);
    }

    public void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public String getStorageURIStr() {
        return this.storageURIStr;
    }

    public void setStorageURIStr(String str) {
        this.storageURI = URI.create(StringUtils.replaceSystemProperties((String)str));
        this.storageURIStr = str;
    }

    public URI getStorageURI() {
        return this.storageURI;
    }

    public boolean isTarArchiver() {
        return "tar".equals(this.properties.get("archiver"));
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        StorageDescriptor.getMessageDigest(digestAlgorithm);
        this.digestAlgorithm = digestAlgorithm;
    }

    public MessageDigest getMessageDigest() {
        return StorageDescriptor.getMessageDigest(this.digestAlgorithm);
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return algorithm != null ? MessageDigest.getInstance(algorithm) : null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm: " + algorithm);
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(Duration retryDelay) {
        this.retryDelay = retryDelay;
    }

    public Availability getInstanceAvailability() {
        return this.instanceAvailability;
    }

    public void setInstanceAvailability(Availability instanceAvailability) {
        this.instanceAvailability = instanceAvailability;
    }

    public String[] getExternalRetrieveAETitles() {
        return this.externalRetrieveAETitles;
    }

    public void setExternalRetrieveAETitles(String ... externalRetrieveAETitles) {
        this.externalRetrieveAETitles = externalRetrieveAETitles;
        Arrays.sort(externalRetrieveAETitles);
    }

    public Availability getExternalRetrieveInstanceAvailability() {
        return this.externalRetrieveInstanceAvailability;
    }

    public void setExternalRetrieveInstanceAvailability(Availability externalRetrieveInstanceAvailability) {
        this.externalRetrieveInstanceAvailability = externalRetrieveInstanceAvailability;
    }

    public String[] getExportStorageID() {
        return this.exportStorageID;
    }

    public void setExportStorageID(String ... exportStorageID) {
        this.exportStorageID = exportStorageID;
        Arrays.sort(exportStorageID);
    }

    public String getRetrieveCacheStorageID() {
        return this.retrieveCacheStorageID;
    }

    public void setRetrieveCacheStorageID(String retrieveCacheStorageID) {
        this.retrieveCacheStorageID = retrieveCacheStorageID;
    }

    public int getRetrieveCacheMaxParallel() {
        return this.retrieveCacheStorageMaxParallel;
    }

    public void setRetrieveCacheMaxParallel(int retrieveCacheStorageMaxParallel) {
        this.retrieveCacheStorageMaxParallel = retrieveCacheStorageMaxParallel;
    }

    public int getDeleterThreads() {
        return this.deleterThreads;
    }

    public void setDeleterThreads(int deleterThreads) {
        this.deleterThreads = deleterThreads;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isNoDeletionConstraint() {
        return this.noDeletionConstraint;
    }

    public void setNoDeletionConstraint(boolean noDeletionConstraint) {
        this.noDeletionConstraint = noDeletionConstraint;
    }

    public boolean isStorageThresholdExceedsPermanently() {
        return this.storageThresholdExceedsPermanently;
    }

    public void setStorageThresholdExceedsPermanently(boolean storageThresholdExceedsPermanently) {
        this.storageThresholdExceedsPermanently = storageThresholdExceedsPermanently;
    }

    public Date getStorageThresholdExceeded() {
        return this.storageThresholdExceeded;
    }

    public void setStorageThresholdExceeded(Date storageThresholdExceeded) {
        this.storageThresholdExceeded = storageThresholdExceeded;
    }

    public boolean isStorageThresholdExceeded() {
        return this.storageThresholdExceeded != null;
    }

    public StorageThreshold getStorageThreshold() {
        return this.storageThreshold;
    }

    public void setStorageThreshold(StorageThreshold storageThreshold) {
        this.storageThreshold = storageThreshold;
    }

    public boolean hasDeleterThresholds() {
        return !this.deleterThresholds.isEmpty();
    }

    public String[] getDeleterThresholdsAsStrings() {
        String[] ss = new String[this.deleterThresholds.size()];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.deleterThresholds.get(i).toString();
        }
        return ss;
    }

    public List<DeleterThreshold> getDeleterThresholds() {
        return this.deleterThresholds;
    }

    public void setDeleterThresholdsFromStrings(String ... ss) {
        this.deleterThresholds.clear();
        for (String s : ss) {
            this.deleterThresholds.add(DeleterThreshold.valueOf(s));
        }
        Collections.sort(this.deleterThresholds);
    }

    public long getDeleterThresholdMinUsableSpace(Calendar cal) {
        for (DeleterThreshold deleterThreshold : this.deleterThresholds) {
            if (!deleterThreshold.match(cal)) continue;
            return deleterThreshold.getMinUsableDiskSpace();
        }
        return -1L;
    }

    public boolean hasRetentionPeriods() {
        return !this.retentionPeriods.isEmpty();
    }

    public String[] getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies deleteStudies) {
        List<RetentionPeriod> retentionPeriods = this.retentionPeriods.get((Object)deleteStudies);
        return retentionPeriods == null ? StringUtils.EMPTY_STRING : (String[])retentionPeriods.stream().map(RetentionPeriod::toString).toArray(String[]::new);
    }

    public List<RetentionPeriod> getRetentionPeriods(RetentionPeriod.DeleteStudies deleteStudies) {
        return this.retentionPeriods.getOrDefault((Object)deleteStudies, Collections.emptyList());
    }

    public void setRetentionPeriods(RetentionPeriod.DeleteStudies deleteStudies, String ... ss) {
        if (ss.length == 0) {
            this.retentionPeriods.remove((Object)deleteStudies);
        } else {
            this.retentionPeriods.put(deleteStudies, Stream.of(ss).map(RetentionPeriod::valueOf).sorted().collect(Collectors.toList()));
        }
    }

    public Optional<Period> getRetentionPeriod(RetentionPeriod.DeleteStudies deleteStudies, Calendar cal) {
        List<RetentionPeriod> retentionPeriods = this.retentionPeriods.get((Object)deleteStudies);
        return retentionPeriods == null ? Optional.empty() : retentionPeriods.stream().filter(x -> x.match(cal)).map(RetentionPeriod::getPeriod).findFirst();
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name, String defValue) {
        String value = this.properties.get(name);
        return value != null ? value : defValue;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(String[] ss) {
        this.properties.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Property in incorrect format : " + s);
            }
            this.setProperty(s.substring(0, index), s.substring(index + 1));
        }
    }

    public StorageDuration getStorageDuration() {
        return this.storageDuration;
    }

    public void setStorageDuration(StorageDuration storageDuration) {
        this.storageDuration = storageDuration;
    }

    public String toString() {
        return "Storage[id=" + this.storageID + ", uri=" + this.storageURI + "]";
    }

    public String getStorageClusterID() {
        return this.storageClusterID;
    }

    public void setStorageClusterID(String storageClusterID) {
        this.storageClusterID = storageClusterID;
    }

    public List<String> getStudyStorageIDs(List<String> otherStorageIDsOfStorageCLuster, List<String> exportFromStorageIDs, Boolean storageClustered, Boolean storageExported) {
        String[][] combinations = new String[][]{{this.storageID}};
        if (!otherStorageIDsOfStorageCLuster.isEmpty() && (storageClustered == null || storageClustered.booleanValue())) {
            combinations = StorageDescriptor.join(combinations, StorageDescriptor.powerSetOf(storageClustered != null, otherStorageIDsOfStorageCLuster));
        }
        if (this.exportStorageID.length > 0 && (storageExported == null || storageExported.booleanValue())) {
            combinations = StorageDescriptor.join(combinations, StorageDescriptor.powerSetOf(storageExported != null, Arrays.asList(this.exportStorageID)));
        }
        if (!exportFromStorageIDs.isEmpty()) {
            combinations = StorageDescriptor.join(combinations, StorageDescriptor.powerSetOf(false, exportFromStorageIDs));
        }
        if (this.retrieveCacheStorageID != null && !exportFromStorageIDs.contains(this.retrieveCacheStorageID)) {
            combinations = StorageDescriptor.join(combinations, new String[][]{new String[0], {this.retrieveCacheStorageID}});
        }
        return StorageDescriptor.toStudyStorageIDs(combinations);
    }

    private static String[][] powerSetOf(boolean excludeEmptySet, List<String> storageIDs) {
        int skip = excludeEmptySet ? 1 : 0;
        String[][] result = new String[(1 << storageIDs.size()) - skip][];
        for (int i = 0; i < result.length; ++i) {
            int n = i + skip;
            result[i] = new String[Integer.bitCount(n)];
            int k = 0;
            for (int j = 0; j < storageIDs.size(); ++j) {
                if ((n & 1 << j) == 0) continue;
                result[i][k++] = storageIDs.get(j);
            }
        }
        return result;
    }

    private static String[][] join(String[][] a, String[][] b) {
        String[][] result = new String[a.length * b.length][];
        int k = 0;
        for (int i = 0; i < a.length; ++i) {
            int j = 0;
            while (j < b.length) {
                result[k] = new String[a[i].length + b[j].length];
                System.arraycopy(a[i], 0, result[k], 0, a[i].length);
                System.arraycopy(b[j], 0, result[k], a[i].length, b[j].length);
                ++j;
                ++k;
            }
        }
        return result;
    }

    private static List<String> toStudyStorageIDs(String[][] a) {
        String[] result = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            Arrays.sort(a[i]);
            result[i] = StringUtils.concat((String[])a[i], (char)'\\');
        }
        return Arrays.asList(result);
    }
}

