/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.dcm4chee.arc.conf.RSOperation;

public class RSForwardRule {
    public static final RSForwardRule[] EMPTY = new RSForwardRule[0];
    private String commonName;
    private String webAppName;
    private EnumSet<RSOperation> rsOperations = EnumSet.noneOf(RSOperation.class);
    private boolean ifNotIPAddressPattern;
    private Pattern ipAddressPattern;
    private boolean ifNotHostnamePattern;
    private Pattern hostnamePattern;
    private boolean ifNotRequestURLPattern;
    private Pattern requestURLPattern;
    private boolean tlsAllowAnyHostname;
    private boolean tlsDisableTrustManager;

    public RSForwardRule() {
    }

    public RSForwardRule(String commonName) {
        this.setCommonName(commonName);
    }

    public final String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public void setWebAppName(String webAppName) {
        this.webAppName = webAppName;
    }

    public RSOperation[] getRSOperations() {
        return this.rsOperations.toArray(new RSOperation[this.rsOperations.size()]);
    }

    public void setRSOperations(RSOperation[] rsOperations) {
        this.rsOperations.clear();
        this.rsOperations.addAll(Arrays.asList(rsOperations));
    }

    public boolean isTlsAllowAnyHostname() {
        return this.tlsAllowAnyHostname;
    }

    public void setTlsAllowAnyHostname(boolean tlsAllowAnyHostname) {
        this.tlsAllowAnyHostname = tlsAllowAnyHostname;
    }

    public boolean isTlsDisableTrustManager() {
        return this.tlsDisableTrustManager;
    }

    public void setTlsDisableTrustManager(boolean tlsDisableTrustManager) {
        this.tlsDisableTrustManager = tlsDisableTrustManager;
    }

    public String getRemoteHostnamePattern() {
        if (this.hostnamePattern == null) {
            return null;
        }
        String s = this.hostnamePattern.pattern();
        return this.ifNotHostnamePattern ? "!" + s : s;
    }

    public void setRemoteHostnamePattern(String hostnamePattern) {
        if (hostnamePattern == null || hostnamePattern.isEmpty()) {
            this.hostnamePattern = null;
            this.ifNotHostnamePattern = false;
        } else if (hostnamePattern.charAt(0) == '!') {
            this.hostnamePattern = Pattern.compile(hostnamePattern.substring(1));
            this.ifNotHostnamePattern = true;
        } else {
            this.hostnamePattern = Pattern.compile(hostnamePattern);
            this.ifNotHostnamePattern = false;
        }
    }

    public String getRemoteIPAddressPattern() {
        if (this.ipAddressPattern == null) {
            return null;
        }
        String s = this.ipAddressPattern.pattern();
        return this.ifNotIPAddressPattern ? "!" + s : s;
    }

    public void setRemoteIPAddressPattern(String ipAddressPattern) {
        if (ipAddressPattern == null || ipAddressPattern.isEmpty()) {
            this.ipAddressPattern = null;
            this.ifNotIPAddressPattern = false;
        } else if (ipAddressPattern.charAt(0) == '!') {
            this.ipAddressPattern = Pattern.compile(ipAddressPattern.substring(1));
            this.ifNotIPAddressPattern = true;
        } else {
            this.ipAddressPattern = Pattern.compile(ipAddressPattern);
            this.ifNotIPAddressPattern = false;
        }
    }

    public String getRequestURLPattern() {
        if (this.requestURLPattern == null) {
            return null;
        }
        String s = this.requestURLPattern.pattern();
        return this.ifNotRequestURLPattern ? "!" + s : s;
    }

    public void setRequestURLPattern(String requestURLPattern) {
        if (requestURLPattern == null || requestURLPattern.isEmpty()) {
            this.requestURLPattern = null;
            this.ifNotRequestURLPattern = false;
        } else if (requestURLPattern.charAt(0) == '!') {
            this.requestURLPattern = Pattern.compile(requestURLPattern.substring(1));
            this.ifNotRequestURLPattern = true;
        } else {
            this.requestURLPattern = Pattern.compile(requestURLPattern);
            this.ifNotRequestURLPattern = false;
        }
    }

    public boolean containsRSOperations(RSOperation rsOp) {
        return this.rsOperations.contains((Object)rsOp);
    }

    public boolean matchesRequest(HttpServletRequest request) {
        return RSForwardRule.matches(this.hostnamePattern, this.ifNotHostnamePattern, request.getRemoteHost()) && RSForwardRule.matches(this.ipAddressPattern, this.ifNotIPAddressPattern, request.getRemoteAddr()) && RSForwardRule.matches(this.requestURLPattern, this.ifNotRequestURLPattern, request.getRequestURL().toString());
    }

    private static boolean matches(Pattern pattern, boolean not, String value) {
        return pattern == null || pattern.matcher(value).matches() != not;
    }

    public String toString() {
        return "RSForwardRule{cn='" + this.commonName + "', webAppName='" + this.webAppName + "', ops=" + this.rsOperations + "}";
    }
}

