/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.conf.HL7Conditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7StudyRetentionPolicy {
    public static final HL7StudyRetentionPolicy[] EMPTY = new HL7StudyRetentionPolicy[0];
    private static final Logger LOG = LoggerFactory.getLogger(HL7StudyRetentionPolicy.class);
    private String commonName;
    private String aeTitle;
    private int priority;
    private HL7Conditions conditions = new HL7Conditions(new String[0]);
    private Period minRetentionPeriod;
    private Period maxRetentionPeriod;
    private boolean startRetentionPeriodOnStudyDate;
    private String exporterID;
    private boolean freezeExpirationDate;
    private boolean revokeExpiration;

    public HL7StudyRetentionPolicy() {
    }

    public HL7StudyRetentionPolicy(String commonName) {
        this.setCommonName(commonName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public HL7Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(HL7Conditions conditions) {
        this.conditions = conditions;
    }

    public Period getMinRetentionPeriod() {
        return this.minRetentionPeriod;
    }

    public void setMinRetentionPeriod(Period minRetentionPeriod) {
        this.minRetentionPeriod = minRetentionPeriod;
    }

    public Period getMaxRetentionPeriod() {
        return this.maxRetentionPeriod;
    }

    public void setMaxRetentionPeriod(Period maxRetentionPeriod) {
        this.maxRetentionPeriod = maxRetentionPeriod;
    }

    public boolean isStartRetentionPeriodOnStudyDate() {
        return this.startRetentionPeriodOnStudyDate;
    }

    public void setStartRetentionPeriodOnStudyDate(boolean startRetentionPeriodOnStudyDate) {
        this.startRetentionPeriodOnStudyDate = startRetentionPeriodOnStudyDate;
    }

    public String getExporterID() {
        return this.exporterID;
    }

    public void setExporterID(String exporterID) {
        this.exporterID = exporterID;
    }

    public boolean isFreezeExpirationDate() {
        return this.freezeExpirationDate;
    }

    public void setFreezeExpirationDate(boolean freezeExpirationDate) {
        this.freezeExpirationDate = freezeExpirationDate;
    }

    public boolean isRevokeExpiration() {
        return this.revokeExpiration;
    }

    public void setRevokeExpiration(boolean revokeExpiration) {
        this.revokeExpiration = revokeExpiration;
    }

    public LocalDate retentionStartDate(Attributes attrs) {
        String s;
        if (this.startRetentionPeriodOnStudyDate && (s = attrs.getString(524320)) != null) {
            try {
                return LocalDate.parse(s, DateTimeFormatter.BASIC_ISO_DATE);
            }
            catch (Exception e) {
                LOG.warn("Failed parsing study date to get retention start date." + e.getMessage());
            }
        }
        return LocalDate.now();
    }

    public boolean protectStudy() {
        return this.revokeExpiration && this.freezeExpirationDate;
    }

    public String toString() {
        return "HL7StudyRetentionPolicy{commonName='" + this.commonName + "', priority=" + this.priority + ", conditions=" + this.conditions + ", minRetentionPeriod=" + this.minRetentionPeriod + ", maxRetentionPeriod=" + this.maxRetentionPeriod + ", startRetentionPeriodOnStudyDate=" + this.startRetentionPeriodOnStudyDate + ", exporterID=" + this.exporterID + ", freezeExpirationDate=" + this.freezeExpirationDate + ", revokeExpiration=" + this.revokeExpiration + "}";
    }
}

