/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.EntitySelector;
import org.dcm4chee.arc.conf.HL7Conditions;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.NullifyIssuer;

public class HL7ExportRule {
    public static final HL7ExportRule[] EMPTY = new HL7ExportRule[0];
    private String commonName;
    private HL7Conditions conditions = new HL7Conditions(new String[0]);
    private String[] exporterIDs = new String[0];
    private Duration suppressDuplicateExportInterval;
    private int suppressDuplicateHistorySize = 100;
    private NullifyIssuer ignoreAssigningAuthorityOfPatientID;
    private Issuer[] assigningAuthorityOfPatientIDs = new Issuer[0];
    private Issuer prefetchForAssigningAuthorityOfPatientID;
    private EntitySelector[] entitySelectors = new EntitySelector[0];

    public HL7ExportRule() {
    }

    public HL7ExportRule(String commonName) {
        this.setCommonName(commonName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public HL7Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(HL7Conditions conditions) {
        this.conditions = conditions;
    }

    public String[] getExporterIDs() {
        return this.exporterIDs;
    }

    public void setExporterIDs(String[] exporterIDs) {
        this.exporterIDs = exporterIDs;
    }

    public Duration getSuppressDuplicateExportInterval() {
        return this.suppressDuplicateExportInterval;
    }

    public void setSuppressDuplicateExportInterval(Duration suppressDuplicateExportInterval) {
        this.suppressDuplicateExportInterval = suppressDuplicateExportInterval;
    }

    public int getSuppressDuplicateHistorySize() {
        return this.suppressDuplicateHistorySize;
    }

    public void setSuppressDuplicateHistorySize(int suppressDuplicateHistorySize) {
        this.suppressDuplicateHistorySize = suppressDuplicateHistorySize;
    }

    public NullifyIssuer getIgnoreAssigningAuthorityOfPatientID() {
        return this.ignoreAssigningAuthorityOfPatientID;
    }

    public void setIgnoreAssigningAuthorityOfPatientID(NullifyIssuer ignoreAssigningAuthorityOfPatientID) {
        this.ignoreAssigningAuthorityOfPatientID = ignoreAssigningAuthorityOfPatientID;
    }

    public Issuer[] getAssigningAuthorityOfPatientIDs() {
        return this.assigningAuthorityOfPatientIDs;
    }

    public void setAssigningAuthorityOfPatientIDs(Issuer[] assigningAuthorityOfPatientIDs) {
        this.assigningAuthorityOfPatientIDs = assigningAuthorityOfPatientIDs;
    }

    public boolean match(String hostName, HL7Fields hl7Fields) {
        return this.conditions.match(hostName, hl7Fields);
    }

    public IDWithIssuer ignoreAssigningAuthorityOfPatientID(IDWithIssuer pid) {
        return this.ignoreAssigningAuthorityOfPatientID != null && this.ignoreAssigningAuthorityOfPatientID.test(pid.getIssuer(), this.assigningAuthorityOfPatientIDs) ? pid.withoutIssuer() : pid;
    }

    public Issuer getPrefetchForAssigningAuthorityOfPatientID() {
        return this.prefetchForAssigningAuthorityOfPatientID;
    }

    public void setPrefetchForAssigningAuthorityOfPatientID(Issuer prefetchForAssigningAuthorityOfPatientID) {
        this.prefetchForAssigningAuthorityOfPatientID = prefetchForAssigningAuthorityOfPatientID;
    }

    public EntitySelector[] getEntitySelectors() {
        return this.entitySelectors;
    }

    public void setEntitySelectors(EntitySelector[] entitySelectors) {
        this.entitySelectors = entitySelectors;
    }

    public String toString() {
        return "HL7ExportRule{cn=" + this.commonName + ", conditions=" + this.conditions + ", exporterIDs=" + Arrays.toString(this.exporterIDs) + ", suppressDups=" + this.suppressDuplicateExportInterval + ", ignoreAssigningAuthorityOfPatientID=" + this.ignoreAssigningAuthorityOfPatientID + ", issuerOfPatientIDs=" + Arrays.toString(this.assigningAuthorityOfPatientIDs) + ", prefetchForAssigningAuthorityOfPatientID=" + this.prefetchForAssigningAuthorityOfPatientID + ", entitySelectors=" + Arrays.toString(this.entitySelectors) + "}";
    }
}

