/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.ScheduleExpression;

public class ExporterDescriptor {
    private String exporterID;
    private String description;
    private URI exportURI;
    private String queueName;
    private String aeTitle;
    private boolean exportAsSourceAE;
    private String[] ianDestinations = new String[0];
    private String[] retrieveAETitles = new String[0];
    private String retrieveLocationUID;
    private Availability instanceAvailability = Availability.ONLINE;
    private String stgCmtSCPAETitle;
    private String deleteStudyFromStorageID;
    private boolean rejectForDataRetentionExpiry;
    private ScheduleExpression[] schedules = new ScheduleExpression[0];
    private final Map<String, String> properties = new HashMap<String, String>();

    public ExporterDescriptor() {
    }

    public ExporterDescriptor(String exporterID) {
        this.exporterID = exporterID;
    }

    public ExporterDescriptor(String exporterID, URI exportURI) {
        this.exporterID = exporterID;
        this.exportURI = exportURI;
    }

    public String getExporterID() {
        return this.exporterID;
    }

    public void setExporterID(String exporterID) {
        this.exporterID = exporterID;
    }

    public URI getExportURI() {
        return this.exportURI;
    }

    public void setExportURI(URI exportURI) {
        this.exportURI = exportURI;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public boolean isExportAsSourceAE() {
        return this.exportAsSourceAE;
    }

    public void setExportAsSourceAE(boolean exportAsSourceAE) {
        this.exportAsSourceAE = exportAsSourceAE;
    }

    public String getStgCmtSCPAETitle() {
        return this.stgCmtSCPAETitle;
    }

    public void setStgCmtSCPAETitle(String stgCmtSCPAETitle) {
        this.stgCmtSCPAETitle = stgCmtSCPAETitle;
    }

    public String getDeleteStudyFromStorageID() {
        return this.deleteStudyFromStorageID;
    }

    public void setDeleteStudyFromStorageID(String deleteStudyFromStorageID) {
        this.deleteStudyFromStorageID = deleteStudyFromStorageID;
    }

    public String[] getIanDestinations() {
        return this.ianDestinations;
    }

    public void setIanDestinations(String ... ianDestinations) {
        this.ianDestinations = ianDestinations;
    }

    public String[] getRetrieveAETitles() {
        return this.retrieveAETitles;
    }

    public void setRetrieveAETitles(String ... retrieveAETitles) {
        this.retrieveAETitles = retrieveAETitles;
    }

    public String getRetrieveLocationUID() {
        return this.retrieveLocationUID;
    }

    public void setRetrieveLocationUID(String retrieveLocationUID) {
        this.retrieveLocationUID = retrieveLocationUID;
    }

    public Availability getInstanceAvailability() {
        return this.instanceAvailability;
    }

    public void setInstanceAvailability(Availability instanceAvailability) {
        this.instanceAvailability = instanceAvailability;
    }

    public boolean isRejectForDataRetentionExpiry() {
        return this.rejectForDataRetentionExpiry;
    }

    public void setRejectForDataRetentionExpiry(boolean rejectForDataRetentionExpiry) {
        this.rejectForDataRetentionExpiry = rejectForDataRetentionExpiry;
    }

    public ScheduleExpression[] getSchedules() {
        return this.schedules;
    }

    public void setSchedules(ScheduleExpression ... schedules) {
        this.schedules = schedules;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name, String defValue) {
        String value = this.properties.get(name);
        return value != null ? value : defValue;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(String[] ss) {
        this.properties.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Property in incorrect format : " + s);
            }
            this.setProperty(s.substring(0, index), s.substring(index + 1));
        }
    }

    public String toString() {
        return "ExporterDescriptor{exporterID=" + this.exporterID + ", exportURI=" + this.exportURI + ", queueName=" + this.queueName + ", aeTitle=" + this.aeTitle + ", exportAsSourceAE=" + this.exportAsSourceAE + ", stgCmtSCPAETitle=" + this.stgCmtSCPAETitle + ", deleteStudyFromStorageID=" + this.deleteStudyFromStorageID + ", ianDests=" + Arrays.toString(this.ianDestinations) + ", retrieveAETs=" + Arrays.toString(this.retrieveAETitles) + ", retrieveLocationUID=" + this.retrieveLocationUID + ", availability=" + this.instanceAvailability + ", schedules=" + Arrays.toString(this.schedules) + ", properties=" + this.properties + "}";
    }
}

