/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import java.util.Calendar;
import java.util.function.Predicate;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.EntitySelector;
import org.dcm4chee.arc.conf.ExportReoccurredInstances;
import org.dcm4chee.arc.conf.ScheduleExpression;

public class ExportPriorsRule {
    public static final ExportPriorsRule[] EMPTY = new ExportPriorsRule[0];
    private String commonName;
    private ScheduleExpression[] schedules = new ScheduleExpression[0];
    private Conditions conditions = new Conditions(new String[0]);
    private String[] exporterIDs = new String[0];
    private Duration suppressDuplicateExportInterval;
    private EntitySelector[] entitySelectors = new EntitySelector[0];
    private ExportReoccurredInstances exportReoccurredInstances = ExportReoccurredInstances.REPLACE;

    public ExportPriorsRule() {
    }

    public ExportPriorsRule(String commonName) {
        this.setCommonName(commonName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public ScheduleExpression[] getSchedules() {
        return this.schedules;
    }

    public void setSchedules(ScheduleExpression[] schedules) {
        this.schedules = schedules;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public String[] getExporterIDs() {
        return this.exporterIDs;
    }

    public void setExporterIDs(String[] exporterIDs) {
        this.exporterIDs = exporterIDs;
    }

    public Duration getSuppressDuplicateExportInterval() {
        return this.suppressDuplicateExportInterval;
    }

    public void setSuppressDuplicateExportInterval(Duration suppressDuplicateExportInterval) {
        this.suppressDuplicateExportInterval = suppressDuplicateExportInterval;
    }

    public EntitySelector[] getEntitySelectors() {
        return this.entitySelectors;
    }

    public void setEntitySelectors(EntitySelector[] entitySelectors) {
        this.entitySelectors = entitySelectors;
    }

    public ExportReoccurredInstances getExportReoccurredInstances() {
        return this.exportReoccurredInstances;
    }

    public void setExportReoccurredInstances(ExportReoccurredInstances exportReoccurredInstances) {
        this.exportReoccurredInstances = exportReoccurredInstances;
    }

    public boolean match(Predicate<ExportReoccurredInstances> predicate, Calendar now, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs) {
        return predicate.test(this.exportReoccurredInstances) && ScheduleExpression.emptyOrAnyContains(now, this.schedules) && this.conditions.match(sendingHost, sendingAET, receivingHost, receivingAET, attrs);
    }

    public String toString() {
        return "ExportPriorsRule{cn=" + this.commonName + ", conditions=" + this.conditions + ", schedules=" + Arrays.toString(this.schedules) + ", exporterIDs=" + Arrays.toString(this.exporterIDs) + ", suppressDups=" + this.suppressDuplicateExportInterval + ", entitySelectors=" + Arrays.toString(this.entitySelectors) + ", exportReoccurredInstances=" + this.exportReoccurredInstances + "}";
    }
}

