/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

public enum BinaryPrefix {
    K(1000, 1),
    k(1000, 1),
    M(1000, 2),
    G(1000, 3),
    T(1000, 4),
    P(1000, 5),
    Ki(1024, 1),
    Mi(1024, 2),
    Gi(1024, 3),
    Ti(1024, 4),
    Pi(1024, 5);

    private final int base;
    private final int exponent;

    private BinaryPrefix(int base, int exponent) {
        this.base = base;
        this.exponent = exponent;
    }

    public int getBase() {
        return this.base;
    }

    public int getExponent() {
        return this.exponent;
    }

    public long size() {
        return BinaryPrefix.size(this.base, this.exponent);
    }

    public static long parse(String s) {
        int unitEnd = s.length();
        if (unitEnd > 0 && s.charAt(0) != '-') {
            try {
                int unitStart;
                if (s.charAt(unitEnd - 1) == 'B') {
                    --unitEnd;
                }
                for (unitStart = unitEnd; unitStart > 0 && !Character.isDigit(s.charAt(unitStart - 1)); --unitStart) {
                }
                String val = s.substring(0, unitStart);
                long unitSize = unitStart < unitEnd ? BinaryPrefix.valueOf(s.substring(unitStart, unitEnd)).size() : 1L;
                return s.indexOf(46) >= 0 ? (long)(Double.parseDouble(val) * (double)unitSize) : Long.parseLong(val) * unitSize;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(s);
    }

    public static String formatBinary(long size) {
        return BinaryPrefix.format(size, Ki);
    }

    public static String formatDecimal(long size) {
        return BinaryPrefix.format(size, k);
    }

    private static long size(int base, int exponent) {
        if (exponent == 0) {
            return 1L;
        }
        long size = base;
        int i = exponent;
        while (--i > 0) {
            size *= (long)base;
        }
        return size;
    }

    private static String format(long size, BinaryPrefix kiloPrefix) {
        int exp;
        if (size < 0L) {
            throw new IllegalArgumentException("size must be positive");
        }
        StringBuilder sb = new StringBuilder();
        int base = kiloPrefix.base;
        long val = size;
        for (exp = 0; val >= (long)base && exp < 5; val /= (long)base, ++exp) {
        }
        long unitSize = BinaryPrefix.size(base, exp);
        if (val * unitSize == size) {
            sb.append(val);
        } else {
            sb.append((double)size / (double)unitSize);
        }
        if (exp != 0) {
            sb.append((Object)BinaryPrefix.values()[kiloPrefix.ordinal() - 1 + exp]).append('B');
        }
        return sb.toString();
    }
}

