/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class AttributesBuilder {
    private static ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private final Attributes attrs;

    public AttributesBuilder(Attributes attrs) {
        this.attrs = attrs;
    }

    public void setString(int[] tagPath, String ... ss) {
        int tag = tagPath[tagPath.length - 1];
        VR vr = DICT.vrOf(tag);
        this.nestedKeys(tagPath).setString(tag, vr, ss);
    }

    public void setNullIfAbsent(int ... tagPath) {
        int tag = tagPath[tagPath.length - 1];
        Attributes item = this.nestedKeys(tagPath);
        if (TagUtils.groupNumber((int)tag) == 30583) {
            if (!item.contains("DCM4CHEE Archive 5", tag)) {
                item.setNull("DCM4CHEE Archive 5", tag, ElementDictionary.vrOf((int)tag, (String)"DCM4CHEE Archive 5"));
            }
        } else {
            AttributesBuilder.setNullIfAbsent(item, tag);
        }
    }

    public static void setNullIfAbsent(Attributes item, int ... tags) {
        for (int tag : tags) {
            AttributesBuilder.setNullIfAbsent(item, tag);
        }
    }

    public static void setNullIfAbsent(Attributes item, int tag) {
        if (!item.contains(tag)) {
            VR vr = DICT.vrOf(tag);
            if (vr == VR.SQ) {
                item.newSequence(tag, 1).add(new Attributes(0));
            } else {
                item.setNull(tag, vr);
            }
        }
    }

    private Attributes nestedKeys(int[] tags) {
        Attributes item = this.attrs;
        for (int i = 0; i < tags.length - 1; ++i) {
            int tag = tags[i];
            Sequence sq = item.getSequence(tag);
            if (sq == null) {
                sq = item.newSequence(tag, 1);
            }
            if (sq.isEmpty()) {
                sq.add(new Attributes());
            }
            item = (Attributes)sq.get(0);
        }
        return item;
    }
}

