/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.code.impl;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.dcm4che3.data.Code;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.entity.CodeEntity;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class CodeServiceEJB {
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    public CodeEntity findOrCreate(Code code) {
        try {
            return this.find(code);
        }
        catch (NoResultException e) {
            CodeEntity entity = new CodeEntity(code);
            this.em.persist((Object)entity);
            this.em.flush();
            return entity;
        }
    }

    private CodeEntity find(Code code) {
        TypedQuery query = this.em.createNamedQuery("CodeEntity.findByCodeValueWithSchemeVersion", CodeEntity.class).setParameter(1, (Object)code.getCodeValue()).setParameter(2, (Object)code.getCodingSchemeDesignator()).setParameter(3, StringUtils.maskNull((Object)code.getCodingSchemeVersion(), (Object)"*"));
        return (CodeEntity)query.getSingleResult();
    }
}

