/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.event.BulkTaskEvent;
import org.dcm4chee.arc.event.TaskEvent;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskAuditService {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAuditService.class);

    TaskAuditService() {
    }

    static AuditInfoBuilder queueMsgAuditInfo(TaskEvent queueMsgEvent) {
        HttpServletRequest req = queueMsgEvent.getRequest();
        Task queueMsg = queueMsgEvent.getTask();
        return new AuditInfoBuilder.Builder().callingUserID(KeycloakContext.valueOf((HttpServletRequest)req).getUserName()).callingHost(req.getRemoteHost()).calledUserID(req.getRequestURI()).outcome(TaskAuditService.outcome(queueMsgEvent.getException())).queueMsg(TaskAuditService.toString(queueMsg)).taskPOID(Long.toString(queueMsg.getPk())).build();
    }

    static AuditInfoBuilder bulkQueueMsgAuditInfo(BulkTaskEvent bulkQueueMsgEvent, String callingUser) {
        HttpServletRequest req = bulkQueueMsgEvent.getRequest();
        AuditInfoBuilder.Builder builder = new AuditInfoBuilder.Builder().callingUserID(callingUser).outcome(TaskAuditService.outcome(bulkQueueMsgEvent.getException())).count(bulkQueueMsgEvent.getCount()).failed(bulkQueueMsgEvent.getFailed()).taskPOID(bulkQueueMsgEvent.getOperation().name());
        return req != null ? builder.callingHost(req.getRemoteHost()).calledUserID(req.getRequestURI()).filters(req.getQueryString()).build() : builder.queueName(bulkQueueMsgEvent.getQueueName()).build();
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])TaskAuditService.activeParticipants(auditInfo, auditLogger), (ParticipantObjectIdentification[])new ParticipantObjectIdentification[]{ParticipantObjectID.taskParticipant(auditInfo)});
    }

    private static ActiveParticipant[] activeParticipants(AuditInfo auditInfo, AuditLogger auditLogger) {
        String callingUserID = auditInfo.getField(1);
        String calledUserID = auditInfo.getField(2);
        ActiveParticipant[] activeParticipants = calledUserID == null ? new ActiveParticipant[]{new ActiveParticipantBuilder(callingUserID, ((Connection)auditLogger.getConnections().get(0)).getHostname()).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).isRequester().build()} : new ActiveParticipant[]{new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUserID)).isRequester().build(), new ActiveParticipantBuilder(calledUserID, ((Connection)auditLogger.getConnections().get(0)).getHostname()).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).build()};
        return activeParticipants;
    }

    private static String outcome(Exception e) {
        return e != null ? e.getMessage() : null;
    }

    private static String toString(Task task) {
        StringWriter w = new StringWriter(256);
        try (JsonGenerator gen = Json.createGenerator((Writer)w);){
            task.writeAsJSON(gen);
        }
        return w.toString();
    }
}

