/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.study.StudyMgtContext;

class StudyRecordAuditService {
    private StudyMgtContext studyMgtCtx;
    private AuditInfoBuilder.Builder infoBuilder;

    StudyRecordAuditService(StudyMgtContext ctx, ArchiveDeviceExtension arcDev) {
        this.studyMgtCtx = ctx;
        this.infoBuilder = new AuditInfoBuilder.Builder().callingHost(this.studyMgtCtx.getRemoteHostName()).studyUIDAccNumDate(this.studyMgtCtx.getAttributes(), arcDev).pIDAndName(this.studyMgtCtx.getPatient() != null ? this.studyMgtCtx.getPatient().getAttributes() : this.studyMgtCtx.getAttributes(), arcDev).outcome(StudyRecordAuditService.outcome(this.studyMgtCtx.getException())).expirationDate(ctx.getExpirationDate() != null ? ctx.getExpirationDate().toString() : null);
    }

    AuditInfoBuilder getStudyUpdateAuditInfo() {
        return this.studyMgtCtx.getHttpRequest() != null ? this.studyExpiredByWeb() : this.studyExpiredByHL7();
    }

    private AuditInfoBuilder studyExpiredByHL7() {
        HL7Segment msh = this.studyMgtCtx.getUnparsedHL7Message().msh();
        return this.infoBuilder.callingUserID(msh.getSendingApplicationWithFacility()).calledUserID(msh.getReceivingApplicationWithFacility()).build();
    }

    private AuditInfoBuilder studyExpiredByWeb() {
        HttpServletRequestInfo httpServletRequestInfo = this.studyMgtCtx.getHttpRequest();
        return this.infoBuilder.callingUserID(httpServletRequestInfo.requesterUserID).calledUserID(StudyRecordAuditService.requestURLWithQueryParams(httpServletRequestInfo)).build();
    }

    private static String requestURLWithQueryParams(HttpServletRequestInfo httpServletRequestInfo) {
        return httpServletRequestInfo.queryString == null ? httpServletRequestInfo.requestURI : httpServletRequestInfo.requestURI + "?" + httpServletRequestInfo.queryString;
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path.toFile());
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])StudyRecordAuditService.activeParticipants(auditLogger, auditInfo), (ParticipantObjectIdentification[])ParticipantObjectID.studyPatParticipants(auditInfo, reader, auditLogger));
    }

    private static ActiveParticipant[] activeParticipants(AuditLogger auditLogger, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[2];
        String callingUserID = auditInfo.getField(1);
        String calledUserID = auditInfo.getField(2);
        AuditMessages.UserIDTypeCode calledUserIDTypeCode = StudyRecordAuditService.userIDTypeCode(calledUserID);
        activeParticipants[0] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditService.remoteUserIDTypeCode(calledUserIDTypeCode, callingUserID)).isRequester().build();
        activeParticipants[1] = new ActiveParticipantBuilder(calledUserID, StudyRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(calledUserIDTypeCode).altUserID(AuditLogger.processID()).build();
        return activeParticipants;
    }

    private static AuditMessages.UserIDTypeCode userIDTypeCode(String userID) {
        return userID.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : AuditMessages.UserIDTypeCode.ApplicationFacility;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }

    private static String outcome(Exception e) {
        return e != null ? e.getMessage() : null;
    }
}

