/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.QueryContext;

class QueryAuditService {
    private static boolean qidoQuery;

    QueryAuditService() {
    }

    static AuditInfoBuilder auditInfo(QueryContext ctx) {
        return ctx.getHttpRequest() != null ? QueryAuditService.createAuditInfoForQIDO(ctx) : QueryAuditService.createAuditInfoForFIND(ctx);
    }

    private static AuditInfoBuilder createAuditInfoForFIND(QueryContext ctx) {
        return new AuditInfoBuilder.Builder().callingHost(ctx.getRemoteHostName()).callingUserID(ctx.getCallingAET()).calledUserID(ctx.getCalledAET()).queryPOID(ctx.getSOPClassUID()).build();
    }

    private static AuditInfoBuilder createAuditInfoForQIDO(QueryContext ctx) {
        HttpServletRequestInfo httpRequest = ctx.getHttpRequest();
        return new AuditInfoBuilder.Builder().callingHost(ctx.getRemoteHostName()).callingUserID(httpRequest.requesterUserID).calledUserID(httpRequest.requestURI).queryPOID(ctx.getSearchMethod()).queryString(httpRequest.queryString).build();
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws IOException {
        ParticipantObjectIdentification poi;
        ActiveParticipant[] activeParticipants;
        AuditInfo auditInfo;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            auditInfo = new AuditInfo(new DataInputStream(in).readUTF());
            activeParticipants = QueryAuditService.activeParticipants(auditLogger, eventType, auditInfo);
            poi = qidoQuery ? ParticipantObjectID.qidoParticipant(auditInfo) : ParticipantObjectID.cFindParticipant(auditInfo, QueryAuditService.findQueryData(path, in));
        }
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])activeParticipants, (ParticipantObjectIdentification[])new ParticipantObjectIdentification[]{poi});
    }

    private static byte[] findQueryData(Path path, InputStream in) throws IOException {
        byte[] data;
        byte[] buffer = new byte[(int)Files.size(path)];
        int len = in.read(buffer);
        if (len != -1) {
            data = new byte[len];
            System.arraycopy(buffer, 0, data, 0, len);
        } else {
            data = new byte[]{};
        }
        return data;
    }

    private static ActiveParticipant[] activeParticipants(AuditLogger auditLogger, AuditUtils.EventType eventType, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[2];
        String archiveUserID = auditInfo.getField(2);
        String callingUserID = auditInfo.getField(1);
        AuditMessages.UserIDTypeCode archiveUserIDTypeCode = QueryAuditService.userIDTypeCode(archiveUserID);
        activeParticipants[0] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditService.remoteUserIDTypeCode(archiveUserIDTypeCode, callingUserID)).isRequester().roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        activeParticipants[1] = new ActiveParticipantBuilder(archiveUserID, QueryAuditService.getLocalHostName(auditLogger)).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build();
        return activeParticipants;
    }

    private static AuditMessages.UserIDTypeCode userIDTypeCode(String userID) {
        qidoQuery = userID.indexOf(47) != -1;
        return qidoQuery ? AuditMessages.UserIDTypeCode.URI : AuditMessages.UserIDTypeCode.StationAETitle;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }
}

