/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectDetail;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentificationBuilder;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PDQAuditService {
    private static final Logger LOG = LoggerFactory.getLogger(PDQAuditService.class);

    PDQAuditService() {
    }

    static AuditInfoBuilder auditInfo(PDQServiceContext ctx, ArchiveDeviceExtension arcDev) {
        return ctx.getHttpServletRequestInfo() == null ? PDQAuditService.schedulerTriggeredPDQ(ctx, arcDev) : PDQAuditService.restfulTriggeredPDQ(ctx, arcDev);
    }

    static AuditInfoBuilder auditInfoFHIR(PDQServiceContext ctx, ArchiveDeviceExtension arcDev) {
        return ctx.getHttpServletRequestInfo() == null ? PDQAuditService.schedulerTriggeredFHIRPDQ(ctx, arcDev) : PDQAuditService.restfulTriggeredFHIRPDQ(ctx, arcDev);
    }

    private static AuditInfoBuilder schedulerTriggeredPDQ(PDQServiceContext ctx, ArchiveDeviceExtension arcDev) {
        return new AuditInfoBuilder.Builder().outgoingHL7Sender(ctx.getSendingAppFacility()).outgoingHL7Receiver(ctx.getReceivingAppFacility()).queryPOID(ctx.getSearchMethod()).patID(ctx.getPatientID(), arcDev).patName(ctx.getPatientAttrs().getString(0x100010), arcDev).build();
    }

    private static AuditInfoBuilder restfulTriggeredPDQ(PDQServiceContext ctx, ArchiveDeviceExtension arcDev) {
        HttpServletRequestInfo httpRequest = ctx.getHttpServletRequestInfo();
        return new AuditInfoBuilder.Builder().outgoingHL7Sender(ctx.getSendingAppFacility()).outgoingHL7Receiver(ctx.getReceivingAppFacility()).callingHost(httpRequest.requesterHost).callingUserID(httpRequest.requesterUserID).calledUserID(httpRequest.requestURI).queryPOID(ctx.getSearchMethod()).queryString(httpRequest.queryString).patID(ctx.getPatientID(), arcDev).patName(ctx.getPatientAttrs().getString(0x100010), arcDev).build();
    }

    private static AuditInfoBuilder schedulerTriggeredFHIRPDQ(PDQServiceContext ctx, ArchiveDeviceExtension arcDev) {
        return new AuditInfoBuilder.Builder().callingUserID(arcDev.getDevice().getDeviceName()).queryString(ctx.getFhirQueryParams()).fhirWebAppName(ctx.getFhirWebAppName()).queryPOID(ctx.getSearchMethod()).patID(ctx.getPatientID(), arcDev).patName(ctx.getPatientAttrs().getString(0x100010), arcDev).build();
    }

    private static AuditInfoBuilder restfulTriggeredFHIRPDQ(PDQServiceContext ctx, ArchiveDeviceExtension arcDev) {
        HttpServletRequestInfo httpRequest = ctx.getHttpServletRequestInfo();
        return new AuditInfoBuilder.Builder().callingHost(httpRequest.requesterHost).callingUserID(httpRequest.requesterUserID).calledUserID(httpRequest.requestURI).queryPOID(ctx.getSearchMethod()).queryString(ctx.getFhirQueryParams()).fhirWebAppName(ctx.getFhirWebAppName()).patID(ctx.getPatientID(), arcDev).patName(ctx.getPatientAttrs().getString(0x100010), arcDev).build();
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType, IHL7ApplicationCache hl7AppCache, IWebApplicationCache webAppCache) throws Exception {
        if (eventType.eventTypeCode == AuditMessages.EventTypeCode.ITI_78_MobilePDQ) {
            return PDQAuditService.auditMsg(auditLogger, path, eventType, webAppCache);
        }
        SpoolFileReader reader = new SpoolFileReader(path.toFile());
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        EventIdentification ei = EventID.toEventIdentification(auditLogger, path, eventType, auditInfo);
        List<ActiveParticipant> activeParticipants = PDQAuditService.activeParticipants(auditLogger, auditInfo, hl7AppCache, eventType);
        List<ParticipantObjectIdentification> participantObjects = PDQAuditService.participantObjects(auditInfo, reader);
        return AuditMessages.createMessage((EventIdentification)ei, (ActiveParticipant[])activeParticipants.toArray(new ActiveParticipant[0]), (ParticipantObjectIdentification[])participantObjects.toArray(new ParticipantObjectIdentification[0]));
    }

    private static List<ParticipantObjectIdentification> participantObjects(AuditInfo auditInfo, SpoolFileReader reader) {
        ArrayList<ParticipantObjectIdentification> participantObjects = new ArrayList<ParticipantObjectIdentification>();
        ParticipantObjectIdentificationBuilder pdq = new ParticipantObjectIdentificationBuilder(auditInfo.getField(10), AuditMessages.ParticipantObjectIDTypeCode.ITI_PatientDemographicsQuery, "2", "24");
        if (auditInfo.getField(11) != null) {
            pdq.detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"QueryString", (String)auditInfo.getField(11))});
        }
        pdq.query(reader.getData());
        participantObjects.add(pdq.build());
        participantObjects.add(ParticipantObjectID.patientPOI(auditInfo, reader));
        return participantObjects;
    }

    private static List<ActiveParticipant> activeParticipants(AuditLogger auditLogger, AuditInfo auditInfo, IHL7ApplicationCache hl7AppCache, AuditUtils.EventType eventType) throws ConfigurationException {
        ArrayList<ActiveParticipant> activeParticipants = new ArrayList<ActiveParticipant>();
        String hl7ReceivingAppWithFacility = auditInfo.getField(24);
        HL7Application hl7AppReceiver = hl7AppCache.findHL7Application(hl7ReceivingAppWithFacility);
        activeParticipants.add(new ActiveParticipantBuilder(hl7ReceivingAppWithFacility, ((Connection)hl7AppReceiver.getConnections().get(0)).getHostname()).userIDTypeCode(AuditMessages.UserIDTypeCode.ApplicationFacility).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build());
        String callingUser = auditInfo.getField(1);
        if (callingUser != null) {
            activeParticipants.add(new ActiveParticipantBuilder(callingUser, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUser)).isRequester().build());
            activeParticipants.add(new ActiveParticipantBuilder(auditInfo.getField(2), PDQAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).build());
            activeParticipants.add(new ActiveParticipantBuilder(auditInfo.getField(23), PDQAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.ApplicationFacility).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build());
        } else {
            activeParticipants.add(new ActiveParticipantBuilder(auditInfo.getField(23), PDQAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.ApplicationFacility).isRequester().roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build());
        }
        return activeParticipants;
    }

    private static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType, IWebApplicationCache webAppCache) throws Exception {
        SpoolFileReader reader = new SpoolFileReader(path.toFile());
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        EventIdentification ei = EventID.toEventIdentification(auditLogger, path, eventType, auditInfo);
        List<ActiveParticipant> activeParticipants = PDQAuditService.activeParticipants(auditLogger, auditInfo, eventType, webAppCache);
        List<ParticipantObjectIdentification> participantObjects = PDQAuditService.participantObjects(auditInfo);
        return AuditMessages.createMessage((EventIdentification)ei, (ActiveParticipant[])activeParticipants.toArray(new ActiveParticipant[0]), (ParticipantObjectIdentification[])participantObjects.toArray(new ParticipantObjectIdentification[0]));
    }

    private static List<ActiveParticipant> activeParticipants(AuditLogger auditLogger, AuditInfo auditInfo, AuditUtils.EventType eventType, IWebApplicationCache webAppCache) throws ConfigurationException {
        ArrayList<ActiveParticipant> activeParticipants = new ArrayList<ActiveParticipant>();
        WebApplication fhirWebApp = webAppCache.findWebApplication(auditInfo.getField(40));
        activeParticipants.add(new ActiveParticipantBuilder(fhirWebApp.getServiceURL().toString(), ((Connection)fhirWebApp.getConnections().get(0)).getHostname()).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build());
        String calledUser = auditInfo.getField(2);
        if (calledUser != null) {
            activeParticipants.add(new ActiveParticipantBuilder(auditInfo.getField(1), auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)auditInfo.getField(1))).isRequester().build());
            activeParticipants.add(new ActiveParticipantBuilder(auditInfo.getField(2), PDQAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build());
        } else {
            activeParticipants.add(new ActiveParticipantBuilder(auditInfo.getField(1), PDQAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).isRequester().build());
        }
        return activeParticipants;
    }

    private static List<ParticipantObjectIdentification> participantObjects(AuditInfo auditInfo) {
        ArrayList<ParticipantObjectIdentification> participantObjects = new ArrayList<ParticipantObjectIdentification>();
        participantObjects.add(new ParticipantObjectIdentificationBuilder(auditInfo.getField(10), AuditMessages.ParticipantObjectIDTypeCode.ITI_MobilePatientDemographicsQuery, "2", "24").detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"QueryEncoding", (String)StandardCharsets.UTF_8.name())}).query(auditInfo.getField(11).getBytes(StandardCharsets.UTF_8)).build());
        participantObjects.add(ParticipantObjectID.patientPOIBuilder(auditInfo).build());
        return participantObjects;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }
}

