/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.HL7ConnectionEvent;

class HL7AuditUtils {
    HL7AuditUtils() {
    }

    static HL7Segment getHL7Segment(UnparsedHL7Message hl7Message, String segName) {
        HL7Segment msh = hl7Message.msh();
        String charset = msh.getField(17, "ASCII");
        HL7Message msg = HL7Message.parse((byte[])hl7Message.unescapeXdddd(), (String)charset);
        return msg.getSegment(segName);
    }

    static boolean isOrderProcessed(HL7ConnectionEvent hl7ConnEvent) {
        String messageType = hl7ConnEvent.getHL7Message().msh().getMessageType();
        return messageType.equals("ORM^O01") || messageType.equals("OMG^O19") || messageType.equals("OMI^O23");
    }

    static boolean isOrderMessage(HL7ConnectionEvent hl7ConnEvent) {
        return HL7AuditUtils.getHL7Segment(hl7ConnEvent.getHL7Message(), "ORC") != null;
    }

    static String procRecHL7StudyIUID(UnparsedHL7Message hl7Message, String defVal) {
        HL7Segment zds = HL7AuditUtils.getHL7Segment(hl7Message, "ZDS");
        HL7Segment ipc = HL7AuditUtils.getHL7Segment(hl7Message, "IPC");
        return zds != null ? zds.getField(1, null) : (ipc != null ? ipc.getField(3, null) : defVal);
    }

    static String procRecHL7Acc(UnparsedHL7Message hl7Message) {
        HL7Segment obr = HL7AuditUtils.getHL7Segment(hl7Message, "OBR");
        HL7Segment ipc = HL7AuditUtils.getHL7Segment(hl7Message, "IPC");
        return ipc != null ? ipc.getField(1, null) : (obr != null ? obr.getField(18, null) : null);
    }
}

