/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.event.ArchiveServiceEvent;
import org.dcm4chee.arc.keycloak.KeycloakContext;

class ApplicationActivityAuditService {
    ApplicationActivityAuditService() {
    }

    static AuditInfoBuilder auditInfo(ArchiveServiceEvent event, String deviceName) {
        return event.getRequest() != null ? ApplicationActivityAuditService.restfulTriggeredInfo(event.getRequest()) : ApplicationActivityAuditService.systemTriggeredInfo(deviceName);
    }

    private static AuditInfoBuilder systemTriggeredInfo(String deviceName) {
        return new AuditInfoBuilder.Builder().calledUserID(deviceName).build();
    }

    private static AuditInfoBuilder restfulTriggeredInfo(HttpServletRequest req) {
        return new AuditInfoBuilder.Builder().calledUserID(req.getRequestURI()).callingUserID(KeycloakContext.valueOf((HttpServletRequest)req).getUserName()).callingHost(req.getRemoteAddr()).build();
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])ApplicationActivityAuditService.activeParticipants(auditLogger, eventType, auditInfo), (ParticipantObjectIdentification[])new ParticipantObjectIdentification[0]);
    }

    private static ActiveParticipant[] activeParticipants(AuditLogger auditLogger, AuditUtils.EventType eventType, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[2];
        String archiveUserID = auditInfo.getField(2);
        activeParticipants[0] = new ActiveParticipantBuilder(archiveUserID, ApplicationActivityAuditService.getLocalHostName(auditLogger)).userIDTypeCode(ApplicationActivityAuditService.userIDTypeCode(archiveUserID)).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build();
        String callingUser = auditInfo.getField(1);
        if (callingUser != null) {
            activeParticipants[1] = new ActiveParticipantBuilder(callingUser, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUser)).isRequester().roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        }
        return activeParticipants;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }

    private static AuditMessages.UserIDTypeCode userIDTypeCode(String userID) {
        return userID.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : AuditMessages.UserIDTypeCode.DeviceName;
    }
}

