/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.xroad;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.xroad.RR441RequestType;
import org.dcm4chee.arc.xroad.RR441ResponseType;
import org.dcm4chee.arc.xroad.RequestHash;
import org.dcm4chee.arc.xroad.XRoadAdapterPortType;
import org.dcm4chee.arc.xroad.XRoadClientIdentifierType;
import org.dcm4chee.arc.xroad.XRoadException;
import org.dcm4chee.arc.xroad.XRoadObjectType;
import org.dcm4chee.arc.xroad.XRoadService;
import org.dcm4chee.arc.xroad.XRoadServiceIdentifierType;

@ApplicationScoped
public class XRoadServiceProvider {
    @Inject
    private Device device;
    private XRoadService service = new XRoadService();

    public Attributes rr441(String endpoint, Map<String, String> props, String patientID) throws XRoadException, ConfigurationException {
        Headers h = new Headers(props, "RR441");
        Holder request = new Holder((Object)XRoadServiceProvider.toRR441(props, patientID));
        Holder response = new Holder();
        this.port(endpoint, props).rr441((Holder<RR441RequestType>)request, h.client, h.service, h.userId, h.id, h.protocolVersion, (Holder<RR441ResponseType>)response, h.requestHash);
        return XRoadServiceProvider.toAttributes(props, XRoadException.validate((RR441ResponseType)response.value));
    }

    private static RR441RequestType toRR441(Map<String, String> props, String patientID) {
        RR441RequestType rq = new RR441RequestType();
        rq.setCValjad(props.getOrDefault("rr441.cValjad", "1,2,6,7,9,10"));
        rq.setCIsikukoodid(patientID);
        return rq;
    }

    private static Attributes toAttributes(Map<String, String> props, RR441ResponseType rsp) {
        List<RR441ResponseType.TtIsikuid.TtIsikud> ttIsikudList = rsp.getTtIsikuid().getTtIsikud();
        if (ttIsikudList.isEmpty()) {
            return null;
        }
        RR441ResponseType.TtIsikuid.TtIsikud ttIsikud = ttIsikudList.get(0);
        Attributes attrs = new Attributes();
        attrs.setString(524293, VR.CS, props.getOrDefault("SpecificCharacterSet", "ISO_IR 100"));
        attrs.setString(0x100010, VR.PN, XRoadServiceProvider.patientName(ttIsikud));
        attrs.setString(0x100020, VR.LO, ttIsikud.getTtIsikudCIsikukood());
        attrs.setString(0x100040, VR.CS, XRoadServiceProvider.patientSex(ttIsikud.getTtIsikudCSugu()));
        attrs.setString(0x100030, VR.DA, XRoadServiceProvider.patientBirthDate(ttIsikud.getTtIsikudCSynniaeg()));
        attrs.setString("DCM4CHEE Archive 5", 0x777700E0, VR.CS, ttIsikud.getTtIsikudCIsStaatus());
        attrs.setString("DCM4CHEE Archive 5", 2004287713, VR.CS, ttIsikud.getTtIsikudCKirjeStaatus());
        return attrs;
    }

    private static String patientName(RR441ResponseType.TtIsikuid.TtIsikud ttIsikud) {
        return ttIsikud.getTtIsikudCPerenimi() + "^" + ttIsikud.getTtIsikudCEesnimi();
    }

    private static String patientBirthDate(String synniaeg) {
        if (synniaeg == null || synniaeg.length() != 10) {
            return null;
        }
        char[] data = new char[8];
        synniaeg.getChars(6, 10, data, 0);
        synniaeg.getChars(3, 5, data, 4);
        synniaeg.getChars(0, 2, data, 6);
        return new String(data);
    }

    private static String patientSex(String sugu) {
        if (sugu != null && sugu.length() == 1) {
            switch (sugu.charAt(0)) {
                case 'M': {
                    return "M";
                }
                case 'N': {
                    return "F";
                }
            }
        }
        return null;
    }

    private XRoadAdapterPortType port(String endpoint, Map<String, String> props) throws ConfigurationException {
        XRoadAdapterPortType port = this.service.getXRoadServicePort();
        BindingProvider bindingProvider = (BindingProvider)port;
        Map reqCtx = bindingProvider.getRequestContext();
        reqCtx.put("javax.xml.ws.service.endpoint.address", endpoint);
        if (endpoint.startsWith("https")) {
            Client client = ClientProxy.getClient((Object)port);
            HTTPConduit conduit = (HTTPConduit)client.getConduit();
            conduit.setTlsClientParameters(this.tlsClientParams(props));
        }
        return port;
    }

    private TLSClientParameters tlsClientParams(Map<String, String> props) throws ConfigurationException {
        TLSClientParameters params = new TLSClientParameters();
        try {
            params.setKeyManagers(this.device.keyManagers());
            params.setTrustManagers(this.device.trustManagers());
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        params.setSecureSocketProtocol(props.get("TLS.protocol"));
        for (String cipherSuite : StringUtils.split((String)props.get("TLS.cipherSuites"), (char)',')) {
            params.getCipherSuites().add(cipherSuite.trim());
        }
        params.setDisableCNCheck(Boolean.parseBoolean(props.getOrDefault("TLS.disableCNCheck", "false")));
        return params;
    }

    private static class Headers {
        final Holder<XRoadClientIdentifierType> client = new Holder();
        final Holder<XRoadServiceIdentifierType> service = new Holder();
        final Holder<String> userId = new Holder();
        final Holder<String> id = new Holder();
        final Holder<String> protocolVersion = new Holder();
        final Holder<RequestHash> requestHash = new Holder();

        private Headers(Map<String, String> props, String serviceCode) {
            this.client.value = Headers.client(props);
            this.service.value = Headers.service(props, serviceCode);
            this.userId.value = props.getOrDefault("userId", "EE11111111111");
            this.id.value = props.getOrDefault("id", "");
            this.protocolVersion.value = props.getOrDefault("protocolVersion", "4.0");
        }

        private static XRoadClientIdentifierType client(Map<String, String> props) {
            XRoadClientIdentifierType type = new XRoadClientIdentifierType();
            type.setObjectType(XRoadObjectType.valueOf(props.getOrDefault("client.objectType", XRoadObjectType.SUBSYSTEM.name())));
            type.setXRoadInstance(props.getOrDefault("client.xRoadInstance", "EE"));
            type.setMemberClass(props.getOrDefault("client.memberClass", "NGO"));
            type.setMemberCode(props.getOrDefault("client.memberCode", "90007945"));
            type.setSubsystemCode(props.getOrDefault("client.subsystemCode", "mia"));
            return type;
        }

        private static XRoadServiceIdentifierType service(Map<String, String> props, String serviceCode) {
            XRoadServiceIdentifierType type = new XRoadServiceIdentifierType();
            type.setObjectType(XRoadObjectType.valueOf(props.getOrDefault("service.objectType", XRoadObjectType.SERVICE.name())));
            type.setXRoadInstance(props.getOrDefault("service.xRoadInstance", "EE"));
            type.setMemberClass(props.getOrDefault("service.memberClass", "GOV"));
            type.setMemberCode(props.getOrDefault("service.memberCode", "70008440"));
            type.setSubsystemCode(props.getOrDefault("service.subsystemCode", "rr"));
            type.setServiceCode(serviceCode);
            type.setServiceVersion(props.getOrDefault("serviceVersion", "v1"));
            return type;
        }
    }
}

