/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.store.InstanceLocations;

enum ObjectType {
    UncompressedSingleFrameImage(MediaTypes.IMAGE_JPEG_TYPE, true, false){

        @Override
        public Optional<MediaType> getCompatibleMimeType(MediaType other) {
            return ObjectType.findCompatibleSingleFrameMimeType(other);
        }

        @Override
        public MediaType[] getRenderedContentTypes() {
            return ObjectType.renderedSingleFrameMediaTypes();
        }

        @Override
        public MediaType[] getBulkdataContentTypes(InstanceLocations inst) {
            return ObjectType.octetStreamMediaType();
        }
    }
    ,
    CompressedSingleFrameImage(MediaTypes.IMAGE_JPEG_TYPE, true, false){

        @Override
        public Optional<MediaType> getCompatibleMimeType(MediaType other) {
            return ObjectType.findCompatibleSingleFrameMimeType(other);
        }

        @Override
        public MediaType[] getRenderedContentTypes() {
            return ObjectType.renderedSingleFrameMediaTypes();
        }

        @Override
        public MediaType[] getBulkdataContentTypes(InstanceLocations inst) {
            return ObjectType.calcPixelDataContentTypes(inst);
        }
    }
    ,
    UncompressedMultiFrameImage(MediaTypes.APPLICATION_DICOM_TYPE, true, false){

        @Override
        public Optional<MediaType> getCompatibleMimeType(MediaType other) {
            return ObjectType.findCompatibleMultiFrameMimeType(other);
        }

        @Override
        public MediaType[] getRenderedContentTypes() {
            return ObjectType.renderedMultiFrameMediaTypes();
        }

        @Override
        public MediaType[] getBulkdataContentTypes(InstanceLocations inst) {
            return ObjectType.octetStreamMediaType();
        }
    }
    ,
    CompressedMultiFrameImage(MediaTypes.APPLICATION_DICOM_TYPE, true, false){

        @Override
        public Optional<MediaType> getCompatibleMimeType(MediaType other) {
            return ObjectType.findCompatibleMultiFrameMimeType(other);
        }

        @Override
        public MediaType[] getRenderedContentTypes() {
            return ObjectType.renderedMultiFrameMediaTypes();
        }

        @Override
        public MediaType[] getBulkdataContentTypes(InstanceLocations inst) {
            return ObjectType.calcPixelDataContentTypes(inst);
        }
    }
    ,
    MPEG2Video(MediaTypes.VIDEO_MPEG_TYPE, false, true),
    MPEG4Video(MediaTypes.VIDEO_MP4_TYPE, false, true),
    SRDocument(MediaType.TEXT_HTML_TYPE, false, false){

        @Override
        public Optional<MediaType> getCompatibleMimeType(MediaType other) {
            return ObjectType.findCompatibleSRMimeType(other);
        }

        @Override
        public MediaType[] getRenderedContentTypes() {
            return ObjectType.renderedSRMediaTypes();
        }

        @Override
        public MediaType[] getBulkdataContentTypes(InstanceLocations inst) {
            return null;
        }
    }
    ,
    EncapsulatedPDF(MediaTypes.APPLICATION_PDF_TYPE, false, false),
    EncapsulatedCDA(MediaType.TEXT_XML_TYPE, false, false){

        @Override
        public MediaType[] getRenderedContentTypes() {
            return null;
        }
    }
    ,
    EncapsulatedSTL(MediaTypes.MODEL_STL_TYPE, false, false){

        @Override
        public MediaType[] getRenderedContentTypes() {
            return null;
        }
    }
    ,
    EncapsulatedOBJ(MediaTypes.MODEL_OBJ_TYPE, false, false){

        @Override
        public MediaType[] getRenderedContentTypes() {
            return null;
        }
    }
    ,
    EncapsulatedMTL(MediaTypes.MODEL_MTL_TYPE, false, false){

        @Override
        public MediaType[] getRenderedContentTypes() {
            return null;
        }
    }
    ,
    EncapsulatedGenozip(MediaTypes.APPLICATION_VND_GENOZIP_TYPE, false, false){

        @Override
        public MediaType[] getRenderedContentTypes() {
            return null;
        }
    }
    ,
    Other(MediaTypes.APPLICATION_DICOM_TYPE, false, false){

        @Override
        public MediaType[] getRenderedContentTypes() {
            return null;
        }

        @Override
        public MediaType[] getBulkdataContentTypes(InstanceLocations inst) {
            return null;
        }
    };

    private final MediaType defaultMimeType;
    private final boolean image;
    private final boolean video;

    private ObjectType(MediaType defaultMimeType, boolean image, boolean video) {
        this.defaultMimeType = defaultMimeType;
        this.image = image;
        this.video = video;
    }

    public static ObjectType objectTypeOf(RetrieveContext ctx, InstanceLocations inst, int frame) {
        if (inst.isImage()) {
            switch (((Location)inst.getLocations().get(0)).getTransferSyntaxUID()) {
                case "1.2.840.10008.1.2.4.100": 
                case "1.2.840.10008.1.2.4.100.1": 
                case "1.2.840.10008.1.2.4.101": 
                case "1.2.840.10008.1.2.4.101.1": {
                    return MPEG2Video;
                }
                case "1.2.840.10008.1.2.4.102": 
                case "1.2.840.10008.1.2.4.102.1": 
                case "1.2.840.10008.1.2.4.103": 
                case "1.2.840.10008.1.2.4.103.1": 
                case "1.2.840.10008.1.2.4.104": 
                case "1.2.840.10008.1.2.4.104.1": 
                case "1.2.840.10008.1.2.4.105": 
                case "1.2.840.10008.1.2.4.105.1": 
                case "1.2.840.10008.1.2.4.106": 
                case "1.2.840.10008.1.2.4.106.1": 
                case "1.2.840.10008.1.2.4.107": 
                case "1.2.840.10008.1.2.4.108": {
                    return MPEG4Video;
                }
                case "1.2.840.10008.1.2": 
                case "1.2.840.10008.1.2.1": {
                    return frame <= 0 && inst.isMultiframe() ? UncompressedMultiFrameImage : UncompressedSingleFrameImage;
                }
            }
            return frame <= 0 && inst.isMultiframe() ? CompressedMultiFrameImage : CompressedSingleFrameImage;
        }
        switch (inst.getSopClassUID()) {
            case "1.2.840.10008.5.1.4.1.1.104.1": {
                return EncapsulatedPDF;
            }
            case "1.2.840.10008.5.1.4.1.1.104.2": {
                return EncapsulatedCDA;
            }
            case "1.2.840.10008.5.1.4.1.1.104.3": {
                return EncapsulatedSTL;
            }
            case "1.2.840.10008.5.1.4.1.1.104.5": {
                return EncapsulatedMTL;
            }
            case "1.2.840.10008.5.1.4.1.1.104.4": {
                return EncapsulatedOBJ;
            }
            case "1.2.40.0.13.1.5.1.4.1.1.104.1": {
                return EncapsulatedGenozip;
            }
        }
        ArchiveDeviceExtension arcDev = ctx.getArchiveAEExtension().getArchiveDeviceExtension();
        return arcDev.isWadoSupportedSRClass(inst.getSopClassUID()) ? SRDocument : Other;
    }

    public MediaType getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public Optional<MediaType> getCompatibleMimeType(MediaType other) {
        return ObjectType.findCompatibleMimeType(other, this.defaultMimeType, MediaTypes.APPLICATION_DICOM_TYPE);
    }

    private static MediaType[] octetStreamMediaType() {
        return new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE};
    }

    private static MediaType[] renderedSingleFrameMediaTypes() {
        return new MediaType[]{MediaTypes.IMAGE_JPEG_TYPE, MediaTypes.IMAGE_GIF_TYPE, MediaTypes.IMAGE_PNG_TYPE};
    }

    private static MediaType[] renderedMultiFrameMediaTypes() {
        return new MediaType[]{MediaTypes.IMAGE_GIF_TYPE};
    }

    private static MediaType[] renderedSRMediaTypes() {
        return new MediaType[]{MediaType.TEXT_HTML_TYPE, MediaType.TEXT_PLAIN_TYPE};
    }

    private static Optional<MediaType> findCompatibleSingleFrameMimeType(MediaType other) {
        return ObjectType.findCompatibleMimeType(other, MediaTypes.IMAGE_JPEG_TYPE, MediaTypes.APPLICATION_DICOM_TYPE, MediaTypes.IMAGE_GIF_TYPE, MediaTypes.IMAGE_PNG_TYPE);
    }

    private static Optional<MediaType> findCompatibleMultiFrameMimeType(MediaType other) {
        return ObjectType.findCompatibleMimeType(other, MediaTypes.APPLICATION_DICOM_TYPE, MediaTypes.IMAGE_GIF_TYPE);
    }

    private static Optional<MediaType> findCompatibleSRMimeType(MediaType other) {
        return ObjectType.findCompatibleMimeType(other, MediaType.TEXT_HTML_TYPE, MediaType.TEXT_PLAIN_TYPE, MediaTypes.APPLICATION_DICOM_TYPE);
    }

    private static Optional<MediaType> findCompatibleMimeType(MediaType other, MediaType ... mimeTypes) {
        return Stream.of(mimeTypes).filter(arg_0 -> ((MediaType)other).isCompatible(arg_0)).findFirst();
    }

    public MediaType[] getRenderedContentTypes() {
        return new MediaType[]{this.defaultMimeType};
    }

    public MediaType[] getBulkdataContentTypes(InstanceLocations inst) {
        return new MediaType[]{this.defaultMimeType};
    }

    public boolean isImage() {
        return this.image;
    }

    public boolean isVideo() {
        return this.video;
    }

    private static MediaType[] calcPixelDataContentTypes(InstanceLocations inst) {
        String tsuid = ((Location)inst.getLocations().get(0)).getTransferSyntaxUID();
        MediaType mediaType = MediaTypes.forTransferSyntax((String)tsuid);
        return new MediaType[]{mediaType, MediaType.APPLICATION_OCTET_STREAM_TYPE};
    }
}

