/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.stgcmtscu;

import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.stgcmt.StgCmtSCU;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.process.AbstractUPSProcessor;

public class UPSStgCmtSCU
extends AbstractUPSProcessor {
    private final StgCmtSCU stgCmtSCU;
    private final String defDestinationAE;

    public UPSStgCmtSCU(UPSProcessingRule rule, UPSService upsService, StgCmtSCU stgCmtSCU) {
        super(rule, upsService, true);
        this.stgCmtSCU = stgCmtSCU;
        this.defDestinationAE = rule.getUPSProcessorURI().getSchemeSpecificPart();
    }

    protected void processA(UPSContext upsCtx, Attributes ups) throws Exception {
        String destinationAE = this.destinationAEOf(ups);
        for (Map.Entry<String, StgCmtInfo> entry : this.seriesStgCmtInfoFrom(ups).entrySet()) {
            String seriesIUID = entry.getKey();
            StgCmtInfo stgCmtInfo = entry.getValue();
            DimseRSP dimseRSP = this.stgCmtSCU.sendNActionRQ(this.rule.getAETitle(), destinationAE, stgCmtInfo.getStudyIUID(), seriesIUID, null, null, null, ups.getString(7606788), stgCmtInfo.getActionInfo());
            Attributes cmd = dimseRSP.getCommand();
            int status = cmd.getInt(2304, -1);
            this.getPerformedProcedureStep(upsCtx).setString(4194900, VR.LO, this.outcomeDesc(status, cmd.getString(2306), destinationAE));
        }
    }

    private Map<String, StgCmtInfo> seriesStgCmtInfoFrom(Attributes ups) {
        HashMap<String, StgCmtInfo> seriesStgCmtInfo = new HashMap<String, StgCmtInfo>();
        ups.getSequence(4210721).forEach(inputInformation -> {
            Attributes actionInfo = new Attributes(inputInformation);
            actionInfo.remove(0x20000D);
            actionInfo.remove(0x20000E);
            actionInfo.setString(528789, VR.UI, UIDUtils.createUID());
            seriesStgCmtInfo.putIfAbsent(inputInformation.getString(0x20000E), new StgCmtInfo(inputInformation.getString(0x20000D), actionInfo));
        });
        return seriesStgCmtInfo;
    }

    private String destinationAEOf(Attributes ups) {
        Attributes dicomStorage;
        Attributes outputDestination = ups.getNestedDataset(0x404070);
        return outputDestination != null && (dicomStorage = outputDestination.getNestedDataset(4210801)) != null ? dicomStorage.getString(553648448, this.defDestinationAE) : this.defDestinationAE;
    }

    private String outcomeDesc(int status, String errorComment, String destinationAE) {
        return status != 0 ? "Request Storage Commitment from AE: " + destinationAE + " failed with status: " + TagUtils.shortToHexString((int)status) + "H, error comment: " + errorComment : "Request Storage Commitment from AE: " + destinationAE;
    }

    static class StgCmtInfo {
        private final String studyIUID;
        private final Attributes actionInfo;

        public StgCmtInfo(String studyIUID, Attributes actionInfo) {
            this.studyIUID = studyIUID;
            this.actionInfo = actionInfo;
        }

        public String getStudyIUID() {
            return this.studyIUID;
        }

        public Attributes getActionInfo() {
            return this.actionInfo;
        }
    }
}

