/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.scp;

import java.io.IOException;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.AbstractDicomService;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;

@ApplicationScoped
@Typed(value={DicomService.class})
public class UPSPushSCP
extends AbstractDicomService {
    @Inject
    private UPSService service;

    public UPSPushSCP() {
        super(new String[]{"1.2.840.10008.5.1.4.34.6.1"});
    }

    public void onDimseRQ(Association as, PresentationContext pc, Dimse dimse, Attributes rq, Attributes rqAttrs) throws IOException {
        switch (as.getAbstractSyntax(pc.getPCID())) {
            case "1.2.840.10008.5.1.4.34.6.1": {
                switch (dimse) {
                    case N_CREATE_RQ: {
                        this.onNCreateRQ(as, pc, rq, rqAttrs);
                        return;
                    }
                    case N_GET_RQ: {
                        this.onNGetRQ(as, pc, rq, rqAttrs);
                        return;
                    }
                    case N_ACTION_RQ: {
                        this.onNActionRQ(as, pc, rq, rqAttrs, 2);
                        return;
                    }
                }
            }
            case "1.2.840.10008.5.1.4.34.6.3": {
                switch (dimse) {
                    case N_SET_RQ: {
                        this.onNSetRQ(as, pc, rq, rqAttrs);
                        return;
                    }
                    case N_GET_RQ: {
                        this.onNGetRQ(as, pc, rq, rqAttrs);
                        return;
                    }
                    case N_ACTION_RQ: {
                        this.onNActionRQ(as, pc, rq, rqAttrs, 1);
                        return;
                    }
                }
            }
            case "1.2.840.10008.5.1.4.34.6.2": {
                switch (dimse) {
                    case N_GET_RQ: {
                        this.onNGetRQ(as, pc, rq, rqAttrs);
                        return;
                    }
                    case N_ACTION_RQ: {
                        this.onNActionRQ(as, pc, rq, rqAttrs, 254);
                        return;
                    }
                }
            }
        }
        throw new DicomServiceException(529);
    }

    private void onNCreateRQ(Association as, PresentationContext pc, Attributes rq, Attributes rqAttrs) throws IOException {
        Attributes rsp = Commands.mkNCreateRSP((Attributes)rq, (int)0);
        Attributes rspAttrs = this.create(as, rq, rqAttrs, rsp);
        as.tryWriteDimseRSP(pc, rsp, rspAttrs);
    }

    private void onNSetRQ(Association as, PresentationContext pc, Attributes rq, Attributes rqAttrs) throws IOException {
        Attributes rsp = Commands.mkNSetRSP((Attributes)rq, (int)0);
        Attributes rspAttrs = this.set(as, rq, rqAttrs, rsp);
        as.tryWriteDimseRSP(pc, rsp, rspAttrs);
    }

    private void onNGetRQ(Association as, PresentationContext pc, Attributes rq, Attributes rqAttrs) throws IOException {
        Attributes rsp = Commands.mkNGetRSP((Attributes)rq, (int)0);
        Attributes rspAttrs = this.get(as, rq, rqAttrs, rsp);
        as.tryWriteDimseRSP(pc, rsp, rspAttrs);
    }

    private void onNActionRQ(Association as, PresentationContext pc, Attributes rq, Attributes rqAttrs, int validActionTypeIDs) throws IOException {
        Attributes rsp = Commands.mkNActionRSP((Attributes)rq, (int)0);
        Attributes rspAttrs = this.action(as, rq, rqAttrs, rsp, validActionTypeIDs);
        as.tryWriteDimseRSP(pc, rsp, rspAttrs);
    }

    private Attributes create(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws DicomServiceException {
        UPSContext ctx = this.service.newUPSContext(as);
        ctx.setUPSInstanceUID(rq.getString(4096));
        ctx.setAttributes(rqAttrs);
        this.service.createUPS(ctx);
        return null;
    }

    private Attributes set(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws DicomServiceException {
        UPSContext ctx = this.service.newUPSContext(as);
        ctx.setUPSInstanceUID(rq.getString(4097));
        ctx.setAttributes(rqAttrs);
        this.service.updateUPS(ctx);
        return null;
    }

    private Attributes get(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws DicomServiceException {
        UPSContext ctx = this.service.newUPSContext(as);
        ctx.setUPSInstanceUID(rq.getString(4097));
        this.service.findUPS(ctx);
        return this.filter(ctx.getAttributes(), rq.getInts(4101));
    }

    private Attributes filter(Attributes attrs, int[] tags) {
        if (tags == null) {
            return attrs;
        }
        Arrays.sort(tags);
        return new Attributes(attrs, tags);
    }

    private Attributes action(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp, int validActionTypeIDs) throws DicomServiceException {
        int actionTypeID = UPSPushSCP.validateActionTypeID(rq.getInt(4104, 0), validActionTypeIDs);
        UPSContext ctx = this.service.newUPSContext(as);
        ctx.setUPSInstanceUID(rq.getString(4097));
        switch (actionTypeID) {
            case 1: {
                ctx.setAttributes(rqAttrs);
                this.service.changeUPSState(ctx);
                break;
            }
            case 2: {
                ctx.setAttributes(rqAttrs);
                this.service.requestUPSCancel(ctx);
                break;
            }
            case 3: {
                ctx.setSubscriberAET(UPSPushSCP.requireNonNull(rqAttrs, 7606836));
                ctx.setDeletionLock(this.validateDeletionLock(rqAttrs));
                if (ctx.getUPSInstanceUID().equals("1.2.840.10008.5.1.4.34.5.1")) {
                    rqAttrs.removeSelected(new int[]{7606832, 7606836});
                    ctx.setAttributes(rqAttrs);
                }
                this.service.createSubscription(ctx);
                break;
            }
            case 4: {
                ctx.setSubscriberAET(UPSPushSCP.requireNonNull(rqAttrs, 7606836));
                this.service.deleteSubscription(ctx);
                break;
            }
            case 5: {
                ctx.setSubscriberAET(UPSPushSCP.requireNonNull(rqAttrs, 7606836));
                this.service.suspendSubscription(ctx);
            }
        }
        return null;
    }

    private boolean validateDeletionLock(Attributes rqAttrs) throws DicomServiceException {
        switch (UPSPushSCP.requireNonNull(rqAttrs, 7606832)) {
            case "TRUE": {
                return true;
            }
            case "FALSE": {
                return false;
            }
        }
        throw new DicomServiceException(277);
    }

    private static String requireNonNull(Attributes rqAttrs, int tag) throws DicomServiceException {
        String value = rqAttrs.getString(tag);
        if (value == null) {
            throw new DicomServiceException(277);
        }
        return value;
    }

    private static int validateActionTypeID(int actionTypeID, int validActionTypeIDs) throws DicomServiceException {
        if (actionTypeID <= 0 || (1 << actionTypeID - 1 & validActionTypeIDs) == 0) {
            throw new DicomServiceException(291).setActionTypeID(actionTypeID);
        }
        return actionTypeID;
    }
}

