/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.ejb.EJBException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.websocket.Session;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.IOD;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.ValidationResult;
import org.dcm4che3.dcmr.ScopeOfAccumulation;
import org.dcm4che3.hl7.HL7Charset;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.HL7SAXTransformer;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.UPSOnHL7;
import org.dcm4chee.arc.conf.UPSOnStore;
import org.dcm4chee.arc.conf.UPSOnUPSCompleted;
import org.dcm4chee.arc.conf.UPSState;
import org.dcm4chee.arc.entity.UPS;
import org.dcm4chee.arc.event.ArchiveServiceEvent;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.ups.UPSConfigurationException;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSEvent;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.UPSUtils;
import org.dcm4chee.arc.ups.impl.UPSContextImpl;
import org.dcm4chee.arc.ups.impl.UPSServiceEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@ApplicationScoped
public class UPSServiceImpl
implements UPSService {
    private static final Logger LOG = LoggerFactory.getLogger(UPSServiceImpl.class);
    private static final IOD CREATE_IOD = UPSServiceImpl.loadIOD("create-iod.xml");
    private static final IOD CREATE_TEMPLATE_IOD = UPSServiceImpl.loadIOD("create-template-iod.xml");
    private static final IOD SET_IOD = UPSServiceImpl.loadIOD("set-iod.xml");
    private final ConcurrentHashMap<String, WSChannel> websocketChannels = new ConcurrentHashMap();
    @Inject
    private UPSServiceEJB ejb;
    @Inject
    private QueryService queryService;
    @Inject
    private Event<UPSEvent> upsEvent;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private Device device;

    @Override
    public UPSContext newUPSContext(Association as) {
        return new UPSContextImpl(as);
    }

    @Override
    public UPSContext newUPSContext(HttpServletRequestInfo httpRequestInfo, ArchiveAEExtension arcAE) {
        return new UPSContextImpl(httpRequestInfo, arcAE);
    }

    @Override
    public UPSContext newUPSContext(UPSContext other) {
        return new UPSContextImpl(other);
    }

    @Override
    public UPS createUPS(UPSContext ctx) throws DicomServiceException {
        Attributes attrs = ctx.getAttributes();
        ValidationResult validate = attrs.validate(ctx.isTemplate() ? CREATE_TEMPLATE_IOD : CREATE_IOD);
        if (!validate.isValid()) {
            throw DicomServiceException.valueOf((ValidationResult)validate, (Attributes)attrs);
        }
        if (ctx.isGlobalSubscription()) {
            throw new DicomServiceException(273, "Cannot create UPS Global Subscription SOP Instance", false);
        }
        if (!"SCHEDULED".equals(attrs.getString(7606272))) {
            throw new DicomServiceException(49929, "The provided value of UPS State was not SCHEDULED");
        }
        if (!attrs.containsValue(7606786)) {
            attrs.setString(7606786, VR.LO, ctx.getArchiveAEExtension().upsWorklistLabel());
        }
        try {
            UPS ups = this.ejb.createUPS(ctx);
            this.fireUPSEvents(ctx);
            return ups;
        }
        catch (Exception e) {
            if (this.upsExists(ctx)) {
                throw new DicomServiceException(273, "The UPS already exists.", false);
            }
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    private boolean upsExists(UPSContext ctx) throws DicomServiceException {
        try {
            return this.ejb.exists(ctx);
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    @Override
    public UPS updateUPS(UPSContext ctx) throws DicomServiceException {
        Attributes attrs = ctx.getAttributes();
        ValidationResult validate = attrs.validate(SET_IOD);
        if (!validate.isValid()) {
            throw DicomServiceException.valueOf((ValidationResult)validate, (Attributes)attrs);
        }
        try {
            UPS ups = this.ejb.updateUPS(ctx);
            this.fireUPSEvents(ctx);
            return ups;
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    @Override
    public UPS changeUPSState(UPSContext ctx) throws DicomServiceException {
        UPSState upsState;
        Attributes attrs = ctx.getAttributes();
        try {
            upsState = UPSState.fromString((String)attrs.getString(7606272));
        }
        catch (NullPointerException e) {
            throw new DicomServiceException(277, "The Procedure Step State is missing.", false);
        }
        catch (IllegalArgumentException e) {
            throw new DicomServiceException(277, "The Procedure Step State is invalid.", false);
        }
        if (upsState == UPSState.SCHEDULED) {
            throw new DicomServiceException(49923, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
        }
        String transactionUID = attrs.getString(528789);
        if (!(transactionUID != null || upsState != UPSState.IN_PROGRESS && ctx.isUPSUpdateWithoutTransactionUID())) {
            throw new DicomServiceException(277, "The Transaction UID is missing.", false);
        }
        try {
            UPS ups = this.ejb.changeUPSState(ctx, upsState, transactionUID);
            this.fireUPSEvents(ctx);
            if (upsState == UPSState.COMPLETED) {
                this.onUPSCompleted(ctx, ups);
            }
            return ups;
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    private void onUPSCompleted(UPSContext ctx, UPS ups) {
        Calendar now = Calendar.getInstance();
        ctx.getArchiveAEExtension().upsOnUPSCompletedStream().filter(rule -> rule.getConditions().match(ctx.getRemoteHostName(), ctx.getRequesterAET(), ctx.getLocalHostName(), ctx.getApplicationEntity().getAETitle(), ups.getAttributes())).peek(rule -> LOG.info("Apply {} on completion of {}", rule, (Object)ups)).filter(rule -> this.isRequiredOtherUPSCompleted(ctx, ups, (UPSOnUPSCompleted)rule)).forEach(rule -> this.createUPSOnUPSCompleted(ctx, ups, (UPSOnUPSCompleted)rule, now));
    }

    private boolean isRequiredOtherUPSCompleted(UPSContext ctx, UPS ups, UPSOnUPSCompleted rule) {
        String refStudyIUID;
        Attributes item;
        String[] requiresOtherUPSCompleted = rule.getRequiresOtherUPSCompleted();
        if (requiresOtherUPSCompleted.length > 0 && (item = ups.getAttributes().getNestedDataset(4236144)) != null && (refStudyIUID = item.getString(0x20000D)) != null) {
            for (String queryString : requiresOtherUPSCompleted) {
                try (Query query = this.queryService.createUPSQuery(this.queryContextUPSNotCompleted(ctx, refStudyIUID, queryString));){
                    long notCompleted = query.fetchCount();
                    if (notCompleted <= 0L) continue;
                    LOG.info("Suspend {} on completion of {} caused by {} not completed required other UPS", new Object[]{rule, ups, notCompleted});
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private QueryContext queryContextUPSNotCompleted(UPSContext ctx, String refStudyIUID, String queryString) {
        QueryParam queryParam = new QueryParam(ctx.getApplicationEntity());
        queryParam.setCombinedDatetimeMatching(true);
        QueryContext queryContext = this.queryService.newQueryContext(ctx.getApplicationEntity(), queryParam);
        queryContext.setQueryKeys(UPSServiceImpl.queryKeysUPSNotCompleted(refStudyIUID, queryString));
        return queryContext;
    }

    private static Attributes queryKeysUPSNotCompleted(String refStudyIUID, String queryString) {
        Attributes keys = new QueryAttributes(QueryAttributes.parseQueryString((String)queryString), null).getQueryKeys();
        Attributes item = new Attributes(1);
        item.setString(0x20000D, VR.UI, refStudyIUID);
        keys.newSequence(4236144, 1).add(item);
        keys.setString(7606272, VR.CS, new String[]{"SCHEDULED", "IN PROGRESS", "CANCELED"});
        return keys;
    }

    private void createUPSOnUPSCompleted(UPSContext ctx, UPS prevUPS, UPSOnUPSCompleted rule, Calendar now) {
        UPSContext upsCtx = this.newUPSContext(ctx);
        upsCtx.setUPSInstanceUID(rule.getInstanceUID(prevUPS.getAttributes()));
        try {
            upsCtx.setAttributes(this.upsOnCompleted(upsCtx, prevUPS, now, rule));
            this.createUPS(upsCtx);
        }
        catch (DicomServiceException | UPSConfigurationException e) {
            LOG.info("Failed to apply {} create on completion of {}", new Object[]{rule, prevUPS, e});
        }
    }

    @Override
    public UPS requestUPSCancel(UPSContext ctx) throws DicomServiceException {
        try {
            UPS ups = this.ejb.requestUPSCancel(ctx, this);
            this.fireUPSEvents(ctx);
            return ups;
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    @Override
    public UPS findUPS(UPSContext ctx) throws DicomServiceException {
        UPS ups = this.ejb.findUPS(ctx);
        Attributes upsAttrs = ups.getAttributes();
        Attributes patAttrs = ups.getPatient().getAttributes();
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, upsAttrs});
        Attributes attrs = new Attributes(patAttrs.size() + upsAttrs.size() + 3);
        attrs.addAll(patAttrs);
        attrs.addAll(upsAttrs);
        attrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.34.6.1");
        attrs.setString(524312, VR.UI, ups.getUPSInstanceUID());
        attrs.setDate(0x404010, VR.DT, new Date[]{ups.getUpdatedTime()});
        ctx.setAttributes(attrs);
        return ups;
    }

    @Override
    public void createSubscription(UPSContext ctx) throws DicomServiceException {
        this.validateSupportEventReports(ctx);
        try {
            this.validateSubscriberAET(ctx);
            switch (ctx.getUPSInstanceUID()) {
                case "1.2.840.10008.5.1.4.34.5.1": {
                    if (ctx.getAttributes().isEmpty()) {
                        throw new DicomServiceException(277, "Matching Keys are missing.", false);
                    }
                }
                case "1.2.840.10008.5.1.4.34.5": {
                    this.ejb.createOrUpdateGlobalSubscription(ctx, this.searchNotSubscribedUPS(ctx));
                    break;
                }
                default: {
                    this.ejb.createOrUpdateSubscription(ctx);
                }
            }
            this.fireUPSEvents(ctx);
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    @Override
    public int deleteSubscription(UPSContext ctx) throws DicomServiceException {
        try {
            return ctx.isGlobalSubscription() ? this.ejb.deleteGlobalSubscription(ctx) : this.ejb.deleteSubscription(ctx);
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    @Override
    public int suspendSubscription(UPSContext ctx) throws DicomServiceException {
        try {
            return ctx.isGlobalSubscription() ? this.ejb.suspendGlobalSubscription(ctx) : this.ejb.deleteSubscription(ctx);
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    @Override
    public void registerWebsocketChannel(Session session, String aet, String subscriberAET) {
        this.websocketChannels.put(session.getId(), new WSChannel(session, aet, subscriberAET));
    }

    @Override
    public void unregisterWebsocketChannel(Session session) {
        this.websocketChannels.remove(session.getId());
    }

    @Override
    public List<Session> getWebsocketChannels(String subscriberAET) {
        return this.websocketChannels.values().stream().filter(ws -> ws.subscriberAET.equals(subscriberAET)).map(ws -> ws.session).collect(Collectors.toList());
    }

    public void onArchiveServiceEvent(@Observes ArchiveServiceEvent event) {
        Attributes eventInformation = new Attributes(3);
        switch (event.getType()) {
            case STARTED: {
                eventInformation.setString(7606850, VR.CS, "RESTARTED");
                eventInformation.setString(7606852, VR.CS, "WARM START");
                eventInformation.setString(7606854, VR.CS, "WARM START");
                break;
            }
            case STOPPED: {
                eventInformation.setString(7606850, VR.CS, "GOING DOWN");
                break;
            }
            case RELOADED: {
                return;
            }
        }
        try {
            this.device.getApplicationEntities().stream().filter(UPSServiceImpl::isUPSEventSCP).forEach(ae -> this.ejb.statusChangeEvents((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class), eventInformation).forEach(arg_0 -> this.upsEvent.fire(arg_0)));
        }
        catch (Exception e) {
            LOG.info("Failed to send StatusChange Event Reports - {}", (Object)e.getMessage());
        }
    }

    public void onStore(@Observes StoreContext ctx) {
        if (ctx.getStoredInstance() == null || ctx.getException() != null) {
            return;
        }
        StoreSession session = ctx.getStoreSession();
        Calendar now = Calendar.getInstance();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        arcAE.upsOnStoreStream().filter(upsOnStore -> upsOnStore.match(now, session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes())).forEach(upsOnStore -> this.createOrUpdateOnStore(arcDev, ctx, now, (UPSOnStore)upsOnStore));
    }

    private void createOrUpdateOnStore(ArchiveDeviceExtension arcDev, StoreContext ctx, Calendar now, UPSOnStore upsOnStore) {
        int retries = arcDev.getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                UPSContext upsContext = this.ejb.createOrUpdateOnStore(ctx, now, upsOnStore);
                if (upsContext != null) {
                    this.fireUPSEvents(upsContext);
                }
                return;
            }
            catch (EJBException e) {
                if (retries-- <= 0) {
                    LOG.warn("{}: Failed to create or update UPS triggered by {}:\n", new Object[]{ctx.getStoreSession(), upsOnStore, e});
                    return;
                }
                LOG.info("{}: Failed to create or update UPS triggered by {} caused by {} - retry", new Object[]{ctx.getStoreSession(), upsOnStore, DicomServiceException.initialCauseOf((Throwable)e)});
                try {
                    Thread.sleep(arcDev.storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("{}: Failed to delay retry to create or update UPS triggered by {}:\n", new Object[]{ctx.getStoreSession(), upsOnStore, e2});
                    continue;
                }
            }
            break;
        }
    }

    public void onHL7Connection(@Observes HL7ConnectionEvent event) {
        if (event.getType() != HL7ConnectionEvent.Type.MESSAGE_PROCESSED || event.getException() != null) {
            return;
        }
        UnparsedHL7Message msg = event.getHL7Message();
        HL7Application hl7App = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(msg.msh().getReceivingApplicationWithFacility(), true);
        if (hl7App == null) {
            return;
        }
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (arcHL7App == null || !arcHL7App.hasUPSOnHL7()) {
            return;
        }
        Socket socket = event.getSocket();
        String host = ReverseDNS.hostNameOf((InetAddress)socket.getInetAddress());
        HL7Fields hl7Fields = new HL7Fields(msg, hl7App.getHL7DefaultCharacterSet());
        Calendar now = Calendar.getInstance();
        arcHL7App.upsOnHL7Stream().filter(upsOnHL7 -> upsOnHL7.getConditions().match(host, hl7Fields)).forEach(upsOnHL7 -> this.createOnHL7(socket, arcHL7App, msg, hl7Fields, now, (UPSOnHL7)upsOnHL7));
    }

    private void createOnHL7(Socket socket, ArchiveHL7ApplicationExtension arcHL7App, UnparsedHL7Message msg, HL7Fields hl7Fields, Calendar now, UPSOnHL7 upsOnHL7) {
        LOG.info("{}: Apply {}", (Object)socket, (Object)upsOnHL7);
        UPSContextImpl ctx = new UPSContextImpl(socket, arcHL7App);
        ctx.setUPSInstanceUID(upsOnHL7.getInstanceUID(hl7Fields));
        try {
            UPS ups = this.ejb.findUPS(ctx);
            LOG.info("UPS {} exists, return", (Object)ups);
        }
        catch (DicomServiceException e) {
            this.createOnHL7(ctx, arcHL7App, msg, hl7Fields, now, upsOnHL7);
        }
    }

    private void createOnHL7(UPSContext ctx, ArchiveHL7ApplicationExtension arcHL7App, UnparsedHL7Message msg, HL7Fields hl7Fields, Calendar now, UPSOnHL7 upsOnHL7) {
        Attributes attrs = this.applyXSLT(arcHL7App, msg, upsOnHL7);
        if (attrs.size() == 0) {
            return;
        }
        ctx.setAttributes(UPSUtils.createOnHL7(arcHL7App, attrs, hl7Fields, now, upsOnHL7));
        try {
            this.createUPS(ctx);
        }
        catch (DicomServiceException e) {
            LOG.info("Failed to apply {} to create UPS", (Object)upsOnHL7, (Object)e);
        }
    }

    private Attributes applyXSLT(ArchiveHL7ApplicationExtension arcHL7App, UnparsedHL7Message msg, UPSOnHL7 upsOnHL7) {
        try {
            String hl7Charset = msg.msh().getField(17, arcHL7App.getHL7Application().getHL7DefaultCharacterSet());
            return HL7SAXTransformer.transform((byte[])msg.unescapeXdddd(), (String)hl7Charset, (String)(arcHL7App.hl7DicomCharacterSet() != null ? arcHL7App.hl7DicomCharacterSet() : HL7Charset.toDicomCharacterSetCode((String)hl7Charset)), (Templates)TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)upsOnHL7.getXSLTStylesheetURI())), null);
        }
        catch (SAXException e) {
            LOG.warn("Failed to apply XSL: {}", (Object)upsOnHL7.getXSLTStylesheetURI(), (Object)e);
        }
        catch (TransformerConfigurationException e) {
            LOG.warn("Failed to compile XSL: {}", (Object)upsOnHL7.getXSLTStylesheetURI(), (Object)e);
        }
        catch (IOException e) {
            LOG.warn("Failed to parse HL7 Message{}: {}", new Object[]{msg, upsOnHL7.getXSLTStylesheetURI(), e});
        }
        return new Attributes();
    }

    boolean websocketChannelsExists(String subscriberAET) {
        return this.websocketChannels.values().stream().anyMatch(ws -> ws.subscriberAET.equals(subscriberAET));
    }

    private void fireUPSEvents(UPSContext ctx) {
        if (ctx.isTemplate()) {
            return;
        }
        try {
            ctx.getUPSEvents().forEach(arg_0 -> this.upsEvent.fire(arg_0));
        }
        catch (Exception e) {
            LOG.warn("Failed to send Event Reports\n", (Throwable)e);
        }
    }

    private static IOD loadIOD(String name) {
        try {
            IOD iod = new IOD();
            iod.parse(UPSServiceImpl.class.getResource(name).toString());
            iod.trimToSize();
            return iod;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateSupportEventReports(UPSContext ctx) throws DicomServiceException {
        if (!UPSServiceImpl.isUPSEventSCP(ctx.getApplicationEntity())) {
            throw new DicomServiceException(49941, "Event Reports are not supported");
        }
    }

    private static boolean isUPSEventSCP(ApplicationEntity ae) {
        return ae.getTransferCapabilityFor("1.2.840.10008.5.1.4.34.6.2", TransferCapability.Role.SCP) != null;
    }

    private void validateSubscriberAET(UPSContext ctx) throws DicomServiceException, ConfigurationException {
        if (ctx.getArchiveAEExtension().isUPSEventSCU(ctx.getSubscriberAET())) {
            try {
                this.aeCache.findApplicationEntity(ctx.getSubscriberAET());
            }
            catch (ConfigurationNotFoundException e) {
                throw new DicomServiceException(49928, (Throwable)e);
            }
        }
    }

    private List<Attributes> searchNotSubscribedUPS(UPSContext ctx) throws DicomServiceException {
        ArrayList<Attributes> list = new ArrayList<Attributes>();
        ApplicationEntity ae = ctx.getApplicationEntity();
        ArchiveDeviceExtension arcdev = ctx.getArchiveDeviceExtension();
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setNotSubscribedByAET(ctx.getSubscriberAET());
        QueryContext queryContext = this.queryService.newQueryContext(ae, queryParam);
        Attributes matchKeys = ctx.getAttributes();
        if (matchKeys != null) {
            IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)matchKeys);
            if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
                queryContext.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
            } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
                queryContext.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)matchKeys));
            }
            queryContext.setQueryKeys(matchKeys);
        } else {
            queryContext.setQueryKeys(new Attributes(0));
        }
        try (Query query = this.queryService.createUPSWithoutQueryEvent(queryContext);){
            query.executeQuery(arcdev.getQueryFetchSize());
            while (query.hasMoreMatches()) {
                list.add(query.nextMatch());
            }
        }
        return list;
    }

    private Attributes upsOnCompleted(UPSContext upsCtx, UPS prevUPS, Calendar now, UPSOnUPSCompleted rule) throws UPSConfigurationException {
        Attributes prevUPSAttrs = prevUPS.getAttributes();
        Attributes attrs = this.applyXSLT(rule, prevUPS);
        if (rule.isIncludeStudyInstanceUID() && !attrs.contains(0x20000D)) {
            attrs.setString(0x20000D, VR.UI, prevUPSAttrs.getString(0x20000D));
        }
        if (!attrs.contains(3670032)) {
            attrs.setString(3670032, VR.LO, rule.getAdmissionID(prevUPSAttrs));
            UPSUtils.setIssuer(attrs, 3670033, rule.getIssuerOfAdmissionID());
        }
        if (!attrs.contains(0x404005)) {
            attrs.setDate(0x404005, VR.DT, new Date[]{UPSUtils.add(now, rule.getStartDateTimeDelay())});
        }
        if (rule.getCompletionDateTimeDelay() != null && !attrs.contains(0x404011)) {
            attrs.setDate(0x404011, VR.DT, new Date[]{UPSUtils.add(now, rule.getCompletionDateTimeDelay())});
        }
        if (rule.getScheduledHumanPerformers().length > 0 && !attrs.contains(0x404034)) {
            UPSUtils.setScheduledHumanPerformerItems(attrs, rule.getScheduledHumanPerformers(), rule.getScheduledHumanPerformerName(attrs), rule.getScheduledHumanPerformerOrganization(attrs));
        }
        if (!attrs.contains(4210712)) {
            UPSUtils.setCode(attrs, 4210712, rule.getScheduledWorkitemCode());
        }
        if (!attrs.contains(4210725)) {
            UPSUtils.setCodes(attrs, 4210725, rule.getScheduledStationNames());
        }
        if (!attrs.contains(4210726)) {
            UPSUtils.setCodes(attrs, 4210726, rule.getScheduledStationClasses());
        }
        if (!attrs.contains(4210727)) {
            UPSUtils.setCodes(attrs, 4210727, rule.getScheduledStationLocations());
        }
        if (!attrs.contains(0x404041)) {
            attrs.setString(0x404041, VR.CS, rule.getInputReadinessState().toString());
        }
        if (!attrs.contains(4236144)) {
            if (rule.isIncludeReferencedRequest()) {
                Attributes refReqSq = prevUPSAttrs.getNestedDataset(4236144);
                if (refReqSq == null) {
                    throw new UPSConfigurationException(rule + " configured to include Referenced Request, but previous UPS " + prevUPS + " attributes does not contain Referenced Request Sequence");
                }
                attrs.newSequence(4236144, 1).add(refReqSq);
            } else {
                attrs.setNull(4236144, VR.SQ);
            }
        }
        if (rule.getDestinationAE() != null && !attrs.contains(0x404070)) {
            attrs.newSequence(0x404070, 1).add(UPSUtils.outputStorage(rule.getDestinationAE()));
        }
        attrs.setString(7606272, VR.CS, "SCHEDULED");
        if (!attrs.contains(7606784)) {
            attrs.setString(7606784, VR.CS, rule.getUPSPriority().toString());
        }
        if (!attrs.contains(7606786)) {
            attrs.setString(7606786, VR.LO, this.worklistLabel(rule, prevUPSAttrs, upsCtx));
        }
        if (!attrs.contains(7606788)) {
            attrs.setString(7606788, VR.LO, rule.getProcedureStepLabel(prevUPSAttrs));
        }
        if (!attrs.contains(4210721)) {
            this.updateIncludeInputInformation(attrs, prevUPS, rule);
        }
        UPSUtils.addScheduledProcessingParameter(attrs, ScopeOfAccumulation.CODE, rule.getScopeOfAccumulation());
        if (rule.isIncludePatient()) {
            attrs.addAll(prevUPS.getPatient().getAttributes());
        }
        return attrs;
    }

    private Attributes applyXSLT(UPSOnUPSCompleted upsOnUPSCompleted, UPS ups) {
        String uri = upsOnUPSCompleted.getXSLTStylesheetURI();
        if (uri != null) {
            try {
                return SAXTransformer.transform((Attributes)ups.getAttributes(), (Templates)TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)uri)), (boolean)false, (!upsOnUPSCompleted.isNoKeywords() ? 1 : 0) != 0, null);
            }
            catch (SAXException e) {
                LOG.warn("{}: Failed to apply XSL: {}", new Object[]{ups, uri, e});
            }
            catch (TransformerConfigurationException e) {
                LOG.warn("{}: Failed to compile XSL: {}", new Object[]{ups, uri, e});
            }
        }
        return new Attributes();
    }

    private String worklistLabel(UPSOnUPSCompleted rule, Attributes prevUPSAttrs, UPSContext ctx) {
        String worklistLabel = rule.getWorklistLabel(prevUPSAttrs);
        return worklistLabel != null ? worklistLabel : ctx.getArchiveAEExtension().upsWorklistLabel();
    }

    private void updateIncludeInputInformation(Attributes attrs, UPS prevUPS, UPSOnUPSCompleted rule) throws UPSConfigurationException {
        Attributes prevUPSAttrs = prevUPS.getAttributes();
        if (rule.getIncludeInputInformation() == UPSOnUPSCompleted.IncludeInputInformation.NO) {
            return;
        }
        if (rule.getIncludeInputInformation() == UPSOnUPSCompleted.IncludeInputInformation.COPY_INPUT) {
            Sequence prevUPSInputInfoSeq = prevUPSAttrs.getSequence(4210721);
            attrs.newSequence(4210721, prevUPSInputInfoSeq.size()).addAll((Collection)prevUPSInputInfoSeq.stream().map(Attributes::new).collect(Collectors.toList()));
            return;
        }
        Sequence prevUPSOutputInfoSeq = prevUPSAttrs.getNestedDataset(7606806).getSequence(0x404033);
        if (prevUPSOutputInfoSeq == null) {
            throw new UPSConfigurationException(rule + " configured to include Output Information of previous UPS. Missing Output Information Sequence in previous UPS " + prevUPS);
        }
        attrs.newSequence(4210721, prevUPSOutputInfoSeq.size()).addAll((Collection)prevUPSOutputInfoSeq.stream().map(Attributes::new).collect(Collectors.toList()));
    }

    private static class WSChannel {
        final Session session;
        final String aet;
        final String subscriberAET;

        private WSChannel(Session session, String aet, String subscriberAET) {
            this.session = session;
            this.aet = aet;
            this.subscriberAET = subscriberAET;
        }
    }
}

