/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stow;

import java.io.OutputStream;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4chee.arc.conf.ArchiveAEExtension;

enum OutputType {
    DICOM_XML{

        @Override
        StreamingOutput entity(Attributes response, ApplicationEntity ae) {
            return out -> {
                try {
                    SAXTransformer.getSAXWriter((Result)new StreamResult(out)).write(response);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e);
                }
            };
        }
    }
    ,
    JSON{

        @Override
        StreamingOutput entity(Attributes response, ApplicationEntity ae) {
            return out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).encodeAsJSONNumber(new JSONWriter(gen)).write(response);
                gen.flush();
            };
        }
    };


    abstract StreamingOutput entity(Attributes var1, ApplicationEntity var2);
}

