/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.stgcmt.StgCmtContext;
import org.dcm4chee.arc.stgcmt.StgCmtManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{aet}/rs")
public class StgVerRS {
    private static final Logger LOG = LoggerFactory.getLogger(StgVerRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private Device device;
    @Inject
    private StgCmtManager stgCmtMgr;
    @Inject
    private Event<StgCmtContext> stgCmtEvent;
    @PathParam(value="aet")
    private String aet;
    @Context
    private HttpServletRequest request;
    @QueryParam(value="storageVerificationPolicy")
    @Pattern(regexp="DB_RECORD_EXISTS|OBJECT_EXISTS|OBJECT_SIZE|OBJECT_FETCH|OBJECT_CHECKSUM|S3_MD5SUM")
    private @Pattern(regexp="DB_RECORD_EXISTS|OBJECT_EXISTS|OBJECT_SIZE|OBJECT_FETCH|OBJECT_CHECKSUM|S3_MD5SUM") String storageVerificationPolicy;
    @QueryParam(value="storageVerificationUpdateLocationStatus")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageVerificationUpdateLocationStatus;
    @QueryParam(value="storageVerificationStorageID")
    private List<String> storageVerificationStorageIDs;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/stgver")
    @Produces(value={"application/dicom+json,application/json"})
    public Response studyStorageCommit(@PathParam(value="StudyInstanceUID") String studyUID) {
        return this.storageCommit(studyUID, null, null);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/stgver")
    @Produces(value={"application/dicom+json,application/json"})
    public Response seriesStorageCommit(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="SeriesInstanceUID") String seriesUID) {
        return this.storageCommit(studyUID, seriesUID, null);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/{SOPInstanceUID}/stgver")
    @Produces(value={"application/dicom+json,application/json"})
    public Response instanceStorageCommit(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="SeriesInstanceUID") String seriesUID, @PathParam(value="SOPInstanceUID") String sopUID) {
        return this.storageCommit(studyUID, seriesUID, sopUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response storageCommit(String studyUID, String seriesUID, String sopUID) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        StgCmtContext ctx = new StgCmtContext(ae, this.aet).setRequest(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
        if (this.storageVerificationPolicy != null) {
            ctx.setStorageVerificationPolicy(StorageVerificationPolicy.valueOf((String)this.storageVerificationPolicy));
        }
        if (this.storageVerificationUpdateLocationStatus != null) {
            ctx.setUpdateLocationStatus(Boolean.parseBoolean(this.storageVerificationUpdateLocationStatus));
        }
        if (!this.storageVerificationStorageIDs.isEmpty()) {
            ctx.setStorageIDs(this.storageVerificationStorageIDs.toArray(StringUtils.EMPTY_STRING));
        }
        try {
            if (!this.stgCmtMgr.calculateResult(ctx, studyUID, seriesUID, sopUID)) {
                Response response = this.errResponse("No matching instances", Response.Status.NOT_FOUND);
                return response;
            }
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            this.stgCmtEvent.fire((Object)ctx);
        }
        Attributes eventInfo = ctx.getEventInfo();
        return Response.status((Response.Status)this.toStatus(eventInfo)).entity((Object)this.toStreamingOutput(eventInfo, ae)).build();
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private Response errResponse(String errorMessage, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + errorMessage + "\"}", status);
    }

    private Response.Status toStatus(Attributes eventInfo) {
        int completed = this.sizeOf(eventInfo.getSequence(528793));
        int failed = this.sizeOf(eventInfo.getSequence(528792));
        return failed == 0 ? Response.Status.OK : (completed == 0 ? Response.Status.CONFLICT : Response.Status.ACCEPTED);
    }

    private int sizeOf(Sequence seq) {
        return seq != null ? seq.size() : 0;
    }

    private StreamingOutput toStreamingOutput(Attributes eventInfo, ApplicationEntity ae) {
        return out -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                JSONWriter writer = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).encodeAsJSONNumber(new JSONWriter(gen));
                gen.writeStartArray();
                writer.write(eventInfo);
                gen.writeEnd();
            }
        };
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }
}

