/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.impl;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.entity.StgCmtResult;
import org.dcm4chee.arc.stgcmt.StgCmtManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PurgeStgCmtScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeStgCmtScheduler.class);
    @Inject
    private StgCmtManager ejb;

    protected PurgeStgCmtScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getPurgeStgCmtPollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        this.delete(StgCmtResult.Status.COMPLETED, arcDev.getPurgeStgCmtCompletedDelay());
    }

    private void delete(StgCmtResult.Status status, Duration delay) {
        if (delay == null) {
            return;
        }
        Date before = new Date(System.currentTimeMillis() - delay.getSeconds() * 1000L);
        int deleted = this.ejb.deleteStgCmts(status, before);
        if (deleted > 0) {
            LOG.info("Purged {} storage commitments", (Object)deleted);
        }
    }
}

