/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qido;

import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.dcm4chee.arc.query.QueryService;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="/institutions")
public class InstitutionsRS {
    private static final Logger LOG = LoggerFactory.getLogger(InstitutionsRS.class);
    @Context
    private HttpServletRequest request;
    @Inject
    private QueryService queryService;
    @QueryParam(value="entity")
    @Pattern(regexp="Series|MWL")
    @DefaultValue(value="Series")
    private @Pattern(regexp="Series|MWL") String entity;

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public String listInstitutions() {
        this.logRequest();
        return this.queryService.getDistinctInstitutions(this.entity).stream().filter(institution -> !institution.equals("*")).sorted().collect(Collectors.joining("\",\"", "{\"Institutions\":[\"", "\"]}"));
    }

    private void logRequest() {
        LOG.info("Process GET {} from {}@{}", new Object[]{this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }
}

