/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.mpps.scu.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.MPPSForwardRule;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.mpps.MPPSContext;
import org.dcm4chee.arc.mpps.scu.MPPSSCU;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class MPPSSCUImpl
implements MPPSSCU {
    private static final Logger LOG = LoggerFactory.getLogger(MPPSSCUImpl.class);
    @Inject
    private TaskManager taskManager;
    @Inject
    private Device device;
    @Inject
    private ProcedureService procService;
    @Inject
    private Event<ProcedureContext> procedureEvent;
    @Inject
    private IApplicationEntityCache aeCache;

    MPPSSCUImpl() {
    }

    void onMPPSReceive(@Observes MPPSContext ctx) {
        if (ctx.getException() != null) {
            return;
        }
        ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
        Calendar now = Calendar.getInstance();
        Attributes mppsAttrs = ctx.getMPPS().getAttributes();
        Set remoteAETs = arcAE.mppsForwardRule().filter(rule -> rule.match(now, ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), mppsAttrs)).map(MPPSForwardRule::getDestinations).flatMap(Stream::of).collect(Collectors.toSet());
        for (String remoteAET : arcAE.mppsForwardDestinations()) {
            remoteAETs.add(remoteAET);
        }
        Attributes ssAttrs = mppsAttrs.getNestedDataset(4194928);
        Attributes patAttrs = ctx.getMPPS().getPatient().getAttributes();
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)patAttrs);
        for (String remoteAET : remoteAETs) {
            try {
                Task task = new Task();
                task.setDeviceName(this.device.getDeviceName());
                task.setQueueName("MPPSSCU");
                task.setScheduledTime(new Date());
                task.setLocalAET(ctx.getLocalApplicationEntity().getAETitle());
                task.setType(Task.Type.MPPS);
                task.setRemoteAET(remoteAET);
                task.setDIMSE(ctx.getDimse().name());
                task.setSOPInstanceUID(ctx.getSopInstanceUID());
                task.setAccessionNumber(ssAttrs.getString(524368));
                task.setStudyInstanceUID(ssAttrs.getString(0x20000D));
                task.setPatientID(idWithIssuer != null ? idWithIssuer.toString() : null);
                task.setPatientName(patAttrs.getString(0x100010));
                task.setPayload((Serializable)ctx.getAttributes());
                task.setStatus(Task.Status.SCHEDULED);
                this.taskManager.scheduleTask(task);
            }
            catch (Exception e) {
                LOG.warn("Failed to Schedule Forward of {} MPPS[uid={}] to AE: {}", new Object[]{ctx.getDimse(), ctx.getSopInstanceUID(), remoteAET, e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome forwardMPPS(String localAET, String remoteAET, Dimse dimse, String sopInstanceUID, Attributes attrs, Attributes procAttrs) throws Exception {
        ApplicationEntity localAE = this.device.getApplicationEntity(localAET, true);
        ApplicationEntity remoteAE = this.aeCache.findApplicationEntity(remoteAET);
        AAssociateRQ aarq = this.mkAAssociateRQ(localAE);
        Association as = localAE.connect(remoteAE, aarq);
        ProcedureContext pCtx = this.createProcedureCtx(sopInstanceUID, attrs.getString(4194898), as, dimse, procAttrs);
        try {
            DimseRSP rsp = dimse == Dimse.N_CREATE_RQ ? as.ncreate("1.2.840.10008.3.1.2.3.3", sopInstanceUID, attrs, null) : as.nset("1.2.840.10008.3.1.2.3.3", sopInstanceUID, attrs, null);
            rsp.next();
            Outcome outcome = this.outcome(rsp.getCommand().getInt(2304, -1), dimse, sopInstanceUID, remoteAET, pCtx);
            return outcome;
        }
        finally {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association to {}", (Object)as, (Object)remoteAET);
            }
            finally {
                this.procedureEvent.fire((Object)pCtx);
            }
        }
    }

    private Outcome outcome(int status, Dimse dimse, String sopInstanceUID, String remoteAET, ProcedureContext pCtx) {
        if (status != 0) {
            String warning = "Forward " + dimse + " MPPS[uid=" + sopInstanceUID + "] to AE: " + remoteAET + " failed with error status: " + Integer.toHexString(status) + "H";
            pCtx.setOutcomeMsg(warning);
            return new Outcome(Task.Status.WARNING, warning);
        }
        return new Outcome(Task.Status.COMPLETED, "Forward " + dimse + " MPPS[uid=" + sopInstanceUID + "] to AE: " + remoteAET);
    }

    private ProcedureContext createProcedureCtx(String sopInstanceUID, String status, Association as, Dimse dimse, Attributes procAttrs) {
        ProcedureContext pCtx = this.procService.createProcedureContext().setAssociation(as);
        pCtx.setAttributes(procAttrs);
        pCtx.setMppsUID(sopInstanceUID);
        pCtx.setStatus(status);
        pCtx.setEventActionCode(dimse == Dimse.N_CREATE_RQ ? "C" : "U");
        return pCtx;
    }

    private AAssociateRQ mkAAssociateRQ(ApplicationEntity localAE) {
        AAssociateRQ aarq = new AAssociateRQ();
        TransferCapability tc = localAE.getTransferCapabilityFor("1.2.840.10008.3.1.2.3.3", TransferCapability.Role.SCU);
        aarq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.3.1.2.3.3", tc.getTransferSyntaxes()));
        return aarq;
    }
}

