/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.mpps.impl;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.net.service.BasicMPPSSCP;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.mpps.MPPSContext;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;

@Stateless
public class MPPSServiceEJB {
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private PatientService patientService;
    @Inject
    private CodeCache codeCache;

    public MPPS createMPPS(MPPSContext ctx) {
        ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        AttributeFilter filter = arcDev.getAttributeFilter(Entity.MPPS);
        Attributes attrs = ctx.getAttributes();
        MPPS mpps = new MPPS();
        mpps.setSopInstanceUID(ctx.getSopInstanceUID());
        PatientMgtContext patMgtCtx = this.patientService.createPatientMgtContextDIMSE(ctx.getAssociation());
        patMgtCtx.setAttributes(attrs);
        Patient pat = this.patientService.findPatient(patMgtCtx);
        if (pat == null) {
            pat = this.patientService.createPatient(patMgtCtx);
        }
        mpps.setPatient(pat);
        mpps.setDiscontinuationReasonCode(this.discontinuationReasonCodeOf(attrs));
        mpps.setAttributes(attrs, filter);
        this.em.persist((Object)mpps);
        return mpps;
    }

    public MPPS updateMPPS(MPPSContext ctx) throws DicomServiceException {
        Attributes attrs;
        ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        AttributeFilter filter = arcDev.getAttributeFilter(Entity.MPPS);
        MPPS mpps = this.findMPPS(ctx);
        if (mpps.getStatus() != MPPS.Status.IN_PROGRESS) {
            BasicMPPSSCP.mayNoLongerBeUpdated();
        }
        if ((attrs = mpps.getAttributes()).updateSelected(Attributes.UpdatePolicy.OVERWRITE, ctx.getAttributes(), null, filter.getSelection())) {
            mpps.setDiscontinuationReasonCode(this.discontinuationReasonCodeOf(attrs));
            mpps.setAttributes(attrs, filter);
        }
        return mpps;
    }

    public MPPS findMPPS(MPPSContext ctx) throws DicomServiceException {
        try {
            return (MPPS)this.em.createNamedQuery("MPPS.findBySOPInstanceUID", MPPS.class).setParameter(1, (Object)ctx.getSopInstanceUID()).getSingleResult();
        }
        catch (NoResultException e) {
            throw new DicomServiceException(274);
        }
    }

    private CodeEntity discontinuationReasonCodeOf(Attributes attrs) {
        Attributes item = attrs.getNestedDataset(7606286);
        return item != null ? this.codeCache.findOrCreate(new Code(item)) : null;
    }
}

