/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.keyvalue.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.dcm4chee.arc.entity.KeyValue;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.keyvalue.ContentTypeMismatchException;
import org.dcm4chee.arc.keyvalue.KeyValueService;
import org.dcm4chee.arc.keyvalue.UserMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="values")
@RequestScoped
public class KeyValueRS {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueRS.class);
    @Inject
    private KeyValueService service;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpHeaders headers;

    @GET
    @Path(value="/{key}")
    public Response getValue(@PathParam(value="key") String key) {
        this.logRequest();
        KeyValue keyValue = this.service.getKeyValue(key, this.username());
        if (keyValue == null) {
            return this.errResponse("There is no Value with the specified Key.", Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)keyValue.getValue(), (String)keyValue.getContentType()).build();
    }

    @PUT
    @Path(value="/{key}")
    public Response setValue(@PathParam(value="key") String key, @QueryParam(value="share") @Pattern(regexp="true|false") @Pattern(regexp="true|false") String share, String value) {
        this.logRequest();
        try {
            String contentType = this.request.getContentType();
            this.service.setKeyValue(key, this.username(), Boolean.parseBoolean(share), value, contentType);
            return Response.noContent().build();
        }
        catch (UserMismatchException e) {
            return this.errResponse(e.getMessage(), Response.Status.FORBIDDEN);
        }
        catch (ContentTypeMismatchException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="/{key}")
    public Response deleteValue(@PathParam(value="key") String key) {
        this.logRequest();
        try {
            KeyValue keyValue = this.service.deleteKeyValue(key, this.username());
            if (keyValue == null) {
                return this.errResponse("There is no Value with the specified Key.", Response.Status.NOT_FOUND);
            }
            return Response.noContent().build();
        }
        catch (UserMismatchException e) {
            return this.errResponse(e.getMessage(), Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String charset(String contentType) {
        if (contentType.contains("charset")) {
            String[] split;
            for (String s : split = contentType.split(";")) {
                if (!s.contains("charset")) continue;
                return s.substring(s.indexOf("=") + 1);
            }
        }
        return StandardCharsets.UTF_8.name();
    }

    private String username() {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        return keycloakContext.isSecured() ? keycloakContext.getUserName() : null;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String errorMessage, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + errorMessage + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

