/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impax.report;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.impax.report.ArrayOfString;
import org.dcm4chee.arc.impax.report.ReportService;
import org.dcm4chee.arc.impax.report.ReportServicePortType;

@ApplicationScoped
public class ReportServiceProvider {
    @Inject
    private Device device;
    private ReportService service = new ReportService();

    public List<String> queryReportByStudyUid(String studyIUID) throws ConfigurationException {
        Map props = ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getImpaxReportProperties();
        String wget = (String)props.get("wget");
        if (wget != null) {
            return Collections.singletonList(this.wget(wget.replace("{}", studyIUID)));
        }
        Holder result = new Holder();
        Holder xmlReports = new Holder();
        this.port(props).queryReportByStudyUid(studyIUID, (Holder<Boolean>)result, (Holder<ArrayOfString>)xmlReports);
        return (Boolean)result.value != false ? ((ArrayOfString)xmlReports.value).getString() : Collections.EMPTY_LIST;
    }

    private String wget(String url) {
        String string;
        block8: {
            InputStream in = new URL(url).openStream();
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                StreamUtils.copy((InputStream)in, (OutputStream)out);
                string = new String(out.toByteArray(), "UTF-8");
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new WebServiceException("Failed to fetch report from " + url, (Throwable)e);
                }
            }
            in.close();
        }
        return string;
    }

    private ReportServicePortType port(Map<String, String> props) throws ConfigurationException {
        String endpoint = props.get("endpoint");
        if (endpoint == null) {
            throw new ConfigurationException("Missing ImpaxReportProperty endpoint");
        }
        ReportServicePortType port = this.service.getReportServicePort();
        BindingProvider bindingProvider = (BindingProvider)port;
        Map reqCtx = bindingProvider.getRequestContext();
        reqCtx.put("javax.xml.ws.service.endpoint.address", endpoint);
        if (endpoint.startsWith("https")) {
            Client client = ClientProxy.getClient((Object)port);
            HTTPConduit conduit = (HTTPConduit)client.getConduit();
            conduit.setTlsClientParameters(this.tlsClientParams(props));
        }
        return port;
    }

    private TLSClientParameters tlsClientParams(Map<String, String> props) throws ConfigurationException {
        TLSClientParameters params = new TLSClientParameters();
        try {
            params.setKeyManagers(this.device.keyManagers());
            params.setTrustManagers(this.device.trustManagers());
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        params.setSecureSocketProtocol(props.get("TLS.protocol"));
        for (String cipherSuite : StringUtils.split((String)props.get("TLS.cipherSuites"), (char)',')) {
            params.getCipherSuites().add(cipherSuite.trim());
        }
        params.setDisableCNCheck(Boolean.parseBoolean(props.getOrDefault("TLS.disableCNCheck", "false")));
        return params;
    }
}

