/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Issuer;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.InputReadinessState;
import org.dcm4chee.arc.conf.UPSPriority;
import org.dcm4chee.arc.conf.UPSState;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.BlobCorruptedException;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Subscription;
import org.dcm4chee.arc.entity.UPSRequest;

@NamedQueries(value={@NamedQuery(name="UPS.findByPatient", query="select ups from UPS ups where ups.patient = ?1"), @NamedQuery(name="UPS.findByIUID", query="select ups from UPS ups where ups.upsInstanceUID = ?1"), @NamedQuery(name="UPS.findByIUIDEager", query="select ups from UPS ups join fetch ups.patient p join fetch ups.attributesBlob join fetch p.attributesBlob where ups.upsInstanceUID = ?1"), @NamedQuery(name="UPS.findWithoutDeletionLock", query="select ups from UPS ups where ((ups.procedureStepState = ?1 and ups.updatedTime < ?2) or (ups.procedureStepState = ?3 and ups.updatedTime < ?4)) and not exists (select sub from Subscription sub where sub.ups = ups and sub.deletionLock = ?5) order by ups.updatedTime"), @NamedQuery(name="UPS.deleteByPatient", query="delete from UPS ups where ups.patient = ?1")})
@Entity
@Table(name="ups", uniqueConstraints={@UniqueConstraint(columnNames={"ups_iuid"})}, indexes={@Index(columnList="updated_time"), @Index(columnList="ups_priority"), @Index(columnList="ups_label"), @Index(columnList="worklist_label"), @Index(columnList="start_date_time"), @Index(columnList="expiration_date_time"), @Index(columnList="expected_end_date_time"), @Index(columnList="input_readiness_state"), @Index(columnList="admission_id"), @Index(columnList="replaced_iuid"), @Index(columnList="ups_state")})
public class UPS {
    public static final String FIND_BY_PATIENT = "UPS.findByPatient";
    public static final String FIND_BY_IUID = "UPS.findByIUID";
    public static final String FIND_BY_IUID_EAGER = "UPS.findByIUIDEager";
    public static final String FIND_WO_DELETION_LOCK = "UPS.findWithoutDeletionLock";
    public static final String DELETE_BY_PATIENT = "UPS.deleteByPatient";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic(optional=false)
    @Column(name="ups_iuid", updatable=false)
    private String upsInstanceUID;
    @Basic(optional=false)
    @Column(name="ups_priority")
    private UPSPriority upsPriority;
    @Basic(optional=false)
    @Column(name="ups_label")
    private String upsLabel;
    @Basic(optional=false)
    @Column(name="worklist_label")
    private String worklistLabel;
    @Basic(optional=false)
    @Column(name="start_date_time")
    private String scheduledStartDateAndTime;
    @Basic(optional=false)
    @Column(name="expiration_date_time")
    private String scheduledProcedureStepExpirationDateTime;
    @Basic(optional=false)
    @Column(name="expected_end_date_time")
    private String expectedCompletionDateAndTime;
    @Basic(optional=false)
    @Column(name="input_readiness_state")
    private InputReadinessState inputReadinessState;
    @Basic(optional=false)
    @Column(name="admission_id")
    private String admissionID;
    @Column(name="admid_entity_id")
    private String admissionIDLocalNamespaceEntityID;
    @Column(name="admid_entity_uid")
    private String admissionIDUniversalEntityID;
    @Column(name="admid_entity_uid_type")
    private String admissionIDUniversalEntityIDType;
    @Basic(optional=false)
    @Column(name="replaced_iuid")
    private String replacedSOPInstanceUID;
    @Basic(optional=false)
    @Column(name="ups_state")
    private UPSState procedureStepState;
    @Column(name="transaction_iuid")
    private String transactionUID;
    @Column(name="performer_aet")
    private String performerAET;
    @ManyToOne
    @JoinColumn(name="ups_code_fk")
    private CodeEntity scheduledWorkitemCode;
    @ManyToMany
    @JoinTable(name="rel_ups_station_name_code", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="station_name_code_fk", referencedColumnName="pk")})
    private Collection<CodeEntity> scheduledStationNameCodes;
    @ManyToMany
    @JoinTable(name="rel_ups_station_class_code", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="station_class_code_fk", referencedColumnName="pk")})
    private Collection<CodeEntity> scheduledStationClassCodes;
    @ManyToMany
    @JoinTable(name="rel_ups_station_location_code", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="station_location_code_fk", referencedColumnName="pk")})
    private Collection<CodeEntity> scheduledStationGeographicLocationCodes;
    @ManyToMany
    @JoinTable(name="rel_ups_perf_code", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="perf_code_fk", referencedColumnName="pk")})
    private Collection<CodeEntity> humanPerformerCodes;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="ups_fk")
    private Collection<UPSRequest> referencedRequests;
    @OneToMany(mappedBy="ups")
    private Collection<Subscription> subscriptions;
    @ManyToOne(optional=false)
    @JoinColumn(name="patient_fk")
    private Patient patient;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, optional=false)
    @JoinColumn(name="dicomattrs_fk")
    private AttributesBlob attributesBlob;

    public String toString() {
        return "UPS[pk=" + this.pk + ", uid=" + this.upsInstanceUID + ", state=" + this.procedureStepState + "]";
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        Date now;
        this.updatedTime = now = new Date();
    }

    public long getPk() {
        return this.pk;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getUPSInstanceUID() {
        return this.upsInstanceUID;
    }

    public void setUpsInstanceUID(String upsInstanceUID) {
        this.upsInstanceUID = upsInstanceUID;
    }

    public UPSState getProcedureStepState() {
        return this.procedureStepState;
    }

    public String getTransactionUID() {
        return this.transactionUID;
    }

    public void setTransactionUID(String transactionUID) {
        this.transactionUID = transactionUID;
    }

    public String getPerformerAET() {
        return this.performerAET;
    }

    public void setPerformerAET(String performerAET) {
        this.performerAET = performerAET;
    }

    public AttributesBlob getAttributesBlob() {
        return this.attributesBlob;
    }

    public Attributes getAttributes() throws BlobCorruptedException {
        return this.attributesBlob.getAttributes();
    }

    public void setAttributes(Attributes attrs, AttributeFilter filter) {
        this.upsPriority = UPSPriority.valueOf((String)attrs.getString(7606784, "MEDIUM"));
        this.upsLabel = attrs.getString(7606788);
        this.worklistLabel = attrs.getString(7606786);
        this.scheduledStartDateAndTime = attrs.getString(0x404005, "*");
        this.scheduledProcedureStepExpirationDateTime = attrs.getString(0x404008, "*");
        this.expectedCompletionDateAndTime = attrs.getString(0x404011, "*");
        this.inputReadinessState = InputReadinessState.valueOf((String)attrs.getString(0x404041, "READY"));
        this.admissionID = attrs.getString(3670032, "*");
        Issuer admissionIDIssuer = Issuer.valueOf((Attributes)attrs.getNestedDataset(3670036));
        if (admissionIDIssuer != null) {
            this.admissionIDLocalNamespaceEntityID = admissionIDIssuer.getLocalNamespaceEntityID();
            this.admissionIDUniversalEntityID = admissionIDIssuer.getUniversalEntityID();
            this.admissionIDUniversalEntityIDType = admissionIDIssuer.getUniversalEntityIDType();
        } else {
            this.admissionIDLocalNamespaceEntityID = null;
            this.admissionIDUniversalEntityID = null;
            this.admissionIDUniversalEntityIDType = null;
        }
        this.replacedSOPInstanceUID = UPS.getString(attrs.getNestedDataset(7606820), 528725, "*");
        this.procedureStepState = UPSState.fromString((String)attrs.getString(7606272, "SCHEDULED"));
        if (this.attributesBlob == null) {
            this.attributesBlob = new AttributesBlob(new Attributes(attrs, filter.getSelection()));
        } else {
            this.attributesBlob.setAttributes(new Attributes(attrs, filter.getSelection()));
        }
        this.updatedTime = new Date();
    }

    private static String getString(Attributes item, int tag, String defVal) {
        return item != null ? item.getString(tag, defVal) : defVal;
    }

    public void setScheduledWorkitemCode(CodeEntity scheduledWorkitemCode) {
        this.scheduledWorkitemCode = scheduledWorkitemCode;
    }

    public Collection<CodeEntity> getScheduledStationNameCodes() {
        if (this.scheduledStationNameCodes == null) {
            this.scheduledStationNameCodes = new ArrayList<CodeEntity>();
        }
        return this.scheduledStationNameCodes;
    }

    public Collection<CodeEntity> getScheduledStationClassCodes() {
        if (this.scheduledStationClassCodes == null) {
            this.scheduledStationClassCodes = new ArrayList<CodeEntity>();
        }
        return this.scheduledStationClassCodes;
    }

    public Collection<CodeEntity> getScheduledStationGeographicLocationCodes() {
        if (this.scheduledStationGeographicLocationCodes == null) {
            this.scheduledStationGeographicLocationCodes = new ArrayList<CodeEntity>();
        }
        return this.scheduledStationGeographicLocationCodes;
    }

    public Collection<CodeEntity> getHumanPerformerCodes() {
        if (this.humanPerformerCodes == null) {
            this.humanPerformerCodes = new ArrayList<CodeEntity>();
        }
        return this.humanPerformerCodes;
    }

    public Collection<UPSRequest> getReferencedRequests() {
        if (this.referencedRequests == null) {
            this.referencedRequests = new ArrayList<UPSRequest>();
        }
        return this.referencedRequests;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }
}

