/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.delete.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.zip.ZipInputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.json.Json;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.util.SafeClose;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.BinaryPrefix;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StorageDuration;
import org.dcm4chee.arc.delete.StudyDeleteContext;
import org.dcm4chee.arc.delete.impl.DeletionServiceEJB;
import org.dcm4chee.arc.delete.impl.StudyDeleteContextImpl;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PurgeStorageScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeStorageScheduler.class);
    @Inject
    private DeletionServiceEJB ejb;
    @Inject
    private StoreService storeService;
    @Inject
    private StorageFactory storageFactory;
    @Inject
    private Event<StudyDeleteContext> studyDeletedEvent;
    private Set<String> inProcess = Collections.synchronizedSet(new HashSet());

    protected PurgeStorageScheduler() {
        super(Scheduler.Mode.scheduleAtFixedRate);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getPurgeStoragePollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        for (StorageDescriptor desc : arcDev.getStorageDescriptors()) {
            if (arcDev.getPurgeStoragePollingInterval() == null) {
                return;
            }
            if (desc.isReadOnly() || !this.inProcess.add(desc.getStorageID())) continue;
            this.device.execute(() -> {
                LOG.info("Start deletion on {}", (Object)desc);
                try {
                    this.process(arcDev, desc);
                }
                catch (Throwable e) {
                    LOG.warn("Deletion on {} throws:\n", (Object)desc, (Object)e);
                }
                finally {
                    this.inProcess.remove(desc.getStorageID());
                    LOG.info("Finished deletion on {}", (Object)desc);
                }
            });
        }
    }

    public void onExport(@Observes ExportContext ctx) {
        ExporterDescriptor desc = ctx.getExporter().getExporterDescriptor();
        String storageID = desc.getDeleteStudyFromStorageID();
        if (ctx.getException() != null || storageID == null || ctx.getOutcome().getStatus() != Task.Status.COMPLETED) {
            return;
        }
        String suid = ctx.getStudyInstanceUID();
        if (ctx.getSeriesInstanceUID() != null) {
            if (ctx.getSopInstanceUID() != null) {
                LOG.info("Suppress deletion of objects from {} on export of Instance[uid={}] of Series[uid={}] of Study[uid={}] by Exporter[id={}]", new Object[]{storageID, ctx.getSopInstanceUID(), ctx.getSeriesInstanceUID(), suid, desc.getExporterID()});
            } else {
                LOG.info("Suppress deletion of objects from {} on export of Series[uid={}] of Study[uid={}] by Exporter[id={}]", new Object[]{storageID, ctx.getSeriesInstanceUID(), suid, desc.getExporterID()});
            }
            return;
        }
        try {
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            StorageDescriptor storageDesc = arcDev.getStorageDescriptorNotNull(storageID);
            if (this.ejb.deleteObjectsOfStudy(suid, storageDesc)) {
                LOG.info("Successfully marked objects of Study[uid={}] at {} for deletion", (Object)suid, (Object)storageDesc);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to mark objects of Study[uid={}] at Storage[id={}] for deletion", new Object[]{suid, storageID, e});
        }
    }

    private void process(ArchiveDeviceExtension arcDev, StorageDescriptor desc) {
        block6: {
            block5: {
                this.deleteSeriesMetadata(arcDev, desc);
                this.deleteObjectsFromStorage(arcDev, desc);
                if (desc.getStorageDuration() == StorageDuration.PERMANENT) {
                    return;
                }
                while (desc.hasRetentionPeriods() && arcDev.getPurgeStoragePollingInterval() != null && this.deleteStudies(arcDev, desc, true) > 0) {
                    this.deleteObjectsFromStorage(arcDev, desc);
                }
                if (!desc.hasDeleterThresholds()) break block5;
                long minUsableSpace = desc.getDeleterThresholdMinUsableSpace(Calendar.getInstance());
                long deleteSize = this.sizeToDelete(desc, minUsableSpace);
                if (deleteSize == 0L) {
                    return;
                }
                LOG.info("Usable Space on {} {} below {} - start deleting {}", new Object[]{desc.getStorageDuration(), desc, BinaryPrefix.formatDecimal((long)minUsableSpace), BinaryPrefix.formatDecimal((long)deleteSize)});
                while (arcDev.getPurgeStoragePollingInterval() != null && deleteSize > 0L && this.deleteStudies(arcDev, desc, false) > 0) {
                    this.deleteObjectsFromStorage(arcDev, desc);
                    deleteSize = this.sizeToDelete(desc, minUsableSpace);
                }
                break block6;
            }
            if (desc.hasRetentionPeriods() || !desc.isNoDeletionConstraint()) break block6;
            LOG.info("Start deleting objects from {} {}", (Object)desc.getStorageDuration(), (Object)desc);
            while (arcDev.getPurgeStoragePollingInterval() != null && this.deleteStudies(arcDev, desc, false) > 0) {
                this.deleteObjectsFromStorage(arcDev, desc);
            }
        }
    }

    private long sizeToDelete(StorageDescriptor desc, long minUsableSpace) {
        long l;
        block9: {
            if (minUsableSpace < 0L) {
                return 0L;
            }
            Storage storage = this.storageFactory.getStorage(desc);
            try {
                l = Math.max(0L, minUsableSpace - storage.getUsableSpace());
                if (storage == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (storage != null) {
                        try {
                            storage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Failed to determine usable space on {}", (Object)desc, (Object)e);
                    return 0L;
                }
            }
            storage.close();
        }
        return l;
    }

    private int deleteStudies(ArchiveDeviceExtension arcDev, StorageDescriptor desc, boolean retentionPeriods) {
        List<Study.PKUID> studyPks;
        try {
            studyPks = this.findStudiesForDeletion(arcDev, desc, retentionPeriods);
        }
        catch (Exception e) {
            LOG.warn("Query for studies for deletion on {} failed", (Object)desc, (Object)e);
            return 0;
        }
        if (studyPks.isEmpty()) {
            LOG.warn("No studies for deletion found on {}", (Object)desc);
            return 0;
        }
        return desc.getStorageDuration() == StorageDuration.CACHE ? this.deleteObjectsOfStudies(arcDev, desc, studyPks) : this.deleteStudiesFromDB(arcDev, desc, studyPks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Study.PKUID> findStudiesForDeletion(ArchiveDeviceExtension arcDev, StorageDescriptor desc, boolean retentionPeriods) {
        int deleteStudyBatchSize = arcDev.getDeleteStudyBatchSize();
        List<Study.PKUID> studyPks = this.ejb.findStudiesForDeletionOnStorage(desc, retentionPeriods, deleteStudyBatchSize);
        String storageID = desc.getStorageID();
        String[] exportStorageID = desc.getExportStorageID();
        StoreSession storeSession = this.storeService.newStoreSession((ApplicationEntity)this.device.getApplicationEntities().iterator().next());
        Duration purgeInstanceRecordsDelay = arcDev.getPurgeInstanceRecordsDelay();
        Iterator<Study.PKUID> iter = studyPks.iterator();
        block7: while (iter.hasNext()) {
            Study.PKUID studyPkUID = iter.next();
            if (exportStorageID.length == 0) {
                try {
                    this.storeService.restoreInstances(storeSession, studyPkUID.uid, null, purgeInstanceRecordsDelay);
                }
                catch (Exception e) {
                    LOG.warn("Failed to restore Instance records of {} - defer deletion of Study from {}\n", new Object[]{studyPkUID, desc, e});
                    this.ejb.updateStudyAccessTime(studyPkUID.pk);
                    iter.remove();
                }
                continue;
            }
            int notStoredOnOtherStorage = this.ejb.instancesNotStoredOnExportStorage(studyPkUID.pk, desc);
            HashMap<String, Storage> storageMap = new HashMap<String, Storage>();
            List<Series> seriesWithPurgedInstances = null;
            try {
                seriesWithPurgedInstances = this.ejb.findSeriesWithPurgedInstances(studyPkUID.pk);
                for (Series series : seriesWithPurgedInstances) {
                    Storage storage = this.getStorage(arcDev, series.getMetadata().getStorageID(), storageMap);
                    ReadContext readContext = storage.createReadContext();
                    readContext.setStoragePath(series.getMetadata().getStoragePath());
                    notStoredOnOtherStorage += PurgeStorageScheduler.instancesNotStoredOnOtherStorage(readContext, storageID, exportStorageID);
                }
            }
            finally {
                for (Storage storage : storageMap.values()) {
                    SafeClose.close((Closeable)storage);
                }
            }
            if (notStoredOnOtherStorage > 0) {
                LOG.info("{} instances of {} on {} not stored on Storage[id={}] - defer deletion of objects", new Object[]{notStoredOnOtherStorage, studyPkUID, desc, exportStorageID});
                this.ejb.updateStudyAccessTime(studyPkUID.pk);
                iter.remove();
                continue;
            }
            if (seriesWithPurgedInstances.isEmpty()) continue;
            for (Series series : seriesWithPurgedInstances) {
                try {
                    this.storeService.restoreInstances(storeSession.withObjectStorageID(storageID), studyPkUID.uid, series.getSeriesInstanceUID(), purgeInstanceRecordsDelay);
                }
                catch (Exception e) {
                    LOG.warn("Failed to restore Instance records of Series[pk={}] - defer deletion of objects from Storage[id={}]\n", new Object[]{series.getPk(), desc, e});
                    this.ejb.updateStudyAccessTime(studyPkUID.pk);
                    iter.remove();
                    continue block7;
                }
            }
        }
        return studyPks;
    }

    private Storage getStorage(ArchiveDeviceExtension arcDev, String storageID, Map<String, Storage> storageMap) {
        Storage storage = storageMap.get(storageID);
        if (storage == null) {
            storage = this.storageFactory.getStorage(arcDev.getStorageDescriptorNotNull(storageID));
            storageMap.put(storageID, storage);
        }
        return storage;
    }

    private static int instancesNotStoredOnOtherStorage(ReadContext ctx, String storageID, String[] exportStorageID) {
        int count = 0;
        LOG.debug("Read Metadata {} from {}", (Object)ctx.getStoragePath(), (Object)ctx.getStorage().getStorageDescriptor());
        try (InputStream in = ctx.getStorage().openInputStream(ctx);){
            ZipInputStream zip = new ZipInputStream(in);
            while (zip.getNextEntry() != null) {
                JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)zip, "UTF-8")));
                Attributes metadata = jsonReader.readDataset(null);
                if (PurgeStorageScheduler.containsStorageID(metadata, PurgeStorageScheduler::matchStorageID, storageID) && !PurgeStorageScheduler.containsStorageID(metadata, PurgeStorageScheduler::matchStorageIDAndCheckStatus, exportStorageID)) {
                    ++count;
                }
                zip.closeEntry();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to read Metadata {} from {}", (Object)ctx.getStoragePath(), (Object)ctx.getStorage().getStorageDescriptor());
            ++count;
        }
        return count;
    }

    private static boolean containsStorageID(Attributes attrs, BiPredicate<Attributes, String[]> predicate, String ... storageID) {
        if (predicate.test(attrs, storageID)) {
            return true;
        }
        Sequence otherStorageSeq = attrs.getSequence("DCM4CHEE Archive 5", 0x77770055);
        if (otherStorageSeq != null) {
            for (Attributes otherStorageItem : otherStorageSeq) {
                if (!predicate.test(otherStorageItem, storageID)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchStorageID(Attributes attrs, String ... storageID) {
        return Arrays.asList(storageID).contains(attrs.getString("DCM4CHEE Archive 5", 0x77770050));
    }

    private static boolean matchStorageIDAndCheckStatus(Attributes attrs, String ... storageID) {
        if (!PurgeStorageScheduler.matchStorageID(attrs, storageID)) {
            return false;
        }
        String status = attrs.getString("DCM4CHEE Archive 5", 2004287574);
        return status == null || status.equals(Location.Status.OK.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteStudiesFromDB(ArchiveDeviceExtension arcDev, StorageDescriptor desc, List<Study.PKUID> studyPkUIDs) {
        int removed = 0;
        for (Study.PKUID pkUID : studyPkUIDs) {
            if (arcDev.getPurgeStoragePollingInterval() == null) break;
            StudyDeleteContextImpl ctx = new StudyDeleteContextImpl(pkUID.pk);
            try {
                int n;
                int limit = arcDev.getDeleteStudyChunkSize();
                while ((n = this.ejb.deleteStudy(ctx, limit, false).size()) > 0) {
                    LOG.debug("Deleted {} instances of Study[pk={}]", (Object)n, (Object)pkUID.pk);
                }
                ++removed;
                LOG.info("Successfully delete {} on {}", (Object)ctx.getStudy(), (Object)desc);
            }
            catch (Exception e) {
                LOG.warn("Failed to delete {} on {}", new Object[]{pkUID, desc, e});
                ctx.setException(e);
            }
            finally {
                if (ctx.getStudy() == null) continue;
                try {
                    this.studyDeletedEvent.fire((Object)ctx);
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception in Study Deletion audit : " + e.getMessage());
                }
            }
        }
        return removed;
    }

    private int deleteObjectsOfStudies(ArchiveDeviceExtension arcDev, StorageDescriptor desc, List<Study.PKUID> studyPkUIDs) {
        int removed = 0;
        for (Study.PKUID studyPkUID : studyPkUIDs) {
            if (arcDev.getPurgeStoragePollingInterval() == null) break;
            try {
                if (!this.ejb.deleteObjectsOfStudy(studyPkUID.pk, desc)) continue;
                ++removed;
                LOG.info("Successfully marked objects of {} at {} for deletion", (Object)studyPkUID, (Object)desc);
            }
            catch (Exception e) {
                if (this.ejb.hasObjectsOnStorage(studyPkUID.pk, desc)) {
                    LOG.warn("Failed to mark objects of {} at {} for deletion", new Object[]{studyPkUID, desc, e});
                    continue;
                }
                LOG.info("{} does not contain objects at {}", (Object)studyPkUID, (Object)desc);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSeriesMetadata(ArchiveDeviceExtension arcDev, StorageDescriptor desc) {
        List<Metadata> metadataList;
        int fetchSize = arcDev.getPurgeStorageFetchSize();
        do {
            if (arcDev.getPurgeStoragePollingInterval() == null) {
                return;
            }
            LOG.debug("Query for Metadata marked for deletion from {}", (Object)desc);
            metadataList = this.ejb.findMetadataWithStatus(desc.getStorageID(), Metadata.Status.TO_DELETE, fetchSize);
            if (metadataList.isEmpty()) {
                LOG.debug("No Metadata marked for deletion found at {}", (Object)desc);
                break;
            }
            LOG.info("Start deleting {} Metadata from {}", (Object)metadataList.size(), (Object)desc);
            AtomicInteger success = new AtomicInteger();
            AtomicInteger skipped = new AtomicInteger();
            int deleteThreads = desc.getDeleterThreads();
            Semaphore semaphore = deleteThreads > 1 ? new Semaphore(deleteThreads) : null;
            try (Storage storage = this.storageFactory.getStorage(desc);){
                for (Metadata metadata : metadataList) {
                    if (semaphore == null) {
                        this.deleteSeriesMetadata(storage, metadata, success, skipped);
                        continue;
                    }
                    semaphore.acquire();
                    this.device.execute(() -> {
                        try {
                            this.deleteSeriesMetadata(storage, metadata, success, skipped);
                        }
                        finally {
                            semaphore.release();
                        }
                    });
                }
                if (semaphore != null) {
                    LOG.debug("Waiting for finishing deleting {} Metadata from {}", (Object)metadataList.size(), (Object)desc);
                    semaphore.acquire(deleteThreads);
                    semaphore.release(deleteThreads);
                }
            }
            catch (Exception e) {
                try {
                    LOG.warn("Failed to access {}", (Object)desc, (Object)e);
                }
                catch (Throwable throwable) {
                    LOG.info("Finished deleting {} (skipped={}, failed={}) Metadata from {}", new Object[]{success, skipped, metadataList.size() - success.get() - skipped.get(), desc});
                    throw throwable;
                }
                LOG.info("Finished deleting {} (skipped={}, failed={}) Metadata from {}", new Object[]{success, skipped, metadataList.size() - success.get() - skipped.get(), desc});
            }
            LOG.info("Finished deleting {} (skipped={}, failed={}) Metadata from {}", new Object[]{success, skipped, metadataList.size() - success.get() - skipped.get(), desc});
        } while (metadataList.size() == fetchSize);
    }

    private void deleteSeriesMetadata(Storage storage, Metadata metadata, AtomicInteger success, AtomicInteger skipped) {
        try {
            if (this.ejb.claimDeleteMetadata(metadata)) {
                storage.deleteObject(metadata.getStoragePath());
                this.ejb.removeMetadata(metadata);
                LOG.debug("Successfully delete {} from {}", (Object)metadata, (Object)storage);
                success.getAndIncrement();
            } else {
                skipped.getAndIncrement();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to delete {} from {}", new Object[]{metadata, storage, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteObjectsFromStorage(ArchiveDeviceExtension arcDev, StorageDescriptor desc) {
        List<Location> locations;
        int fetchSize = arcDev.getPurgeStorageFetchSize();
        do {
            if (arcDev.getPurgeStoragePollingInterval() == null) {
                return;
            }
            LOG.debug("Query for objects marked for deletion at {}", (Object)desc);
            locations = this.ejb.findLocationsWithStatus(desc.getStorageID(), Location.Status.TO_DELETE, fetchSize);
            if (locations.isEmpty()) {
                LOG.debug("No objects marked for deletion found at {}", (Object)desc);
                break;
            }
            LOG.info("Start deleting {} objects from {}", (Object)locations.size(), (Object)desc);
            int deleteThreads = desc.getDeleterThreads();
            Semaphore semaphore = deleteThreads > 1 ? new Semaphore(deleteThreads) : null;
            AtomicInteger success = new AtomicInteger();
            AtomicInteger skipped = new AtomicInteger();
            try (Storage storage = this.storageFactory.getStorage(desc);){
                for (Location location : locations) {
                    if (semaphore == null) {
                        this.deleteLocation(storage, location, success, skipped);
                        continue;
                    }
                    semaphore.acquire();
                    this.device.execute(() -> {
                        try {
                            this.deleteLocation(storage, location, success, skipped);
                        }
                        finally {
                            semaphore.release();
                        }
                    });
                }
                if (semaphore != null) {
                    LOG.debug("Waiting for finishing deleting {} objects from {}", (Object)locations.size(), (Object)desc);
                    semaphore.acquire(deleteThreads);
                    semaphore.release(deleteThreads);
                }
            }
            catch (Exception e) {
                try {
                    LOG.warn("Failed to access {}", (Object)desc, (Object)e);
                }
                catch (Throwable throwable) {
                    LOG.info("Finished deleting {} (skipped={}, failed={}) objects from {}", new Object[]{success, skipped, locations.size() - success.get() - skipped.get(), desc});
                    throw throwable;
                }
                LOG.info("Finished deleting {} (skipped={}, failed={}) objects from {}", new Object[]{success, skipped, locations.size() - success.get() - skipped.get(), desc});
            }
            LOG.info("Finished deleting {} (skipped={}, failed={}) objects from {}", new Object[]{success, skipped, locations.size() - success.get() - skipped.get(), desc});
        } while (locations.size() == fetchSize);
    }

    private void deleteLocation(Storage storage, Location location, AtomicInteger success, AtomicInteger skipped) {
        int endTarPath;
        String storagePath = location.getStoragePath();
        if (storage.getStorageDescriptor().isTarArchiver() && (endTarPath = storagePath.indexOf(33)) > 0) {
            storagePath = storagePath.substring(0, endTarPath);
        }
        try {
            if (this.ejb.claimDeleteObject(location)) {
                storage.deleteObject(storagePath);
                this.ejb.removeLocation(location);
                LOG.debug("Successfully delete {} from {}", (Object)storagePath, (Object)storage);
                success.getAndIncrement();
            } else {
                skipped.getAndIncrement();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to delete {} from {}", new Object[]{location, storage, e});
        }
    }
}

