/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseCallingAETitleAsCoercion
implements AttributesCoercion {
    static final Logger LOG = LoggerFactory.getLogger(UseCallingAETitleAsCoercion.class);
    private final Type type;
    private final String callingAET;
    private final AttributesCoercion next;

    private UseCallingAETitleAsCoercion(Type type, String callingAET, AttributesCoercion next) {
        this.type = type;
        this.callingAET = callingAET;
        this.next = next;
    }

    public static AttributesCoercion of(Type type, String callingAET, AttributesCoercion next) {
        return type != null ? new UseCallingAETitleAsCoercion(type, callingAET, next) : next;
    }

    public String remapUID(String uid) {
        return this.next != null ? this.next.remapUID(uid) : uid;
    }

    public void coerce(Attributes attrs, Attributes modified) throws Exception {
        LOG.info("Use Calling AE Title coercion applied by {}", (Object)this);
        this.type.coerce(attrs, modified, this.callingAET);
        if (this.next != null) {
            this.next.coerce(attrs, modified);
        }
    }

    private static Attributes ensureItem(Sequence sq) {
        if (sq.isEmpty()) {
            sq.add(new Attributes(1));
        }
        return (Attributes)sq.get(0);
    }

    public static enum Type {
        ScheduledStationAETitle{

            @Override
            void coerce(Attributes attrs, Attributes modified, String callingAET) {
                Attributes sps = UseCallingAETitleAsCoercion.ensureItem(attrs.ensureSequence(0x400100, 1));
                if (!sps.containsValue(0x400001)) {
                    sps.setString(0x400001, VR.AE, callingAET);
                }
            }
        }
        ,
        SendingApplicationEntityTitleOfSeries{

            @Override
            void coerce(Attributes attrs, Attributes modified, String callingAET) {
                if (!attrs.containsValue("DCM4CHEE Archive 5", 0x77770037)) {
                    attrs.setString("DCM4CHEE Archive 5", 0x77770037, VR.AE, callingAET);
                }
            }
        };


        abstract void coerce(Attributes var1, Attributes var2, String var3);
    }
}

