/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.coerce.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.deident.DeIdentifier;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.coerce.CoercionProcessor;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="deidentify")
public class DeIdentificationCoercionProcessor
implements CoercionProcessor {
    static final Logger LOG = LoggerFactory.getLogger(DeIdentificationCoercionProcessor.class);

    public boolean coerce(ArchiveAttributeCoercion2 coercion, String sopClassUID, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs, Attributes modified) throws Exception {
        String[] names = StringUtils.split((String)coercion.getSchemeSpecificPart(), (char)',');
        DeIdentifier.Option[] options = new DeIdentifier.Option[names.length];
        for (int i = 0; i < names.length; ++i) {
            options[i] = DeIdentifier.Option.valueOf((String)names[i]);
        }
        new DeIdentifier(options).deidentify(attrs);
        LOG.info("Deidentified attributes by coercion {}", (Object)coercion);
        return true;
    }

    public String remapUID(ArchiveAttributeCoercion2 coercion, String uid) {
        for (String name : StringUtils.split((String)coercion.getSchemeSpecificPart(), (char)',')) {
            if (!name.equals("RetainUIDsOption")) continue;
            return uid;
        }
        return UIDUtils.remapUID((String)uid);
    }
}

