/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentificationBuilder;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.net.audit.AuditLoggerDeviceExtension;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.AssociationEvent;
import org.dcm4chee.arc.ConnectionEvent;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.audit.ApplicationActivityAuditService;
import org.dcm4chee.arc.audit.AssociationEventsAuditService;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.ConnectionEventsAuditService;
import org.dcm4chee.arc.audit.DeletionAuditService;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ExternalRetrieveAuditService;
import org.dcm4chee.arc.audit.HL7AuditUtils;
import org.dcm4chee.arc.audit.InstanceInfo;
import org.dcm4chee.arc.audit.PDQAuditService;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.PatientRecordAuditService;
import org.dcm4chee.arc.audit.ProcedureRecordAuditService;
import org.dcm4chee.arc.audit.ProvideAndRegisterAuditService;
import org.dcm4chee.arc.audit.QueryAuditService;
import org.dcm4chee.arc.audit.RetrieveAuditService;
import org.dcm4chee.arc.audit.SoftwareConfigurationAuditService;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.audit.SpoolFileWriter;
import org.dcm4chee.arc.audit.StorageCommitAuditService;
import org.dcm4chee.arc.audit.StudyRecordAuditService;
import org.dcm4chee.arc.audit.TaskAuditService;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.delete.StudyDeleteContext;
import org.dcm4chee.arc.event.ArchiveServiceEvent;
import org.dcm4chee.arc.event.BulkTaskEvent;
import org.dcm4chee.arc.event.RejectionNoteSent;
import org.dcm4chee.arc.event.SoftwareConfiguration;
import org.dcm4chee.arc.event.StudySizeEvent;
import org.dcm4chee.arc.event.TaskEvent;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.stgcmt.StgCmtContext;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.study.StudyMgtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AuditService {
    private static final Logger LOG = LoggerFactory.getLogger(AuditService.class);
    @Inject
    private Device device;
    @Inject
    private IHL7ApplicationCache hl7AppCache;
    @Inject
    private IWebApplicationCache webAppCache;
    @Inject
    private IApplicationEntityCache aeCache;

    private void aggregateAuditMessage(AuditLogger auditLogger, Path path) throws Exception {
        AuditUtils.EventType eventType = AuditUtils.EventType.fromFile(path);
        if (path.toFile().length() == 0L) {
            LOG.info("Attempt to read from an empty file {} by {}.", (Object)path, (Object)eventType);
            return;
        }
        switch (eventType.eventClass) {
            case APPLN_ACTIVITY: {
                this.auditApplicationActivity(auditLogger, path, eventType);
                break;
            }
            case CONN_FAILURE: {
                this.auditConnectionFailure(auditLogger, path, eventType);
                break;
            }
            case STORE_WADOR: {
                this.auditStoreOrWADORetrieve(auditLogger, path, eventType);
                break;
            }
            case RETRIEVE: {
                this.auditRetrieve(auditLogger, path, eventType);
                break;
            }
            case USER_DELETED: 
            case SCHEDULER_DELETED: {
                this.auditDeletion(auditLogger, path, eventType);
                break;
            }
            case QUERY: {
                this.auditQuery(auditLogger, path, eventType);
                break;
            }
            case PATIENT: {
                this.auditPatientRecord(auditLogger, path, eventType);
                break;
            }
            case PROCEDURE: {
                this.auditProcedureRecord(auditLogger, path, eventType);
                break;
            }
            case STUDY: {
                this.auditStudyRecord(auditLogger, path, eventType);
                break;
            }
            case PROV_REGISTER: {
                this.auditProvideAndRegister(auditLogger, path, eventType);
                break;
            }
            case STGCMT: {
                this.auditStorageCommit(auditLogger, path, eventType);
                break;
            }
            case INST_RETRIEVED: {
                this.auditExternalRetrieve(auditLogger, path, eventType);
                break;
            }
            case LDAP_CHANGES: {
                this.auditSoftwareConfiguration(auditLogger, path, eventType);
                break;
            }
            case QUEUE_EVENT: {
                this.auditQueueMessageEvent(auditLogger, path, eventType);
                break;
            }
            case IMPAX: {
                this.auditPatientMismatch(auditLogger, path, eventType);
                break;
            }
            case ASSOCIATION_FAILURE: {
                this.auditAssociationFailure(auditLogger, path, eventType);
            }
        }
    }

    void spoolApplicationActivity(ArchiveServiceEvent event) {
        try {
            this.writeSpoolFile(AuditUtils.EventType.forApplicationActivity(event), null, ApplicationActivityAuditService.auditInfo(event, this.device.getDeviceName()));
        }
        catch (Exception e) {
            LOG.info("Failed to spool Application Activity [EventType={}]\n", (Object)event.getType(), (Object)e);
        }
    }

    private void auditApplicationActivity(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(ApplicationActivityAuditService.auditMsg(auditLogger, path, eventType), auditLogger);
    }

    private void spoolInstancesDeleted(StoreContext ctx, String suffix) {
        AuditUtils.EventType eventType = AuditUtils.EventType.forInstancesDeleted(ctx);
        try {
            this.writeSpoolFile(eventType, suffix, DeletionAuditService.instancesDeletedAuditInfo(ctx, this.getArchiveDevice()));
        }
        catch (Exception e) {
            LOG.info("Failed to spool Instances Deleted [AuditEventType={}]\n", (Object)eventType, (Object)e);
        }
    }

    void spoolStudyDeleted(StudyDeleteContext ctx) {
        AuditUtils.EventType eventType = AuditUtils.EventType.forStudyDeleted(ctx);
        try {
            this.writeSpoolFile(eventType, null, DeletionAuditService.studyDeletedAuditInfo(ctx, this.getArchiveDevice()));
        }
        catch (Exception e) {
            LOG.info("Failed to spool Study Deleted for [StudyIUID={}, AuditEventType={}]\n", new Object[]{ctx.getStudy().getStudyInstanceUID(), eventType, e});
        }
    }

    void spoolExternalRejection(RejectionNoteSent rejectionNoteSent) {
        AuditUtils.EventType eventType = AuditUtils.EventType.forExternalRejection(rejectionNoteSent);
        try {
            this.writeSpoolFile(eventType, null, DeletionAuditService.externalRejectionAuditInfo(rejectionNoteSent, this.getArchiveDevice()));
        }
        catch (Exception e) {
            LOG.info("Failed to spool External Rejection [AuditEventType={}]\n", (Object)eventType, (Object)e);
        }
    }

    private void auditDeletion(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(DeletionAuditService.auditMsg(auditLogger, path, eventType), auditLogger);
    }

    void spoolTaskEvent(TaskEvent taskEvent) {
        if (taskEvent.getTask() == null) {
            return;
        }
        String callingUser = KeycloakContext.valueOf((HttpServletRequest)taskEvent.getRequest()).getUserName();
        try {
            this.writeSpoolFile(AuditUtils.EventType.forQueueEvent(taskEvent.getOperation()), null, TaskAuditService.queueMsgAuditInfo(taskEvent));
        }
        catch (Exception e) {
            LOG.info("Failed to spool Task Event for [Operation={}] of [TaskID={}] triggered by [User={}]\n", new Object[]{taskEvent.getOperation(), taskEvent.getTask().getPk(), callingUser, e});
        }
    }

    void spoolBulkQueueMessageEvent(BulkTaskEvent bulkQueueMsgEvent) {
        HttpServletRequest request = bulkQueueMsgEvent.getRequest();
        String callingUser = request != null ? KeycloakContext.valueOf((HttpServletRequest)request).getUserName() : this.device.getDeviceName();
        try {
            this.writeSpoolFile(AuditUtils.EventType.forQueueEvent(bulkQueueMsgEvent.getOperation()), null, TaskAuditService.bulkQueueMsgAuditInfo(bulkQueueMsgEvent, callingUser));
        }
        catch (Exception e) {
            LOG.info("Failed to spool Bulk Queue Message Event for [QueueOperation={}] triggered by [User={}]\n", new Object[]{bulkQueueMsgEvent.getOperation(), callingUser, e});
        }
    }

    private void auditQueueMessageEvent(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(TaskAuditService.auditMsg(auditLogger, path, eventType), auditLogger);
    }

    void spoolSoftwareConfiguration(SoftwareConfiguration softwareConfiguration) {
        String callingUser = softwareConfiguration.getRequest() != null ? KeycloakContext.valueOf((HttpServletRequest)softwareConfiguration.getRequest()).getUserName() : softwareConfiguration.getDeviceName();
        try {
            this.writeSpoolFile(SoftwareConfigurationAuditService.auditInfo(softwareConfiguration, callingUser), AuditUtils.EventType.LDAP_CHNGS, new byte[][]{softwareConfiguration.getLdapDiff().toString().getBytes()});
        }
        catch (Exception e) {
            LOG.info("Failed to spool Software Configuration Changes for [Device={}] done by [CallingUser={}]\n", new Object[]{softwareConfiguration.getDeviceName(), callingUser, e});
        }
    }

    private void auditSoftwareConfiguration(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(SoftwareConfigurationAuditService.auditMsg(auditLogger, path, eventType), auditLogger);
    }

    void spoolExternalRetrieve(ExternalRetrieveContext ctx) {
        try {
            this.writeSpoolFile(AuditUtils.EventType.INST_RETRV, null, ExternalRetrieveAuditService.auditInfo(ctx, this.getArchiveDevice()));
        }
        catch (Exception e) {
            LOG.info("Failed to spool External Retrieve for [StudyIUID={}] triggered by [Requester={}]\n", new Object[]{ctx.getStudyInstanceUID(), ctx.getRequesterUserID(), e});
        }
    }

    private void auditExternalRetrieve(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(ExternalRetrieveAuditService.auditMsg(auditLogger, path, eventType, this.aeCache), auditLogger);
    }

    void spoolConnectionFailure(ConnectionEvent event) {
        if (event.getRemoteConnection().getProtocol().name().startsWith("SYSLOG")) {
            LOG.info("Suppress audits of connection failures to audit record repository : {}", (Object)event.getRemoteConnection().getDevice());
            return;
        }
        try {
            this.writeSpoolFile(AuditUtils.EventType.CONN_FAILR, null, ConnectionEventsAuditService.connFailureAuditInfo(event));
        }
        catch (Exception e) {
            LOG.info("Failed to spool Connection Failure for [EventType={}]\n", (Object)event.getType(), (Object)e);
        }
    }

    private void auditConnectionFailure(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(ConnectionEventsAuditService.auditMsg(auditLogger, path, eventType), auditLogger);
    }

    void spoolStudySizeEvent(StudySizeEvent event) {
        try {
            AuditInfoBuilder auditInfoBuilder = new AuditInfoBuilder.Builder().callingUserID(this.device.getDeviceName()).studyIUID(event.getStudyIUID()).patID(event.getPatientID(), this.getArchiveDevice()).build();
            this.writeSpoolFile(AuditUtils.EventType.STUDY_READ, null, auditInfoBuilder);
        }
        catch (Exception e) {
            LOG.info("Failed to spool study size info for {}\n", (Object)event, (Object)e);
        }
    }

    private void auditStudySize(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        SpoolFileReader reader = new SpoolFileReader(path.toFile());
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        EventIdentification ei = EventID.toEventIdentification(auditLogger, path, eventType, auditInfo);
        ActiveParticipant[] activeParticipants = new ActiveParticipant[]{new ActiveParticipantBuilder(auditInfo.getField(1), this.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).altUserID(AuditLogger.processID()).isRequester().build()};
        ParticipantObjectIdentificationBuilder studyPOI = ParticipantObjectID.studyPOI(auditInfo.getField(4));
        studyPOI.lifeCycle("8");
        ParticipantObjectIdentificationBuilder patientPOI = ParticipantObjectID.patientPOIBuilder(auditInfo);
        AuditMessage auditMsg = AuditMessages.createMessage((EventIdentification)ei, (ActiveParticipant[])activeParticipants, (ParticipantObjectIdentification[])new ParticipantObjectIdentification[]{studyPOI.build(), patientPOI.build()});
        this.emitAuditMessage(auditMsg, auditLogger);
    }

    void spoolPDQ(PDQServiceContext ctx) {
        try {
            if (ctx.getFhirWebAppName() == null) {
                this.writeSpoolFile(PDQAuditService.auditInfo(ctx, this.getArchiveDevice()), AuditUtils.EventType.PAT_DEMO_Q, ctx.getHl7Msg().data(), ctx.getRsp().data());
            } else {
                this.writeSpoolFile(PDQAuditService.auditInfoFHIR(ctx, this.getArchiveDevice()), AuditUtils.EventType.FHIR___PDQ, new byte[0][]);
            }
        }
        catch (Exception e) {
            LOG.info("Failed to spool PDQ for {}", (Object)ctx);
        }
    }

    void spoolQuery(QueryContext ctx) {
        if (ctx.getAssociation() == null && ctx.getHttpRequest() == null) {
            return;
        }
        try {
            AuditUtils.EventType eventType = AuditUtils.EventType.QUERY__EVT;
            AuditInfo auditInfo = new AuditInfo(QueryAuditService.auditInfo(ctx));
            FileTime eventTime = null;
            for (AuditLogger auditLogger : this.auditLoggers(ctx, eventType)) {
                Path directory = this.toDirPath(auditLogger);
                try {
                    Path file;
                    block20: {
                        Files.createDirectories(directory, new FileAttribute[0]);
                        file = Files.createTempFile(directory, eventType.name(), null, new FileAttribute[0]);
                        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, StandardOpenOption.APPEND));){
                            new DataOutputStream(out).writeUTF(auditInfo.toString());
                            if (ctx.getAssociation() == null) break block20;
                            try (DicomOutputStream dos = new DicomOutputStream((OutputStream)out, "1.2.840.10008.1.2");){
                                dos.writeDataset(null, ctx.getQueryKeys());
                            }
                            catch (Exception e) {
                                LOG.info("Failed to create DicomOutputStream.\n", (Throwable)e);
                            }
                        }
                    }
                    if (eventTime == null) {
                        eventTime = Files.getLastModifiedTime(file, new LinkOption[0]);
                    } else {
                        Files.setLastModifiedTime(file, eventTime);
                    }
                    if (this.getArchiveDevice().isAuditAggregate()) continue;
                    this.auditAndProcessFile(auditLogger, file);
                }
                catch (Exception e) {
                    LOG.info("Failed to write to Query Audit Spool File at [AuditLogger={}]\n", (Object)auditLogger.getCommonName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.info("Failed to spool Query.\n", (Throwable)e);
        }
    }

    private List<AuditLogger> auditLoggers(QueryContext ctx, AuditUtils.EventType eventType) {
        AuditLoggerDeviceExtension ext = (AuditLoggerDeviceExtension)this.device.getDeviceExtension(AuditLoggerDeviceExtension.class);
        if (ext == null) {
            return Collections.emptyList();
        }
        return ext.getAuditLoggers().stream().filter(auditLogger -> auditLogger.isInstalled() && !auditLogger.isAuditMessageSuppressed(this.createMinimalAuditMsg(eventType, ctx.getCallingAET()))).collect(Collectors.toList());
    }

    private AuditMessage createMinimalAuditMsg(AuditUtils.EventType eventType, String userID) {
        AuditMessage msg = new AuditMessage();
        msg.setEventIdentification(EventID.toEventIdentification(eventType));
        ActiveParticipant ap = new ActiveParticipant();
        ap.setUserID(userID);
        ap.setUserIsRequestor(true);
        msg.getActiveParticipant().add(ap);
        return msg;
    }

    void auditAndProcessFile(AuditLogger auditLogger, Path file) {
        try {
            this.aggregateAuditMessage(auditLogger, file);
            Files.delete(file);
        }
        catch (Exception e) {
            LOG.info("Failed to process [AuditSpoolFile={}] of [AuditLogger={}].\n", new Object[]{file, auditLogger.getCommonName(), e});
            try {
                Files.move(file, file.resolveSibling(file.getFileName().toString() + ".failed"), new CopyOption[0]);
            }
            catch (IOException e1) {
                LOG.info("Failed to mark [AuditSpoolFile={}] of [AuditLogger={}] as failed.\n", new Object[]{file, auditLogger.getCommonName(), e1});
            }
        }
    }

    private void auditQuery(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        AuditMessage msg = eventType.eventTypeCode == null ? QueryAuditService.auditMsg(auditLogger, path, eventType) : PDQAuditService.auditMsg(auditLogger, path, eventType, this.hl7AppCache, this.webAppCache);
        this.emitAuditMessage(msg, auditLogger);
    }

    void spoolStoreEvent(StoreContext ctx) {
        try {
            if (ctx.getRejectedInstance() != null) {
                LOG.info("Suppress audit on receive of instances rejected by a previous received Rejection Note : {}", (Object)ctx.getRejectedInstance());
                return;
            }
            RejectionNote rejectionNote = ctx.getRejectionNote();
            if (rejectionNote != null && !rejectionNote.isRevokeRejection()) {
                this.spoolInstancesDeleted(ctx, null);
                return;
            }
            if (this.isDuplicateReceivedInstance(ctx)) {
                if (rejectionNote != null && rejectionNote.isRevokeRejection()) {
                    this.spoolInstancesStored(ctx);
                }
                return;
            }
            if (ctx.getAttributes() == null) {
                LOG.info("Instances stored is not audited as store context attributes are not set. " + (ctx.getException() != null ? ctx.getException().getMessage() : null));
                return;
            }
            this.spoolInstancesStored(ctx);
        }
        catch (Exception e) {
            LOG.info("Failed to spool Store Event.\n", (Throwable)e);
        }
    }

    private void spoolInstancesStored(StoreContext ctx) {
        StoreSession ss = ctx.getStoreSession();
        HttpServletRequestInfo httpServletRequestInfo = ss.getHttpRequest();
        String callingUserID = httpServletRequestInfo != null ? httpServletRequestInfo.requesterUserID : (ss.getCallingAET() != null ? ss.getCallingAET() : this.device.getDeviceName());
        String calledUserID = httpServletRequestInfo != null ? this.requestURLWithQueryParams(httpServletRequestInfo) : ss.getCalledAET();
        try {
            String outcome = ctx.getException() != null ? (ctx.getRejectionNote() != null ? ctx.getRejectionNote().getRejectionNoteCode().getCodeMeaning() + "-" + ctx.getException().getMessage() : ctx.getException().getMessage()) : null;
            AuditInfoBuilder instanceInfo = new AuditInfoBuilder.Builder().sopCUID(ctx.getSopClassUID()).sopIUID(ctx.getSopInstanceUID()).mppsUID(ctx.getMppsInstanceUID()).outcome(outcome).errorCode(ctx.getException() instanceof DicomServiceException ? ((DicomServiceException)ctx.getException()).getStatus() : 0).build();
            ArchiveDeviceExtension arcDev = this.getArchiveDevice();
            Attributes attr = ctx.getAttributes();
            AuditInfoBuilder.Builder infoBuilder = new AuditInfoBuilder.Builder().callingHost(ss.getRemoteHostName()).callingUserID(callingUserID).calledUserID(calledUserID).impaxEndpoint(ss.getImpaxReportEndpoint()).studyUIDAccNumDate(attr, arcDev).pIDAndName(attr, arcDev);
            AuditInfoBuilder info = infoBuilder.warning(ctx.getRejectionNote() != null ? ctx.getRejectionNote().getRejectionNoteCode().getCodeMeaning() : null).build();
            String suffix = "-" + callingUserID.replace('|', '-') + "-" + ctx.getStoreSession().getCalledAET() + "-" + ctx.getStudyInstanceUID();
            suffix = outcome != null ? suffix.concat("_ERROR") : suffix;
            this.writeSpoolFile(AuditUtils.EventType.forInstanceStored(ctx), suffix, info, instanceInfo);
            if (ctx.getPreviousInstance() != null && ctx.getPreviousInstance().getSopInstanceUID().equals(ctx.getStoredInstance().getSopInstanceUID())) {
                this.spoolInstancesDeleted(ctx, suffix);
            }
            if (ctx.getImpaxReportPatientMismatch() != null) {
                AuditInfoBuilder patMismatchInfo = infoBuilder.patMismatchCode(ctx.getImpaxReportPatientMismatch().toString()).build();
                this.writeSpoolFile(AuditUtils.EventType.IMPAX_MISM, null, patMismatchInfo, instanceInfo);
            }
        }
        catch (Exception e) {
            LOG.info("Failed to spool Instances Stored for [StudyIUID={}] triggered by [CallingUser={}]\n", new Object[]{ctx.getStudyInstanceUID(), callingUserID, e});
        }
    }

    private void auditPatientMismatch(AuditLogger logger, Path path, AuditUtils.EventType eventType) throws Exception {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        AuditMessage auditMsg = AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(logger, path, eventType, auditInfo), (ActiveParticipant[])this.patientMismatchActiveParticipants(logger, auditInfo), (ParticipantObjectIdentification[])ParticipantObjectID.studyPatParticipants(auditInfo, reader.getInstanceLines(), eventType, logger));
        this.emitAuditMessage(auditMsg, logger);
    }

    private ActiveParticipant[] patientMismatchActiveParticipants(AuditLogger logger, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[3];
        String callingUserID = auditInfo.getField(1);
        String callingHost = auditInfo.getField(0);
        String calledUserID = auditInfo.getField(2);
        activeParticipants[0] = new ActiveParticipantBuilder(calledUserID, this.getLocalHostName(logger)).userIDTypeCode(this.userIDTypeCode(calledUserID)).build();
        activeParticipants[1] = new ActiveParticipantBuilder(callingUserID, callingHost != null ? callingHost : this.getLocalHostName(logger)).userIDTypeCode(callingHost != null ? AuditMessages.userIDTypeCode((String)callingUserID) : AuditMessages.UserIDTypeCode.DeviceName).isRequester().build();
        String impaxEndpoint = auditInfo.getField(34);
        activeParticipants[2] = new ActiveParticipantBuilder(impaxEndpoint, this.impaxEndpointHost(impaxEndpoint)).userIDTypeCode(this.userIDTypeCode(impaxEndpoint)).build();
        return activeParticipants;
    }

    private String impaxEndpointHost(String impaxEndpoint) {
        String impaxEndpointRelative = impaxEndpoint.substring(impaxEndpoint.indexOf("//") + 2);
        return impaxEndpointRelative.substring(0, impaxEndpointRelative.indexOf(47));
    }

    private boolean isDuplicateReceivedInstance(StoreContext ctx) {
        return ctx.getLocations().isEmpty() && ctx.getStoredInstance() == null && ctx.getException() == null;
    }

    void spoolRetrieveWADO(RetrieveContext ctx) {
        HttpServletRequestInfo httpServletRequestInfo = ctx.getHttpServletRequestInfo();
        try {
            Attributes attrs = ((InstanceLocations)ctx.getMatches().get(0)).getAttributes();
            String suffix = "-" + httpServletRequestInfo.requesterHost + "-" + ctx.getLocalAETitle() + "-" + ctx.getStudyInstanceUIDs()[0];
            AuditInfoBuilder info = new AuditInfoBuilder.Builder().callingHost(httpServletRequestInfo.requesterHost).callingUserID(httpServletRequestInfo.requesterUserID).calledUserID(this.requestURLWithQueryParams(httpServletRequestInfo)).studyUIDAccNumDate(attrs, this.getArchiveDevice()).pIDAndName(attrs, this.getArchiveDevice()).outcome(null != ctx.getException() ? ctx.getException().getMessage() : null).build();
            AuditInfoBuilder instanceInfo = new AuditInfoBuilder.Builder().sopCUID(attrs.getString(524310)).sopIUID(ctx.getSopInstanceUIDs()[0]).build();
            this.writeSpoolFile(AuditUtils.EventType.WADO___URI, suffix, info, instanceInfo);
        }
        catch (Exception e) {
            LOG.info("Failed to spool Wado Retrieve for [StudyIUID={}] triggered by [User={}]\n", new Object[]{ctx.getStudyInstanceUID(), httpServletRequestInfo.requesterUserID, e});
        }
    }

    private String requestURLWithQueryParams(HttpServletRequestInfo httpServletRequestInfo) {
        return httpServletRequestInfo.queryString == null ? httpServletRequestInfo.requestURI : httpServletRequestInfo.requestURI + "?" + httpServletRequestInfo.queryString;
    }

    private void auditStoreError(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        InstanceInfo instanceInfo = new InstanceInfo();
        HashSet<String> outcome = new HashSet<String>();
        HashSet<AuditMessages.EventTypeCode> errorCode = new HashSet<AuditMessages.EventTypeCode>();
        instanceInfo.addAcc(auditInfo);
        reader.getInstanceLines().forEach(line -> {
            AuditInfo info = new AuditInfo((String)line);
            outcome.add(info.getField(8));
            AuditMessages.EventTypeCode errorEventTypeCode = AuditUtils.errorEventTypeCode(info.getField(29));
            if (errorEventTypeCode != null) {
                errorCode.add(errorEventTypeCode);
            }
            instanceInfo.addSOPInstance(info);
            instanceInfo.addMpps(info);
        });
        AuditMessage auditMsg = AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, outcome, errorCode), (ActiveParticipant[])this.storeWadoURIActiveParticipants(auditLogger, auditInfo, eventType), (ParticipantObjectIdentification[])ParticipantObjectID.studyPatParticipants(auditInfo, instanceInfo));
        this.emitAuditMessage(auditMsg, auditLogger);
    }

    private void auditStoreOrWADORetrieve(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        if (path.toFile().getName().endsWith("_ERROR")) {
            this.auditStoreError(auditLogger, path, eventType);
            return;
        }
        if (eventType.name().startsWith("WADO")) {
            this.auditWADORetrieve(auditLogger, path, eventType);
            return;
        }
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        AuditMessage auditMsg = AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])this.storeWadoURIActiveParticipants(auditLogger, auditInfo, eventType), (ParticipantObjectIdentification[])ParticipantObjectID.studyPatParticipants(auditInfo, reader.getInstanceLines(), eventType, auditLogger));
        this.emitAuditMessage(auditMsg, auditLogger);
    }

    private void auditWADORetrieve(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        AuditMessage auditMsg = AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])this.storeWadoURIActiveParticipants(auditLogger, auditInfo, eventType), (ParticipantObjectIdentification[])ParticipantObjectID.studyPatParticipants(auditInfo, reader.getInstanceLines(), eventType, auditLogger));
        this.emitAuditMessage(auditMsg, auditLogger);
    }

    private ActiveParticipant[] storeWadoURIActiveParticipants(AuditLogger auditLogger, AuditInfo auditInfo, AuditUtils.EventType eventType) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[3];
        String callingUserID = auditInfo.getField(1);
        String archiveUserID = auditInfo.getField(2);
        AuditMessages.UserIDTypeCode archiveUserIDTypeCode = this.userIDTypeCode(archiveUserID);
        activeParticipants[0] = new ActiveParticipantBuilder(archiveUserID, this.getLocalHostName(auditLogger)).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build();
        String impaxEndpoint = auditInfo.getField(34);
        String callingHost = auditInfo.getField(0);
        ActiveParticipantBuilder requester = new ActiveParticipantBuilder(callingUserID, callingHost != null ? callingHost : this.getLocalHostName(auditLogger)).userIDTypeCode(callingHost != null ? AuditService.remoteUserIDTypeCode(archiveUserIDTypeCode, callingUserID) : AuditMessages.UserIDTypeCode.DeviceName).isRequester();
        if (impaxEndpoint != null) {
            activeParticipants[1] = requester.build();
            activeParticipants[2] = new ActiveParticipantBuilder(impaxEndpoint, this.impaxEndpointHost(impaxEndpoint)).userIDTypeCode(this.userIDTypeCode(impaxEndpoint)).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        } else {
            activeParticipants[1] = requester.roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        }
        return activeParticipants;
    }

    void spoolRetrieve(AuditUtils.EventType eventType, RetrieveContext ctx) {
        if (ctx.getMatches().isEmpty() && ctx.getCStoreForwards().isEmpty() && (ctx.failed() == 0 || ctx.getFailedMatches().isEmpty())) {
            LOG.info("Neither matches nor C-Store Forwards nor failed matches present. Exit spooling retrieve event {}", (Object)eventType);
            return;
        }
        try {
            Collection<InstanceLocations> completedMatches;
            Collection<InstanceLocations> failedRetrieves;
            RetrieveAuditService retrieveAuditService = new RetrieveAuditService(ctx, this.getArchiveDevice());
            if (ctx.failed() > 0 && !(failedRetrieves = retrieveAuditService.failedMatches()).isEmpty()) {
                this.writeSpoolFile(eventType, null, retrieveAuditService.createRetrieveFailureAuditInfo(failedRetrieves).toArray(new AuditInfoBuilder[0]));
            }
            if (!(completedMatches = retrieveAuditService.completedMatches()).isEmpty()) {
                this.writeSpoolFile(eventType, null, retrieveAuditService.createRetrieveSuccessAuditInfo(completedMatches).toArray(new AuditInfoBuilder[0]));
            }
        }
        catch (Exception e) {
            LOG.info("Failed to spool Retrieve of [StudyIUID={}]\n", (Object)ctx.getStudyInstanceUID(), (Object)e);
        }
    }

    private ArchiveDeviceExtension getArchiveDevice() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
    }

    private void auditRetrieve(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(RetrieveAuditService.auditMsg(auditLogger, path, eventType), auditLogger);
    }

    void spoolHL7Message(HL7ConnectionEvent hl7ConnEvent) {
        if (hl7ConnEvent.getHL7ResponseMessage() == null) {
            return;
        }
        HL7ConnectionEvent.Type type = hl7ConnEvent.getType();
        if (type == HL7ConnectionEvent.Type.MESSAGE_PROCESSED) {
            this.spoolIncomingHL7Msg(hl7ConnEvent);
        }
        if (type == HL7ConnectionEvent.Type.MESSAGE_RESPONSE) {
            this.spoolOutgoingHL7Msg(hl7ConnEvent);
        }
    }

    private void spoolIncomingHL7Msg(HL7ConnectionEvent hl7ConnEvent) {
        UnparsedHL7Message hl7Message = hl7ConnEvent.getHL7Message();
        HL7Segment pid = HL7AuditUtils.getHL7Segment(hl7Message, "PID");
        if (pid == null) {
            LOG.info("Exit spooling incoming HL7 message for message type {} as there is no PID segment.", (Object)hl7Message.msh().getMessageType());
            return;
        }
        try {
            UnparsedHL7Message hl7ResponseMessage = hl7ConnEvent.getHL7ResponseMessage();
            if (HL7AuditUtils.isOrderMessage(hl7ConnEvent)) {
                ProcedureRecordAuditService procedureRecordAuditService = new ProcedureRecordAuditService(hl7ConnEvent, this.getArchiveDevice());
                this.writeSpoolFile(procedureRecordAuditService.getHL7IncomingOrderInfo(), AuditUtils.EventType.forHL7IncomingOrderMsg(hl7ResponseMessage), hl7ConnEvent);
                if (!procedureRecordAuditService.hasPIDSegment()) {
                    LOG.info("Missing PID segment. Abort patient audit of incoming HL7 order message.");
                    return;
                }
            }
            PatientRecordAuditService patRecAuditService = new PatientRecordAuditService(hl7ConnEvent, this.getArchiveDevice());
            AuditUtils.EventType eventType = AuditUtils.EventType.forHL7IncomingPatRec(hl7ResponseMessage);
            this.writeSpoolFile(patRecAuditService.getHL7IncomingPatInfo(), eventType, hl7ConnEvent);
            HL7Segment mrg = HL7AuditUtils.getHL7Segment(hl7Message, "MRG");
            if (mrg != null && eventType != AuditUtils.EventType.PAT___READ) {
                this.writeSpoolFile(patRecAuditService.getHL7IncomingPrevPatInfo(mrg), AuditUtils.EventType.PAT_DELETE, hl7ConnEvent);
            }
        }
        catch (Exception e) {
            LOG.info("Failed to spool HL7 Incoming for [Message={}]\n", (Object)hl7Message, (Object)e);
        }
    }

    private void spoolOutgoingHL7Msg(HL7ConnectionEvent hl7ConnEvent) {
        try {
            PatientRecordAuditService patRecAuditService = new PatientRecordAuditService(hl7ConnEvent, this.getArchiveDevice());
            if (patRecAuditService.isArchiveHL7MsgAndNotOrder()) {
                this.writeSpoolFile(patRecAuditService.getHL7OutgoingPatInfo(), AuditUtils.EventType.forHL7OutgoingPatRec(hl7ConnEvent.getHL7Message().msh().getMessageType()), hl7ConnEvent);
                HL7Segment mrg = HL7AuditUtils.getHL7Segment(hl7ConnEvent.getHL7Message(), "MRG");
                if (mrg != null) {
                    this.writeSpoolFile(patRecAuditService.getHL7OutgoingPrevPatInfo(mrg), AuditUtils.EventType.PAT_DELETE, hl7ConnEvent);
                }
            }
            if (HL7AuditUtils.isOrderMessage(hl7ConnEvent)) {
                this.spoolOutgoingHL7OrderMsg(hl7ConnEvent);
            }
        }
        catch (Exception e) {
            LOG.info("Failed to spool HL7 Outgoing for [Message={}]\n", (Object)hl7ConnEvent.getHL7Message(), (Object)e);
        }
    }

    private void spoolOutgoingHL7OrderMsg(HL7ConnectionEvent hl7ConnEvent) {
        UnparsedHL7Message hl7Message = hl7ConnEvent.getHL7Message();
        Collection hl7OrderSPSStatuses = ((ArchiveHL7ApplicationExtension)((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(hl7Message.msh().getSendingApplicationWithFacility(), true).getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class)).hl7OrderSPSStatuses();
        HL7Segment orc = HL7AuditUtils.getHL7Segment(hl7Message, "ORC");
        String orderCtrlStatus = orc.getField(1, null) + "_" + orc.getField(5, null);
        this.writeSpoolFile(new ProcedureRecordAuditService(hl7ConnEvent, this.getArchiveDevice()).getHL7OutgoingOrderInfo(), AuditUtils.EventType.forHL7OutgoingOrderMsg(orderCtrlStatus, hl7OrderSPSStatuses), hl7ConnEvent);
    }

    void spoolPatientRecord(PatientMgtContext ctx) {
        if (ctx.getUnparsedHL7Message() != null) {
            return;
        }
        try {
            PatientRecordAuditService patRecAuditService = new PatientRecordAuditService(ctx, this.getArchiveDevice());
            this.writeSpoolFile(AuditUtils.EventType.forPatRec(ctx), null, patRecAuditService.getPatAuditInfo());
            if (ctx.getPreviousAttributes() != null) {
                this.writeSpoolFile(AuditUtils.EventType.PAT_DELETE, null, patRecAuditService.getPrevPatAuditInfo());
            }
        }
        catch (Exception e) {
            LOG.info("Failed to spool Patient Record for [PatientID={}]\n", (Object)ctx.getPatientID(), (Object)e);
        }
    }

    private void auditPatientRecord(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(PatientRecordAuditService.auditMsg(auditLogger, path, eventType, this.hl7AppCache, this.aeCache), auditLogger);
    }

    void spoolProcedureRecord(ProcedureContext ctx) {
        if (ctx.getUnparsedHL7Message() != null && !ctx.getUnparsedHL7Message().msh().getMessageType().equals("ADT^A10")) {
            return;
        }
        try {
            this.writeSpoolFile(AuditUtils.EventType.forProcedure(ctx.getEventActionCode()), null, new ProcedureRecordAuditService(ctx, this.getArchiveDevice()).getProcUpdateAuditInfo());
        }
        catch (Exception e) {
            LOG.info("Failed to spool Procedure Update procedure record for [Attributes={}, EventActionCode={}]\n", new Object[]{ctx.getAttributes(), ctx.getEventActionCode(), e});
        }
    }

    void spoolStudyRecord(StudyMgtContext ctx) {
        try {
            this.writeSpoolFile(AuditUtils.EventType.forStudy(ctx.getEventActionCode()), null, new StudyRecordAuditService(ctx, this.getArchiveDevice()).getStudyUpdateAuditInfo());
        }
        catch (Exception e) {
            LOG.info("Failed to spool Study Update procedure record for [StudyIUID={}, EventActionCode={}]\n", new Object[]{ctx.getStudy(), ctx.getEventActionCode(), e});
        }
    }

    private void auditStudyRecord(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        if (eventType.eventActionCode.equals("R")) {
            this.auditStudySize(auditLogger, path, eventType);
            return;
        }
        this.emitAuditMessage(StudyRecordAuditService.auditMsg(auditLogger, path, eventType), auditLogger);
    }

    private void auditProcedureRecord(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(ProcedureRecordAuditService.auditMsg(auditLogger, path, eventType, this.aeCache), auditLogger);
    }

    void spoolProvideAndRegister(ExportContext ctx) {
        try {
            this.writeSpoolFile(AuditUtils.EventType.PROV_REGIS, null, ProvideAndRegisterAuditService.provideRegisterAuditInfo(ctx, this.getArchiveDevice()));
        }
        catch (Exception e) {
            LOG.info("Failed to spool Provide and Register for [SubmissionSetUID={}, XDSiManifest={}]\n", new Object[]{ctx.getSubmissionSetUID(), ctx.getXDSiManifest(), e});
        }
    }

    private void auditProvideAndRegister(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(ProvideAndRegisterAuditService.provideRegisterAuditMsg(auditLogger, path, eventType), auditLogger);
    }

    void spoolStgCmt(StgCmtContext ctx) {
        try {
            Sequence success = ctx.getEventInfo().getSequence(528793);
            Sequence failed = ctx.getEventInfo().getSequence(528792);
            if (success != null && !success.isEmpty()) {
                this.writeSpoolFile(AuditUtils.EventType.STG_COMMIT, null, StorageCommitAuditService.getSuccessAuditInfo(ctx, this.getArchiveDevice()));
            }
            if (failed != null && !failed.isEmpty()) {
                this.writeSpoolFile(AuditUtils.EventType.STG_COMMIT, null, StorageCommitAuditService.getFailedAuditInfo(ctx, this.getArchiveDevice()));
            }
        }
        catch (Exception e) {
            LOG.info("Failed to spool storage commitment.\n", (Throwable)e);
        }
    }

    private void auditStorageCommit(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(StorageCommitAuditService.auditMsg(auditLogger, path, eventType), auditLogger);
    }

    void spoolAssociationFailure(AssociationEvent associationEvent) {
        try {
            this.writeSpoolFile(AuditUtils.EventType.ASSOC_FAIL, null, AssociationEventsAuditService.associationFailureAuditInfo(associationEvent));
        }
        catch (Exception e) {
            LOG.info("Failed to spool association event failure for [AssociationEventType={}]\n", (Object)associationEvent.getType(), (Object)e);
        }
    }

    private void auditAssociationFailure(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) throws Exception {
        this.emitAuditMessage(AssociationEventsAuditService.associationFailureAuditMsg(auditLogger, path, eventType), auditLogger);
    }

    private String getLocalHostName(AuditLogger log) {
        return ((Connection)log.getConnections().get(0)).getHostname();
    }

    private Path toDirPath(AuditLogger auditLogger) throws UnsupportedEncodingException {
        return Paths.get(StringUtils.replaceSystemProperties((String)this.getArchiveDevice().getAuditSpoolDirectory()), URLEncoder.encode(auditLogger.getCommonName(), "UTF-8"));
    }

    private void writeSpoolFile(AuditInfoBuilder auditInfoBuilder, AuditUtils.EventType eventType, HL7ConnectionEvent hl7ConnEvent) {
        this.writeSpoolFile(auditInfoBuilder, eventType, this.limitHL7MsgInAudit(hl7ConnEvent.getHL7Message(), hl7ConnEvent.getType()), this.limitHL7MsgInAudit(hl7ConnEvent.getHL7ResponseMessage(), hl7ConnEvent.getType()));
    }

    private byte[] limitHL7MsgInAudit(UnparsedHL7Message unparsedHL7Msg, HL7ConnectionEvent.Type type) {
        ArchiveHL7ApplicationExtension arcHL7App;
        HL7Segment msh = unparsedHL7Msg.msh();
        HL7Application hl7App = ((HL7DeviceExtension)this.device.getDeviceExtensionNotNull(HL7DeviceExtension.class)).getHL7Application(type == HL7ConnectionEvent.Type.MESSAGE_PROCESSED ? msh.getReceivingApplicationWithFacility() : msh.getSendingApplicationWithFacility(), true);
        int auditHL7MsgLimit = hl7App == null || (arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class)) == null ? ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getAuditHL7MsgLimit() : arcHL7App.auditHL7MsgLimit();
        return this.truncateHL7(unparsedHL7Msg, auditHL7MsgLimit);
    }

    private byte[] truncateHL7(UnparsedHL7Message unparsedHL7Msg, int auditHL7MsgLimit) {
        byte[] data = unparsedHL7Msg.data();
        if (data.length <= auditHL7MsgLimit) {
            return data;
        }
        LOG.info("HL7 message [MessageHeader={}] length {} greater configured Audit HL7 Message Limit {} - truncate HL7 message in emitted audit", new Object[]{unparsedHL7Msg.msh(), data.length, auditHL7MsgLimit});
        byte[] truncatedHL7 = new byte[auditHL7MsgLimit];
        System.arraycopy(data, 0, truncatedHL7, 0, auditHL7MsgLimit - 3);
        System.arraycopy("...".getBytes(), 0, truncatedHL7, auditHL7MsgLimit - 3, 3);
        return truncatedHL7;
    }

    private void writeSpoolFile(AuditInfoBuilder auditInfoBuilder, AuditUtils.EventType eventType, byte[] ... data) {
        if (auditInfoBuilder == null) {
            LOG.info("Attempt to write empty file by : {}", (Object)eventType);
            return;
        }
        FileTime eventTime = null;
        AuditLoggerDeviceExtension ext = (AuditLoggerDeviceExtension)this.device.getDeviceExtension(AuditLoggerDeviceExtension.class);
        for (AuditLogger auditLogger : ext.getAuditLoggers()) {
            if (!auditLogger.isInstalled()) continue;
            try {
                Path dir = this.toDirPath(auditLogger);
                Files.createDirectories(dir, new FileAttribute[0]);
                Path file = Files.createTempFile(dir, eventType.name(), null, new FileAttribute[0]);
                try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, StandardOpenOption.APPEND));){
                    try (SpoolFileWriter writer = new SpoolFileWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.APPEND));){
                        writer.writeLine(new AuditInfo(auditInfoBuilder));
                    }
                    out.write(data[0]);
                    if (data.length > 1 && data[1].length > 0) {
                        out.write(data[1]);
                    }
                }
                if (eventTime == null) {
                    eventTime = Files.getLastModifiedTime(file, new LinkOption[0]);
                } else {
                    Files.setLastModifiedTime(file, eventTime);
                }
                if (this.getArchiveDevice().isAuditAggregate()) continue;
                this.auditAndProcessFile(auditLogger, file);
            }
            catch (Exception e) {
                LOG.info("Failed to write audit spool file for [AuditEventType={}] at [AuditLogger={}]\n", new Object[]{eventType, auditLogger.getCommonName(), e});
            }
        }
    }

    private void writeSpoolFile(AuditUtils.EventType eventType, String suffix, AuditInfoBuilder ... auditInfoBuilders) {
        String file;
        String string = file = suffix != null ? eventType.name().concat(suffix) : eventType.name();
        if (auditInfoBuilders == null) {
            LOG.info("Attempt to write empty file : " + file);
            return;
        }
        FileTime eventTime = null;
        AuditLoggerDeviceExtension ext = (AuditLoggerDeviceExtension)this.device.getDeviceExtension(AuditLoggerDeviceExtension.class);
        for (AuditLogger auditLogger : ext.getAuditLoggers()) {
            if (!auditLogger.isInstalled()) continue;
            try {
                Path filePath;
                Path dir = this.toDirPath(auditLogger);
                Files.createDirectories(dir, new FileAttribute[0]);
                Path path = filePath = eventType.eventClass == AuditUtils.EventClass.STORE_WADOR || suffix != null && eventType.eventClass == AuditUtils.EventClass.USER_DELETED ? this.filePath(file, dir, auditInfoBuilders) : this.filePath(eventType, dir, auditInfoBuilders);
                if (eventTime == null) {
                    eventTime = Files.getLastModifiedTime(filePath, new LinkOption[0]);
                } else {
                    Files.setLastModifiedTime(filePath, eventTime);
                }
                if (this.getArchiveDevice().isAuditAggregate()) continue;
                this.auditAndProcessFile(auditLogger, filePath);
            }
            catch (Exception e) {
                LOG.info("Failed to write [AuditSpoolFile={}] at [AuditLogger={}]\n", new Object[]{file, auditLogger.getCommonName(), e});
            }
        }
    }

    private Path filePath(AuditUtils.EventType eventType, Path dir, AuditInfoBuilder ... auditInfoBuilders) throws IOException {
        Path file = Files.createTempFile(dir, eventType.name(), null, new FileAttribute[0]);
        try (SpoolFileWriter writer = new SpoolFileWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.APPEND));){
            for (AuditInfoBuilder auditInfoBuilder : auditInfoBuilders) {
                writer.writeLine(new AuditInfo(auditInfoBuilder));
            }
        }
        return file;
    }

    private Path filePath(String fileName, Path dir, AuditInfoBuilder ... auditInfoBuilders) throws IOException {
        Path file = dir.resolve(fileName);
        boolean append = Files.exists(file, new LinkOption[0]);
        try (SpoolFileWriter writer = new SpoolFileWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, append ? StandardOpenOption.APPEND : StandardOpenOption.CREATE_NEW));){
            if (!append) {
                writer.writeLine(new AuditInfo(auditInfoBuilders[0]));
            }
            writer.writeLine(new AuditInfo(auditInfoBuilders[1]));
        }
        return file;
    }

    private void emitAuditMessage(AuditMessage msg, AuditLogger logger) throws Exception {
        msg.getAuditSourceIdentification().add(logger.createAuditSourceIdentification());
        try {
            logger.write(logger.timeStamp(), msg);
        }
        catch (Exception e) {
            LOG.info("Failed to emit audit message for [AuditLogger={}]\n", (Object)logger.getCommonName(), (Object)e);
            throw e;
        }
    }

    private AuditMessages.UserIDTypeCode userIDTypeCode(String userID) {
        return userID.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : (userID.indexOf(124) != -1 ? AuditMessages.UserIDTypeCode.ApplicationFacility : (userID.equals(this.device.getDeviceName()) ? AuditMessages.UserIDTypeCode.DeviceName : AuditMessages.UserIDTypeCode.StationAETitle));
    }

    static AuditMessages.UserIDTypeCode remoteUserIDTypeCode(AuditMessages.UserIDTypeCode archiveUserIDTypeCode, String remoteUserID) {
        if (remoteUserID != null) {
            return remoteUserID.indexOf(124) != -1 ? AuditMessages.UserIDTypeCode.ApplicationFacility : (archiveUserIDTypeCode == AuditMessages.UserIDTypeCode.URI ? AuditMessages.userIDTypeCode((String)remoteUserID) : AuditMessages.UserIDTypeCode.StationAETitle);
        }
        LOG.info("Remote user ID was not set during spooling.");
        return null;
    }
}

