/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.json.Json;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4chee.arc.conf.AcceptConflictingPatientID;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;

class IocmUtils {
    IocmUtils() {
    }

    static Attributes linkInstancesWithMWL(StoreSession session, RetrieveService retrieveService, ProcedureService procedureService, ProcedureContext ctx, QueryService queryService, RejectionNote rjNote, Attributes coerceAttrs, InputStream in) throws Exception {
        Attributes result;
        String studyInstanceUID = ctx.getStudyInstanceUID();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        StoreService storeService = session.getStoreService();
        Attributes instanceRefs = IocmUtils.parseSOPInstanceReferences(in);
        ctx.setSourceInstanceRefs(instanceRefs);
        IocmUtils.restoreInstances(session, instanceRefs);
        Collection instanceLocations = retrieveService.queryInstances(session, instanceRefs, studyInstanceUID);
        if (instanceLocations.isEmpty()) {
            return null;
        }
        if (IocmUtils.isMerge(ctx, instanceRefs)) {
            procedureService.updateStudySeriesAttributes(ctx);
            result = IocmUtils.getResult(instanceLocations);
        } else {
            Attributes sopInstanceRefs = IocmUtils.getSOPInstanceRefs(instanceRefs, instanceLocations, arcAE.getApplicationEntity());
            IocmUtils.moveSequence(sopInstanceRefs, 528661, instanceRefs);
            session.setAcceptConflictingPatientID(AcceptConflictingPatientID.YES);
            session.setPatientUpdatePolicy(Attributes.UpdatePolicy.PRESERVE);
            session.setStudyUpdatePolicy(arcAE.linkMWLEntryUpdatePolicy());
            result = storeService.copyInstances(session, instanceLocations, coerceAttrs, Attributes.UpdatePolicy.OVERWRITE);
            IocmUtils.rejectInstances(instanceRefs, queryService, rjNote, session, result);
        }
        return result;
    }

    private static boolean isMerge(ProcedureContext ctx, Attributes instanceRefs) {
        String linkStrategy = ctx.getLinkStrategy();
        String studyInstanceUIDInstRefs = instanceRefs.getString(0x20000D);
        if (linkStrategy == null) {
            return ctx.getStudyInstanceUID().equals(studyInstanceUIDInstRefs);
        }
        if (linkStrategy.equals("MERGE")) {
            ctx.setStudyInstanceUIDInstRefs(studyInstanceUIDInstRefs);
            return true;
        }
        return false;
    }

    static Attributes copyMove(StoreSession session, RetrieveService retrieveService, QueryService queryService, String studyInstanceUID, Attributes coerceAttrs, RejectionNote rjNote, InputStream in) throws Exception {
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        StoreService storeService = session.getStoreService();
        Attributes instanceRefs = IocmUtils.parseSOPInstanceReferences(in);
        IocmUtils.restoreInstances(session, instanceRefs);
        Collection instanceLocations = retrieveService.queryInstances(session, instanceRefs, studyInstanceUID);
        if (instanceLocations.isEmpty()) {
            return null;
        }
        Attributes sopInstanceRefs = IocmUtils.getSOPInstanceRefs(instanceRefs, instanceLocations, arcAE.getApplicationEntity());
        IocmUtils.moveSequence(sopInstanceRefs, 528661, instanceRefs);
        session.setAcceptConflictingPatientID(AcceptConflictingPatientID.YES);
        session.setPatientUpdatePolicy(Attributes.UpdatePolicy.PRESERVE);
        session.setStudyUpdatePolicy(arcAE.copyMoveUpdatePolicy());
        Attributes result = storeService.copyInstances(session, instanceLocations, coerceAttrs, Attributes.UpdatePolicy.MERGE);
        if (rjNote != null) {
            IocmUtils.rejectInstances(instanceRefs, queryService, rjNote, session, result);
        }
        return result;
    }

    static void rejectInstances(Attributes instanceRefs, QueryService queryService, RejectionNote rjNote, StoreSession session, Attributes result) throws IOException {
        Sequence refSeriesSeq = instanceRefs.getSequence(528661);
        IocmUtils.removeFailedInstanceRefs(refSeriesSeq, IocmUtils.failedIUIDs(result));
        if (!refSeriesSeq.isEmpty()) {
            IocmUtils.reject(session, queryService, instanceRefs, rjNote);
        }
    }

    private static Set<String> failedIUIDs(Attributes result) {
        Sequence failedSOPSeq = result.getSequence(528792);
        if (failedSOPSeq == null || failedSOPSeq.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> failedIUIDs = new HashSet<String>(failedSOPSeq.size() * 4 / 3 + 1);
        failedSOPSeq.forEach(failedSOPRef -> failedIUIDs.add(failedSOPRef.getString(528725)));
        return failedIUIDs;
    }

    private static void removeFailedInstanceRefs(Sequence refSeriesSeq, Set<String> failedIUIDs) {
        if (failedIUIDs.isEmpty()) {
            return;
        }
        Iterator refSeriesIter = refSeriesSeq.iterator();
        while (refSeriesIter.hasNext()) {
            Sequence refSOPSeq = ((Attributes)refSeriesIter.next()).getSequence(528793);
            refSOPSeq.removeIf(attributes -> failedIUIDs.contains(attributes.getString(528725)));
            if (!refSOPSeq.isEmpty()) continue;
            refSeriesIter.remove();
        }
    }

    private static void reject(StoreSession session, QueryService queryService, Attributes instanceRefs, RejectionNote rjNote) throws IOException {
        StoreService storeService = session.getStoreService();
        StoreContext koctx = storeService.newStoreContext(session);
        Attributes ko = queryService.createRejectionNote(instanceRefs, rjNote);
        koctx.setReceiveTransferSyntax("1.2.840.10008.1.2.1");
        storeService.store(koctx, ko);
    }

    private static Attributes getResult(Collection<InstanceLocations> instanceLocations) {
        Attributes result = new Attributes();
        Sequence refSOPSeq = result.newSequence(528793, instanceLocations.size());
        instanceLocations.forEach(instanceLocation -> IocmUtils.populateResult(refSOPSeq, instanceLocation));
        return result;
    }

    private static void populateResult(Sequence refSOPSeq, InstanceLocations instanceLocation) {
        Attributes refSOP = new Attributes(2);
        refSOP.setString(528720, VR.UI, instanceLocation.getSopClassUID());
        refSOP.setString(528725, VR.UI, instanceLocation.getSopInstanceUID());
        refSOPSeq.add(refSOP);
    }

    private static Attributes getSOPInstanceRefs(Attributes instanceRefs, Collection<InstanceLocations> instances, ApplicationEntity ae) {
        String sourceStudyUID = instanceRefs.getString(0x20000D);
        Attributes refStudy = new Attributes(2);
        Sequence refSeriesSeq = refStudy.newSequence(528661, 10);
        refStudy.setString(0x20000D, VR.UI, sourceStudyUID);
        HashMap seriesMap = new HashMap();
        instances.forEach(instance -> {
            Attributes iAttr = instance.getAttributes();
            String seriesIUID = iAttr.getString(0x20000E);
            Sequence refSOPSeq = (Sequence)seriesMap.get(seriesIUID);
            if (refSOPSeq == null) {
                Attributes refSeries = new Attributes(4);
                refSeries.setString(524372, VR.AE, ae.getAETitle());
                refSOPSeq = refSeries.newSequence(528793, 10);
                refSeries.setString(0x20000E, VR.UI, seriesIUID);
                seriesMap.put(seriesIUID, refSOPSeq);
                refSeriesSeq.add(refSeries);
            }
            Attributes refSOP = new Attributes(2);
            refSOP.setString(528720, VR.UI, instance.getSopClassUID());
            refSOP.setString(528725, VR.UI, instance.getSopInstanceUID());
            refSOPSeq.add(refSOP);
        });
        return refStudy;
    }

    private static void moveSequence(Attributes src, int tag, Attributes dest) {
        Sequence srcSeq = src.getSequence(tag);
        int size = srcSeq.size();
        Sequence destSeq = dest.newSequence(tag, size);
        for (int i = 0; i < size; ++i) {
            destSeq.add(srcSeq.remove(0));
        }
    }

    private static void restoreInstances(StoreSession session, Attributes sopInstanceRefs) throws IOException {
        StoreService storeService = session.getStoreService();
        String studyUID = sopInstanceRefs.getString(0x20000D);
        Sequence seq = sopInstanceRefs.getSequence(528661);
        if (seq == null || seq.isEmpty()) {
            storeService.restoreInstances(session, studyUID, null, null);
        } else {
            for (Attributes item : seq) {
                storeService.restoreInstances(session, studyUID, item.getString(0x20000E), null);
            }
        }
    }

    private static Attributes parseSOPInstanceReferences(InputStream in) {
        Attributes attrs = new Attributes(2);
        try {
            JsonParser parser = Json.createParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            IocmUtils.expect(parser, JsonParser.Event.START_OBJECT);
            block10: while (parser.next() == JsonParser.Event.KEY_NAME) {
                String keyName;
                switch (keyName = parser.getString()) {
                    case "StudyInstanceUID": {
                        IocmUtils.expect(parser, JsonParser.Event.VALUE_STRING);
                        attrs.setString(0x20000D, VR.UI, parser.getString());
                        continue block10;
                    }
                    case "ReferencedSeriesSequence": {
                        IocmUtils.parseReferencedSeriesSequence(parser, attrs.newSequence(528661, 10));
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("Unexpected Key name " + keyName);
            }
        }
        catch (JsonParsingException e) {
            throw new IllegalArgumentException(e.getMessage() + " at location : " + e.getLocation());
        }
        if (!attrs.contains(0x20000D)) {
            throw new IllegalArgumentException("Missing StudyInstanceUID");
        }
        return attrs;
    }

    private static void parseReferencedSeriesSequence(JsonParser parser, Sequence seq) {
        IocmUtils.expect(parser, JsonParser.Event.START_ARRAY);
        while (parser.next() == JsonParser.Event.START_OBJECT) {
            seq.add(IocmUtils.parseReferencedSeries(parser));
        }
    }

    private static Attributes parseReferencedSeries(JsonParser parser) {
        Attributes attrs = new Attributes(2);
        block8: while (parser.next() == JsonParser.Event.KEY_NAME) {
            String keyName;
            switch (keyName = parser.getString()) {
                case "SeriesInstanceUID": {
                    IocmUtils.expect(parser, JsonParser.Event.VALUE_STRING);
                    attrs.setString(0x20000E, VR.UI, parser.getString());
                    continue block8;
                }
                case "ReferencedSOPSequence": {
                    IocmUtils.parseReferencedSOPSequence(parser, attrs.newSequence(528793, 10));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unexpected Key name " + keyName);
        }
        if (!attrs.contains(0x20000E)) {
            throw new IllegalArgumentException("Missing SeriesInstanceUID");
        }
        return attrs;
    }

    private static void parseReferencedSOPSequence(JsonParser parser, Sequence seq) {
        IocmUtils.expect(parser, JsonParser.Event.START_ARRAY);
        while (parser.next() == JsonParser.Event.START_OBJECT) {
            seq.add(IocmUtils.parseReferencedSOP(parser));
        }
    }

    private static Attributes parseReferencedSOP(JsonParser parser) {
        Attributes attrs = new Attributes(2);
        block8: while (parser.next() == JsonParser.Event.KEY_NAME) {
            String keyName;
            switch (keyName = parser.getString()) {
                case "ReferencedSOPClassUID": {
                    IocmUtils.expect(parser, JsonParser.Event.VALUE_STRING);
                    attrs.setString(528720, VR.UI, parser.getString());
                    continue block8;
                }
                case "ReferencedSOPInstanceUID": {
                    IocmUtils.expect(parser, JsonParser.Event.VALUE_STRING);
                    attrs.setString(528725, VR.UI, parser.getString());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unexpected Key name " + keyName);
        }
        if (!attrs.contains(528720)) {
            throw new IllegalArgumentException("Missing ReferencedSOPClassUID");
        }
        if (!attrs.contains(528725)) {
            throw new IllegalArgumentException("Missing ReferencedSOPInstanceUID");
        }
        return attrs;
    }

    private static void expect(JsonParser parser, JsonParser.Event expected) {
        JsonParser.Event next = parser.next();
        if (next != expected) {
            throw new IllegalArgumentException("Unexpected " + next);
        }
    }
}

