/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.mgt.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.mgt.RetrieveBatch;
import org.dcm4chee.arc.retrieve.mgt.RetrieveManager;
import org.dcm4chee.arc.retrieve.mgt.impl.RetrieveManagerEJB;
import org.dcm4chee.arc.retrieve.scu.CMoveSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RetrieveManagerImpl
implements RetrieveManager {
    private static final Logger LOG = LoggerFactory.getLogger(RetrieveManagerImpl.class);
    @Inject
    private Device device;
    @Inject
    private Event<ExternalRetrieveContext> externalRetrieve;
    @Inject
    private CMoveSCU moveSCU;
    @Inject
    private RetrieveManagerEJB ejb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome cmove(ExternalRetrieveContext ctx, Task task) throws Exception {
        ApplicationEntity localAE = this.device.getApplicationEntity(ctx.getLocalAET(), true);
        if (localAE == null || !localAE.isInstalled()) {
            throw new ConfigurationException("No such Application Entity: " + ctx.getLocalAET());
        }
        Association as = this.moveSCU.openAssociation(localAE, ctx.getRemoteAET());
        ctx.setRemoteHostName(ReverseDNS.hostNameOf((InetAddress)as.getSocket().getInetAddress()));
        try {
            this.ejb.resetRetrieveTask(task);
            DimseRSP rsp = this.moveSCU.cmove(as, 0, ctx.getDestinationAET(), ctx.getKeys());
            while (rsp.next()) {
                this.ejb.updateRetrieveTask(task, rsp.getCommand());
            }
            this.externalRetrieve.fire((Object)ctx.setResponse(rsp.getCommand()));
            Outcome outcome = this.toOutcome(ctx, (ArchiveAEExtension)localAE.getAEExtensionNotNull(ArchiveAEExtension.class));
            return outcome;
        }
        finally {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association:\\n", (Object)as, (Object)e);
            }
        }
    }

    private Outcome toOutcome(ExternalRetrieveContext ctx, ArchiveAEExtension arcAE) {
        int status = ctx.getStatus();
        Attributes keys = ctx.getKeys();
        StringBuilder sb = new StringBuilder(256).append("Export ").append(keys.getString(524370)).append("[suid:").append(keys.getString(0x20000D)).append("] from ").append(ctx.getRemoteAET()).append(" to ").append(ctx.getDestinationAET());
        if (status == 0 || status == 45056) {
            int failed;
            sb.append(" - completed:").append(ctx.completed());
            int warning = ctx.warning();
            if (warning > 0) {
                sb.append(", warning:").append(warning);
            }
            if ((failed = ctx.failed()) > 0) {
                sb.append(", failed:").append(failed);
            }
        } else {
            sb.append(" failed - status:").append(TagUtils.shortToHexString((int)status)).append('H');
            String errorComment = ctx.getErrorComment();
            if (errorComment != null) {
                sb.append(", error:").append(errorComment);
            }
        }
        return new Outcome(status == 0 ? (arcAE.retrieveTaskWarningOnNoMatch() && ctx.completed() == 0 && ctx.warning() == 0 || arcAE.retrieveTaskWarningOnWarnings() && ctx.warning() == 0 ? Task.Status.WARNING : Task.Status.COMPLETED) : (status == 45056 && (ctx.completed() > 0 || ctx.warning() > 0) ? Task.Status.WARNING : Task.Status.FAILED), sb.toString());
    }

    @Override
    public int scheduleRetrieveTask(ExternalRetrieveContext ctx, Date notRetrievedAfter) {
        return this.ejb.scheduleRetrieveTask(ctx, notRetrievedAfter);
    }

    @Override
    public List<RetrieveBatch> listRetrieveBatches(TaskQueryParam queryParam, int offset, int limit) {
        return this.ejb.listRetrieveBatches(queryParam, offset, limit);
    }
}

