/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaQuery;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.Code;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.QueryOption;
import org.dcm4chee.arc.MergeMWLQueryParam;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesQueryAttributes;
import org.dcm4chee.arc.entity.StudyQueryAttributes;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.util.QueryParam;

public interface QueryService {
    public QueryContext newQueryContextFIND(Association var1, String var2, EnumSet<QueryOption> var3);

    public QueryContext newQueryContextQIDO(HttpServletRequestInfo var1, String var2, String var3, ApplicationEntity var4, QueryParam var5);

    public QueryContext newQueryContext(ApplicationEntity var1, QueryParam var2);

    public void coerceAttributes(QueryContext var1) throws Exception;

    public Query createQuery(QueryContext var1);

    public Query createPatientQuery(QueryContext var1);

    public Query createStudyQuery(QueryContext var1);

    public Query createSeriesQuery(QueryContext var1);

    public Query createInstanceQuery(QueryContext var1);

    public Query createMWLQuery(QueryContext var1);

    public Query createMPPSQuery(QueryContext var1);

    public Query createUPSQuery(QueryContext var1);

    public Query createUPSWithoutQueryEvent(QueryContext var1);

    public Attributes getSeriesAttributes(QueryContext var1, Long var2);

    public void addLocationAttributes(Attributes var1, Long var2);

    public long calculateStudySize(Long var1);

    public StudyQueryAttributes calculateStudyQueryAttributes(Long var1, QueryRetrieveView var2);

    public SeriesQueryAttributes calculateSeriesQueryAttributes(Long var1, Series.InstancePurgeState var2, String var3, String var4, QueryRetrieveView var5);

    public Attributes getStudyAttributesWithSOPInstanceRefs(String var1, ApplicationEntity var2, Collection<Attributes> var3);

    public Attributes createIAN(ApplicationEntity var1, String var2, String[] var3, String var4, String[] var5, String var6, Availability var7);

    public Attributes createXDSiManifest(ApplicationEntity var1, String var2, String[] var3, String var4, Code var5, int var6, int var7, Collection<Attributes> var8);

    public Attributes createUPSInfo(ApplicationEntity var1, String var2, String var3, String var4, ExporterDescriptor var5);

    public Attributes createRejectionNote(ApplicationEntity var1, String var2, String var3, String var4, RejectionNote var5);

    public Attributes createRejectionNote(Attributes var1, RejectionNote var2);

    public Attributes createActionInfo(String var1, String var2, String var3, ApplicationEntity var4);

    public Attributes queryExportTaskInfo(Task var1, ApplicationEntity var2);

    public Attributes getStudyAttributes(String var1);

    public List<Object[]> getSeriesInstanceUIDs(String var1);

    public List<Object[]> getSOPInstanceUIDs(String var1);

    public List<Object[]> getSOPInstanceUIDs(String var1, String var2);

    public Integer getNumberOfFrames(String var1, String var2, String var3);

    public ZipInputStream openZipInputStream(QueryContext var1, String var2, String var3) throws IOException;

    public AttributesCoercion getAttributesCoercion(QueryContext var1);

    public CFindSCU cfindSCU();

    public List<String> getDistinctModalities();

    public List<String> getDistinctInstitutions(String var1);

    public List<Tuple> unknownSizeStudies(Date var1, int var2);

    public CriteriaQuery<Patient> createPatientWithUnknownIssuerQuery(QueryParam var1, Attributes var2);

    public CriteriaQuery<AttributesBlob> createPatientAttributesQuery(QueryParam var1, Attributes var2);

    public Date getLastModified(boolean var1, String var2, String var3);

    public List<Attributes> queryMWL(MergeMWLQueryParam var1);
}

