/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qmgt.impl;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.IDeviceCache;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.event.BulkTaskEvent;
import org.dcm4chee.arc.event.TaskEvent;
import org.dcm4chee.arc.event.TaskOperation;
import org.dcm4chee.arc.qmgt.TaskCanceled;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.qmgt.impl.TaskManagerEJB;
import org.dcm4chee.arc.qmgt.impl.TaskScheduler;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TaskManagerImpl
implements TaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerImpl.class);
    @Inject
    private Device device;
    @Inject
    private TaskManagerEJB ejb;
    @Inject
    private TaskScheduler scheduler;
    @Inject
    private IDeviceCache deviceCache;
    @Inject
    private Event<TaskEvent> taskEventEvent;
    @Inject
    private Event<BulkTaskEvent> bulkTaskEventEvent;
    @Inject
    private Event<TaskCanceled> taskCanceledEvent;

    @Override
    public Task findTask(TaskQueryParam taskQueryParam) {
        return this.ejb.findTask(taskQueryParam);
    }

    @Override
    public void scheduleTask(Task task) {
        this.ejb.scheduleTask(task);
        if (task.getScheduledTime().getTime() <= System.currentTimeMillis()) {
            this.processQueue(task.getQueueName());
        }
    }

    @Override
    public void processQueue(String queueName) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        this.scheduler.process(arcDev.getQueueDescriptorNotNull(queueName), arcDev.getTaskFetchSize());
    }

    @Override
    public StreamingOutput writeAsJSON(TaskQueryParam taskQueryParam, int offset, int limit) {
        return out -> {
            OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            try (JsonGenerator gen = Json.createGenerator((Writer)w);){
                gen.writeStartArray();
                this.ejb.forEachTask(taskQueryParam, offset, limit, task -> task.writeAsJSON(gen));
                gen.writeEnd();
            }
        };
    }

    @Override
    public StreamingOutput writeAsCSV(TaskQueryParam taskQueryParam, int offset, int limit, String[] headers, char delimiter) {
        return out -> {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            try (CSVPrinter printer = new CSVPrinter((Appendable)writer, CSVFormat.RFC4180.builder().setHeader(headers).setDelimiter(delimiter).setQuoteMode(QuoteMode.ALL).build());){
                this.ejb.forEachTask(taskQueryParam, offset, limit, task -> task.writeAsCSV(printer));
            }
        };
    }

    @Override
    public Response countTasks(TaskQueryParam taskQueryParam) {
        try {
            return this.count(this.ejb.countTasks(taskQueryParam));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response cancelTask(TaskQueryParam taskQueryParam, HttpServletRequest request) {
        Task task = this.ejb.findTask(taskQueryParam);
        if (task == null) {
            return this.noSuchTask(taskQueryParam.getTaskPK());
        }
        if (task.getStatus().done) {
            return this.errResponse("Cannot cancel Task with status: " + task.getStatus(), Response.Status.CONFLICT);
        }
        TaskEvent taskEvent = new TaskEvent(request, TaskOperation.CancelTasks);
        taskEvent.setTask(task);
        try {
            if (task.getStatus() == Task.Status.IN_PROCESS) {
                this.taskCanceledEvent.fire((Object)new TaskCanceled(task));
            }
            task.setStatus(Task.Status.CANCELED);
            this.ejb.merge(task);
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            this.taskEventEvent.fire((Object)taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response cancelTasks(TaskQueryParam taskQueryParam, HttpServletRequest request) {
        Task.Status status = taskQueryParam.getStatus();
        if (status == null) {
            return this.errResponse("Missing query parameter: status", Response.Status.BAD_REQUEST);
        }
        if (status.done) {
            return this.errResponse("Cannot cancel tasks with status: " + status, Response.Status.BAD_REQUEST);
        }
        int count = 0;
        int failed = 0;
        BulkTaskEvent taskEvent = new BulkTaskEvent(request, TaskOperation.CancelTasks);
        try {
            List<Task> list;
            LOG.info("Cancel processing of Tasks with Status {}", (Object)status);
            if (status == Task.Status.SCHEDULED) {
                count = this.ejb.cancelTasks(taskQueryParam);
                Response response = this.count(count);
                return response;
            }
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            int taskFetchSize = arcDev.getTaskFetchSize();
            do {
                list = this.ejb.findTasks(taskQueryParam, taskFetchSize);
                for (Task task : list) {
                    try {
                        this.taskCanceledEvent.fire((Object)new TaskCanceled(task));
                        task.setStatus(Task.Status.CANCELED);
                        this.ejb.merge(task);
                        ++count;
                    }
                    catch (Exception e) {
                        LOG.info("Failed to cancel {}", (Object)task, (Object)e);
                        ++failed;
                    }
                }
            } while (list.size() >= taskFetchSize);
            Response response = this.response(count, failed);
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            taskEvent.setCount((long)count);
            taskEvent.setFailed(failed);
            this.bulkTaskEventEvent.fire((Object)taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response rescheduleTask(TaskQueryParam taskQueryParam, Date scheduledTime, List<String> newDeviceName, HttpServletRequest request) {
        List<ArchiveDeviceExtension> targetDevices = this.targetDevices(newDeviceName);
        Task task = this.ejb.findTask(taskQueryParam);
        if (task == null) {
            return this.noSuchTask(taskQueryParam.getTaskPK());
        }
        if (!newDeviceName.isEmpty()) {
            try {
                this.adjustDeviceName(task, targetDevices.get(0), null, null);
            }
            catch (IllegalStateException e) {
                return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
            }
        }
        TaskEvent taskEvent = new TaskEvent(request, TaskOperation.RescheduleTasks);
        taskEvent.setTask(task);
        try {
            this.rescheduleTask(task, scheduledTime != null ? scheduledTime : new Date());
            if (scheduledTime == null && newDeviceName.isEmpty()) {
                this.processQueue(task.getQueueName());
            }
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            this.taskEventEvent.fire((Object)taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response rescheduleTasks(TaskQueryParam taskQueryParam, Date scheduledTime, List<String> newDeviceName, HttpServletRequest request) {
        List<ArchiveDeviceExtension> targetDevices = this.targetDevices(newDeviceName);
        int count = 0;
        int failed = 0;
        HashSet<String> queueNames = new HashSet<String>();
        BulkTaskEvent taskEvent = new BulkTaskEvent(request, TaskOperation.RescheduleTasks);
        Date now = new Date();
        taskQueryParam.setUpdatedBeforeNotAfter(now);
        Date scheduledTime1 = scheduledTime != null ? scheduledTime : now;
        try {
            List<Task> list;
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            int taskFetchSize = arcDev.getTaskFetchSize();
            do {
                list = this.ejb.findTasks(taskQueryParam, taskFetchSize);
                for (Task task : list) {
                    if (!newDeviceName.isEmpty()) {
                        try {
                            this.adjustDeviceName(task, targetDevices.get(count % targetDevices.size()), null, null);
                        }
                        catch (IllegalStateException e) {
                            LOG.info(e.getMessage());
                            ++failed;
                            continue;
                        }
                    }
                    try {
                        this.rescheduleTask(task, scheduledTime1);
                        queueNames.add(task.getQueueName());
                        ++count;
                    }
                    catch (Exception e) {
                        LOG.info("Failed to reschedule {}", (Object)task, (Object)e);
                        ++failed;
                    }
                }
            } while (list.size() >= taskFetchSize);
            if (scheduledTime == null && newDeviceName.isEmpty()) {
                queueNames.forEach(this::processQueue);
            }
            Response response = this.response(count, failed);
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            taskEvent.setCount((long)count);
            taskEvent.setFailed(failed);
            this.bulkTaskEventEvent.fire((Object)taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response rescheduleExportTask(TaskQueryParam taskQueryParam, Date scheduledTime, List<String> newDeviceName, String newExporterID, HttpServletRequest request) {
        Task task;
        List<ArchiveDeviceExtension> targetDevices = this.targetDevices(newDeviceName);
        ArchiveDeviceExtension targetDevice = targetDevices.get(0);
        if (newExporterID != null) {
            try {
                targetDevice.getExporterDescriptorNotNull(newExporterID);
            }
            catch (IllegalArgumentException e) {
                return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
            }
        }
        if ((task = this.ejb.findTask(taskQueryParam)) == null) {
            return this.noSuchTask(taskQueryParam.getTaskPK());
        }
        if (!newDeviceName.isEmpty() || newExporterID != null) {
            try {
                this.adjustDeviceName(task, targetDevices.get(0), newExporterID, null);
            }
            catch (IllegalStateException e) {
                return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
            }
        }
        TaskEvent taskEvent = new TaskEvent(request, TaskOperation.RescheduleTasks);
        taskEvent.setTask(task);
        try {
            this.rescheduleTask(task, scheduledTime != null ? scheduledTime : new Date());
            if (scheduledTime == null && newDeviceName.isEmpty()) {
                this.processQueue(task.getQueueName());
            }
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            this.taskEventEvent.fire((Object)taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response rescheduleExportTasks(TaskQueryParam taskQueryParam, Date scheduledTime, List<String> newDeviceName, String newExporterID, HttpServletRequest request) {
        List<ArchiveDeviceExtension> targetDevices = this.targetDevices(newDeviceName);
        if (newExporterID != null) {
            try {
                for (ArchiveDeviceExtension targetDevice : targetDevices) {
                    targetDevice.getExporterDescriptorNotNull(newExporterID);
                }
            }
            catch (IllegalArgumentException e) {
                return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
            }
        }
        int count = 0;
        int failed = 0;
        HashSet<String> queueNames = new HashSet<String>();
        BulkTaskEvent taskEvent = new BulkTaskEvent(request, TaskOperation.RescheduleTasks);
        Date now = new Date();
        taskQueryParam.setUpdatedBeforeNotAfter(now);
        Date scheduledTime1 = scheduledTime != null ? scheduledTime : now;
        try {
            List<Task> list;
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            int taskFetchSize = arcDev.getTaskFetchSize();
            do {
                list = this.ejb.findTasks(taskQueryParam, taskFetchSize);
                for (Task task : list) {
                    if (!newDeviceName.isEmpty() || newExporterID != null) {
                        try {
                            this.adjustDeviceName(task, targetDevices.get(count % targetDevices.size()), newExporterID, null);
                        }
                        catch (IllegalStateException e) {
                            LOG.info(e.getMessage());
                            ++failed;
                            continue;
                        }
                    }
                    try {
                        this.rescheduleTask(task, scheduledTime1);
                        queueNames.add(task.getQueueName());
                        ++count;
                    }
                    catch (Exception e) {
                        LOG.info("Failed to reschedule {}", (Object)task, (Object)e);
                        ++failed;
                    }
                }
            } while (list.size() >= taskFetchSize);
            if (scheduledTime == null && newDeviceName.isEmpty()) {
                queueNames.forEach(this::processQueue);
            }
            Response response = this.response(count, failed);
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            taskEvent.setCount((long)count);
            taskEvent.setFailed(failed);
            this.bulkTaskEventEvent.fire((Object)taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response rescheduleRetrieveTask(TaskQueryParam taskQueryParam, Date scheduledTime, List<String> newDeviceName, String newQueueName, HttpServletRequest request) {
        Task task;
        List<ArchiveDeviceExtension> targetDevices = this.targetDevices(newDeviceName);
        ArchiveDeviceExtension targetDevice = targetDevices.get(0);
        if (newQueueName != null) {
            try {
                targetDevice.getQueueDescriptorNotNull(newQueueName);
            }
            catch (IllegalArgumentException e) {
                return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
            }
        }
        if ((task = this.ejb.findTask(taskQueryParam)) == null) {
            return this.noSuchTask(taskQueryParam.getTaskPK());
        }
        if (!newDeviceName.isEmpty() || newQueueName != null) {
            try {
                this.adjustDeviceName(task, targetDevices.get(0), null, newQueueName);
            }
            catch (IllegalStateException e) {
                return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
            }
        }
        TaskEvent taskEvent = new TaskEvent(request, TaskOperation.RescheduleTasks);
        taskEvent.setTask(task);
        try {
            this.rescheduleTask(task, scheduledTime != null ? scheduledTime : new Date());
            if (scheduledTime == null && newDeviceName.isEmpty()) {
                this.processQueue(task.getQueueName());
            }
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            this.taskEventEvent.fire((Object)taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response rescheduleRetrieveTasks(TaskQueryParam taskQueryParam, Date scheduledTime, List<String> newDeviceName, String newQueueName, HttpServletRequest request) {
        List<ArchiveDeviceExtension> targetDevices = this.targetDevices(newDeviceName);
        if (newQueueName != null) {
            try {
                for (ArchiveDeviceExtension targetDevice : targetDevices) {
                    targetDevice.getQueueDescriptorNotNull(newQueueName);
                }
            }
            catch (IllegalArgumentException e) {
                return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
            }
        }
        int count = 0;
        int failed = 0;
        HashSet<String> queueNames = new HashSet<String>();
        BulkTaskEvent taskEvent = new BulkTaskEvent(request, TaskOperation.RescheduleTasks);
        Date now = new Date();
        taskQueryParam.setUpdatedBeforeNotAfter(now);
        Date scheduledTime1 = scheduledTime != null ? scheduledTime : now;
        try {
            List<Task> list;
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            int taskFetchSize = arcDev.getTaskFetchSize();
            do {
                list = this.ejb.findTasks(taskQueryParam, taskFetchSize);
                for (Task task : list) {
                    if (!newDeviceName.isEmpty() || newQueueName != null) {
                        try {
                            this.adjustDeviceName(task, targetDevices.get(count % targetDevices.size()), null, newQueueName);
                        }
                        catch (IllegalStateException e) {
                            LOG.info(e.getMessage());
                            ++failed;
                            continue;
                        }
                    }
                    try {
                        this.rescheduleTask(task, scheduledTime1);
                        queueNames.add(task.getQueueName());
                        ++count;
                    }
                    catch (Exception e) {
                        LOG.info("Failed to reschedule {}", (Object)task, (Object)e);
                        ++failed;
                    }
                }
            } while (list.size() >= taskFetchSize);
            if (scheduledTime == null && newDeviceName.isEmpty()) {
                queueNames.forEach(this::processQueue);
            }
            Response response = this.response(count, failed);
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            taskEvent.setCount((long)count);
            taskEvent.setFailed(failed);
            this.bulkTaskEventEvent.fire((Object)taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response deleteTask(TaskQueryParam taskQueryParam, HttpServletRequest request) {
        Task task = this.ejb.findTask(taskQueryParam);
        if (task == null) {
            return this.noSuchTask(taskQueryParam.getTaskPK());
        }
        TaskEvent taskEvent = new TaskEvent(request, TaskOperation.DeleteTasks);
        taskEvent.setTask(task);
        try {
            if (task.getStatus() == Task.Status.IN_PROCESS) {
                this.taskCanceledEvent.fire((Object)new TaskCanceled(task));
            }
            this.ejb.remove(task);
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            taskEvent.setException(e);
            Response response = this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            this.taskEventEvent.fire((Object)taskEvent);
        }
    }

    @Override
    public Response deleteTasks(TaskQueryParam taskQueryParam, HttpServletRequest request) {
        BulkTaskEvent taskEvent = new BulkTaskEvent(request, TaskOperation.DeleteTasks);
        this.deleteTasks(taskQueryParam, taskEvent);
        return taskEvent.getException() == null ? this.response(taskEvent.getCount(), taskEvent.getFailed()) : this.errResponseAsTextPlain(this.exceptionAsString(taskEvent.getException()), Response.Status.INTERNAL_SERVER_ERROR);
    }

    @Override
    public void deleteTasks(TaskQueryParam taskQueryParam, String queueName) {
        this.deleteTasks(taskQueryParam, new BulkTaskEvent(queueName, TaskOperation.DeleteTasks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTasks(TaskQueryParam taskQueryParam, BulkTaskEvent taskEvent) {
        int count = 0;
        int failed = 0;
        Task.Status status = taskQueryParam.getStatus();
        try {
            Task.Type type = taskQueryParam.getType();
            if (status != Task.Status.IN_PROCESS && type != Task.Type.DIFF) {
                if (status == null) {
                    taskQueryParam.setNotStatus(Task.Status.IN_PROCESS);
                }
                if (type == null) {
                    taskQueryParam.setNotType(Task.Type.DIFF);
                }
                count = this.ejb.deleteTasks(taskQueryParam);
                taskQueryParam.setNotStatus(null);
                taskQueryParam.setNotType(null);
            }
            if (status == null || status == Task.Status.IN_PROCESS || type == null || type == Task.Type.DIFF) {
                List<Task> list;
                ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
                int taskFetchSize = arcDev.getTaskFetchSize();
                do {
                    list = this.ejb.findTasks(taskQueryParam, taskFetchSize);
                    for (Task task : list) {
                        try {
                            if (task.getStatus() == Task.Status.IN_PROCESS) {
                                this.taskCanceledEvent.fire((Object)new TaskCanceled(task));
                            }
                            this.ejb.remove(task);
                            ++count;
                        }
                        catch (Exception e) {
                            LOG.info("Failed to delete {}", (Object)task, (Object)e);
                            ++failed;
                        }
                    }
                } while (list.size() >= taskFetchSize);
            }
        }
        catch (Exception e) {
            taskEvent.setException(e);
        }
        finally {
            taskEvent.setCount((long)count);
            taskEvent.setFailed(failed);
            this.bulkTaskEventEvent.fire((Object)taskEvent);
            if (count > 0) {
                LOG.info("Deleted {} tasks matching {}", (Object)count, (Object)taskQueryParam);
            }
        }
    }

    private List<ArchiveDeviceExtension> targetDevices(List<String> deviceNames) {
        if (deviceNames.isEmpty()) {
            return Collections.singletonList((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class));
        }
        ArrayList<ArchiveDeviceExtension> list = new ArrayList<ArchiveDeviceExtension>(deviceNames.size());
        for (String deviceName : deviceNames) {
            try {
                list.add((ArchiveDeviceExtension)this.deviceCache.findDevice(deviceName).getDeviceExtensionNotNull(ArchiveDeviceExtension.class));
            }
            catch (IllegalStateException | ConfigurationNotFoundException e) {
                throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST));
            }
            catch (Exception e) {
                throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
            }
        }
        return list;
    }

    private void adjustDeviceName(Task task, ArchiveDeviceExtension targetDevice, String newExporterID, String newQueueName) {
        String exporterID;
        String deviceName = targetDevice.getDevice().getDeviceName();
        String string = exporterID = newExporterID != null ? newExporterID : task.getExporterID();
        if (exporterID != null && task.getType() == Task.Type.EXPORT) {
            ExporterDescriptor exporterDescriptor = targetDevice.getExporterDescriptor(exporterID);
            if (exporterDescriptor == null) {
                throw new IllegalStateException("Cannot reschedule Export Task{id=" + task.getPk() + "} to Exporter{id=" + exporterID + "} not configured at Device{name=" + deviceName + "}");
            }
            task.setExporterID(exporterID);
            task.setQueueName(exporterDescriptor.getQueueName());
            task.setLocalAET(exporterDescriptor.getAETitle());
        } else {
            String queueName;
            String string2 = queueName = newQueueName != null ? newQueueName : task.getQueueName();
            if (targetDevice.getQueueDescriptor(queueName) == null) {
                throw new IllegalStateException("Cannot reschedule Taskid=" + task.getPk() + "} on Queue{name=" + queueName + "} not configured at Device{name=" + deviceName + "}");
            }
            task.setQueueName(queueName);
        }
        this.validateTaskAssociationInitiator(task, targetDevice);
        task.setDeviceName(deviceName);
    }

    private void validateTaskAssociationInitiator(Task task, ArchiveDeviceExtension targetDevice) {
        switch (task.getType()) {
            case EXPORT: 
            case REST: {
                break;
            }
            case HL7: {
                HL7Application hl7Application = ((HL7DeviceExtension)targetDevice.getDevice().getDeviceExtensionNotNull(HL7DeviceExtension.class)).getHL7Application(task.getSendingApplicationWithFacility(), true);
                if (hl7Application != null && hl7Application.isInstalled()) break;
                throw new IllegalStateException("No such HL7 Application{name=" + task.getSendingApplicationWithFacility() + "} on new device{name=" + targetDevice.getDevice().getDeviceName() + "}");
            }
            default: {
                ApplicationEntity ae = targetDevice.getDevice().getApplicationEntity(task.getLocalAET(), true);
                if (ae != null && ae.isInstalled()) break;
                throw new IllegalStateException("No such Application Entity{dicomAETitle=" + task.getLocalAET() + "} on new device{name=" + targetDevice.getDevice().getDeviceName() + "}");
            }
        }
    }

    private void rescheduleTask(Task task, Date scheduledTime) {
        if (task.getStatus() == Task.Status.IN_PROCESS) {
            this.taskCanceledEvent.fire((Object)new TaskCanceled(task));
        }
        task.setStatus(Task.Status.SCHEDULED);
        task.setScheduledTime(scheduledTime);
        task.setProcessingStartTime(null);
        task.setProcessingEndTime(null);
        task.setNumberOfFailures(0);
        task.setOutcomeMessage(null);
        task.setErrorMessage(null);
        this.ejb.merge(task);
    }

    private Response noSuchTask(long taskID) {
        return this.errResponse("No such Task : " + taskID, Response.Status.NOT_FOUND);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private Response response(int count, int failed) {
        return failed == 0 ? this.count(count) : (count == 0 ? this.conflict(failed) : this.accepted(count, failed));
    }

    private Response count(long count) {
        return Response.ok((Object)("{\"count\":" + count + "}")).build();
    }

    private Response accepted(int rescheduled, int failed) {
        return Response.accepted((Object)("{\"count\":" + rescheduled + ", \"failed\":" + failed + "}")).build();
    }

    private Response conflict(int failed) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"failed\":" + failed + "}")).build();
    }
}

