/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.procedure.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.MWLImport;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.procedure.impl.MWLScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MWLImporter
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MWLScheduler.class);
    @Inject
    private ProcedureService service;

    protected MWLImporter() {
        super(Scheduler.Mode.scheduleAtFixedRate);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return !arcDev.getMWLImports().isEmpty() ? arcDev.getMWLImportInterval() : null;
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        for (MWLImport mwlImport : arcDev.getMWLImports()) {
            try {
                this.service.importMWL(mwlImport);
            }
            catch (Exception e) {
                LOG.info("Failed to process {}\n", (Object)mwlImport, (Object)e);
            }
        }
    }
}

