/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.patient;

import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.CriteriaQuery;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.CircularPatientMergeException;
import org.dcm4chee.arc.patient.NonUniquePatientException;
import org.dcm4chee.arc.patient.PatientMergedException;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientTrackingNotAllowedException;
import org.dcm4chee.arc.patient.PatientUnmergedException;

public interface PatientService {
    public PatientMgtContext createPatientMgtContextDIMSE(Association var1);

    public PatientMgtContext createPatientMgtContextWEB(HttpServletRequestInfo var1);

    public PatientMgtContext createPatientMgtContextHL7(HL7Application var1, Socket var2, UnparsedHL7Message var3);

    public PatientMgtContext createPatientMgtContextScheduler();

    public List<Patient> findPatients(IDWithIssuer var1);

    public Patient findPatient(IDWithIssuer var1);

    public Patient createPatient(PatientMgtContext var1);

    public Patient updatePatient(PatientMgtContext var1) throws NonUniquePatientException, PatientMergedException;

    public boolean deleteDuplicateCreatedPatient(IDWithIssuer var1, Patient var2, Study var3);

    public Patient mergePatient(PatientMgtContext var1) throws NonUniquePatientException, PatientMergedException, CircularPatientMergeException;

    public Patient changePatientID(PatientMgtContext var1) throws NonUniquePatientException, PatientMergedException, PatientTrackingNotAllowedException;

    public boolean unmergePatient(PatientMgtContext var1) throws NonUniquePatientException, PatientUnmergedException;

    public Patient findPatient(PatientMgtContext var1);

    public void deletePatient(PatientMgtContext var1);

    public Patient updatePatientStatus(PatientMgtContext var1);

    public List<String> studyInstanceUIDsOf(Patient var1);

    public boolean supplementIssuer(PatientMgtContext var1, Patient var2, IDWithIssuer var3, Map<IDWithIssuer, Long> var4);

    public <T> T merge(T var1);

    public void testSupplementIssuers(CriteriaQuery<Patient> var1, int var2, Set<IDWithIssuer> var3, Map<IDWithIssuer, Long> var4, AttributesFormat var5);

    public <T> List<T> queryWithOffsetAndLimit(CriteriaQuery<T> var1, int var2, int var3);
}

